/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit.diff;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.netbeans.junit.diff.Diff;

public class SimpleDiff
implements Diff {
    private static final int BUFSIZE = 1024;

    public boolean diff(File first, File second, File diff) throws IOException {
        if (this.isBinaryFile(first) || this.isBinaryFile(second)) {
            return this.binaryCompare(first, second, diff);
        }
        return this.textualCompare(first, second, diff);
    }

    public boolean diff(String first, String second, String diff) throws IOException {
        File fFirst = new File(first);
        File fSecond = new File(second);
        File fDiff = null != diff ? new File(diff) : null;
        return this.diff(fFirst, fSecond, fDiff);
    }

    protected boolean isBinaryFile(File file) throws IOException {
        FileInputStream is = null;
        is = new FileInputStream(file);
        byte[] buffer = new byte[1024];
        int bytesRead = is.read(buffer, 0, 1024);
        if (bytesRead == -1) {
            return false;
        }
        int i = 0;
        while (i != bytesRead) {
            if (buffer[i] < 0) {
                return true;
            }
            ++i;
        }
        is.close();
        return false;
    }

    protected boolean binaryCompare(File first, File second, File diff) throws IOException {
        if (first.length() != second.length()) {
            return true;
        }
        BufferedInputStream fs1 = new BufferedInputStream(new FileInputStream(first));
        BufferedInputStream fs2 = new BufferedInputStream(new FileInputStream(second));
        byte[] b1 = new byte[1024];
        byte[] b2 = new byte[1024];
        do {
            int l1 = ((InputStream)fs1).read(b1);
            int l2 = ((InputStream)fs2).read(b2);
            if (l1 == -1) {
                return l2 != -1;
            }
            if (l1 == l2) continue;
            return true;
        } while (Arrays.equals(b1, b2));
        return true;
    }

    protected boolean textualCompare(File first, File second, File diff) throws IOException {
        String s2;
        String s1;
        BufferedReader r1 = new BufferedReader(new FileReader(first));
        BufferedReader r2 = new BufferedReader(new FileReader(second));
        do {
            s1 = r1.readLine();
            s2 = r2.readLine();
            if (s1 != null) continue;
            return s2 != null;
        } while (s1.equals(s2));
        return true;
    }

    static {
        BUFSIZE = 1024;
    }
}

