/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.tree;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.netbeans.modules.xml.core.DTDDataObject;
import org.netbeans.modules.xml.core.XMLDataObject;
import org.netbeans.modules.xml.core.XMLDataObjectLook;
import org.netbeans.modules.xml.core.cookies.CookieManagerCookie;
import org.netbeans.modules.xml.core.cookies.TreeDocumentCookie;
import org.netbeans.modules.xml.core.cookies.TreeEditorCookie;
import org.netbeans.modules.xml.core.cookies.UpdateDocumentCookie;
import org.netbeans.modules.xml.core.sync.Representation;
import org.netbeans.modules.xml.core.tree.DTDParsingSupport;
import org.netbeans.modules.xml.core.tree.DTDTreeRepresentation;
import org.netbeans.modules.xml.core.tree.ParsingSupport;
import org.netbeans.modules.xml.core.tree.Util;
import org.netbeans.modules.xml.core.tree.XMLParsingSupport;
import org.netbeans.modules.xml.core.tree.XMLTreeRepresentation;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeDocumentType;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.event.TreeEvent;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.xml.sax.InputSource;

public class TreeEditorCookieImpl
implements TreeEditorCookie,
UpdateDocumentCookie {
    private Task prepareTask;
    private final Exception[] prepareException = new Exception[1];
    private XMLDataObjectLook xmlDO;
    private final PropertyChangeSupport pchs;
    private final CookieManagerCookie cookieMgr;
    private int status;
    private int oldStatus;
    private TreeReference tree;
    private static final ReferenceQueue TREEREF_QUEUE = new ReferenceQueue();
    private static final int CLEANER_TIME = 5001;
    private static final RequestProcessor.Task CLEANER_TASK = RequestProcessor.postRequest((Runnable)new TreeRefQueueCleaner(), (int)5001, (int)1);
    private Object treeLock = new TreeLock();
    private PropertyChangeListener treeListener = null;
    private TreeDocumentCookie treeDocumentCookie;
    private Representation rep;
    static /* synthetic */ Class class$org$xml$sax$InputSource;

    public TreeEditorCookieImpl(XMLDataObjectLook xmlDO) {
        this.xmlDO = xmlDO;
        this.cookieMgr = xmlDO.getCookieManager();
        this.oldStatus = this.status = 0;
        this.pchs = new PropertyChangeSupport(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TreeDocumentRoot openDocumentRoot() throws IOException, TreeException {
        TreeDocumentRoot root;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeEditorCookieImpl.openDocumentRoot()");
        }
        while (true) {
            this.prepareDocumentRoot().waitFinished();
            TreeEditorCookieImpl treeEditorCookieImpl = this;
            synchronized (treeEditorCookieImpl) {
                root = this.getDocumentRoot();
                if (root != null) break;
                if (this.prepareException[0] instanceof IOException) {
                    throw (IOException)this.prepareException[0];
                }
                if (this.prepareException[0] instanceof TreeException) {
                    throw (TreeException)((Object)this.prepareException[0]);
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("\tTree parsing retry due to (expected null): " + this.prepareException[0]);
                }
                this.prepareTask = null;
            }
        }
        {
            if (!Util.THIS.isLoggable()) return root;
            Util.THIS.debug("TreeEditorCookieImpl.openDocumentRoot() = " + root);
            return root;
        }
    }

    public Task prepareDocumentRoot() {
        TreeEditorCookieImpl treeEditorCookieImpl = this;
        synchronized (treeEditorCookieImpl) {
            if (this.prepareTask != null) {
                Task task = this.prepareTask;
                return task;
            }
            this.prepareTask = new Task(new Runnable(){

                public void run() {
                    try {
                        InputSource src = TreeEditorCookieImpl.this.inputSource();
                        TreeEditorCookieImpl.this.parseTree(src, true);
                        ((TreeEditorCookieImpl)TreeEditorCookieImpl.this).prepareException[0] = null;
                    }
                    catch (IOException ex) {
                        ((TreeEditorCookieImpl)TreeEditorCookieImpl.this).prepareException[0] = ex;
                    }
                    catch (TreeException ex) {
                        ((TreeEditorCookieImpl)TreeEditorCookieImpl.this).prepareException[0] = ex;
                    }
                    TreeEditorCookieImpl.this.fireTreeAndStatus();
                }
            });
        }
        new Thread((Runnable)this.prepareTask, "Parsing tree...").start();
        return this.prepareTask;
    }

    public TreeDocumentRoot getDocumentRoot() {
        if (this.tree == null) {
            return null;
        }
        TreeDocumentRoot root = this.tree.getDocumentRoot();
        if (root == null) {
            return null;
        }
        return root;
    }

    public int getStatus() {
        return this.status;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pchs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pchs.removePropertyChangeListener(l);
    }

    private void setTree(TreeDocumentRoot doc) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeEditorCookieImpl::setTree: " + doc);
        }
        if (doc == this.getDocumentRoot() && doc != null) {
            return;
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\tdifferent doc delivered, merging");
        }
        TreeDocumentRoot oldTreeDoc = this.getDocumentRoot();
        try {
            block17: {
                try {
                    if (doc == null) {
                        if (Util.THIS.isLoggable()) {
                            Util.THIS.debug("\tbefore REMOVE : " + this.getDocumentRoot());
                        }
                        this.removeTreeDocumentCookie();
                        if (this.rep != null) {
                            // empty if block
                        }
                        if (this.getDocumentRoot() != null) {
                            ((TreeObject)this.getDocumentRoot()).removePropertyChangeListener(this.treeListener);
                            this.treeListener = null;
                        }
                        this.tree = null;
                    } else if (this.tree == null) {
                        if (Util.THIS.isLoggable()) {
                            Util.THIS.debug("\tbefore ADD : " + this.getDocumentRoot());
                        }
                        this.tree = new TreeReference(doc);
                        this.treeListener = new TreeListener();
                        ((TreeObject)this.getDocumentRoot()).addPropertyChangeListener(this.treeListener);
                        this.addTreeDocumentCookie();
                    } else {
                        if (Util.THIS.isLoggable()) {
                            Util.THIS.debug("\tbefore MERGE : " + this.getDocumentRoot());
                        }
                        TreeObject root = (TreeObject)this.getDocumentRoot();
                        root.removePropertyChangeListener(this.treeListener);
                        root.merge((TreeObject)doc);
                        root.addPropertyChangeListener(this.treeListener);
                    }
                    if (this.rep != null) break block17;
                    this.rep = this.xmlDO instanceof XMLDataObject ? new XMLTreeRepresentation(this, this.xmlDO.getSyncInterface()) : new DTDTreeRepresentation(this, this.xmlDO.getSyncInterface());
                    this.xmlDO.getSyncInterface().addRepresentation(this.rep);
                }
                catch (CannotMergeException exc) {
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("MERGE FATAL ERROR:");
                    }
                    exc.printStackTrace();
                    Object var5_6 = null;
                }
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            throw throwable;
        }
    }

    public void updateTree(Object input) {
        try {
            this.parseTree((InputSource)input, false);
        }
        catch (TreeException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fireTreeAndStatus();
    }

    private void parseTree(InputSource input, boolean force) throws TreeException, IOException {
        block15: {
            if (input == null) {
                throw new IOException();
            }
            String annotation = null;
            if (this.status == 0 && this.getDocumentRoot() == null && !force) {
                return;
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("XMLTreeEditorCookieImpl::updateTree(force=" + force + ")");
            }
            try {
                ParsingSupport parser = null;
                if (this.xmlDO instanceof XMLDataObject) {
                    parser = new XMLParsingSupport();
                } else if (this.xmlDO instanceof DTDDataObject) {
                    parser = new DTDParsingSupport();
                } else if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("parseTree() Unexpected instance: " + this.xmlDO.getClass());
                }
                annotation = Util.THIS.getString("MSG_Unexpected_exception_in_parser_or_handler");
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("PARSING: " + input.getSystemId());
                }
                TreeDocumentRoot doc = parser.parse(input);
                annotation = Util.THIS.getString("MSG_Unexpected_exception_in_merge");
                this.setTreeAndStatus(doc, 1);
            }
            catch (Exception ex) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("XMLTreeEditorCookieImpl::updateTree", ex);
                }
                this.setTreeAndStatus(null, 3);
                if (ex instanceof TreeException || ex instanceof IOException) {
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                    if (ex instanceof TreeException) {
                        throw (TreeException)((Object)ex);
                    }
                }
                if (!(ex instanceof RuntimeException)) break block15;
                Util.THIS.getErrorManager().annotate((Throwable)ex, annotation);
                Util.THIS.debug(ex);
                throw new TreeException(ex);
            }
        }
    }

    private void addTreeDocumentCookie() {
        this.treeDocumentCookie = new TreeDocumentCookieImpl();
        this.cookieMgr.addCookie(this.treeDocumentCookie);
    }

    private void removeTreeDocumentCookie() {
        if (this.treeDocumentCookie != null) {
            this.cookieMgr.removeCookie(this.treeDocumentCookie);
        }
    }

    private void setTreeAndStatus(TreeDocumentRoot doc, int newStatus) {
        Object object = this.treeLock;
        synchronized (object) {
            this.setTree(doc);
            this.oldStatus = this.status;
            this.status = newStatus;
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Tree status transition: " + this.oldStatus + "=>" + newStatus);
            }
        }
    }

    private void fireTreeAndStatus() {
        final int fireStatus = this.status;
        final int fireOldStatus = this.oldStatus;
        final TreeDocumentRoot fireTree = this.getDocumentRoot();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Firing tree status transition: " + this.oldStatus + "=>" + this.status);
        }
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                TreeEditorCookieImpl.this.pchs.firePropertyChange("status", fireOldStatus, fireStatus);
                TreeEditorCookieImpl.this.pchs.firePropertyChange("documentRoot", null, fireTree);
            }
        });
    }

    public void updateDocumentRoot() {
        Task task = new Task(new Runnable(){

            public void run() {
                try {
                    TreeEditorCookieImpl.this.parseTree(TreeEditorCookieImpl.this.inputSource(), true);
                }
                catch (TreeException ex) {
                    Util.THIS.debug(ex);
                }
                catch (IOException ex) {
                    Util.THIS.debug(ex);
                }
            }
        });
        this.xmlDO.getSyncInterface().postRequest((Runnable)task);
        task.waitFinished();
        this.fireTreeAndStatus();
    }

    private InputSource inputSource() {
        Representation primary = this.xmlDO.getSyncInterface().getPrimaryRepresentation();
        InputSource src = (InputSource)primary.getChange(class$org$xml$sax$InputSource == null ? (class$org$xml$sax$InputSource = TreeEditorCookieImpl.class$("org.xml.sax.InputSource")) : class$org$xml$sax$InputSource);
        if (src == null && Util.THIS.isLoggable()) {
            Util.THIS.debug("Primary representation can not provide InputSource: " + primary);
        }
        return src;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TreeLock {
        private TreeLock() {
        }
    }

    public static class CookieFactoryImpl
    implements CookieSet.Factory {
        private WeakReference editor;
        private final XMLDataObjectLook dobj;
        static /* synthetic */ Class class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie;
        static /* synthetic */ Class class$org$netbeans$modules$xml$core$cookies$UpdateDocumentCookie;

        public CookieFactoryImpl(XMLDataObjectLook dobj) {
            this.dobj = dobj;
        }

        public Node.Cookie createCookie(Class klass) {
            if (klass.isAssignableFrom(class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie == null ? (class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie = CookieFactoryImpl.class$("org.netbeans.modules.xml.core.cookies.TreeEditorCookie")) : class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie)) {
                return this.createEditor();
            }
            if (klass.isAssignableFrom(class$org$netbeans$modules$xml$core$cookies$UpdateDocumentCookie == null ? (class$org$netbeans$modules$xml$core$cookies$UpdateDocumentCookie = CookieFactoryImpl.class$("org.netbeans.modules.xml.core.cookies.UpdateDocumentCookie")) : class$org$netbeans$modules$xml$core$cookies$UpdateDocumentCookie)) {
                return this.createEditor();
            }
            return null;
        }

        private synchronized TreeEditorCookieImpl createEditor() {
            if (this.editor == null) {
                return this.prepareEditor();
            }
            TreeEditorCookieImpl cached = (TreeEditorCookieImpl)this.editor.get();
            if (cached == null) {
                return this.prepareEditor();
            }
            return cached;
        }

        private TreeEditorCookieImpl prepareEditor() {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Initializing TreeEditorCookieImpl ...");
            }
            TreeEditorCookieImpl cake = new TreeEditorCookieImpl(this.dobj);
            this.editor = new WeakReference<TreeEditorCookieImpl>(cake);
            return cake;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class TreeRefQueueCleaner
    implements Runnable {
        private TreeRefQueueCleaner() {
        }

        public void run() {
            try {
                TreeReference ref;
                while ((ref = (TreeReference)TREEREF_QUEUE.poll()) != null) {
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("" + ref + " reclaimed.");
                    }
                    ref.getEditor().setTreeAndStatus(null, 0);
                    ref.getEditor().fireTreeAndStatus();
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                CLEANER_TASK.schedule(5001);
                throw throwable;
            }
            CLEANER_TASK.schedule(5001);
        }
    }

    private class TreeReference
    extends WeakReference {
        TreeReference(TreeDocumentRoot root) {
            super(root, TREEREF_QUEUE);
        }

        public TreeDocumentRoot getDocumentRoot() {
            return (TreeDocumentRoot)super.get();
        }

        public TreeEditorCookieImpl getEditor() {
            return TreeEditorCookieImpl.this;
        }

        public String toString() {
            return "TreeReference[" + this.getEditor().xmlDO.getName() + "]";
        }
    }

    private class TreeListener
    implements PropertyChangeListener {
        private PropertyChangeEvent last;
        static /* synthetic */ Class class$org$netbeans$tax$TreeDocument;
        static /* synthetic */ Class class$javax$swing$text$Document;

        private TreeListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("!!! TreeEditorCookieImpl::TreeListener::propertyChange: propertyName = '" + e.getPropertyName() + "'");
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("!!!                  ::TreeListener::propertyChange: last = " + this.last);
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("!!!                  ::TreeListener::propertyChange: e    = " + e);
            }
            if (e != this.last) {
                this.last = e;
                TreeEditorCookieImpl.this.xmlDO.getSyncInterface().representationChanged(class$org$netbeans$tax$TreeDocument == null ? (class$org$netbeans$tax$TreeDocument = TreeListener.class$("org.netbeans.tax.TreeDocument")) : class$org$netbeans$tax$TreeDocument);
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("!!!                  ::TreeListener::propertyChange: *after* representationChanged (TreeDocument.class)");
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("!!!                  ::TreeListener::propertyChange: ( e instanceof TreeEvent ) => " + (e instanceof TreeEvent));
                }
                boolean updateFromText = false;
                if (e instanceof TreeEvent && ((TreeEvent)e).isBubbling()) {
                    TreeEvent treeEvent = (TreeEvent)e;
                    if (treeEvent.getOriginalSource() instanceof TreeDocumentType && ("publicId".equals(treeEvent.getOriginalPropertyName()) || "systemId".equals(treeEvent.getOriginalPropertyName()))) {
                        updateFromText = true;
                    }
                } else if ("childList".equals(e.getPropertyName()) && e.getNewValue() instanceof TreeDocumentType) {
                    updateFromText = true;
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("!!!                  ::TreeListener::propertyChange: updateFromText = " + updateFromText);
                }
                if (updateFromText) {
                    TreeEditorCookieImpl.this.xmlDO.getSyncInterface().representationChanged(class$javax$swing$text$Document == null ? (class$javax$swing$text$Document = TreeListener.class$("javax.swing.text.Document")) : class$javax$swing$text$Document);
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class TreeDocumentCookieImpl
    implements TreeDocumentCookie {
        private TreeDocumentCookieImpl() {
        }

        public TreeDocumentRoot getDocumentRoot() {
            try {
                return TreeEditorCookieImpl.this.openDocumentRoot();
            }
            catch (IOException ex) {
                return null;
            }
            catch (TreeException ex) {
                return null;
            }
        }
    }
}

