/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.cookies;

import java.io.StringReader;
import org.netbeans.api.xml.parsers.SAXEntityParser;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class ValidateSchemaSupport
extends ValidateXMLSupport {
    public ValidateSchemaSupport(InputSource inputSource) {
        super(inputSource);
    }

    protected XMLReader createParser(boolean validate) {
        String XERCES_FEATURE_PREFIX = "http://apache.org/xml/features/";
        XMLReader parser = super.createParser(validate);
        if (parser == null) {
            return null;
        }
        if (validate) {
            try {
                if (!parser.getFeature("http://apache.org/xml/features/validation/schema")) {
                    return null;
                }
                return new SchemaChecker(parser);
            }
            catch (SAXException ex) {
                return null;
            }
        }
        return parser;
    }

    private static class SchemaChecker
    extends SAXEntityParser {
        public SchemaChecker(XMLReader parser) {
            super(parser);
        }

        protected InputSource wrapInputSource(InputSource inputSource) {
            String targetNamespace = this.getTargetNamespace();
            String url = inputSource.getSystemId();
            StringBuffer buffer = new StringBuffer();
            String namespace = "http://www.w3.org/2001/XMLSchema-instance";
            buffer.append("<schemaWrapper xmlns:xsi='" + namespace + "' ");
            buffer.append("xmlns='" + this.getTargetNamespace() + "' ");
            if (targetNamespace != null) {
                buffer.append("xsi:schemaLocation='" + targetNamespace + " " + url + "'/>");
            } else {
                buffer.append("xsi:noNamespaceSchemaLocation='" + url + "'/>");
            }
            StringReader reader = new StringReader(buffer.toString());
            InputSource input = new InputSource();
            input.setCharacterStream(reader);
            return input;
        }

        protected boolean propagateException(SAXParseException ex) {
            String message;
            if (super.propagateException(ex) && (message = ex.getMessage()).indexOf(this.getTargetNamespace()) < 0) {
                return message.indexOf("schemaWrapper") < 0;
            }
            return false;
        }

        private String getTargetNamespace() {
            return "HI-IT-IS-INTERNAL-NAMESPACE";
        }
    }
}

