/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.xs.AbstractDatatypeValidator;
import org.apache.xerces.impl.dv.xs.AbstractNumericValidator;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.ListDatatypeValidator;
import org.apache.xerces.impl.validation.ValidationContext;
import org.apache.xerces.impl.xpath.regex.RegularExpression;
import org.apache.xerces.impl.xs.SchemaSymbols;

public class UnionDatatypeValidator
extends AbstractDatatypeValidator {
    private boolean fIsRestriction;
    private Vector fBaseValidators;
    private int fValidatorsSize;
    private Vector fEnumeration;
    private StringBuffer errorMsg;

    public UnionDatatypeValidator() {
        this(null, null, false, null);
    }

    public UnionDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl, XMLErrorReporter xMLErrorReporter) {
        block8: {
            this.fIsRestriction = false;
            this.fBaseValidators = null;
            this.fValidatorsSize = 0;
            this.fEnumeration = null;
            this.errorMsg = null;
            this.fErrorReporter = xMLErrorReporter;
            this.fBaseValidator = datatypeValidator;
            this.fIsRestriction = true;
            try {
                if (hashtable == null) break block8;
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (string.equals(SchemaSymbols.ELT_ENUMERATION)) {
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
                        this.fEnumeration = (Vector)hashtable.get(string);
                        continue;
                    }
                    if (string.equals(SchemaSymbols.ELT_PATTERN)) {
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
                        this.fPattern = (String)hashtable.get(string);
                        this.fRegex = new RegularExpression(this.fPattern, "X");
                        continue;
                    }
                    String string2 = "union datatype, facet " + string + " with value " + (String)hashtable.get(string);
                    throw new InvalidDatatypeFacetException(string2);
                }
                if (datatypeValidator == null || (this.fFacetsDefined & 0x10) == 0 || this.fEnumeration == null) break block8;
                int n = 0;
                try {
                    while (n < this.fEnumeration.size()) {
                        datatypeValidator.validate((String)this.fEnumeration.elementAt(n), null);
                        ++n;
                    }
                }
                catch (Exception exception) {
                    throw new InvalidDatatypeFacetException("Value of enumeration = '" + this.fEnumeration.elementAt(n) + "' must be from the value space of base.");
                }
            }
            catch (Exception exception) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "DatatypeFacetError", new Object[]{exception.getMessage()}, (short)1);
            }
        }
    }

    public UnionDatatypeValidator(Vector vector, XMLErrorReporter xMLErrorReporter) {
        this.fIsRestriction = false;
        this.fBaseValidators = null;
        this.fValidatorsSize = 0;
        this.fEnumeration = null;
        this.errorMsg = null;
        this.fErrorReporter = xMLErrorReporter;
        this.fIsRestriction = false;
        if (vector != null) {
            this.fValidatorsSize = vector.size();
            this.fBaseValidators = vector;
            if (this.fValidatorsSize > 0) {
                this.fBaseValidator = (DatatypeValidator)vector.elementAt(0);
            }
        }
    }

    public Object validate(String string, ValidationContext validationContext) throws InvalidDatatypeValueException {
        if (string == null && validationContext != null) {
            this.fBaseValidator.validate(string, validationContext);
        } else {
            this.checkContentEnum(string, validationContext, false, null);
        }
        return null;
    }

    public Hashtable getFacets() {
        return null;
    }

    public int compare(String string, String string2) {
        if (this.fIsRestriction) {
            return this.fBaseValidator.compare(string, string2);
        }
        int n = -1;
        while (++n < this.fValidatorsSize) {
            DatatypeValidator datatypeValidator = (DatatypeValidator)this.fBaseValidators.elementAt(n);
            if (datatypeValidator.compare(string, string2) != 0) continue;
            return 0;
        }
        return -1;
    }

    public Object clone() throws CloneNotSupportedException {
        UnionDatatypeValidator unionDatatypeValidator = null;
        unionDatatypeValidator = new UnionDatatypeValidator();
        unionDatatypeValidator.fLocale = this.fLocale;
        unionDatatypeValidator.fBaseValidator = this.fBaseValidator;
        unionDatatypeValidator.fBaseValidators = (Vector)this.fBaseValidators.clone();
        unionDatatypeValidator.fPattern = this.fPattern;
        unionDatatypeValidator.fEnumeration = this.fEnumeration;
        unionDatatypeValidator.fFacetsDefined = this.fFacetsDefined;
        return unionDatatypeValidator;
    }

    public Vector getBaseValidators() {
        return this.fBaseValidators;
    }

    private boolean verifyEnum(Vector vector) {
        if ((this.fFacetsDefined & 0x10) != 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                if (this.fEnumeration.contains(enumeration.nextElement())) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected void checkContentEnum(String var1_1, ValidationContext var2_2, boolean var3_3, Vector var4_4) throws InvalidDatatypeValueException {
        var5_5 = -1;
        var6_6 = false;
        var7_7 = null;
        if (!this.fIsRestriction) ** GOTO lbl42
        if ((this.fFacetsDefined & 8) != 0) {
            if (this.fRegex == null || !this.fRegex.matches(var1_1)) {
                throw new InvalidDatatypeValueException("Value '" + var1_1 + "' does not match regular expression facet '" + this.fPattern + "'.");
            }
            var3_3 = true;
        }
        if (var4_4 != null) {
            if (!this.verifyEnum(var4_4)) {
                throw new InvalidDatatypeValueException("Enumeration '" + var4_4 + "' for value '" + var1_1 + "' is based on enumeration '" + this.fEnumeration + "'");
            }
        } else {
            var4_4 = this.fEnumeration != null ? this.fEnumeration : null;
        }
        ((UnionDatatypeValidator)this.fBaseValidator).checkContentEnum(var1_1, var2_2, var3_3, var4_4);
        return;
lbl-1000:
        // 1 sources

        {
            var7_7 = (DatatypeValidator)this.fBaseValidators.elementAt(var5_5);
            if (var6_6) break;
            try {
                if (var7_7 instanceof ListDatatypeValidator) {
                    if (var3_3) {
                        throw new InvalidDatatypeValueException("Facet \"Pattern\" can not be applied to a list datatype");
                    }
                    ((ListDatatypeValidator)var7_7).checkContentEnum(var1_1, var2_2, var4_4);
                } else if (var7_7 instanceof UnionDatatypeValidator) {
                    ((UnionDatatypeValidator)var7_7).checkContentEnum(var1_1, var2_2, var3_3, var4_4);
                } else if (var4_4 != null) {
                    if (var7_7 instanceof AbstractNumericValidator) {
                        ((AbstractNumericValidator)var7_7).checkContentEnum(var1_1, var2_2, var4_4);
                    } else {
                        if (!var4_4.contains(var1_1)) {
                            throw new InvalidDatatypeValueException("Value '" + var1_1 + "' must be one of " + var4_4);
                        }
                        var7_7.validate(var1_1, var2_2);
                    }
                } else {
                    var7_7.validate(var1_1, var2_2);
                }
                var6_6 = true;
                continue;
            }
            catch (InvalidDatatypeValueException var8_8) {
                // empty catch block
            }
lbl42:
            // 3 sources

            ** while (++var5_5 < this.fValidatorsSize)
        }
lbl43:
        // 2 sources

        if (!var6_6) {
            throw new InvalidDatatypeValueException("Content '" + var1_1 + "' does not match any union types");
        }
    }
}

