/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import org.apache.xerces.impl.validation.Grammar;
import org.apache.xerces.impl.validation.GrammarPool;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.util.SymbolTable;

public class CachingParserPool {
    public static final boolean DEFAULT_SHADOW_SYMBOL_TABLE = false;
    public static final boolean DEFAULT_SHADOW_GRAMMAR_POOL = false;
    protected SymbolTable fSynchronizedSymbolTable;
    protected GrammarPool fSynchronizedGrammarPool;
    protected boolean fShadowSymbolTable = false;
    protected boolean fShadowGrammarPool = false;

    public CachingParserPool() {
        this(new SymbolTable(), new GrammarPool());
    }

    public CachingParserPool(SymbolTable symbolTable, GrammarPool grammarPool) {
        this.fSynchronizedSymbolTable = new SynchronizedSymbolTable(symbolTable);
        this.fSynchronizedGrammarPool = new SynchronizedGrammarPool(grammarPool);
    }

    public SymbolTable getSymbolTable() {
        return this.fSynchronizedSymbolTable;
    }

    public GrammarPool getGrammarPool() {
        return this.fSynchronizedGrammarPool;
    }

    public void setShadowSymbolTable(boolean bl) {
        this.fShadowSymbolTable = bl;
    }

    public DOMParser createDOMParser() {
        SymbolTable symbolTable = this.fShadowSymbolTable ? new ShadowedSymbolTable(this.fSynchronizedSymbolTable) : this.fSynchronizedSymbolTable;
        GrammarPool grammarPool = this.fShadowGrammarPool ? new ShadowedGrammarPool(this.fSynchronizedGrammarPool) : this.fSynchronizedGrammarPool;
        return new DOMParser(symbolTable, grammarPool);
    }

    public SAXParser createSAXParser() {
        SymbolTable symbolTable = this.fShadowSymbolTable ? new ShadowedSymbolTable(this.fSynchronizedSymbolTable) : this.fSynchronizedSymbolTable;
        GrammarPool grammarPool = this.fShadowGrammarPool ? new ShadowedGrammarPool(this.fSynchronizedGrammarPool) : this.fSynchronizedGrammarPool;
        return new SAXParser(symbolTable, grammarPool);
    }

    public static final class ShadowedGrammarPool
    extends GrammarPool {
        private GrammarPool fGrammarPool;

        public ShadowedGrammarPool(GrammarPool grammarPool) {
            this.fGrammarPool = grammarPool;
        }

        public Grammar getGrammar(String string) {
            if (super.containsGrammar(string)) {
                return super.getGrammar(string);
            }
            return this.fGrammarPool.getGrammar(string);
        }

        public boolean containsGrammar(String string) {
            return super.containsGrammar(string) || this.fGrammarPool.containsGrammar(string);
        }
    }

    public static final class SynchronizedGrammarPool
    extends GrammarPool {
        private GrammarPool fGrammarPool;

        public SynchronizedGrammarPool(GrammarPool grammarPool) {
            this.fGrammarPool = grammarPool;
        }

        public void putGrammar(String string, Grammar grammar) {
            GrammarPool grammarPool = this.fGrammarPool;
            synchronized (grammarPool) {
                this.fGrammarPool.putGrammar(string, grammar);
            }
        }

        public Grammar getGrammar(String string) {
            GrammarPool grammarPool = this.fGrammarPool;
            synchronized (grammarPool) {
                Grammar grammar = this.fGrammarPool.getGrammar(string);
                return grammar;
            }
        }

        public Grammar removeGrammar(String string) {
            GrammarPool grammarPool = this.fGrammarPool;
            synchronized (grammarPool) {
                Grammar grammar = this.fGrammarPool.removeGrammar(string);
                return grammar;
            }
        }

        public boolean containsGrammar(String string) {
            GrammarPool grammarPool = this.fGrammarPool;
            synchronized (grammarPool) {
                boolean bl = this.fGrammarPool.containsGrammar(string);
                return bl;
            }
        }
    }

    public static final class ShadowedSymbolTable
    extends SymbolTable {
        protected SymbolTable fSymbolTable;

        public ShadowedSymbolTable(SymbolTable symbolTable) {
            this.fSymbolTable = symbolTable;
        }

        public String addSymbol(String string) {
            if (this.fSymbolTable.containsSymbol(string)) {
                return this.fSymbolTable.addSymbol(string);
            }
            return super.addSymbol(string);
        }

        public String addSymbol(char[] cArray, int n, int n2) {
            if (this.fSymbolTable.containsSymbol(cArray, n, n2)) {
                return this.fSymbolTable.addSymbol(cArray, n, n2);
            }
            return super.addSymbol(cArray, n, n2);
        }

        public int hash(String string) {
            return this.fSymbolTable.hash(string);
        }

        public int hash(char[] cArray, int n, int n2) {
            return this.fSymbolTable.hash(cArray, n, n2);
        }
    }

    public static final class SynchronizedSymbolTable
    extends SymbolTable {
        protected SymbolTable fSymbolTable;

        public SynchronizedSymbolTable(SymbolTable symbolTable) {
            this.fSymbolTable = symbolTable;
        }

        public String addSymbol(String string) {
            SymbolTable symbolTable = this.fSymbolTable;
            synchronized (symbolTable) {
                String string2 = this.fSymbolTable.addSymbol(string);
                return string2;
            }
        }

        public String addSymbol(char[] cArray, int n, int n2) {
            SymbolTable symbolTable = this.fSymbolTable;
            synchronized (symbolTable) {
                String string = this.fSymbolTable.addSymbol(cArray, n, n2);
                return string;
            }
        }

        public boolean containsSymbol(String string) {
            SymbolTable symbolTable = this.fSymbolTable;
            synchronized (symbolTable) {
                boolean bl = this.fSymbolTable.containsSymbol(string);
                return bl;
            }
        }

        public boolean containsSymbol(char[] cArray, int n, int n2) {
            SymbolTable symbolTable = this.fSymbolTable;
            synchronized (symbolTable) {
                boolean bl = this.fSymbolTable.containsSymbol(cArray, n, n2);
                return bl;
            }
        }
    }
}

