/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.xerces.impl.validation.GrammarPool;
import org.apache.xerces.parsers.AbstractDOMParser;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.util.EntityResolverWrapper;
import org.apache.xerces.util.ErrorHandlerWrapper;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class DOMParser
extends AbstractDOMParser {
    public DOMParser() {
        super(new StandardParserConfiguration());
    }

    public DOMParser(XMLParserConfiguration xMLParserConfiguration) {
        super(xMLParserConfiguration);
    }

    public DOMParser(SymbolTable symbolTable) {
        super(new StandardParserConfiguration(symbolTable));
    }

    public DOMParser(SymbolTable symbolTable, GrammarPool grammarPool) {
        super(new StandardParserConfiguration(symbolTable, grammarPool));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(String string) throws SAXException, IOException {
        XMLInputSource xMLInputSource = new XMLInputSource(null, string, null);
        try {
            try {
                this.parse(xMLInputSource);
            }
            catch (XMLParseException xMLParseException) {
                Exception exception = xMLParseException.getException();
                if (exception == null) {
                    LocatorImpl locatorImpl = new LocatorImpl();
                    locatorImpl.setPublicId(xMLParseException.getPublicId());
                    locatorImpl.setSystemId(xMLParseException.getSystemId());
                    locatorImpl.setLineNumber(xMLParseException.getLineNumber());
                    locatorImpl.setColumnNumber(xMLParseException.getColumnNumber());
                    throw new SAXParseException(xMLParseException.getMessage(), locatorImpl);
                }
                if (exception instanceof SAXException) {
                    throw (SAXException)exception;
                }
                if (!(exception instanceof IOException)) throw new SAXException(exception);
                throw (IOException)exception;
            }
            catch (XNIException xNIException) {
                Exception exception = xNIException.getException();
                if (exception == null) {
                    throw new SAXException(xNIException.getMessage());
                }
                if (exception instanceof SAXException) {
                    throw (SAXException)exception;
                }
                if (!(exception instanceof IOException)) throw new SAXException(exception);
                throw (IOException)exception;
            }
            Object var7_3 = null;
        }
        catch (Throwable throwable) {
            Object var7_4 = null;
            try {
                Reader reader = xMLInputSource.getCharacterStream();
                if (reader != null) {
                    reader.close();
                    throw throwable;
                }
                InputStream inputStream = xMLInputSource.getByteStream();
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        Reader reader = xMLInputSource.getCharacterStream();
        if (reader != null) {
            reader.close();
            return;
        }
        InputStream inputStream = xMLInputSource.getByteStream();
        if (inputStream == null) return;
        inputStream.close();
        return;
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        try {
            XMLInputSource xMLInputSource = new XMLInputSource(inputSource.getPublicId(), inputSource.getSystemId(), null);
            xMLInputSource.setByteStream(inputSource.getByteStream());
            xMLInputSource.setCharacterStream(inputSource.getCharacterStream());
            xMLInputSource.setEncoding(inputSource.getEncoding());
            this.parse(xMLInputSource);
        }
        catch (XMLParseException xMLParseException) {
            Exception exception = xMLParseException.getException();
            if (exception == null) {
                LocatorImpl locatorImpl = new LocatorImpl();
                locatorImpl.setPublicId(xMLParseException.getPublicId());
                locatorImpl.setSystemId(xMLParseException.getSystemId());
                locatorImpl.setLineNumber(xMLParseException.getLineNumber());
                locatorImpl.setColumnNumber(xMLParseException.getColumnNumber());
                throw new SAXParseException(xMLParseException.getMessage(), locatorImpl);
            }
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new SAXException(exception);
        }
        catch (XNIException xNIException) {
            Exception exception = xNIException.getException();
            if (exception == null) {
                throw new SAXException(xNIException.getMessage());
            }
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new SAXException(exception);
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        try {
            this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", new EntityResolverWrapper(entityResolver));
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    public EntityResolver getEntityResolver() {
        EntityResolver entityResolver = null;
        try {
            XMLEntityResolver xMLEntityResolver = (XMLEntityResolver)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/entity-resolver");
            if (xMLEntityResolver != null && xMLEntityResolver instanceof EntityResolverWrapper) {
                entityResolver = ((EntityResolverWrapper)xMLEntityResolver).getEntityResolver();
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        return entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        try {
            this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/error-handler", new ErrorHandlerWrapper(errorHandler));
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    public ErrorHandler getErrorHandler() {
        ErrorHandler errorHandler = null;
        try {
            XMLErrorHandler xMLErrorHandler = (XMLErrorHandler)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/error-handler");
            if (xMLErrorHandler != null && xMLErrorHandler instanceof ErrorHandlerWrapper) {
                errorHandler = ((ErrorHandlerWrapper)xMLErrorHandler).getErrorHandler();
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        return errorHandler;
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            this.fConfiguration.setFeature(string, bl);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string2 = xMLConfigurationException.getMessage();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(string2);
            }
            throw new SAXNotSupportedException(string2);
        }
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            return this.fConfiguration.getFeature(string);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string2 = xMLConfigurationException.getMessage();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(string2);
            }
            throw new SAXNotSupportedException(string2);
        }
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            this.fConfiguration.setProperty(string, object);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string2 = xMLConfigurationException.getMessage();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(string2);
            }
            throw new SAXNotSupportedException(string2);
        }
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            return this.fConfiguration.getProperty(string);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string2 = xMLConfigurationException.getMessage();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(string2);
            }
            throw new SAXNotSupportedException(string2);
        }
    }
}

