/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHMethodDeclaration;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.ReturnControl;
import bsh.SimpleNode;
import java.io.Serializable;

class BshMethod
implements Serializable {
    BSHMethodDeclaration method;
    NameSpace declaringNameSpace;
    private Class[] argTypes;

    BshMethod(BSHMethodDeclaration bSHMethodDeclaration, NameSpace nameSpace) {
        this.method = bSHMethodDeclaration;
        this.declaringNameSpace = nameSpace;
    }

    public Class[] getArgTypes() {
        if (this.argTypes == null) {
            this.argTypes = this.method.params.argTypes;
        }
        return this.argTypes;
    }

    public Object invokeDeclaredMethod(Object[] objectArray, Interpreter interpreter, CallStack callStack, SimpleNode simpleNode) throws EvalError {
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        if (objectArray.length != this.method.params.numArgs) {
            try {
                String string = (String)this.declaringNameSpace.get("bsh.help." + this.method.name, interpreter);
                interpreter.println(string);
                return Primitive.VOID;
            }
            catch (Exception exception) {
                throw new EvalError("Wrong number of arguments for local method: " + this.method.name, simpleNode);
            }
        }
        NameSpace nameSpace = new NameSpace(this.declaringNameSpace, this.method.name);
        nameSpace.setNode(simpleNode);
        int n = 0;
        while (n < this.method.params.numArgs) {
            if (this.method.params.argTypes[n] != null) {
                try {
                    objectArray[n] = NameSpace.getAssignableForm(objectArray[n], this.method.params.argTypes[n]);
                }
                catch (EvalError evalError) {
                    throw new EvalError("Invalid argument: `" + this.method.params.argNames[n] + "'" + " for method: " + this.method.name + " : " + evalError.getMessage(), simpleNode);
                }
                nameSpace.setTypedVariable(this.method.params.argNames[n], this.method.params.argTypes[n], objectArray[n], false);
            } else {
                if (objectArray[n] == Primitive.VOID) {
                    throw new EvalError("Undefined variable or class name, parameter: " + this.method.params.argNames[n] + " to method: " + this.method.name, simpleNode);
                }
                nameSpace.setVariable(this.method.params.argNames[n], objectArray[n]);
            }
            ++n;
        }
        callStack.push(nameSpace);
        Object object = this.method.block.eval(callStack, interpreter, true);
        callStack.pop();
        if (object instanceof ReturnControl) {
            ReturnControl returnControl = (ReturnControl)object;
            if (returnControl.kind == 41) {
                object = ((ReturnControl)object).value;
            } else {
                throw new EvalError("continue or break in method body", this.method);
            }
        }
        if (this.method.returnType != null) {
            if (this.method.returnType == Primitive.VOID) {
                return this.method.returnType;
            }
            try {
                object = NameSpace.getAssignableForm(object, (Class)this.method.returnType);
            }
            catch (EvalError evalError) {
                throw new EvalError("Incorrect type returned from method: " + this.method.name + evalError.getMessage(), this.method);
            }
        }
        return object;
    }

    public String toString() {
        return "Bsh Method: " + this.method.name;
    }
}

