/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.logger;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.lib.logger.TraceLogger;
import org.netbeans.lib.logger.impl.FlagsAsStrings;
import org.netbeans.lib.logger.impl.TraceLoggerImpl;
import org.netbeans.modules.logger.FlagEditor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class FlagArrayCustomEditor
extends JPanel {
    static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$logger$FlagArrayCustomEditor == null ? (class$org$netbeans$modules$logger$FlagArrayCustomEditor = FlagArrayCustomEditor.class$("org.netbeans.modules.logger.FlagArrayCustomEditor")) : class$org$netbeans$modules$logger$FlagArrayCustomEditor));
    private Vector itemsVector;
    private Vector filesVector;
    private HashMap flagTable;
    private FlagEditor editor;
    private TraceLoggerImpl lgrImpl;
    private static final int DEFAULT_WIDTH = 400;
    private JPanel jPanel1;
    private JSeparator jSeparator2;
    private JComboBox fileComboBox;
    private JTextArea loggerSettingField;
    private JLabel fileLabel;
    private JList itemList;
    private JTextField itemField;
    private JLabel itemLabel;
    private JPanel buttonsPanel;
    private JButton addButton;
    private JButton changeButton;
    private JButton removeButton;
    private JPanel paddingPanel;
    static /* synthetic */ Class class$org$netbeans$modules$logger$FlagArrayCustomEditor;

    public FlagArrayCustomEditor(FlagEditor flagEditor) {
        this.editor = flagEditor;
        TraceLogger traceLogger = TraceLogger.getTraceLogger();
        this.lgrImpl = (TraceLoggerImpl)traceLogger;
        this.filesVector = this.lgrImpl.getLogStreamNames();
        this.fillFlagTable();
        this.itemsVector = new Vector();
        this.initComponents();
        this.loggerSettingField.setText((String)this.editor.getValue());
        int n = 0;
        while (n < this.filesVector.size()) {
            this.fileComboBox.addItem(this.filesVector.elementAt(n));
            ++n;
        }
        this.fileComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)FlagArrayCustomEditor.this.fileComboBox.getSelectedItem();
                try {
                    FlagArrayCustomEditor.this.lgrImpl.validateLogFile(string);
                    FlagArrayCustomEditor.this.itemsVector = (Vector)FlagArrayCustomEditor.this.flagTable.get(string);
                    if (FlagArrayCustomEditor.this.itemsVector == null) {
                        FlagArrayCustomEditor.this.itemsVector = new Vector();
                        FlagArrayCustomEditor.this.flagTable.put(string, FlagArrayCustomEditor.this.itemsVector);
                        FlagArrayCustomEditor.this.fileComboBox.addItem(string);
                        FlagArrayCustomEditor.this.filesVector.add(string);
                    }
                    FlagArrayCustomEditor.this.itemList.setListData(FlagArrayCustomEditor.this.itemsVector);
                }
                catch (Throwable throwable) {
                    NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception(throwable);
                    TopManager.getDefault().notify((NotifyDescriptor)exception);
                }
            }
        });
        this.itemList.setCellRenderer(new EmptyStringListCellRenderer());
        this.itemsVector = (Vector)this.flagTable.get(this.filesVector.elementAt(0));
        this.itemList.setListData(this.itemsVector);
        this.itemList.setSelectionMode(0);
        this.setBorder(new EmptyBorder(new Insets(16, 8, 8, 0)));
        this.buttonsPanel.setBorder(new EmptyBorder(new Insets(0, 5, 5, 5)));
        this.itemLabel.setText(bundle.getString("CTL_Item"));
        this.fileLabel.setText(bundle.getString("logFileLabel"));
        this.addButton.setText(bundle.getString("CTL_Add"));
        this.changeButton.setText(bundle.getString("CTL_Change"));
        this.removeButton.setText(bundle.getString("CTL_Remove"));
        this.updateButtons();
        HelpCtx.setHelpIDString((JComponent)this, (String)(class$org$netbeans$modules$logger$FlagArrayCustomEditor == null ? (class$org$netbeans$modules$logger$FlagArrayCustomEditor = FlagArrayCustomEditor.class$("org.netbeans.modules.logger.FlagArrayCustomEditor")) : class$org$netbeans$modules$logger$FlagArrayCustomEditor).getName());
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.max(dimension.width, 400), dimension.height);
    }

    public void fillFlagTable() {
        this.flagTable = new HashMap();
        this.filesVector = this.lgrImpl.getLogStreamNames();
        int n = 0;
        while (n < this.filesVector.size()) {
            Vector<String> vector = new Vector<String>();
            Vector vector2 = this.lgrImpl.getStreamFlagsAsStrings((String)this.filesVector.elementAt(n));
            int n2 = 0;
            while (n2 < vector2.size()) {
                FlagsAsStrings flagsAsStrings = (FlagsAsStrings)vector2.elementAt(n2);
                vector.add(flagsAsStrings.toString());
                ++n2;
            }
            this.flagTable.put((String)this.filesVector.elementAt(n), vector);
            ++n;
        }
    }

    public String generateFlagSetting() {
        String string = " ";
        int n = 0;
        while (n < this.filesVector.size()) {
            String string2 = (String)this.filesVector.elementAt(n);
            string = string + string2 + "(";
            Vector vector = (Vector)this.flagTable.get(string2);
            int n2 = 0;
            while (n2 < vector.size()) {
                string = string + (String)vector.elementAt(n2) + " ";
                ++n2;
            }
            string = string + ") ";
            ++n;
        }
        return string;
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.generateFlagSetting();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jSeparator2 = new JSeparator();
        this.fileComboBox = new JComboBox();
        this.loggerSettingField = new JTextArea();
        this.fileLabel = new JLabel();
        this.itemList = new JList();
        this.itemField = new JTextField();
        this.itemLabel = new JLabel();
        this.buttonsPanel = new JPanel();
        this.addButton = new JButton();
        this.changeButton = new JButton();
        this.removeButton = new JButton();
        this.paddingPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(200, 400));
        this.setBorder(new EmptyBorder(new Insets(16, 8, 8, 0)));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setPreferredSize(new Dimension(128, 43));
        this.jPanel1.setAlignmentY(0.0f);
        this.jPanel1.setAlignmentX(0.0f);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jSeparator2, gridBagConstraints);
        this.fileComboBox.setPreferredSize(new Dimension(120, 25));
        this.fileComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.fileComboBox, gridBagConstraints);
        this.loggerSettingField.setBorder(new EtchedBorder(Color.white, Color.black));
        this.loggerSettingField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                FlagArrayCustomEditor.this.loggerSettingFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.loggerSettingField, gridBagConstraints);
        this.fileLabel.setText("xxx");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.fileLabel, gridBagConstraints);
        this.itemList.setBorder(new EtchedBorder(Color.white, Color.black));
        this.itemList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FlagArrayCustomEditor.this.itemListValueChanged(listSelectionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.itemList, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.itemField, gridBagConstraints);
        this.itemLabel.setText("xxx");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.itemLabel, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FlagArrayCustomEditor.this.addButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 8, 0, 8);
        gridBagConstraints2.weightx = 1.0;
        this.buttonsPanel.add((Component)this.addButton, gridBagConstraints2);
        this.changeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FlagArrayCustomEditor.this.changeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(8, 8, 0, 8);
        gridBagConstraints2.weightx = 1.0;
        this.buttonsPanel.add((Component)this.changeButton, gridBagConstraints2);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FlagArrayCustomEditor.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(8, 8, 8, 8);
        gridBagConstraints2.weightx = 1.0;
        this.buttonsPanel.add((Component)this.removeButton, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weighty = 1.0;
        this.buttonsPanel.add((Component)this.paddingPanel, gridBagConstraints2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 12;
        this.jPanel1.add((Component)this.buttonsPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.insets = new Insets(0, 4, 0, 4);
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints3);
    }

    private void loggerSettingFieldFocusLost(FocusEvent focusEvent) {
        try {
            this.editor.setValue(this.loggerSettingField.getText());
            this.fillFlagTable();
            String string = (String)this.fileComboBox.getSelectedItem();
            this.itemsVector = (Vector)this.flagTable.get(string);
            if (this.itemsVector == null) {
                this.itemsVector = new Vector();
                this.flagTable.put(string, this.itemsVector);
                this.fileComboBox.addItem(string);
                this.filesVector.add(string);
            }
            this.itemList.setListData(this.itemsVector);
        }
        catch (Throwable throwable) {
            NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception(throwable);
            TopManager.getDefault().notify((NotifyDescriptor)exception);
        }
    }

    private void jTextField1ActionPerformed(ActionEvent actionEvent) {
    }

    private void loggerSettingFieldInputMethodTextChanged(InputMethodEvent inputMethodEvent) {
    }

    private void changeButtonActionPerformed(ActionEvent actionEvent) {
        try {
            this.lgrImpl.parseFlags(this.itemField.getText());
            int n = this.itemList.getSelectedIndex();
            String string = (String)this.itemsVector.elementAt(n);
            this.itemsVector.removeElementAt(n);
            this.itemsVector.insertElementAt(this.itemField.getText(), n);
            this.itemList.setListData(this.itemsVector);
            this.itemList.setSelectedIndex(n);
            this.itemList.repaint();
            this.updateValue();
        }
        catch (Throwable throwable) {
            NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception(throwable);
            TopManager.getDefault().notify((NotifyDescriptor)exception);
        }
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.itemList.getSelectedIndex();
        this.itemsVector.removeElementAt(n);
        this.itemList.setListData(this.itemsVector);
        if (this.itemsVector.size() != 0) {
            if (n >= this.itemsVector.size()) {
                n = this.itemsVector.size() - 1;
            }
            this.itemList.setSelectedIndex(n);
        }
        this.itemList.repaint();
        this.updateValue();
    }

    private void itemListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateButtons();
        int n = this.itemList.getSelectedIndex();
        if (n != -1) {
            this.itemField.setText((String)this.itemsVector.elementAt(n));
        }
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        try {
            this.lgrImpl.parseFlags(this.itemField.getText());
            this.itemsVector.addElement(this.itemField.getText());
            this.itemList.setListData(this.itemsVector);
            this.itemList.setSelectedIndex(this.itemsVector.size() - 1);
            this.itemList.repaint();
            this.updateValue();
        }
        catch (Throwable throwable) {
            NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception(throwable);
            TopManager.getDefault().notify((NotifyDescriptor)exception);
        }
    }

    private void updateButtons() {
        int n = this.itemList.getSelectedIndex();
        if (n == -1) {
            this.removeButton.setEnabled(false);
            this.changeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
            this.changeButton.setEnabled(true);
        }
    }

    private void updateValue() {
        try {
            this.editor.setValue(this.generateFlagSetting());
            this.loggerSettingField.setText((String)this.editor.getValue());
        }
        catch (Throwable throwable) {
            NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception(throwable);
            TopManager.getDefault().notify((NotifyDescriptor)exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class EmptyStringListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        protected static Border hasFocusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
        protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public EmptyStringListCellRenderer() {
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (!(object instanceof String)) {
                return this;
            }
            String string = (String)object;
            if ("".equals(string)) {
                string = bundle.getString("CTL_Empty");
            }
            this.setText(string);
            if (bl) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setBorder(bl2 ? hasFocusBorder : noFocusBorder);
            return this;
        }
    }
}

