/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.SecureClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import koala.dynamicjava.interpreter.ClassLoaderContainer;
import koala.dynamicjava.interpreter.Interpreter;
import koala.dynamicjava.tree.TypeDeclaration;

public class TreeClassLoader
extends SecureClassLoader
implements ClassLoaderContainer {
    public static String DEFAULT_CODE_SOURCE_URL = "http://koala.ilog.fr/djava/javadoc/koala/dynamicjava/interpreter/TreeClassLoader.html";
    public static String CODE_SOURCE_URL_PROPERTY = "koala.dynamicjava.interpreter.TreeClassLoader.codesource.url";
    protected static CodeSource codeSource;
    protected Map classes = new HashMap(11);
    protected Map trees = new HashMap(11);
    protected Interpreter interpreter;
    protected ClassLoader classLoader;

    public TreeClassLoader(Interpreter interpreter) {
        this(interpreter, null);
    }

    public TreeClassLoader(Interpreter interpreter, ClassLoader classLoader) {
        super(interpreter.getClass().getClassLoader());
        this.interpreter = interpreter;
        this.classLoader = classLoader;
    }

    public Class defineClass(String string, byte[] byArray) {
        Class<?> clazz = this.defineClass(string, byArray, 0, byArray.length, codeSource);
        this.classes.put(string, clazz);
        this.trees.remove(string);
        return clazz;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean hasDefined(String string) {
        return this.classes.containsKey(string);
    }

    public Set getClassNames() {
        return this.classes.keySet();
    }

    public void addTree(String string, TypeDeclaration typeDeclaration) {
        this.trees.put(string, typeDeclaration);
    }

    public TypeDeclaration getTree(String string) {
        return (TypeDeclaration)this.trees.get(string);
    }

    public void addURL(URL uRL) {
        this.classLoader = this.classLoader == null ? new URLClassLoader(new URL[]{uRL}) : new URLClassLoader(new URL[]{uRL}, this.classLoader);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        if (this.classes.containsKey(string)) {
            return (Class)this.classes.get(string);
        }
        try {
            if (this.classLoader != null) {
                return Class.forName(string, true, this.classLoader);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return this.interpreter.loadClass(string);
    }

    static {
        try {
            String string = System.getProperty(CODE_SOURCE_URL_PROPERTY);
            if (string != null) {
                codeSource = new CodeSource(new URL(string), null);
            }
        }
        catch (MalformedURLException malformedURLException) {
            codeSource = new CodeSource(null, null);
        }
        try {
            codeSource = new CodeSource(new URL(DEFAULT_CODE_SOURCE_URL), null);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException.getMessage());
        }
    }
}

