/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.CompletionQuery;

class XMLResultItem
implements CompletionQuery.ResultItem {
    public String displayText;
    public Icon icon;
    public Color foreground = Color.black;
    public Color background = Color.white;
    public Color selectionForeground = Color.black;
    public Color selectionBackground = new Color(204, 204, 255);
    private static JLabel rubberStamp = new JLabel();

    public XMLResultItem() {
    }

    public XMLResultItem(String displayText) {
        this.displayText = displayText;
    }

    public XMLResultItem(String displayText, Icon icon, Color foreground, Color background, Color selectionForeground, Color selectionBackground) {
        this.displayText = displayText;
        this.icon = icon;
        this.foreground = foreground;
        this.background = background;
        this.selectionForeground = selectionForeground;
        this.selectionBackground = selectionBackground;
    }

    public String getReplacementText(int modifiers) {
        return this.displayText;
    }

    protected Icon getIcon() {
        return this.icon;
    }

    boolean replaceText(JTextComponent component, String text, int offset, int len) {
        BaseDocument doc = (BaseDocument)component.getDocument();
        doc.atomicLock();
        try {
            try {
                doc.remove(offset, len);
                doc.insertString(offset, text, null);
            }
            catch (BadLocationException exc) {
                boolean bl = false;
                Object var9_7 = null;
                doc.atomicUnlock();
                return bl;
            }
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            doc.atomicUnlock();
            throw throwable;
        }
        doc.atomicUnlock();
        return true;
    }

    public boolean substituteCommonText(JTextComponent c, int offset, int len, int subLen) {
        return this.replaceText(c, this.getReplacementText(0).substring(0, subLen), offset, len);
    }

    public final boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
        int modifier = shift ? 1 : 0;
        return this.substituteText(c, offset, len, modifier);
    }

    public boolean substituteText(JTextComponent c, int offset, int len, int modifiers) {
        return this.replaceText(c, this.getReplacementText(modifiers), offset, len);
    }

    public Component getPaintComponent(JList list, boolean isSelected, boolean cellHasFocus) {
        if (this.getIcon() != null) {
            rubberStamp.setIcon(this.getIcon());
        }
        rubberStamp.setText(this.getItemText());
        if (isSelected) {
            rubberStamp.setBackground(this.selectionBackground);
            rubberStamp.setForeground(this.selectionForeground);
        } else {
            rubberStamp.setBackground(this.background);
            rubberStamp.setForeground(this.foreground);
        }
        return rubberStamp;
    }

    public final String getItemText() {
        return this.displayText;
    }

    static {
        rubberStamp.setOpaque(true);
    }
}

