/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.syntax;

import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.xml.text.completion.XMLCompletion;
import org.netbeans.modules.xml.text.syntax.UniKit;
import org.netbeans.modules.xml.text.syntax.XMLDefaultSyntax;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.openide.TopManager;

public class XMLKit
extends UniKit {
    private static final long serialVersionUID = 5326735092324267367L;
    public static final String xmlCommentAction = "xml-comment";
    public static final String xmlUncommentAction = "xml-uncomment";
    public static final String xmlTestAction = "xml-dump";
    public static Map settings;

    public Syntax createSyntax(Document doc) {
        return new XMLDefaultSyntax();
    }

    public Document createDefaultDocument() {
        return new NbEditorDocument(((Object)((Object)this)).getClass());
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument doc) {
        return new XMLSyntaxSupport(doc);
    }

    public Completion createCompletion(ExtEditorUI extEditorUI) {
        return new XMLCompletion(extEditorUI);
    }

    public static void setMap(Map map) {
        settings = map;
    }

    public Map getMap() {
        return settings;
    }

    public String getContentType() {
        return "text/xml";
    }

    protected Action[] createActions() {
        Action[] actions = new Action[]{new XMLCommentAction(), new XMLUncommentAction(), new TestAction()};
        return TextAction.augmentList(super.createActions(), actions);
    }

    public static class TestAction
    extends XMLEditorAction {
        private static final long serialVersionUID = 4004056745446099L;

        public TestAction() {
            super(XMLKit.xmlTestAction);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target == null) {
                return;
            }
            if (!target.isEditable() || !target.isEnabled()) {
                this.problem(null);
                return;
            }
            Caret caret = target.getCaret();
            BaseDocument doc = (BaseDocument)target.getDocument();
            try {
                doc.dump(System.out);
                if (target == null) {
                    throw new BadLocationException(null, 0);
                }
            }
            catch (BadLocationException e) {
                this.problem(null);
            }
        }
    }

    public static class XMLUncommentAction
    extends XMLEditorAction {
        private static final String commentStartString = "<!--";
        private static final String commentEndString = "-->";
        private static final char[] commentStart = new char[]{'<', '!', '-', '-'};
        private static final char[] commentEnd = new char[]{'-', '-', '>'};
        static final long serialVersionUID = 40040567454546061L;

        public XMLUncommentAction() {
            super(XMLKit.xmlUncommentAction);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            block11: {
                if (target == null) {
                    return;
                }
                if (!target.isEditable() || !target.isEnabled()) {
                    this.problem(null);
                    return;
                }
                Caret caret = target.getCaret();
                BaseDocument doc = (BaseDocument)target.getDocument();
                try {
                    if (caret.isSelectionVisible()) {
                        int startPos = Utilities.getRowStart((BaseDocument)doc, (int)target.getSelectionStart());
                        int endPos = target.getSelectionEnd();
                        doc.atomicLock();
                        try {
                            if (endPos > 0 && Utilities.getRowStart((BaseDocument)doc, (int)endPos) == endPos) {
                                --endPos;
                            }
                            int pos = startPos;
                            int lineCnt = Utilities.getRowCount((BaseDocument)doc, (int)startPos, (int)endPos);
                            while (lineCnt > 0) {
                                char[] startChars = doc.getChars(pos, 4);
                                char[] endChars = doc.getChars(Utilities.getRowEnd((BaseDocument)doc, (int)pos) - 3, 3);
                                if (startChars[0] == commentStart[0] && startChars[1] == commentStart[1] && startChars[2] == commentStart[2] && startChars[3] == commentStart[3] && endChars[0] == commentEnd[0] && endChars[1] == commentEnd[1] && endChars[2] == commentEnd[2]) {
                                    doc.remove(pos, 4);
                                    doc.remove(Utilities.getRowEnd((BaseDocument)doc, (int)pos) - 3, 3);
                                }
                                pos = Utilities.getRowStart((BaseDocument)doc, (int)pos, (int)1);
                                --lineCnt;
                            }
                            Object var12_14 = null;
                        }
                        catch (Throwable throwable) {
                            Object var12_15 = null;
                            doc.atomicUnlock();
                            throw throwable;
                        }
                        doc.atomicUnlock();
                        {
                            break block11;
                        }
                    }
                    char[] startChars = doc.getChars(target.getSelectionStart(), 4);
                    char[] endChars = doc.getChars(Utilities.getRowEnd((BaseDocument)doc, (int)target.getSelectionStart()) - 3, 3);
                    if (startChars[0] == commentStart[0] && startChars[1] == commentStart[1] && startChars[2] == commentStart[2] && startChars[3] == commentStart[3] && endChars[0] == commentEnd[0] && endChars[1] == commentEnd[1] && endChars[2] == commentEnd[2]) {
                        doc.remove(target.getSelectionStart(), 4);
                        doc.remove(Utilities.getRowEnd((BaseDocument)doc, (int)target.getSelectionStart()) - 3, 3);
                    }
                }
                catch (BadLocationException e) {
                    this.problem(null);
                }
            }
        }
    }

    public static class XMLCommentAction
    extends XMLEditorAction {
        private static final long serialVersionUID = 4004056745446061L;
        private static final String commentStartString = "<!--";
        private static final String commentEndString = "-->";

        public XMLCommentAction() {
            super(XMLKit.xmlCommentAction);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            block9: {
                if (target == null) {
                    return;
                }
                if (!target.isEditable() || !target.isEnabled()) {
                    this.problem(null);
                    return;
                }
                Caret caret = target.getCaret();
                BaseDocument doc = (BaseDocument)target.getDocument();
                try {
                    if (caret.isSelectionVisible()) {
                        int startPos = Utilities.getRowStart((BaseDocument)doc, (int)target.getSelectionStart());
                        int endPos = target.getSelectionEnd();
                        doc.atomicLock();
                        try {
                            if (endPos > 0 && Utilities.getRowStart((BaseDocument)doc, (int)endPos) == endPos) {
                                --endPos;
                            }
                            int pos = startPos;
                            int lineCnt = Utilities.getRowCount((BaseDocument)doc, (int)startPos, (int)endPos);
                            while (lineCnt > 0) {
                                doc.insertString(pos, commentStartString, null);
                                doc.insertString(Utilities.getRowEnd((BaseDocument)doc, (int)pos), commentEndString, null);
                                pos = Utilities.getRowStart((BaseDocument)doc, (int)pos, (int)1);
                                --lineCnt;
                            }
                            Object var10_10 = null;
                        }
                        catch (Throwable throwable) {
                            Object var10_11 = null;
                            doc.atomicUnlock();
                            throw throwable;
                        }
                        doc.atomicUnlock();
                        {
                            break block9;
                        }
                    }
                    doc.insertString(Utilities.getRowStart((BaseDocument)doc, (int)target.getSelectionStart()), commentStartString, null);
                    doc.insertString(Utilities.getRowEnd((BaseDocument)doc, (int)target.getSelectionStart()), commentEndString, null);
                }
                catch (BadLocationException e) {
                    this.problem(null);
                }
            }
        }
    }

    public static abstract class XMLEditorAction
    extends BaseAction {
        public XMLEditorAction(String id) {
            super(id);
        }

        protected void problem(String reason) {
            if (reason != null) {
                TopManager.getDefault().setStatusText("Cannot proceed: " + reason);
            }
            new Panel().getToolkit().beep();
        }
    }
}

