/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.form;

import java.awt.Container;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.InfoPanel;
import org.netbeans.modules.i18n.form.FormI18nString;
import org.netbeans.modules.i18n.form.FormI18nStringEditor;
import org.netbeans.modules.i18n.form.FormI18nSupport;
import org.netbeans.modules.i18n.java.JavaI18nString;
import org.netbeans.modules.i18n.java.JavaI18nSupport;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.windows.TopComponent;

public class FormI18nSupport
extends JavaI18nSupport {
    private static final String DEBUG = "netbeans.debug.exceptions";

    public FormI18nSupport(DataObject sourceDataObject) {
        super(sourceDataObject);
    }

    protected I18nSupport.I18nFinder createFinder() {
        return new FormI18nFinder(((I18nSupport)this).sourceDataObject, ((I18nSupport)this).document);
    }

    protected I18nSupport.I18nReplacer createReplacer() {
        return new FormI18nReplacer((FormI18nFinder)this.getFinder());
    }

    public JPanel getInfo(HardCodedString hcString) {
        return new FormInfoPanel(hcString, ((I18nSupport)this).document);
    }

    public static class Factory
    extends I18nSupport.Factory {
        static /* synthetic */ Class class$org$netbeans$modules$form$FormDataObject;

        public I18nSupport create(DataObject dataObject) throws IOException {
            I18nSupport support = super.create(dataObject);
            FormEditorSupport formSupport = ((FormDataObject)dataObject).getFormEditor();
            if (formSupport.isOpened()) {
                return support;
            }
            if (formSupport.loadForm()) {
                return support;
            }
            throw new IOException("I18N: Loading form for " + dataObject.getName() + " was not succesful.");
        }

        public I18nSupport createI18nSupport(DataObject dataObject) {
            return new FormI18nSupport(dataObject);
        }

        public Class getDataObjectClass() {
            return class$org$netbeans$modules$form$FormDataObject == null ? (class$org$netbeans$modules$form$FormDataObject = Factory.class$("org.netbeans.modules.form.FormDataObject")) : class$org$netbeans$modules$form$FormDataObject;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class FormInfoPanel
    extends InfoPanel {
        public FormInfoPanel(HardCodedString hcString, StyledDocument document) {
            super(hcString, document);
        }

        protected void setHardCodedString(HardCodedString hcString, StyledDocument document) {
            String hardLine;
            this.getStringText().setText(hcString == null ? "" : hcString.getText());
            if (hcString.getStartPosition() == null) {
                hardLine = "";
            } else {
                int pos = hcString.getStartPosition().getOffset();
                try {
                    Element paragraph = document.getParagraphElement(pos);
                    hardLine = document.getText(paragraph.getStartOffset(), paragraph.getEndOffset() - paragraph.getStartOffset()).trim();
                }
                catch (BadLocationException ble) {
                    hardLine = "";
                }
            }
            this.getFoundInText().setText(hardLine);
            if (hcString instanceof FormHardCodedString) {
                this.getComponentText().setText(((FormHardCodedString)hcString).getValidProperty().getRADComponentName());
                this.getPropertyText().setText(((FormHardCodedString)hcString).getNodeProperty().getName());
            } else {
                ((Container)((Object)this)).remove(this.getComponentLabel());
                ((Container)((Object)this)).remove(this.getComponentText());
                ((Container)((Object)this)).remove(this.getPropertyLabel());
                ((Container)((Object)this)).remove(this.getPropertyText());
            }
        }
    }

    private static class FormHardCodedString
    extends HardCodedString {
        private ValidFormProperty validProperty;
        private Node.Property nodeProperty;

        FormHardCodedString(String text, Position startPosition, Position endPosition, ValidFormProperty validProperty, Node.Property nodeProperty) {
            super(text, startPosition, endPosition);
            this.validProperty = validProperty;
            this.nodeProperty = nodeProperty;
        }

        public ValidFormProperty getValidProperty() {
            return this.validProperty;
        }

        public Node.Property getNodeProperty() {
            return this.nodeProperty;
        }
    }

    private static class FormI18nReplacer
    extends JavaI18nSupport.JavaI18nReplacer {
        private FormI18nFinder finder;

        public FormI18nReplacer(FormI18nFinder finder) {
            this.finder = finder;
        }

        public void replace(HardCodedString hcString, I18nString i18nString) {
            if (hcString instanceof FormHardCodedString) {
                this.replaceInGuarded((FormHardCodedString)hcString, (JavaI18nString)i18nString);
            } else {
                super.replace(hcString, i18nString);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void replaceInGuarded(FormHardCodedString formHcString, JavaI18nString javaI18nString) {
            try {
                Object newValue;
                String oldString;
                String replaceString = javaI18nString.getReplaceString();
                int lastPos = this.finder.getLastPosition().getOffset();
                int pos = formHcString.getEndPosition().getOffset();
                Node.Property nodeProperty = formHcString.getNodeProperty();
                ValidFormProperty validProp = formHcString.getValidProperty();
                Object oldValue = nodeProperty.getValue();
                if (nodeProperty instanceof RADProperty) {
                    if (oldValue instanceof RADConnectionPropertyEditor.RADConnectionDesignValue && ((RADConnectionPropertyEditor.RADConnectionDesignValue)oldValue).getType() == 2) {
                        oldString = ((RADConnectionPropertyEditor.RADConnectionDesignValue)oldValue).getCode();
                        StringBuffer buff = new StringBuffer(oldString);
                        int index = this.indexOfHardString(oldString, formHcString.getText(), validProp.getSkip());
                        if (index == -1) {
                            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)I18nUtil.getBundle().getString("MSG_StringNotFoundInGuarded"), 0);
                            TopManager.getDefault().notify((NotifyDescriptor)message);
                            return;
                        }
                        int startOffset = index;
                        int endOffset = startOffset + formHcString.getText().length() + 2;
                        buff.replace(startOffset, endOffset, replaceString);
                        RADConnectionPropertyEditor.RADConnectionDesignValue newConnectionValue = new RADConnectionPropertyEditor.RADConnectionDesignValue(buff.toString());
                        newValue = newConnectionValue;
                    } else {
                        ((RADProperty)nodeProperty).setCurrentEditor((PropertyEditor)new FormI18nStringEditor());
                        newValue = new FormI18nString(javaI18nString);
                    }
                } else {
                    oldString = (String)oldValue;
                    StringBuffer buff = new StringBuffer(oldString);
                    int index = this.indexOfHardString(oldString, formHcString.getText(), validProp.getSkip());
                    if (index == -1) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)I18nUtil.getBundle().getString("MSG_StringNotFoundInGuarded"), 0);
                        TopManager.getDefault().notify((NotifyDescriptor)message);
                        return;
                    }
                    int startOffset = index;
                    int endOffset = startOffset + formHcString.getText().length() + 2;
                    buff.replace(startOffset, endOffset, replaceString);
                    newValue = buff.toString();
                }
                nodeProperty.setValue(newValue);
                this.finder.decrementLastFoundSkip();
                StyledDocument document = javaI18nString.getSupport().getDocument();
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)((Object)document)).readLock();
                }
                try {
                    try {
                        this.finder.setLastPosition(document.createPosition(lastPos += replaceString.length() - formHcString.getText().length() - 2));
                    }
                    catch (BadLocationException ble) {
                        if (Boolean.getBoolean(FormI18nSupport.DEBUG)) {
                            System.err.println("I18N: Form support: Position reset in guarded block not successful.");
                        }
                        Object var17_26 = null;
                        if (!(document instanceof AbstractDocument)) return;
                        ((AbstractDocument)((Object)document)).readUnlock();
                        return;
                    }
                    Object var17_25 = null;
                }
                catch (Throwable throwable) {
                    Object var17_27 = null;
                    if (!(document instanceof AbstractDocument)) throw throwable;
                    ((AbstractDocument)((Object)document)).readUnlock();
                    throw throwable;
                }
                if (!(document instanceof AbstractDocument)) return;
                ((AbstractDocument)((Object)document)).readUnlock();
                return;
            }
            catch (IllegalAccessException iae) {
                if (!Boolean.getBoolean(FormI18nSupport.DEBUG)) return;
                iae.printStackTrace();
                return;
            }
            catch (InvocationTargetException ite) {
                if (!Boolean.getBoolean(FormI18nSupport.DEBUG)) return;
                ite.printStackTrace();
            }
        }

        private int indexOfHardString(String source, String hardString, int skip) {
            while (skip >= 0) {
                int index = this.finder.indexOfNonI18nString(source, hardString, skip);
                if (index >= 0) {
                    return index;
                }
                --skip;
            }
            return -1;
        }
    }

    private static class FormI18nFinder
    extends JavaI18nSupport.JavaI18nFinder {
        private DataObject sourceDataObject;
        private String componentName = "";
        private String propertyName = "";
        private TreeSet formProperties;
        private ValidFormProperty lastFoundProp;
        private boolean guardedPosition;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$org$openide$cookies$EditorCookie;
        static /* synthetic */ Class class$org$openide$windows$TopComponent;

        public FormI18nFinder(DataObject sourceDataObject, StyledDocument document) {
            super(document);
            this.sourceDataObject = sourceDataObject;
            this.init();
        }

        private void init() {
            this.clearFormInfoValues();
            this.lastFoundProp = null;
            this.createFormProperties();
        }

        protected void reset() {
            super.reset();
            this.init();
        }

        void decrementLastFoundSkip() {
            if (this.lastFoundProp != null) {
                this.lastFoundProp.decrementSkip();
            }
        }

        private synchronized boolean createFormProperties() {
            this.formProperties = new TreeSet(new ValidFormPropertyComparator((FormDataObject)this.sourceDataObject));
            this.updateFormProperties();
            return true;
        }

        private synchronized void updateFormProperties() {
            if (this.formProperties == null) {
                return;
            }
            List c = ((FormDataObject)this.sourceDataObject).getFormEditor().getFormModel().getMetaComponents();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                RADComponent radComponent = (RADComponent)it.next();
                Node.PropertySet[] propSets = radComponent.getProperties();
                int i = 0;
                while (i < propSets.length) {
                    String setName = propSets[i].getName();
                    if (setName == "properties" || setName == "properties2" || setName == "synthetic") {
                        Node.Property[] properties = propSets[i].getProperties();
                        int j = 0;
                        while (j < properties.length) {
                            block10: {
                                Node.Property property = properties[j];
                                if (!property.isHidden() && property instanceof RADProperty && ((RADProperty)property).isChanged()) {
                                    Object value;
                                    try {
                                        value = property.getValue();
                                    }
                                    catch (IllegalAccessException iae) {
                                        break block10;
                                    }
                                    catch (InvocationTargetException ite) {
                                        break block10;
                                    }
                                    if (value != null && (property.getValueType().equals(class$java$lang$String == null ? FormI18nFinder.class$("java.lang.String") : class$java$lang$String) || value instanceof RADConnectionPropertyEditor.RADConnectionDesignValue && (((RADConnectionPropertyEditor.RADConnectionDesignValue)value).getType() == 3 || ((RADConnectionPropertyEditor.RADConnectionDesignValue)value).getType() == 2))) {
                                        this.formProperties.add(new ValidFormProperty(radComponent.getName(), property));
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }

        protected HardCodedString findNextString() {
            HardCodedString hcString;
            this.clearFormInfoValues();
            boolean guarded = false;
            do {
                hcString = super.findNextString();
                if (this.i18nSearch) {
                    return hcString;
                }
                if (hcString == null) break;
                guarded = this.isGuardedPosition(hcString.getStartPosition().getOffset());
                if (!guarded) continue;
                hcString = this.findInForm(hcString);
            } while (guarded && hcString == null);
            return hcString;
        }

        private void clearFormInfoValues() {
            this.componentName = "";
            this.propertyName = "";
        }

        private synchronized HardCodedString findInForm(HardCodedString hcString) {
            Iterator it;
            boolean found = false;
            String hardString = hcString.getText();
            ValidFormProperty validProp = null;
            Node.Property nodeProperty = null;
            if (this.lastFoundProp != null) {
                validProp = this.lastFoundProp;
                it = this.formProperties.tailSet(this.lastFoundProp).iterator();
            } else {
                it = this.formProperties.iterator();
            }
            do {
                Object value;
                if (validProp == null && it.hasNext()) {
                    validProp = (ValidFormProperty)it.next();
                }
                if (validProp == null) break;
                Node.Property property = validProp.getProperty();
                String radCompName = validProp.getRADComponentName();
                try {
                    value = property.getValue();
                }
                catch (IllegalAccessException iae) {
                    if (Boolean.getBoolean(FormI18nSupport.DEBUG)) {
                        iae.printStackTrace();
                    }
                    validProp = null;
                    continue;
                }
                catch (InvocationTargetException ite) {
                    if (Boolean.getBoolean(FormI18nSupport.DEBUG)) {
                        ite.printStackTrace();
                    }
                    validProp = null;
                    continue;
                }
                if (value != null && (property.getValueType().equals(class$java$lang$String == null ? FormI18nFinder.class$("java.lang.String") : class$java$lang$String) || value instanceof RADConnectionPropertyEditor.RADConnectionDesignValue && (((RADConnectionPropertyEditor.RADConnectionDesignValue)value).getType() == 3 || ((RADConnectionPropertyEditor.RADConnectionDesignValue)value).getType() == 2))) {
                    String string;
                    if (property instanceof RADProperty) {
                        if (value instanceof FormI18nString) {
                            validProp = null;
                            continue;
                        }
                        if (value instanceof RADConnectionPropertyEditor.RADConnectionDesignValue) {
                            string = "";
                            RADConnectionPropertyEditor.RADConnectionDesignValue connectionValue = (RADConnectionPropertyEditor.RADConnectionDesignValue)value;
                            if (connectionValue.getType() == 3) {
                                string = connectionValue.getValue();
                                if (this.indexOfNonI18nString(string, hardString, validProp.getSkip()) != -1) {
                                    found = true;
                                }
                            } else if (connectionValue.getType() == 2 && this.indexOfNonI18nString(string = connectionValue.getCode(), hardString, validProp.getSkip()) != -1) {
                                found = true;
                            }
                        } else {
                            string = FormI18nFinder.toAscii((String)value);
                            if (validProp.getSkip() == 0 && string.equals(hardString)) {
                                found = true;
                            }
                        }
                    } else {
                        string = (String)value;
                        if (this.indexOfNonI18nString(string, hardString, validProp.getSkip()) != -1) {
                            found = true;
                        }
                    }
                }
                if (found) {
                    nodeProperty = property;
                    this.componentName = radCompName;
                    this.propertyName = property.getName();
                    break;
                }
                validProp = null;
            } while (it.hasNext());
            if (found) {
                this.lastFoundProp = new ValidFormProperty(validProp);
                this.lastFoundProp.incrementSkip();
                return new FormHardCodedString(hcString.getText(), hcString.getStartPosition(), hcString.getEndPosition(), validProp, nodeProperty);
            }
            return null;
        }

        public Position getLastPosition() {
            return this.lastPosition;
        }

        public void setLastPosition(Position lastPosition) {
            this.lastPosition = lastPosition;
        }

        public int indexOfNonI18nString(String source, String hardString, int skip) {
            int startString;
            int index = 0;
            int startIndex = 0;
            while ((startString = source.indexOf(34, startIndex)) != -1) {
                int endString = source.indexOf(34, startString + 1);
                int endLineIndex = source.indexOf(10, startString + 1);
                if (endLineIndex == -1 || endString < endLineIndex) {
                    int quote;
                    String partLine;
                    String foundString = source.substring(startString, endString + 1);
                    int startLine = source.indexOf(10, startIndex + 1);
                    if (startLine != -1 && startLine < startString) {
                        startIndex = startLine + 1;
                    }
                    if (this.isSearchedString(partLine = endLineIndex == -1 ? source.substring(startIndex) : ((quote = source.indexOf(34, endString + 1)) != -1 && quote < endLineIndex ? source.substring(startIndex, quote) + source.substring(quote, endLineIndex).replace('\"', '_') : source.substring(startIndex, endLineIndex)), foundString)) {
                        if (index == skip) {
                            if (foundString.equals("\"" + hardString + "\"")) {
                                return startString;
                            }
                            return -1;
                        }
                        ++index;
                    }
                    startIndex = endString + 1;
                    continue;
                }
                startIndex = endLineIndex + 1;
            }
            return -1;
        }

        private static String toAscii(String str) {
            StringBuffer buf = new StringBuffer(str.length() * 6);
            char[] chars = str.toCharArray();
            int i = 0;
            while (i < chars.length) {
                char c = chars[i];
                switch (c) {
                    case '\b': {
                        buf.append("\\b");
                        break;
                    }
                    case '\t': {
                        buf.append("\\t");
                        break;
                    }
                    case '\n': {
                        buf.append("\\n");
                        break;
                    }
                    case '\f': {
                        buf.append("\\f");
                        break;
                    }
                    case '\r': {
                        buf.append("\\r");
                        break;
                    }
                    case '\"': {
                        buf.append("\\\"");
                        break;
                    }
                    case '\\': {
                        buf.append("\\\\");
                        break;
                    }
                    default: {
                        if (c >= ' ' && c <= '\u007f') {
                            buf.append(c);
                            break;
                        }
                        buf.append("\\u");
                        String hex = Integer.toHexString(c);
                        int j = 0;
                        while (j < 4 - hex.length()) {
                            buf.append('0');
                            ++j;
                        }
                        buf.append(hex);
                    }
                }
                ++i;
            }
            return buf.toString();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private synchronized boolean isGuardedPosition(int position) {
            Class clazz;
            class CheckUndoableEditListener
            implements UndoableEditListener {
                private UndoableEdit edit;
                private final /* synthetic */ FormI18nFinder this$0;

                CheckUndoableEditListener(FormI18nFinder this$0) {
                    this.this$0 = this$0;
                }

                public void undoableEditHappened(UndoableEditEvent evt) {
                    this.edit = evt.getEdit();
                }

                public UndoableEdit getEdit() {
                    return this.edit;
                }
            }
            CheckUndoableEditListener undoListener;
            block22: {
                block20: {
                    this.guardedPosition = false;
                    StyledDocument document = this.document;
                    undoListener = new CheckUndoableEditListener(this);
                    try {
                        try {
                            NbDocument.runAtomicAsUser((StyledDocument)document, (Runnable)new Runnable(this, document, undoListener, position){
                                private final /* synthetic */ StyledDocument val$document;
                                private final /* synthetic */ CheckUndoableEditListener val$undoListener;
                                private final /* synthetic */ int val$position;
                                private final /* synthetic */ FormI18nFinder this$0;
                                {
                                    this.this$0 = this$0;
                                    this.val$document = val$document;
                                    this.val$undoListener = val$undoListener;
                                    this.val$position = val$position;
                                }

                                public void run() {
                                    try {
                                        this.val$document.addUndoableEditListener(this.val$undoListener);
                                        this.val$document.insertString(this.val$position, " ", null);
                                    }
                                    catch (BadLocationException ble) {
                                        FormI18nFinder.access$002(this.this$0, true);
                                    }
                                }
                            });
                        }
                        catch (BadLocationException ble) {
                            Object var6_5 = null;
                            document.removeUndoableEditListener(undoListener);
                            if (this.guardedPosition) {
                                return this.guardedPosition;
                            }
                            EditorCookie ec = (EditorCookie)this.sourceDataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = FormI18nFinder.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                            if (ec == null) {
                                return this.guardedPosition;
                            }
                            JEditorPane[] panes = ec.getOpenedPanes();
                            if (panes != null && panes.length > 0) {
                                TopComponent tp = (TopComponent)SwingUtilities.getAncestorOfClass(class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = FormI18nFinder.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent, panes[0]);
                                if (tp == null) {
                                    UndoableEdit edit = undoListener.getEdit();
                                    if (edit == null) return this.guardedPosition;
                                    if (!edit.canUndo()) return this.guardedPosition;
                                    edit.undo();
                                    return this.guardedPosition;
                                }
                                UndoRedo undoRedo = tp.getUndoRedo();
                                if (undoRedo == null) {
                                    return this.guardedPosition;
                                }
                                if (!undoRedo.canUndo()) return this.guardedPosition;
                                undoRedo.undo();
                                return this.guardedPosition;
                            }
                            UndoableEdit edit = undoListener.getEdit();
                            if (edit == null) return this.guardedPosition;
                            if (!edit.canUndo()) return this.guardedPosition;
                            edit.undo();
                            return this.guardedPosition;
                        }
                        Object var6_4 = null;
                        document.removeUndoableEditListener(undoListener);
                        if (this.guardedPosition) {
                            return this.guardedPosition;
                        }
                        if (class$org$openide$cookies$EditorCookie != null) break block20;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        document.removeUndoableEditListener(undoListener);
                        if (this.guardedPosition) {
                            return this.guardedPosition;
                        }
                        EditorCookie ec = (EditorCookie)this.sourceDataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = FormI18nFinder.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                        if (ec == null) {
                            return this.guardedPosition;
                        }
                        JEditorPane[] panes = ec.getOpenedPanes();
                        if (panes != null && panes.length > 0) {
                            TopComponent tp = (TopComponent)SwingUtilities.getAncestorOfClass(class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = FormI18nFinder.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent, panes[0]);
                            if (tp == null) {
                                UndoableEdit edit = undoListener.getEdit();
                                if (edit == null) return this.guardedPosition;
                                if (!edit.canUndo()) return this.guardedPosition;
                                edit.undo();
                                return this.guardedPosition;
                            }
                            UndoRedo undoRedo = tp.getUndoRedo();
                            if (undoRedo == null) {
                                return this.guardedPosition;
                            }
                            if (!undoRedo.canUndo()) throw throwable;
                            undoRedo.undo();
                            throw throwable;
                        }
                        UndoableEdit edit = undoListener.getEdit();
                        if (edit == null) throw throwable;
                        if (!edit.canUndo()) throw throwable;
                        edit.undo();
                        throw throwable;
                    }
                    clazz = class$org$openide$cookies$EditorCookie = FormI18nFinder.class$("org.openide.cookies.EditorCookie");
                    break block22;
                }
                clazz = class$org$openide$cookies$EditorCookie;
            }
            EditorCookie ec = (EditorCookie)this.sourceDataObject.getCookie(clazz);
            if (ec == null) {
                return this.guardedPosition;
            }
            JEditorPane[] panes = ec.getOpenedPanes();
            if (panes != null && panes.length > 0) {
                TopComponent tp = (TopComponent)SwingUtilities.getAncestorOfClass(class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = FormI18nFinder.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent, panes[0]);
                if (tp == null) {
                    UndoableEdit edit = undoListener.getEdit();
                    if (edit == null) return this.guardedPosition;
                    if (!edit.canUndo()) return this.guardedPosition;
                    edit.undo();
                    return this.guardedPosition;
                }
                UndoRedo undoRedo = tp.getUndoRedo();
                if (undoRedo == null) {
                    return this.guardedPosition;
                }
                if (!undoRedo.canUndo()) return this.guardedPosition;
                undoRedo.undo();
                return this.guardedPosition;
            }
            UndoableEdit edit = undoListener.getEdit();
            if (edit == null) return this.guardedPosition;
            if (!edit.canUndo()) return this.guardedPosition;
            edit.undo();
            return this.guardedPosition;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ boolean access$002(FormI18nFinder x0, boolean x1) {
            x0.guardedPosition = x1;
            return x0.guardedPosition;
        }
    }

    private static class ValidFormPropertyComparator
    implements Comparator {
        private static final String CREATION_CODE_PRE = "creationCodePre";
        private static final String CREATION_CODE_CUSTOM = "creationCodeCustom";
        private static final String CREATION_CODE_POST = "creationCodePost";
        private static final String INIT_CODE_PRE = "initCodePre";
        private static final String INIT_CODE_POST = "initCodePost";
        private final FormModel formModel;

        public ValidFormPropertyComparator(FormDataObject formDataObject) {
            this.formModel = formDataObject.getFormEditor().getFormModel();
        }

        public int compare(Object o1, Object o2) {
            String propName1 = ((ValidFormProperty)o1).getProperty().getName();
            String propName2 = ((ValidFormProperty)o2).getProperty().getName();
            boolean isInCreation1 = false;
            boolean isInCreation2 = false;
            if (propName1.equals(CREATION_CODE_PRE) || propName1.equals(CREATION_CODE_CUSTOM) || propName1.equals(CREATION_CODE_POST)) {
                isInCreation1 = true;
            }
            if (propName2.equals(CREATION_CODE_PRE) || propName2.equals(CREATION_CODE_CUSTOM) || propName2.equals(CREATION_CODE_POST)) {
                isInCreation2 = true;
            }
            if (isInCreation1 != isInCreation2) {
                return isInCreation1 ? -1 : 1;
            }
            RADComponent comp1 = this.formModel.findRADComponent(((ValidFormProperty)o1).getRADComponentName());
            RADComponent comp2 = this.formModel.findRADComponent(((ValidFormProperty)o2).getRADComponentName());
            int index1 = -1;
            int index2 = -1;
            if (!comp1.equals(comp2)) {
                Object[] components = this.formModel.getMetaComponents().toArray();
                int i = 0;
                while (i < components.length) {
                    if (comp1.equals(components[i])) {
                        index1 = i;
                    }
                    if (comp2.equals(components[i])) {
                        index2 = i;
                    }
                    if (index1 != -1 && index2 != -1) break;
                    ++i;
                }
                return index1 - index2;
            }
            if (isInCreation1) {
                index1 = -1;
                index2 = -1;
                if (propName1.equals(CREATION_CODE_PRE)) {
                    index1 = 0;
                } else if (propName1.equals(CREATION_CODE_CUSTOM)) {
                    index1 = 1;
                } else if (propName1.equals(CREATION_CODE_POST)) {
                    index1 = 2;
                }
                if (propName2.equals(CREATION_CODE_PRE)) {
                    index2 = 0;
                } else if (propName2.equals(CREATION_CODE_CUSTOM)) {
                    index2 = 1;
                } else if (propName2.equals(CREATION_CODE_POST)) {
                    index2 = 2;
                }
                return index1 - index2;
            }
            index1 = -1;
            index2 = -1;
            index1 = propName1.equals(INIT_CODE_PRE) ? 0 : (propName1.equals(INIT_CODE_POST) ? 2 : 1);
            index2 = propName2.equals(INIT_CODE_PRE) ? 0 : (propName2.equals(INIT_CODE_POST) ? 2 : 1);
            if (index1 != 1 || index2 != 1) {
                return index1 - index2;
            }
            Node.PropertySet[] propSets = comp1.getProperties();
            Object[] properties = new Node.Property[]{};
            ArrayList<Node.Property> aList = new ArrayList<Node.Property>();
            int i = 0;
            while (i < propSets.length) {
                if (propSets[i].getName().equals("properties") || propSets[i].getName().equals("properties2") || propSets[i].getName().equals("synthetic")) {
                    aList.addAll(Arrays.asList(propSets[i].getProperties()));
                }
                ++i;
            }
            properties = aList.toArray();
            index1 = -1;
            index2 = -1;
            Node.Property prop1 = ((ValidFormProperty)o1).getProperty();
            Node.Property prop2 = ((ValidFormProperty)o2).getProperty();
            int i2 = 0;
            while (i2 < properties.length) {
                if (prop1.equals((Object)properties[i2])) {
                    index1 = i2;
                }
                if (prop2.equals((Object)properties[i2])) {
                    index2 = i2;
                }
                if (index1 != -1 && index2 != -1) break;
                ++i2;
            }
            return index1 - index2;
        }
    }

    private static class ValidFormProperty {
        private Node.Property property;
        private String radCompName;
        private int skip;

        public ValidFormProperty(String radCompName, Node.Property property) {
            this.radCompName = radCompName;
            this.property = property;
            this.skip = 0;
        }

        public ValidFormProperty(ValidFormProperty validProperty) {
            this.radCompName = validProperty.getRADComponentName();
            this.property = validProperty.getProperty();
            this.skip = validProperty.getSkip();
        }

        public String getRADComponentName() {
            return this.radCompName;
        }

        public Node.Property getProperty() {
            return this.property;
        }

        public int getSkip() {
            return this.skip;
        }

        public void incrementSkip() {
            ++this.skip;
        }

        public void decrementSkip() {
            if (this.skip > 0) {
                --this.skip;
            }
        }
    }
}

