/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.lib.ddl.DDLException;
import org.openide.util.NbBundle;

public class DatabaseConnection
implements DBConnection {
    static final ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
    static final long serialVersionUID = 4554639187416958735L;
    private String drv;
    private String drvname;
    private String db;
    private String usr;
    private String schema;
    private String pwd = "";
    private Boolean rpwd = Boolean.FALSE;
    private PropertyChangeSupport propertySupport;
    private String name;
    private static final String SUPPORT = "_schema_support";
    public static final String PROP_DRIVER = "driver";
    public static final String PROP_DATABASE = "database";
    public static final String PROP_USER = "user";
    public static final String PROP_PASSWORD = "password";
    public static final String PROP_SCHEMA = "schema";
    public static final String PROP_DRIVERNAME = "drivername";
    public static final String PROP_NAME = "name";

    public DatabaseConnection() {
        this.propertySupport = new PropertyChangeSupport(this);
    }

    public DatabaseConnection(String string, String string2, String string3, String string4) {
        this.drv = string;
        this.db = string2;
        this.usr = string3;
        this.pwd = string4;
        this.name = null;
        this.name = this.getName();
    }

    public String getDriver() {
        return this.drv;
    }

    public void setDriver(String string) {
        if (string == null || string.equals(this.drv)) {
            return;
        }
        String string2 = this.drv;
        this.drv = string;
        this.propertySupport.firePropertyChange(PROP_DRIVER, string2, this.drv);
    }

    public String getDriverName() {
        return this.drvname;
    }

    public void setDriverName(String string) {
        if (string == null || string.equals(this.drvname)) {
            return;
        }
        String string2 = this.drvname;
        this.drvname = string;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_DRIVERNAME, string2, this.drvname);
        }
    }

    public String getDatabase() {
        if (this.db == null) {
            this.db = new String();
        }
        return this.db;
    }

    public void setDatabase(String string) {
        if (string == null || string.equals(this.db)) {
            return;
        }
        String string2 = this.db;
        this.db = string;
        this.name = null;
        this.name = this.getName();
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_DATABASE, string2, this.db);
        }
    }

    public String getUser() {
        if (this.usr == null) {
            this.usr = new String();
        }
        return this.usr;
    }

    public void setUser(String string) {
        if (string == null || string.equals(this.usr)) {
            return;
        }
        String string2 = this.usr;
        this.usr = string;
        this.name = null;
        this.name = this.getName();
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_USER, string2, this.usr);
        }
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getSchema() == null || this.getSchema().length() == 0 ? MessageFormat.format(bundle.getString("ConnectionNodeUniqueName"), this.getDatabase(), this.getUser(), bundle.getString("SchemaIsNotSet")) : MessageFormat.format(bundle.getString("ConnectionNodeUniqueName"), this.getDatabase(), this.getUser(), this.getSchema());
        }
        return this.name;
    }

    public void setName(String string) {
        if (this.name == null || this.name.equals(string)) {
            return;
        }
        String string2 = this.name;
        this.name = string;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_NAME, string2, this.name);
        }
    }

    public String getSchema() {
        if (this.schema == null) {
            this.schema = new String();
        }
        return this.schema;
    }

    public void setSchema(String string) {
        if (string == null || string.equals(this.schema)) {
            return;
        }
        String string2 = this.schema;
        this.schema = string;
        this.name = null;
        this.name = this.getName();
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_SCHEMA, string2, this.schema);
        }
    }

    public boolean rememberPassword() {
        return this.rpwd.equals(Boolean.TRUE);
    }

    public void setRememberPassword(boolean bl) {
        this.rpwd = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public String getPassword() {
        return this.pwd;
    }

    public void setPassword(String string) {
        if (string == null || string.equals(this.pwd)) {
            return;
        }
        String string2 = this.pwd;
        this.pwd = string;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_PASSWORD, string2, this.pwd);
        }
    }

    public Connection createJDBCConnection() throws DDLException {
        if (this.drv == null || this.db == null || this.usr == null || this.pwd == null) {
            throw new DDLException(bundle.getString("EXC_InsufficientConnInfo"));
        }
        Properties properties = new Properties();
        ((Hashtable)properties).put(PROP_USER, this.usr);
        ((Hashtable)properties).put(PROP_PASSWORD, this.pwd);
        try {
            Class.forName(this.drv);
            Connection connection = DriverManager.getConnection(this.db, properties);
            return connection;
        }
        catch (SQLException sQLException) {
            String string = MessageFormat.format(bundle.getString("EXC_CannotEstablishConnection"), this.db, this.drv, sQLException.getMessage());
            if (this.drv.equals("com.pointbase.jdbc.jdbcUniversalDriver") && sQLException.getErrorCode() == 86024) {
                string = MessageFormat.format(bundle.getString("EXC_PointbaseServerRejected"), string, this.db);
            }
            throw new DDLException(string);
        }
        catch (Exception exception) {
            String string = MessageFormat.format(bundle.getString("EXC_CannotEstablishConnection"), this.db, this.drv, exception.getMessage());
            throw new DDLException(string);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public int hashCode() {
        return this.drv.hashCode() + this.db.hashCode() + this.usr.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DBConnection) {
            DBConnection dBConnection = (DBConnection)object;
            return this.toString().equals(dBConnection.toString());
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.drv = (String)objectInputStream.readObject();
        this.db = (String)objectInputStream.readObject();
        this.usr = (String)objectInputStream.readObject();
        this.schema = (String)objectInputStream.readObject();
        this.rpwd = new Boolean(false);
        this.name = (String)objectInputStream.readObject();
        if (this.name == null || !this.name.equals(SUPPORT)) {
            this.schema = null;
        }
        this.name = null;
        this.name = this.getName();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.drv);
        objectOutputStream.writeObject(this.db);
        objectOutputStream.writeObject(this.usr);
        objectOutputStream.writeObject(this.schema);
        objectOutputStream.writeObject(SUPPORT);
    }

    public String toString() {
        return "Driver:" + this.drv + "Database:" + this.db.toLowerCase() + "User:" + this.usr.toLowerCase() + "Schema:" + this.schema.toLowerCase();
    }
}

