/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import org.netbeans.modules.db.explorer.DatabaseDriver;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.nodes.ConnectionNode;
import org.openide.TopManager;
import org.openide.nodes.Node;
import org.openide.options.SystemOption;
import org.openide.util.NbBundle;

public class DatabaseOption
extends SystemOption {
    static final ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
    private static boolean debugMode;
    private static Vector drivers;
    private static Vector connections;
    private static int fetchlimit;
    private static int fetchstep;
    private static boolean autoConn;
    public static final String PROP_DEBUG_MODE = "debugMode";
    public static final String PROP_FETCH_LIMIT = "fetchLimit";
    public static final String PROP_FETCH_STEP = "fetchStep";
    public static final String PROP_AUTO_CONNECTION = "autoConn";
    static final long serialVersionUID = -13629330831657810L;

    public DatabaseOption() {
        drivers = new Vector();
        connections = new Vector();
        debugMode = false;
    }

    public Vector getAvailableDrivers() {
        Vector vector = null;
        if (drivers.size() == 0) {
            Map map = (Map)DatabaseNodeInfo.getGlobalNodeInfo("driverlist");
            Vector vector2 = (Vector)map.get("defaultdriverlist");
            if (vector2 != null && vector2.size() > 0) {
                vector = new Vector(vector2.size());
                Enumeration enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    String string;
                    String string2;
                    String string3;
                    Object object = enumeration.nextElement();
                    String string4 = (String)((Map)object).get("name");
                    if ((object = new DatabaseDriver(string4, string3 = (String)((Map)object).get("driver"), string2 = (String)((Map)object).get("prefix"), string = (String)((Map)object).get("adaptor"))) == null) continue;
                    vector.add(object);
                }
            } else {
                vector = new Vector();
            }
            drivers = vector;
        }
        return drivers;
    }

    public boolean getDebugMode() {
        return debugMode;
    }

    public void setDebugMode(boolean bl) {
        if (debugMode == bl) {
            return;
        }
        debugMode = bl;
        this.firePropertyChange(PROP_DEBUG_MODE, new Boolean(!debugMode), new Boolean(debugMode));
    }

    public void setAvailableDrivers(Vector vector) {
        drivers = vector;
    }

    public Vector getConnections() {
        if (connections == null) {
            connections = new Vector();
        }
        return connections;
    }

    public void setConnections(Vector vector) {
        connections = vector;
    }

    public int getFetchLimit() {
        return fetchlimit;
    }

    public void setFetchLimit(int n) {
        int n2 = fetchlimit;
        if (n2 == n) {
            return;
        }
        fetchlimit = n;
        this.firePropertyChange(PROP_FETCH_LIMIT, new Integer(n2), new Integer(n));
    }

    public int getFetchStep() {
        return fetchstep;
    }

    public void setFetchStep(int n) {
        int n2 = fetchstep;
        if (n2 == n) {
            return;
        }
        fetchstep = n;
        this.firePropertyChange(PROP_FETCH_STEP, new Integer(n2), new Integer(n));
    }

    public boolean isAutoConn() {
        return autoConn;
    }

    public void setAutoConn(boolean bl) {
        boolean bl2 = autoConn;
        if (bl2 == bl) {
            return;
        }
        autoConn = bl;
        this.firePropertyChange(PROP_AUTO_CONNECTION, new Boolean(!autoConn), new Boolean(autoConn));
    }

    public void save() {
        this.firePropertyChange(null, null, null);
    }

    public String displayName() {
        return bundle.getString("OptionName");
    }

    public String toString() {
        return drivers.size() + " drivers, " + connections.size() + " connections";
    }

    private void closeConnections() {
        try {
            Node[] nodeArray = TopManager.getDefault().getPlaces().nodes().environment().getChildren().findChild("Databases").getChildren().getNodes();
            int n = 0;
            while (n < nodeArray.length) {
                if (nodeArray[n] instanceof ConnectionNode) {
                    ((ConnectionNodeInfo)((ConnectionNode)nodeArray[n]).getInfo()).disconnect();
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.getAvailableDrivers());
        objectOutput.writeObject(this.getConnections());
        objectOutput.writeInt(fetchlimit);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        drivers = (Vector)objectInput.readObject();
        connections = (Vector)objectInput.readObject();
        fetchlimit = objectInput.readInt();
    }

    static {
        fetchlimit = 100;
        fetchstep = 200;
        autoConn = true;
    }
}

