/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.modules.db.DatabaseException;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.NewConnectionPanel;
import org.netbeans.modules.db.explorer.dlg.SchemaPanel;
import org.netbeans.modules.db.explorer.infos.ConnectionOwnerOperations;
import org.netbeans.modules.db.explorer.infos.DriverNodeInfo;
import org.netbeans.modules.db.explorer.nodes.RootNode;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.nodes.Node;

public class ConnectUsingDriverAction
extends DatabaseAction {
    static final long serialVersionUID = 8245005834483564671L;
    ConnectionDialog dlg = null;
    static /* synthetic */ Class class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo;

    public void performAction(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length <= 0) {
            return;
        }
        Node node = nodeArray[0];
        DriverNodeInfo driverNodeInfo = (DriverNodeInfo)node.getCookie(class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo == null ? (class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo = ConnectUsingDriverAction.class$("org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo")) : class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo);
        final ConnectionOwnerOperations connectionOwnerOperations = (ConnectionOwnerOperations)((Object)driverNodeInfo.getParent(this.nodename));
        Vector vector = RootNode.getOption().getAvailableDrivers();
        DatabaseConnection databaseConnection = new DatabaseConnection();
        databaseConnection.setDriverName(driverNodeInfo.getName());
        databaseConnection.setDriver(driverNodeInfo.getURL());
        final NewConnectionPanel newConnectionPanel = new NewConnectionPanel(vector, databaseConnection);
        final SchemaPanel schemaPanel = new SchemaPanel(new Vector(), new String());
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == NotifyDescriptor.OK_OPTION) {
                    ConnectUsingDriverAction.this.dlg.setException(null);
                    newConnectionPanel.setConnectionInfo();
                    try {
                        ClassLoader classLoader = TopManager.getDefault().currentClassLoader();
                        classLoader.loadClass(newConnectionPanel.getDriver());
                        if (schemaPanel.getSchema() == null) {
                            ConnectUsingDriverAction.this.dlg.setSelectedComponent(schemaPanel);
                        }
                        if (ConnectUsingDriverAction.this.dlg.isException()) {
                            schemaPanel.setComment(DatabaseAction.bundle.getString("MSG_SchemaPanelWarning"));
                            return;
                        }
                        newConnectionPanel.getConnection().setSchema(schemaPanel.getSchema());
                        connectionOwnerOperations.addConnection(newConnectionPanel.getConnection());
                        if (ConnectUsingDriverAction.this.dlg != null) {
                            ConnectUsingDriverAction.this.dlg.close();
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        String string = MessageFormat.format(DatabaseAction.bundle.getString("EXC_ClassNotFound"), classNotFoundException.getMessage());
                        TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
                    }
                    catch (Exception exception) {
                        String string = MessageFormat.format(DatabaseAction.bundle.getString("ERR_UnableToAddConnection"), exception.getMessage());
                        TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
                    }
                }
            }
        };
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                block11: {
                    String string = schemaPanel.getSchema() != null ? schemaPanel.getSchema() : newConnectionPanel.getUser();
                    if (((JTabbedPane)changeEvent.getSource()).getSelectedComponent().equals(schemaPanel)) {
                        newConnectionPanel.setConnectionInfo();
                        DBConnection dBConnection = newConnectionPanel.getConnection();
                        try {
                            ClassLoader classLoader = TopManager.getDefault().currentClassLoader();
                            classLoader.loadClass(newConnectionPanel.getDriver());
                            Connection connection = dBConnection.createJDBCConnection();
                            if (connection == null) break block11;
                            Vector<String> vector = new Vector<String>();
                            try {
                                ResultSet resultSet = connection.getMetaData().getSchemas();
                                while (resultSet.next()) {
                                    vector.add(resultSet.getString(1).trim());
                                }
                                resultSet.close();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            connection.close();
                            if (!schemaPanel.setSchemas(vector, string)) {
                                ConnectUsingDriverAction.this.dlg.setException((Exception)new DDLException("User name is not in the list of accessible schemas"));
                            }
                        }
                        catch (SQLException sQLException) {
                            String string2 = MessageFormat.format(DatabaseAction.bundle.getString("ERR_UnableObtainSchemas"), sQLException.getMessage());
                            if (dBConnection.getDriver().equals("com.pointbase.jdbc.jdbcUniversalDriver") && sQLException.getErrorCode() == 86024) {
                                string2 = MessageFormat.format(DatabaseAction.bundle.getString("EXC_PointbaseServerRejected"), string2, dBConnection.getDatabase());
                            }
                            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 0));
                            ConnectUsingDriverAction.this.dlg.setSelectedComponent(newConnectionPanel);
                            ConnectUsingDriverAction.this.dlg.setException(new DatabaseException("Unable to obtain schema. " + sQLException.getMessage()));
                        }
                        catch (Exception exception) {
                            String string3 = MessageFormat.format(DatabaseAction.bundle.getString("ERR_UnableObtainSchemas"), exception.getMessage());
                            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string3, 0));
                            ConnectUsingDriverAction.this.dlg.setSelectedComponent(newConnectionPanel);
                            ConnectUsingDriverAction.this.dlg.setException(new DatabaseException("Unable to obtain schema. " + exception.getMessage()));
                        }
                    } else if (schemaPanel.getSchema() != null) {
                        string = schemaPanel.getSchema();
                    }
                }
            }
        };
        this.dlg = new ConnectionDialog(newConnectionPanel, schemaPanel, newConnectionPanel.getTitle(), actionListener, changeListener);
        this.dlg.setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

