/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dataview;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.MutableComboBoxModel;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.db.DatabaseException;
import org.netbeans.modules.db.explorer.infos.ColumnNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.nodes.ConnectionNode;
import org.netbeans.modules.db.explorer.nodes.RootNode;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.awt.SplittedPanel;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.windows.TopComponent;

public class DataViewWindow
extends TopComponent {
    private JTextArea queryarea;
    private JTable jtable;
    private DataModel dbadaptor;
    private JComboBox rcmdscombo;
    private String schema;
    private ResourceBundle bundle;
    private Node node;
    static final long serialVersionUID = 6855188441469780252L;
    static int tstrg = 0;
    static int gtcmd = 0;

    public DataViewWindow(DatabaseNodeInfo databaseNodeInfo, String string) throws SQLException {
        this.schema = databaseNodeInfo.getUser();
        this.node = databaseNodeInfo.getNode();
        try {
            this.bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
            Node node = this.node;
            while (!(node instanceof ConnectionNode)) {
                node = node.getParentNode();
            }
            this.setName(this.bundle.getString("CommandEditorTitle") + " " + node.getDisplayName());
            ((JComponent)((Object)this)).setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            ((Container)((Object)this)).setLayout(gridBagLayout);
            this.dbadaptor = new DataModel(databaseNodeInfo);
            JPanel jPanel = new JPanel();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            jPanel.setLayout(gridBagLayout2);
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
            this.queryarea = new JTextArea(string, 3, 70);
            this.queryarea.setLineWrap(true);
            this.queryarea.setWrapStyleWord(true);
            this.queryarea.setDropTarget(new DropTarget(this.queryarea, new ViewDropTarget()));
            this.queryarea.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_DataViewTextAreaA11yName"));
            this.queryarea.setToolTipText(this.bundle.getString("ACS_DataViewTextAreaA11yDesc"));
            JScrollPane jScrollPane = new JScrollPane(this.queryarea);
            gridBagLayout2.setConstraints(jScrollPane, gridBagConstraints2);
            jPanel.add(jScrollPane);
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 0.0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints2.anchor = 15;
            this.rcmdscombo = new JComboBox(new ComboModel());
            this.rcmdscombo.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_DataViewComboBoxA11yName"));
            this.rcmdscombo.setToolTipText(this.bundle.getString("ACS_DataViewComboBoxA11yDesc"));
            gridBagLayout2.setConstraints(this.rcmdscombo, gridBagConstraints2);
            jPanel.add(this.rcmdscombo);
            this.rcmdscombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    RecentCommand recentCommand = (RecentCommand)jComboBox.getSelectedItem();
                    if (recentCommand != null) {
                        DataViewWindow.this.setCommand(recentCommand.getCommand());
                    }
                }
            });
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.weighty = 0.0;
            gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.anchor = 15;
            JButton jButton = new JButton(this.bundle.getString("ExecuteButton"));
            jButton.setToolTipText(this.bundle.getString("ACS_ExecuteButtonA11yDesc"));
            jButton.setMnemonic(this.bundle.getString("ExecuteButton_Mnemonic").charAt(0));
            gridBagLayout2.setConstraints(jButton, gridBagConstraints2);
            jPanel.add(jButton);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataViewWindow.this.executeCommand();
                }
            });
            this.jtable = new JTable(this.dbadaptor);
            this.jtable.setToolTipText(this.bundle.getString("ACS_DataViewTableA11yDesc"));
            this.jtable.setAutoResizeMode(0);
            jScrollPane = new JScrollPane(this.jtable);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridy = 1;
            SplittedPanel splittedPanel = new SplittedPanel();
            splittedPanel.setSplitType(1);
            splittedPanel.setSplitTypeChangeEnabled(false);
            splittedPanel.setSplitAbsolute(false);
            splittedPanel.setSplitPosition(20);
            splittedPanel.add((Component)jPanel, SplittedPanel.ADD_LEFT);
            splittedPanel.add((Component)jScrollPane, SplittedPanel.ADD_RIGHT);
            gridBagLayout.setConstraints((Component)splittedPanel, gridBagConstraints);
            ((Container)((Object)this)).add((Component)splittedPanel);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public String getCommand() {
        return this.queryarea.getText();
    }

    public void setCommand(String string) {
        this.queryarea.setText(string);
    }

    public boolean executeCommand() {
        try {
            String string = this.queryarea.getText().trim();
            this.dbadaptor.execute(string);
            RecentCommand recentCommand = new RecentCommand(string);
            ((ComboModel)this.rcmdscombo.getModel()).addElement(recentCommand);
            return true;
        }
        catch (Exception exception) {
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)(this.bundle.getString("DataViewFetchErrorPrefix") + exception.getMessage()), 0));
            return false;
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        return null;
    }

    class DataModel
    extends AbstractTableModel {
        DatabaseNodeInfo node_info;
        Vector coldef;
        Vector data;
        boolean editable = false;
        static final long serialVersionUID = 7729426847826999963L;
        static /* synthetic */ Class class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$java$lang$Boolean;
        static /* synthetic */ Class class$java$lang$Integer;
        static /* synthetic */ Class class$java$lang$Long;
        static /* synthetic */ Class class$java$lang$Double;
        static /* synthetic */ Class class$java$sql$Date;
        static /* synthetic */ Class class$java$lang$Object;

        public DataModel(DatabaseNodeInfo databaseNodeInfo) throws SQLException {
            this.node_info = databaseNodeInfo;
        }

        public void execute(String string) throws Exception {
            Statement statement;
            if (string.length() == 0) {
                return;
            }
            try {
                Connection connection = this.node_info.getConnection();
                statement = connection.createStatement();
            }
            catch (Exception exception) {
                String string2 = MessageFormat.format(DataViewWindow.this.bundle.getString("EXC_ConnectionIsBroken"), exception.getMessage());
                throw new DatabaseException(string2);
            }
            if (string.toLowerCase().startsWith("select")) {
                ResultSet resultSet = statement.executeQuery(string);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                Object var6_9 = null;
                int n = resultSetMetaData.getColumnCount();
                this.coldef = new Vector(n);
                int n2 = 1;
                while (n2 <= n) {
                    ColDef colDef = new ColDef(resultSetMetaData.getColumnLabel(n2), resultSetMetaData.isWritable(n2));
                    colDef.setDataType(resultSetMetaData.getColumnType(n2));
                    this.coldef.add(colDef);
                    ++n2;
                }
                int n3 = 0;
                int n4 = RootNode.getOption().getFetchLimit();
                int n5 = RootNode.getOption().getFetchStep();
                this.data = new Vector();
                while (resultSet.next()) {
                    Vector<Object> vector = new Vector<Object>(n);
                    int n6 = 1;
                    while (n6 <= n) {
                        vector.add(resultSet.getObject(n6));
                        ++n6;
                    }
                    this.data.addElement(vector);
                    if (++n3 < n4) continue;
                    Object[] objectArray = new String[]{new Integer(n3).toString(), new Integer(n5).toString()};
                    String string3 = DataViewWindow.this.bundle.getString("DataViewCancelButton");
                    String string4 = DataViewWindow.this.bundle.getString("DataViewNextFetchButton");
                    String string5 = DataViewWindow.this.bundle.getString("DataViewAllFetchButton");
                    String string6 = MessageFormat.format(DataViewWindow.this.bundle.getString("DataViewMessage"), objectArray);
                    NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string6, DataViewWindow.this.bundle.getString("FetchDataTitle"), 1, 3, new Object[]{string4, string5, string3}, NotifyDescriptor.CANCEL_OPTION);
                    String string7 = (String)TopManager.getDefault().notify(notifyDescriptor);
                    if (string7.equals(string5)) {
                        n4 = Integer.MAX_VALUE;
                        continue;
                    }
                    if (!string7.equals(string4)) break;
                    n4 += n5;
                }
                resultSet.close();
                this.fireTableChanged(null);
            } else {
                if (string.toLowerCase().startsWith("delete") || string.toLowerCase().startsWith("insert") || string.toLowerCase().startsWith("update")) {
                    statement.executeUpdate(string);
                } else {
                    statement.execute(string);
                    while (!(DataViewWindow.this.node instanceof ConnectionNode)) {
                        DataViewWindow.this.node = DataViewWindow.this.node.getParentNode();
                    }
                    Enumeration enumeration = DataViewWindow.this.node.getChildren().nodes();
                    while (enumeration.hasMoreElements()) {
                        ((DatabaseNodeInfo)((Node)enumeration.nextElement()).getCookie(class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo == null ? DataModel.class$("org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo") : class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo)).refreshChildren();
                    }
                }
                TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)DataViewWindow.this.bundle.getString("CommandExecuted"), 1));
            }
            statement.close();
        }

        public String getColumnName(int n) {
            if (n < this.coldef.size()) {
                String string = ((ColDef)this.coldef.elementAt(n)).getName();
                return string;
            }
            return "";
        }

        public Class getColumnClass(int n) {
            if (n < this.coldef.size()) {
                int n2 = ((ColDef)this.coldef.elementAt(n)).getDataType();
                switch (n2) {
                    case -1: 
                    case 1: 
                    case 12: {
                        return class$java$lang$String == null ? (class$java$lang$String = DataModel.class$("java.lang.String")) : class$java$lang$String;
                    }
                    case -7: {
                        return class$java$lang$Boolean == null ? (class$java$lang$Boolean = DataModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                    }
                    case -6: 
                    case 4: 
                    case 5: {
                        return class$java$lang$Integer == null ? (class$java$lang$Integer = DataModel.class$("java.lang.Integer")) : class$java$lang$Integer;
                    }
                    case -5: {
                        return class$java$lang$Long == null ? (class$java$lang$Long = DataModel.class$("java.lang.Long")) : class$java$lang$Long;
                    }
                    case 6: 
                    case 8: {
                        return class$java$lang$Double == null ? (class$java$lang$Double = DataModel.class$("java.lang.Double")) : class$java$lang$Double;
                    }
                    case 91: {
                        return class$java$sql$Date == null ? (class$java$sql$Date = DataModel.class$("java.sql.Date")) : class$java$sql$Date;
                    }
                }
            }
            return class$java$lang$Object == null ? (class$java$lang$Object = DataModel.class$("java.lang.Object")) : class$java$lang$Object;
        }

        public boolean isCellEditable(int n, int n2) {
            if (!this.editable) {
                return false;
            }
            if (n2 < this.coldef.size()) {
                return ((ColDef)this.coldef.elementAt(n2)).isWritable();
            }
            return false;
        }

        public int getColumnCount() {
            if (this.coldef == null) {
                return 0;
            }
            return this.coldef.size();
        }

        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        public Object getValueAt(int n, int n2) {
            Vector vector = null;
            if (n < this.data.size()) {
                vector = (Vector)this.data.elementAt(n);
            }
            if (vector != null && n2 < vector.size()) {
                return vector.elementAt(n2);
            }
            return null;
        }

        private String format(Object object, int n) {
            if (object == null) {
                return "null";
            }
            switch (n) {
                case 4: 
                case 6: 
                case 8: {
                    return object.toString();
                }
                case -7: {
                    return (Boolean)object != false ? "1" : "0";
                }
                case 91: {
                    return object.toString();
                }
            }
            return "\"" + object.toString() + "\"";
        }

        public void setValueAt(Object object, int n, int n2) {
            int n3 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            HashMap hashMap = new HashMap();
            Enumeration enumeration = this.coldef.elements();
            while (enumeration.hasMoreElements()) {
                ColDef colDef = (ColDef)enumeration.nextElement();
                if (colDef.isBestRowIdentifierColumn()) {
                    String string = colDef.getName();
                    String string2 = this.format(this.getValueAt(n, n3), colDef.getDataType());
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" and ");
                    }
                    stringBuffer.append(string + " = " + string2);
                }
                ++n3;
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class ViewDropTarget
    implements DropTargetListener {
        static /* synthetic */ Class class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo;
        static /* synthetic */ Class class$org$openide$util$datatransfer$ExTransferable;

        ViewDropTarget() {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        private ColumnNodeInfo getNodeInfo(Transferable transferable) {
            Node node = NodeTransfer.node((Transferable)transferable, (int)6);
            if (node != null) {
                return (ColumnNodeInfo)node.getCookie(class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo == null ? (class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo = ViewDropTarget.class$("org.netbeans.modules.db.explorer.infos.ColumnNodeInfo")) : class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo);
            }
            node = NodeTransfer.node((Transferable)transferable, (int)1);
            if (node != null) {
                return (ColumnNodeInfo)node.getCookie(class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo == null ? (class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo = ViewDropTarget.class$("org.netbeans.modules.db.explorer.infos.ColumnNodeInfo")) : class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo);
            }
            return null;
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            String string = null;
            Object var3_3 = null;
            Transferable transferable = dropTargetDropEvent.getTransferable();
            StringBuffer stringBuffer = new StringBuffer();
            try {
                DataFlavor dataFlavor = new DataFlavor(NbBundle.getBundle((Class)(class$org$openide$util$datatransfer$ExTransferable == null ? (class$org$openide$util$datatransfer$ExTransferable = ViewDropTarget.class$("org.openide.util.datatransfer.ExTransferable")) : class$org$openide$util$datatransfer$ExTransferable)).getString("MultiNodeMimeType"), NbBundle.getBundle((Class)(class$org$openide$util$datatransfer$ExTransferable == null ? (class$org$openide$util$datatransfer$ExTransferable = ViewDropTarget.class$("org.openide.util.datatransfer.ExTransferable")) : class$org$openide$util$datatransfer$ExTransferable)).getString("transferFlavorsMultiFlavorName"));
                if (transferable.isDataFlavorSupported(dataFlavor)) {
                    Object object;
                    Object object2;
                    Serializable serializable;
                    MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                    int n = multiTransferObject.getCount();
                    int n2 = 0;
                    HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
                    int n3 = 0;
                    while (n3 < n) {
                        serializable = this.getNodeInfo(multiTransferObject.getTransferableAt(n3));
                        if (serializable != null) {
                            object2 = ((DatabaseNodeInfo)serializable).getTable();
                            object = (Integer)hashMap.get(object2);
                            if (object == null) {
                                object = new Integer(n2++);
                                hashMap.put(object2, (Integer)object);
                            }
                            if (stringBuffer.length() > 0) {
                                stringBuffer.append(", ");
                            }
                            stringBuffer.append("t" + object + "." + ((DatabaseNodeInfo)serializable).getName());
                        }
                        ++n3;
                    }
                    serializable = new StringBuffer();
                    object2 = hashMap.keySet().iterator();
                    while (object2.hasNext()) {
                        object = (String)object2.next();
                        if (((StringBuffer)serializable).length() > 0) {
                            ((StringBuffer)serializable).append(", ");
                        }
                        ((StringBuffer)serializable).append((String)object + " t" + hashMap.get(object));
                    }
                    string = "select " + stringBuffer.toString() + " from " + ((StringBuffer)serializable).toString();
                } else {
                    ColumnNodeInfo columnNodeInfo = this.getNodeInfo(transferable);
                    if (columnNodeInfo != null) {
                        string = "select " + columnNodeInfo.getName() + " from " + columnNodeInfo.getTable();
                    }
                }
                if (string != null) {
                    DataViewWindow.this.setCommand(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class ComboModel
    extends AbstractListModel
    implements MutableComboBoxModel {
        Vector commands;
        Object selected;
        static final long serialVersionUID = -5831993904798984334L;

        public ComboModel() {
            this(new Vector(1));
        }

        public ComboModel(Vector vector) {
            this.commands = vector;
        }

        public Object getSelectedItem() {
            return this.selected;
        }

        public void setSelectedItem(Object object) {
            this.selected = object;
            this.fireContentsChanged(this, -1, -1);
        }

        public void addElement(Object object) {
            if (!this.commands.contains(object)) {
                this.commands.add(object);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void removeElement(Object object) {
            this.commands.removeElement(object);
            this.fireContentsChanged(this, -1, -1);
        }

        public void insertElementAt(Object object, int n) {
            if (!this.commands.contains(object)) {
                this.commands.insertElementAt(object, n);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void removeElementAt(int n) {
            this.commands.removeElementAt(n);
            this.fireContentsChanged(this, -1, -1);
        }

        public int getSize() {
            return this.commands.size();
        }

        public Object getElementAt(int n) {
            return this.commands.get(n);
        }
    }

    class RecentCommand {
        private String command;
        private String shortCommand;

        public RecentCommand(String string) {
            this.command = string;
            this.shortCommand = this.getShortCommand();
        }

        public String toString() {
            return this.shortCommand;
        }

        public String getCommand() {
            return this.command;
        }

        public boolean equals(Object object) {
            if (object instanceof RecentCommand) {
                return ((RecentCommand)object).getShortCommand().equals(this.shortCommand);
            }
            return super.equals(object);
        }

        private String getShortCommand() {
            StringTokenizer stringTokenizer = new StringTokenizer(this.command);
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreElements()) {
                stringBuffer.append(stringTokenizer.nextElement());
                stringBuffer.append(" ");
            }
            return stringBuffer.toString();
        }
    }

    class ColDef {
        private String name;
        private boolean writable;
        private boolean bric;
        int datatype;

        public ColDef(String string, boolean bl) {
            this.name = string;
            this.writable = bl;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public int getDataType() {
            return this.datatype;
        }

        public void setDataType(int n) {
            this.datatype = n;
        }

        public boolean isWritable() {
            return this.writable;
        }

        public void setWritable(boolean bl) {
            this.writable = bl;
        }

        public boolean isBestRowIdentifierColumn() {
            return this.bric;
        }

        public void setBestRowIdentifierColumn(boolean bl) {
            this.bric = bl;
        }
    }
}

