/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.io.IOException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.lib.ddl.DatabaseProductNotFoundException;
import org.netbeans.lib.ddl.DatabaseSpecification;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.impl.SpecificationFactory;
import org.netbeans.modules.db.DatabaseException;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseOption;
import org.netbeans.modules.db.explorer.dlg.UnsupportedDatabaseDialog;
import org.netbeans.modules.db.explorer.infos.ConnectionOperations;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.nodes.ConnectionNode;
import org.netbeans.modules.db.explorer.nodes.RootNode;
import org.openide.nodes.Node;

public class ConnectionNodeInfo
extends DatabaseNodeInfo
implements ConnectionOperations {
    static final long serialVersionUID = -8322295510950137669L;

    public void connect(String string) throws DatabaseException {
        String string2 = this.getDriver();
        String string3 = this.getDatabase();
        Object var4_4 = null;
        try {
            Specification specification;
            Object object;
            Node[] nodeArray;
            if (string2.startsWith("com.pointbase.jdbc.jdbcUniversalDriver")) {
                nodeArray = this.getParent().getNode().getChildren().getNodes();
                int n = 0;
                while (n < nodeArray.length) {
                    if (nodeArray[n] instanceof ConnectionNode && ((DatabaseNodeInfo)(object = (ConnectionNodeInfo)((ConnectionNode)nodeArray[n]).getInfo())).getDriver().startsWith("com.pointbase.jdbc.jdbcUniversalDriver") && (!((DatabaseNodeInfo)object).getDatabase().equals(string3) || !((DatabaseNodeInfo)object).getUser().equals(this.getUser())) && ((DatabaseNodeInfo)object).getConnection() != null) {
                        throw new Exception(DatabaseNodeInfo.bundle.getString("EXC_PBConcurrentConn"));
                    }
                    ++n;
                }
            }
            nodeArray = this.getConnectionProperties();
            DatabaseConnection databaseConnection = new DatabaseConnection(string2, string3, this.getUser(), this.getPassword());
            object = databaseConnection.createJDBCConnection();
            SpecificationFactory specificationFactory = (SpecificationFactory)this.getSpecificationFactory();
            if (string != null) {
                specification = (Specification)specificationFactory.createSpecification((DBConnection)databaseConnection, string, (Connection)object);
            } else {
                this.setReadOnly(false);
                specification = (Specification)specificationFactory.createSpecification((DBConnection)databaseConnection, (Connection)object);
            }
            this.put("dbproduct", specification.getProperties().get("dbproduct"));
            this.setSpecification((DatabaseSpecification)specification);
            DriverSpecification driverSpecification = specificationFactory.createDriverSpecification(specification.getMetaData().getDriverName().trim());
            if (specification.getMetaData().getDriverName().trim().equals("jConnect (TM) for JDBC (TM)")) {
                driverSpecification.setMetaData(object.getMetaData());
            } else {
                driverSpecification.setMetaData(specification.getMetaData());
            }
            driverSpecification.setCatalog(object.getCatalog());
            driverSpecification.setSchema(this.getSchema());
            this.setDriverSpecification(driverSpecification);
            this.setConnection((Connection)object);
        }
        catch (DatabaseProductNotFoundException databaseProductNotFoundException) {
            UnsupportedDatabaseDialog unsupportedDatabaseDialog = new UnsupportedDatabaseDialog();
            unsupportedDatabaseDialog.show();
            this.setReadOnly(false);
            switch (unsupportedDatabaseDialog.getResult()) {
                case 1: {
                    this.connect("GenericDatabaseSystem");
                }
                case 2: {
                    this.connectReadOnly();
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public void connect() throws DatabaseException {
        this.connect(null);
    }

    public void connectReadOnly() throws DatabaseException {
        this.setReadOnly(true);
        this.connect("GenericDatabaseSystem");
    }

    public void disconnect() throws DatabaseException {
        Connection connection = this.getConnection();
        if (connection != null) {
            try {
                connection.close();
                this.setConnection(null);
            }
            catch (Exception exception) {
                this.setConnection(null);
                String string = MessageFormat.format(DatabaseNodeInfo.bundle.getString("EXC_ConnectionIsBroken"), exception.getMessage());
                throw new DatabaseException(string);
            }
        }
    }

    public void delete() throws IOException {
        try {
            this.disconnect();
            Vector vector = RootNode.getOption().getConnections();
            DatabaseConnection databaseConnection = (DatabaseConnection)this.getDatabaseConnection();
            if (vector.contains(databaseConnection)) {
                vector.remove(databaseConnection);
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public Object put(Object object, Object object2) {
        if (object.equals("user") || object.equals("driver") || object.equals("db") || object.equals("schema")) {
            String string = (String)this.get(object);
            String string2 = (String)object2;
            this.updateConnection((String)object, string, string2);
        }
        return super.put(object, object2);
    }

    private void updateConnection(String string, String string2, String string3) {
        DatabaseOption databaseOption = RootNode.getOption();
        Vector vector = databaseOption.getConnections();
        Enumeration enumeration = vector.elements();
        DBConnection dBConnection = this.getDatabaseConnection();
        int n = vector.indexOf(dBConnection);
        if (n >= 0) {
            DatabaseConnection databaseConnection = (DatabaseConnection)vector.elementAt(n);
            if (string.equals("schema")) {
                databaseConnection.setSchema(string3);
            } else if (string.equals("user")) {
                databaseConnection.setUser(string3);
            } else if (string.equals("driver")) {
                databaseConnection.setDriver(string3);
            } else if (string.equals("db")) {
                databaseConnection.setDatabase(string3);
            }
        }
        this.setName(dBConnection.getName());
    }
}

