/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;
import org.netbeans.modules.db.DatabaseException;
import org.netbeans.modules.db.explorer.DatabaseDriver;
import org.netbeans.modules.db.explorer.DatabaseNodeChildren;
import org.netbeans.modules.db.explorer.DatabaseOption;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.DriverNodeInfo;
import org.netbeans.modules.db.explorer.infos.DriverOperations;
import org.netbeans.modules.db.explorer.nodes.RootNode;

public class DriverListNodeInfo
extends DatabaseNodeInfo
implements DriverOperations {
    static final long serialVersionUID = -7948529055260667590L;

    protected void initChildren(Vector vector) throws DatabaseException {
        Vector vector2 = RootNode.getOption().getAvailableDrivers();
        if (vector2 != null) {
            try {
                Enumeration enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    DatabaseDriver databaseDriver = (DatabaseDriver)enumeration.nextElement();
                    DriverNodeInfo driverNodeInfo = (DriverNodeInfo)DatabaseNodeInfo.createNodeInfo(this, "driver");
                    if (driverNodeInfo != null && databaseDriver != null) {
                        driverNodeInfo.setDatabaseDriver(databaseDriver);
                        vector.add(driverNodeInfo);
                        continue;
                    }
                    String string = MessageFormat.format(DatabaseNodeInfo.bundle.getString("EXC_Driver"), databaseDriver.toString());
                    throw new Exception(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void addDriver(DatabaseDriver databaseDriver) throws DatabaseException {
        DatabaseOption databaseOption = RootNode.getOption();
        Vector vector = databaseOption.getAvailableDrivers();
        if (vector.contains(databaseDriver)) {
            String string = MessageFormat.format(DatabaseNodeInfo.bundle.getString("EXC_DriverAlreadyExists"), databaseDriver.toString());
            throw new DatabaseException(string);
        }
        vector.add(databaseDriver);
        DatabaseNodeChildren databaseNodeChildren = (DatabaseNodeChildren)this.getNode().getChildren();
        DriverNodeInfo driverNodeInfo = (DriverNodeInfo)DatabaseNodeInfo.createNodeInfo(this, "driver");
        driverNodeInfo.setDatabaseDriver(databaseDriver);
        databaseNodeChildren.createSubnode(driverNodeInfo, true);
    }
}

