/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Vector;
import org.netbeans.modules.db.DatabaseException;
import org.netbeans.modules.db.explorer.DatabaseDriver;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.DriverListNodeInfo;
import org.netbeans.modules.db.explorer.nodes.RootNode;

public class DriverNodeInfo
extends DriverListNodeInfo {
    static final long serialVersionUID = 6994829681095273161L;

    public DatabaseDriver getDatabaseDriver() {
        return (DatabaseDriver)this.get("dbdriver");
    }

    public void setDatabaseDriver(DatabaseDriver databaseDriver) {
        this.put("name", databaseDriver.getName());
        this.put("url", databaseDriver.getURL());
        this.put("prefix", databaseDriver.getDatabasePrefix());
        this.put("adaptorClass", databaseDriver.getDatabaseAdaptor());
        this.put("dbdriver", databaseDriver);
    }

    public void delete() throws IOException {
        try {
            DatabaseDriver databaseDriver = this.getDatabaseDriver();
            Vector vector = RootNode.getOption().getAvailableDrivers();
            int n = vector.indexOf(databaseDriver);
            if (n == -1) {
                String string = MessageFormat.format(DatabaseNodeInfo.bundle.getString("EXC_DriverNotFound"), databaseDriver.toString());
                throw new DatabaseException(string);
            }
            vector.removeElementAt(n);
            this.getParent().refreshChildren();
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }
}

