/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.nodes;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.lib.ddl.CommandNotSupportedException;
import org.netbeans.lib.ddl.impl.AddColumn;
import org.netbeans.lib.ddl.impl.RenameTable;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.impl.TableColumn;
import org.netbeans.modules.db.explorer.DatabaseNodeChildren;
import org.netbeans.modules.db.explorer.infos.ColumnNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableListNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableNodeInfo;
import org.netbeans.modules.db.explorer.nodes.DatabaseNode;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;

public class TableNode
extends DatabaseNode {
    static /* synthetic */ Class class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo;

    public void setInfo(DatabaseNodeInfo databaseNodeInfo) {
        super.setInfo(databaseNodeInfo);
        this.getCookieSet().add((Node.Cookie)this);
    }

    public void setName(String string) {
        try {
            DatabaseNodeInfo databaseNodeInfo = this.getInfo();
            Specification specification = (Specification)databaseNodeInfo.getSpecification();
            RenameTable renameTable = specification.createCommandRenameTable(databaseNodeInfo.getName(), string);
            renameTable.setObjectOwner((String)databaseNodeInfo.get("schema"));
            renameTable.execute();
            super.setName(string);
            databaseNodeInfo.put("table", string);
        }
        catch (CommandNotSupportedException commandNotSupportedException) {
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)commandNotSupportedException.getMessage(), 0));
        }
        catch (Exception exception) {
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)exception.getMessage(), 0));
        }
    }

    protected void createPasteTypes(Transferable transferable, List list) {
        super.createPasteTypes(transferable, list);
        Node node = NodeTransfer.node((Transferable)transferable, (int)6);
        if (node != null && node.canDestroy()) {
            ColumnNodeInfo columnNodeInfo = (ColumnNodeInfo)node.getCookie(class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo == null ? (class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo = TableNode.class$("org.netbeans.modules.db.explorer.infos.ColumnNodeInfo")) : class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo);
            if (columnNodeInfo != null) {
                list.add(new ColumnPasteType(columnNodeInfo, node));
                return;
            }
        } else {
            DatabaseNodeInfo databaseNodeInfo = (DatabaseNodeInfo)NodeTransfer.cookie((Transferable)transferable, (int)6, (Class)(class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo == null ? (class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo = TableNode.class$("org.netbeans.modules.db.explorer.infos.ColumnNodeInfo")) : class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo));
            if (databaseNodeInfo != null) {
                list.add(new ColumnPasteType((ColumnNodeInfo)databaseNodeInfo, null));
                return;
            }
        }
    }

    public String getShortDescription() {
        return NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ND_Table");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ColumnPasteType
    extends PasteType {
        final ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
        private DatabaseNodeInfo info;
        private Node node;

        public ColumnPasteType(ColumnNodeInfo columnNodeInfo, Node node) {
            this.info = columnNodeInfo;
            this.node = node;
        }

        public String getName() {
            return this.bundle.getString("PasteColumnName");
        }

        public Transferable paste() throws IOException {
            ResourceBundle resourceBundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
            TableNodeInfo tableNodeInfo = (TableNodeInfo)TableNode.this.getInfo();
            if (this.info != null) {
                try {
                    String string = this.info.getName();
                    ColumnNodeInfo columnNodeInfo = (ColumnNodeInfo)this.info;
                    TableColumn tableColumn = columnNodeInfo.getColumnSpecification();
                    Specification specification = (Specification)tableNodeInfo.getSpecification();
                    AddColumn addColumn = specification.createCommandAddColumn(tableNodeInfo.getTable());
                    addColumn.getColumns().add(tableColumn);
                    addColumn.setObjectOwner((String)this.info.get("schema"));
                    addColumn.execute();
                    tableNodeInfo.addColumn(string);
                    if (this.node != null) {
                        this.node.destroy();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                throw new IOException(resourceBundle.getString("EXC_CannotFindColumnOwnerInformation"));
            }
            return null;
        }
    }

    private class TablePasteType
    extends PasteType {
        private DatabaseNodeInfo info;
        private Node node;

        public TablePasteType(TableNodeInfo tableNodeInfo, Node node) {
            this.info = tableNodeInfo;
            this.node = node;
        }

        public String getName() {
            ResourceBundle resourceBundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
            return resourceBundle.getString("PasteTableName");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Transferable paste() throws IOException {
            TableNodeInfo tableNodeInfo = (TableNodeInfo)TableNode.this.getInfo();
            ResourceBundle resourceBundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle_noi18n");
            TableListNodeInfo tableListNodeInfo = (TableListNodeInfo)TableNode.this.getInfo().getParent("tablelist");
            if (tableNodeInfo == null) throw new IOException(resourceBundle.getString("EXC_CannotFindTableOwnerInformation"));
            TableNodeInfo tableNodeInfo2 = tableListNodeInfo.getChildrenTableInfo(tableNodeInfo);
            DatabaseNodeChildren databaseNodeChildren = (DatabaseNodeChildren)TableNode.this.getChildren();
            String string = tableNodeInfo.getName();
            if (tableNodeInfo2 != null) {
                String string2 = resourceBundle.getString("PasteTableNameFormat");
                string = MessageFormat.format(string2, string);
            }
            try {
                tableListNodeInfo.addTable(string);
                if (this.node == null) return null;
                this.node.destroy();
                return null;
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
    }
}

