/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.util.ArrayList;
import java.util.Map;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.JavaDoc;
import org.openide.src.JavaDocTag;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.Type;

public class JCExtension {
    public static boolean equals(JCClass jCClass, ClassElement classElement) {
        return jCClass.getFullName().equals(classElement.getName().getFullName());
    }

    public static boolean equals(JCType jCType, Type type) {
        int n = 0;
        while (type.isArray()) {
            ++n;
            type = type.getElementType();
        }
        String string = type.isPrimitive() ? type.getFullString() : type.getClassName().getFullName();
        return jCType.getArrayDepth() == n && jCType.getClazz().getFullName().equals(string);
    }

    public static boolean equals(JCField jCField, FieldElement fieldElement) {
        return jCField.getName().equals(fieldElement.getName().getFullName()) && JCExtension.equals(jCField.getType(), fieldElement.getType());
    }

    public static boolean equals(JCConstructor jCConstructor, ConstructorElement constructorElement) {
        JCParameter[] jCParameterArray = jCConstructor.getParameters();
        MethodParameter[] methodParameterArray = constructorElement.getParameters();
        if (methodParameterArray == null || jCParameterArray.length != methodParameterArray.length) {
            return false;
        }
        int n = jCParameterArray.length - 1;
        while (n >= 0) {
            if (!JCExtension.equals(jCParameterArray[n].getType(), methodParameterArray[n].getType())) {
                return false;
            }
            --n;
        }
        return true;
    }

    public static boolean equals(JCMethod jCMethod, MethodElement methodElement) {
        return jCMethod.getName().equals(methodElement.getName().getFullName()) && JCExtension.equals((JCConstructor)jCMethod, (ConstructorElement)methodElement);
    }

    public static FieldElement findFieldElement(JCField jCField, ClassElement classElement) {
        FieldElement[] fieldElementArray = classElement.getFields();
        if (fieldElementArray != null) {
            int n = 0;
            while (n < fieldElementArray.length) {
                if (JCExtension.equals(jCField, fieldElementArray[n])) {
                    return fieldElementArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public static ConstructorElement findConstructorElement(JCConstructor jCConstructor, ClassElement classElement) {
        ConstructorElement[] constructorElementArray = classElement.getConstructors();
        if (constructorElementArray != null) {
            int n = 0;
            while (n < constructorElementArray.length) {
                if (JCExtension.equals(jCConstructor, constructorElementArray[n])) {
                    return constructorElementArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public static MethodElement findMethodElement(JCMethod jCMethod, ClassElement classElement) {
        MethodElement[] methodElementArray = classElement.getMethods();
        if (methodElementArray != null) {
            int n = 0;
            while (n < methodElementArray.length) {
                if (JCExtension.equals(jCMethod, methodElementArray[n])) {
                    return methodElementArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    static JCClass getIdentifierClass(Identifier identifier, Map map, boolean bl) {
        Object object;
        Object object2;
        ClassElement classElement;
        JCFinder jCFinder;
        String string = identifier.getFullName();
        JCClass jCClass = (JCClass)map.get(string);
        if (jCClass != null) {
            return jCClass;
        }
        if (bl && (jCFinder = JavaCompletion.getFinder()) != null && (jCClass = jCFinder.getExactClass(string)) != null) {
            jCClass = JavaCompletion.getSimpleClass(jCClass);
            map.put(string, jCClass);
            return jCClass;
        }
        int n = -1;
        try {
            classElement = ClassElement.forName((String)string);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            System.err.println("Error occurred during name resolving");
            throwable.printStackTrace();
            if (throwable instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)throwable;
            }
            return JavaCompletion.INVALID_CLASS;
        }
        if (classElement != null && (object2 = classElement.getSource()) != null) {
            object = null;
            object = object2.getPackage();
            if (object != null) {
                String string2 = object.getFullName();
                if (string.startsWith(string2)) {
                    n = string2.length();
                }
            } else {
                n = 0;
            }
        }
        if (n < 0 && (object2 = JavaCompletion.getFinder()) != null) {
            if (!bl) {
                jCClass = object2.getExactClass(string);
            }
            if (jCClass == null && (object = object2.findClasses(null, string, true)) != null && object.size() == 1) {
                jCClass = (JCClass)object.get(0);
            }
            if (jCClass != null) {
                jCClass = JavaCompletion.getSimpleClass(jCClass);
                map.put(string, jCClass);
                return jCClass;
            }
        }
        if (n < 0) {
            n = Math.max(string.lastIndexOf(46), 0);
            object2 = string.substring(0, n);
            int n2 = ((String)object2).lastIndexOf(46);
            if (n2 == -1 && ((String)object2).length() > 0 && Character.isUpperCase(((String)object2).charAt(0))) {
                n = 0;
            }
            if (n2 < string.length() - 1) {
                while (n2 >= 0 && Character.isUpperCase(string.charAt(n2 + 1))) {
                    object2 = ((String)object2).substring(0, n2);
                    n = n2;
                    n2 = ((String)object2).lastIndexOf(46);
                }
            }
        }
        jCClass = JavaCompletion.getSimpleClass(string, n);
        map.put(string, jCClass);
        return jCClass;
    }

    static JCType getType(Type type, Map map, boolean bl) {
        int n = 0;
        while (type.isArray()) {
            ++n;
            type = type.getElementType();
        }
        JCClass jCClass = type.isPrimitive() ? JavaCompletion.getPrimitiveClass(type.getFullString()) : JCExtension.getIdentifierClass(type.getClassName(), map, bl);
        return JavaCompletion.getType(jCClass, n);
    }

    private static boolean isDeprecated(Object object) {
        MethodElement methodElement;
        JavaDoc.Method method;
        JavaDocTag[] javaDocTagArray = null;
        if (object instanceof ClassElement) {
            ClassElement classElement = (ClassElement)object;
            JavaDoc.Class clazz = classElement.getJavaDoc();
            if (clazz != null) {
                javaDocTagArray = clazz.getTags("@deprecated");
            }
        } else if (object instanceof FieldElement) {
            FieldElement fieldElement = (FieldElement)object;
            JavaDoc.Field field = fieldElement.getJavaDoc();
            if (field != null) {
                javaDocTagArray = field.getTags("@deprecated");
            }
        } else if (object instanceof ConstructorElement) {
            ConstructorElement constructorElement = (ConstructorElement)object;
            JavaDoc.Method method2 = constructorElement.getJavaDoc();
            if (method2 != null) {
                javaDocTagArray = method2.getTags("@deprecated");
            }
        } else if (object instanceof MethodElement && (method = (methodElement = (MethodElement)object).getJavaDoc()) != null) {
            javaDocTagArray = method.getTags("@deprecated");
        }
        return javaDocTagArray != null && javaDocTagArray.length > 0;
    }

    static JCClass parseClassElement(ClassElement classElement, int n, int n2, int n3, Map map, boolean bl) {
        JCClass jCClass = JCExtension.getIdentifierClass(classElement.getName(), map, bl);
        if (jCClass.equals(JavaCompletion.INVALID_CLASS)) {
            return null;
        }
        return new NbJCClass(jCClass.getName(), jCClass.getPackageName(), classElement.isInterface(), JCExtension.isDeprecated(classElement), classElement.getModifiers(), classElement, n, n2, n3, map, bl);
    }

    static class NbJCClass
    extends JavaCompletion.AbstractClass {
        public NbJCClass(String string, String string2, boolean bl, int n, ClassElement classElement, int n2, int n3, int n4, Map map, boolean bl2) {
            this(string, string2, bl, false, n, classElement, n2, n3, n4, map, bl2);
        }

        public NbJCClass(String string, String string2, boolean bl, boolean bl2, int n, ClassElement classElement, int n2, int n3, int n4, Map map, boolean bl3) {
            super(string, string2, bl, bl2, n);
            Identifier[] identifierArray;
            Comparable[] comparableArray;
            int n5;
            this.body = new JavaCompletion.AbstractClass.Body();
            ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
            Identifier identifier = classElement.getSuperclass();
            this.body.superClass = identifier != null ? JCExtension.getIdentifierClass(identifier, map, bl3) : (bl ? JavaCompletion.INVALID_CLASS : JavaCompletion.OBJECT_CLASS);
            Identifier[] identifierArray2 = classElement.getInterfaces();
            this.body.interfaces = JavaCompletion.EMPTY_CLASSES;
            if (identifierArray2 != null) {
                int n6 = 0;
                while (n6 < identifierArray2.length) {
                    if (identifierArray2[n6] != null) {
                        arrayList.add(JCExtension.getIdentifierClass(identifierArray2[n6], map, bl3));
                    }
                    ++n6;
                }
                this.body.interfaces = new JCClass[arrayList.size()];
                arrayList.toArray(this.body.interfaces);
                arrayList.clear();
            }
            FieldElement[] fieldElementArray = classElement.getFields();
            this.body.fields = JavaCompletion.EMPTY_FIELDS;
            if (fieldElementArray != null) {
                int n7 = 0;
                while (n7 < fieldElementArray.length) {
                    if (fieldElementArray[n7] != null) {
                        n5 = fieldElementArray[n7].getModifiers();
                        if (bl) {
                            n5 |= 1;
                        }
                        if (JCExtension.isDeprecated(fieldElementArray[n7])) {
                            n5 |= 0x100000;
                        }
                        if (JavaCompletion.getLevel(n5) >= n3) {
                            arrayList.add(new JavaCompletion.BaseField(this, fieldElementArray[n7].getName().getName(), JCExtension.getType(fieldElementArray[n7].getType(), map, bl3), n5));
                        }
                    }
                    ++n7;
                }
                this.body.fields = new JCField[arrayList.size()];
                arrayList.toArray(this.body.fields);
                arrayList.clear();
            }
            ConstructorElement[] constructorElementArray = classElement.getConstructors();
            this.body.constructors = JavaCompletion.EMPTY_CONSTRUCTORS;
            if (constructorElementArray != null) {
                n5 = 0;
                while (n5 < constructorElementArray.length) {
                    if (constructorElementArray[n5] != null && JavaCompletion.getLevel(constructorElementArray[n5].getModifiers()) >= n4) {
                        JCParameter[] jCParameterArray = JavaCompletion.EMPTY_PARAMETERS;
                        MethodParameter[] methodParameterArray = constructorElementArray[n5].getParameters();
                        if (methodParameterArray != null) {
                            jCParameterArray = new JCParameter[methodParameterArray.length];
                            int n8 = 0;
                            while (n8 < methodParameterArray.length) {
                                jCParameterArray[n8] = new JavaCompletion.BaseParameter(methodParameterArray[n8].getName(), JCExtension.getType(methodParameterArray[n8].getType(), map, bl3));
                                ++n8;
                            }
                        }
                        comparableArray = JavaCompletion.EMPTY_CLASSES;
                        identifierArray = constructorElementArray[n5].getExceptions();
                        comparableArray = new JCClass[identifierArray.length];
                        int n9 = 0;
                        while (n9 < identifierArray.length) {
                            comparableArray[n9] = JCExtension.getIdentifierClass(identifierArray[n9], map, bl3);
                            ++n9;
                        }
                        int n10 = constructorElementArray[n5].getModifiers();
                        if (JCExtension.isDeprecated(constructorElementArray[n5])) {
                            n10 |= 0x100000;
                        }
                        arrayList.add(new JavaCompletion.BaseConstructor(this, n10, jCParameterArray, (JCClass[])comparableArray));
                    }
                    ++n5;
                }
                this.body.constructors = new JCConstructor[arrayList.size()];
                arrayList.toArray(this.body.constructors);
                arrayList.clear();
            }
            MethodElement[] methodElementArray = classElement.getMethods();
            this.body.methods = JavaCompletion.EMPTY_METHODS;
            if (methodElementArray != null) {
                int n11 = 0;
                while (n11 < methodElementArray.length) {
                    if (methodElementArray[n11] != null) {
                        int n12 = methodElementArray[n11].getModifiers();
                        if (bl) {
                            n12 |= 1;
                        }
                        if (JCExtension.isDeprecated(methodElementArray[n11])) {
                            n12 |= 0x100000;
                        }
                        if (JavaCompletion.getLevel(n12) >= n4) {
                            comparableArray = JavaCompletion.EMPTY_PARAMETERS;
                            identifierArray = methodElementArray[n11].getParameters();
                            if (identifierArray != null) {
                                comparableArray = new JCParameter[identifierArray.length];
                                int n13 = 0;
                                while (n13 < identifierArray.length) {
                                    comparableArray[n13] = new JavaCompletion.BaseParameter(identifierArray[n13].getName(), JCExtension.getType(identifierArray[n13].getType(), map, bl3));
                                    ++n13;
                                }
                            }
                            JCClass[] jCClassArray = JavaCompletion.EMPTY_CLASSES;
                            Identifier[] identifierArray3 = methodElementArray[n11].getExceptions();
                            jCClassArray = new JCClass[identifierArray3.length];
                            int n14 = 0;
                            while (n14 < identifierArray3.length) {
                                jCClassArray[n14] = JCExtension.getIdentifierClass(identifierArray3[n14], map, bl3);
                                ++n14;
                            }
                            arrayList.add(new JavaCompletion.BaseMethod(this, methodElementArray[n11].getName().getName(), n12, JCExtension.getType(methodElementArray[n11].getReturn(), map, bl3), (JCParameter[])comparableArray, jCClassArray));
                        }
                    }
                    ++n11;
                }
            }
            this.body.methods = new JCMethod[arrayList.size()];
            arrayList.toArray(this.body.methods);
            arrayList.clear();
        }

        protected void init() {
        }
    }
}

