/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.FileAccessor;
import org.netbeans.editor.ext.java.DAFileProvider;
import org.netbeans.editor.ext.java.JCBaseFinder;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCUtilities;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.modules.editor.java.FileObjectAccessor;
import org.netbeans.modules.editor.java.JCStorageElement;
import org.netbeans.modules.editor.java.JCUpdater;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.JavaOptions;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;

public class JCStorage
implements SettingsChangeListener {
    private static final String DB_DIR = "ParserDB";
    private static final String STORAGE = "storage";
    private static final String STORAGE_EXT = "ser";
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.jcstorage");
    private static final boolean debugUpdater = Boolean.getBoolean("netbeans.debug.editor.updater");
    private static final String PROVIDER_FILE_EXT = "jcs";
    private static boolean inited;
    private static JCStorage storage;
    private FileObject dbFolder;
    private ArrayList elementList = new ArrayList();
    private final Object ELEMENT_LIST_LOCK = new Object();
    private HashSet updatingElements = new HashSet();
    private Map updatedFS = Collections.synchronizedMap(new HashMap());
    private JCFinder finder;
    private PropertyChangeSupport pcs;
    static /* synthetic */ Class class$org$netbeans$editor$ext$java$JavaCompletion;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$JCStorage;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit;

    public static JCStorage getStorage() {
        Class clazz = class$org$netbeans$editor$ext$java$JavaCompletion == null ? (class$org$netbeans$editor$ext$java$JavaCompletion = JCStorage.class$("org.netbeans.editor.ext.java.JavaCompletion")) : class$org$netbeans$editor$ext$java$JavaCompletion;
        synchronized (clazz) {
            Class clazz2 = class$org$netbeans$modules$editor$java$JCStorage == null ? (class$org$netbeans$modules$editor$java$JCStorage = JCStorage.class$("org.netbeans.modules.editor.java.JCStorage")) : class$org$netbeans$modules$editor$java$JCStorage;
            synchronized (clazz2) {
                if (storage == null) {
                    JCStorage.init(TopManager.getDefault().getRepository().getDefaultFileSystem().getRoot());
                }
                JCStorage jCStorage = storage;
                return jCStorage;
            }
        }
    }

    private static void init(FileObject fileObject) {
        long l = 0L;
        if (debug) {
            System.err.println("JCStorage initing\t" + Thread.currentThread());
            l = System.currentTimeMillis();
        }
        storage = new JCStorage(fileObject);
        if (debug) {
            System.err.println("JCStorage inited in=" + (System.currentTimeMillis() - l) + "ms");
        }
    }

    JCStorage(FileObject fileObject) {
        Settings.addSettingsChangeListener(this);
        this.checkDBFolder(fileObject);
        if (this.dbFolder != null) {
            if (debug) {
                String string;
                try {
                    string = this.dbFolder.getFileSystem().toString();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    string = "<Invalid filesystem>";
                }
                System.err.println("JCStorage.init(): scanning dbFolder='" + this.dbFolder + "' of filesystem='" + string + "'");
            }
            this.initElements();
            this.initProviders();
            this.refresh();
            this.parseUnfinishedElements();
        }
    }

    private void checkDBFolder(FileObject fileObject) {
        if (fileObject != null) {
            this.dbFolder = fileObject.getFileObject(DB_DIR);
            if (this.dbFolder == null) {
                try {
                    this.dbFolder = fileObject.createFolder(DB_DIR);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void parseFSOnBackground(final FileSystem fileSystem) {
        if (Boolean.getBoolean("netbeans.full.hack")) {
            return;
        }
        if (fileSystem == null) {
            return;
        }
        FileObject fileObject = fileSystem.getRoot();
        if (fileObject == null || fileSystem.isHidden()) {
            return;
        }
        JCStorageElement jCStorageElement = this.findFileSystemElement(fileSystem.getSystemName());
        if (jCStorageElement != null && jCStorageElement.getUpdated()) {
            if (debugUpdater) {
                System.err.println("parser DB is already updated:" + fileSystem.getSystemName());
            }
            return;
        }
        if (jCStorageElement != null && this.updatingElements.contains(jCStorageElement)) {
            if (debugUpdater) {
                System.err.println("parser DB is already updated:" + fileSystem.getSystemName());
            }
            return;
        }
        if (!(BaseOptions.getOptions(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JCStorage.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit) instanceof JavaOptions)) {
            return;
        }
        JavaOptions javaOptions = (JavaOptions)BaseOptions.getOptions(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JCStorage.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit);
        String string = javaOptions.getUpdatePDAfterMounting();
        if ("pd_never".equals(string)) {
            return;
        }
        if ("pd_always".equals(string)) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                Node[] nodeArray = new Node[]{dataObject.getNodeDelegate()};
                final JCUpdater jCUpdater = new JCUpdater(nodeArray, false, false);
                this.updatedFS.put(fileSystem, jCUpdater);
                jCUpdater.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent == null) {
                            return;
                        }
                        if ("mount_fs".equals(propertyChangeEvent.getPropertyName()) && jCUpdater != null) {
                            jCUpdater.removePropertyChangeListener(this);
                            JCStorage.this.updatedFS.remove(fileSystem);
                        }
                    }
                });
                jCUpdater.start();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    public void removeParsedFS(FileSystem fileSystem) {
        if (Boolean.getBoolean("netbeans.full.hack")) {
            return;
        }
        if (fileSystem == null) {
            return;
        }
        if (this.updatedFS.containsKey(fileSystem)) {
            JCUpdater jCUpdater;
            if (debugUpdater) {
                System.err.println("removing parsed FS:" + fileSystem.getSystemName());
            }
            if ((jCUpdater = (JCUpdater)this.updatedFS.get(fileSystem)) != null && jCUpdater.isAlive()) {
                jCUpdater.interruptTask();
                this.updatedFS.remove(fileSystem);
                this.deleteFile(this.getElement(fileSystem));
                this.saveElements();
            }
        }
    }

    private void parseUnfinishedElements() {
        JCStorageElement[] jCStorageElementArray = this.getElements();
        int n = 0;
        while (n < jCStorageElementArray.length) {
            if (!jCStorageElementArray[n].getUpdated()) {
                if (debugUpdater) {
                    System.err.println("Unfinished parser DB element found:" + jCStorageElementArray[n].getFileSystemName());
                }
                if (jCStorageElementArray[n].getFileSystemName() != null) {
                    FileSystem fileSystem = Repository.getDefault().findFileSystem(jCStorageElementArray[n].getFileSystemName());
                    if (fileSystem != null) {
                        this.parseFSOnBackground(fileSystem);
                    } else if (debugUpdater) {
                        System.err.println("FS is not mounted, unfinished element will not be reparsed:" + jCStorageElementArray[n].getFileSystemName());
                    }
                }
            }
            ++n;
        }
    }

    FileObject getParserDBFile(String string, String string2) {
        FileObject fileObject = null;
        if (this.dbFolder != null) {
            return this.dbFolder.getFileObject(string, string2);
        }
        return fileObject;
    }

    private PropertyChangeSupport getPCS() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPCS().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPCS().removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.getPCS().firePropertyChange(string, object, object2);
    }

    private File getStorageFile(boolean bl) {
        File file = null;
        if (this.dbFolder == null) {
            return null;
        }
        FileObject fileObject = this.dbFolder.getFileObject(STORAGE, STORAGE_EXT);
        try {
            if (bl && fileObject == null) {
                fileObject = this.dbFolder.createData(STORAGE, STORAGE_EXT);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (fileObject != null) {
            file = NbClassPath.toFile((FileObject)fileObject);
        }
        return file;
    }

    private void initElements() {
        block6: {
            try {
                File file = this.getStorageFile(false);
                if (file == null || !file.exists()) break block6;
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
                Object object = this.ELEMENT_LIST_LOCK;
                synchronized (object) {
                    this.elementList = (ArrayList)objectInputStream.readObject();
                }
                objectInputStream.close();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void saveElements() {
        block5: {
            try {
                File file = this.getStorageFile(true);
                if (file == null) break block5;
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                Object object = this.ELEMENT_LIST_LOCK;
                synchronized (object) {
                    objectOutputStream.writeObject(this.elementList);
                }
                objectOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public JCStorageElement[] getElements() {
        Object object = this.ELEMENT_LIST_LOCK;
        synchronized (object) {
            JCStorageElement[] jCStorageElementArray = new JCStorageElement[this.elementList.size()];
            this.elementList.toArray(jCStorageElementArray);
            JCStorageElement[] jCStorageElementArray2 = jCStorageElementArray;
            return jCStorageElementArray2;
        }
    }

    public JCStorageElement getElement(String string) {
        Object object = this.ELEMENT_LIST_LOCK;
        synchronized (object) {
            int n = this.elementList.indexOf(new JCStorageElement(string));
            if (n >= 0) {
                JCStorageElement jCStorageElement = (JCStorageElement)this.elementList.get(n);
                return jCStorageElement;
            }
            JCStorageElement jCStorageElement = null;
            return jCStorageElement;
        }
    }

    private JCStorageElement getElement(FileSystem fileSystem) {
        if (fileSystem == null) {
            return null;
        }
        JCStorageElement[] jCStorageElementArray = this.getElements();
        int n = 0;
        while (n < jCStorageElementArray.length) {
            if (fileSystem.getSystemName().equals(jCStorageElementArray[n].getFileSystemName())) {
                return jCStorageElementArray[n];
            }
            ++n;
        }
        return null;
    }

    private void initProviders() {
        if (this.dbFolder != null) {
            Enumeration enumeration = this.dbFolder.getData(false);
            while (enumeration.hasMoreElements()) {
                JCStorageElement jCStorageElement;
                FileObject fileObject = (FileObject)enumeration.nextElement();
                if (debug) {
                    System.err.println("JCStorage.initProviders(): fileObject='" + fileObject + "'");
                }
                if (!PROVIDER_FILE_EXT.equals(fileObject.getExt()) || !fileObject.existsExt("jcb")) continue;
                String string = fileObject.getName();
                FileObject fileObject2 = this.dbFolder.getFileObject(string, "jcb");
                DAFileProvider dAFileProvider = new DAFileProvider(new FileObjectAccessor(fileObject), new FileObjectAccessor(fileObject2));
                if (debug) {
                    System.err.println("JCStorage.initProviders():   body file exists: " + fileObject2);
                }
                if ((jCStorageElement = this.getElement(string)) != null) {
                    jCStorageElement.setProvider(dAFileProvider);
                    continue;
                }
                jCStorageElement = new JCStorageElement(string);
                jCStorageElement.setProvider(dAFileProvider);
                this.addElement(jCStorageElement);
            }
        }
    }

    public void deleteFile(JCStorageElement jCStorageElement) {
        if (jCStorageElement == null || jCStorageElement.getName() == null) {
            return;
        }
        try {
            DataObject dataObject;
            FileObject fileObject = this.getParserDBFile(jCStorageElement.getName(), PROVIDER_FILE_EXT);
            FileObject fileObject2 = this.getParserDBFile(jCStorageElement.getName(), "jcb");
            if (fileObject != null && (dataObject = DataObject.find((FileObject)fileObject)) != null) {
                try {
                    dataObject.delete();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
            if (fileObject2 != null && (dataObject = DataObject.find((FileObject)fileObject2)) != null) {
                try {
                    dataObject.delete();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
            this.removeElement(jCStorageElement.getName());
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
    }

    void removeElement(String string) {
        Object object = this.ELEMENT_LIST_LOCK;
        synchronized (object) {
            int n = this.elementList.size();
            int n2 = 0;
            while (n2 < n) {
                if (string.equals(((JCStorageElement)this.elementList.get(n2)).getName())) {
                    this.elementList.remove(n2);
                    --n;
                }
                ++n2;
            }
        }
        this.saveElements();
        this.firePropertyChange(null, null, null);
        this.refresh();
    }

    public JCStorageElement findFileSystemElement(String string) {
        Object object = this.ELEMENT_LIST_LOCK;
        synchronized (object) {
            JCStorageElement jCStorageElement;
            Iterator iterator = ((AbstractList)this.elementList).iterator();
            while (iterator.hasNext()) {
                jCStorageElement = (JCStorageElement)iterator.next();
                if (!string.equals(jCStorageElement.getFileSystemName())) continue;
                JCStorageElement jCStorageElement2 = jCStorageElement;
                return jCStorageElement2;
            }
            jCStorageElement = null;
            return jCStorageElement;
        }
    }

    void removeFileSystemElement(String string) {
        Object object = this.ELEMENT_LIST_LOCK;
        synchronized (object) {
            int n = this.elementList.size();
            int n2 = 0;
            while (n2 < n) {
                if (string.equals(((JCStorageElement)this.elementList.get(n2)).getFileSystemName())) {
                    this.elementList.remove(n2);
                    --n;
                }
                ++n2;
            }
        }
    }

    private void addElement(JCStorageElement jCStorageElement) {
        Object object = this.ELEMENT_LIST_LOCK;
        synchronized (object) {
            int n = this.elementList.indexOf(jCStorageElement);
            if (n >= 0) {
                this.elementList.set(n, jCStorageElement);
            } else {
                this.elementList.add(jCStorageElement);
            }
            this.firePropertyChange(null, null, null);
        }
    }

    public JCStorageElement addElement(String string, String string2, int n, int n2, int n3) {
        return this.addElement(string, string2, n, n2, n3, true);
    }

    public JCStorageElement addElement(String string, String string2, int n, int n2, int n3, boolean bl) {
        JCStorageElement jCStorageElement = new JCStorageElement(string, string2, n, n2, n3, bl);
        this.removeFileSystemElement(string2);
        this.addElement(jCStorageElement);
        this.saveElements();
        return jCStorageElement;
    }

    public void checkProvider(JCStorageElement jCStorageElement) {
        if (jCStorageElement.getProvider() == null && this.dbFolder != null) {
            String string = jCStorageElement.getName();
            String string2 = PROVIDER_FILE_EXT;
            FileObject fileObject = this.dbFolder.getFileObject(string, string2);
            try {
                if (fileObject == null) {
                    fileObject = this.dbFolder.createData(string, string2);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (fileObject != null) {
                string2 = "jcb";
                FileObject fileObject2 = this.dbFolder.getFileObject(string, string2);
                try {
                    if (fileObject2 == null) {
                        fileObject2 = this.dbFolder.createData(string, string2);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (fileObject2 != null) {
                    DAFileProvider dAFileProvider = new DAFileProvider(new FileObjectAccessor(fileObject), new FileObjectAccessor(fileObject2));
                    dAFileProvider.reset();
                    jCStorageElement.setProvider(dAFileProvider);
                }
            }
        }
    }

    public void refresh() {
        this.finder = new JCBaseFinder();
        ((JCBaseFinder)this.finder).setCaseSensitive(this.getCaseSensitive());
        ((JCBaseFinder)this.finder).setNaturalSort(this.getNaturalSort());
        ((JCBaseFinder)this.finder).setShowDeprecated(this.getShowDeprecated());
        JavaCompletion.setFinder(this.finder);
        JCStorage jCStorage = this;
        synchronized (jCStorage) {
            Object object = this.ELEMENT_LIST_LOCK;
            synchronized (object) {
                Iterator iterator = ((AbstractList)this.elementList).iterator();
                while (iterator.hasNext()) {
                    JCStorageElement jCStorageElement = (JCStorageElement)iterator.next();
                    if (jCStorageElement.getProvider() == null || this.updatingElements.contains(jCStorageElement)) continue;
                    this.finder.append(jCStorageElement.getProvider());
                }
            }
        }
    }

    public synchronized void addProcessedElement(JCStorageElement jCStorageElement) {
        this.updatingElements.add(jCStorageElement);
    }

    public synchronized void removeProcessedElement(JCStorageElement jCStorageElement) {
        this.updatingElements.remove(jCStorageElement);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 5) {
            System.err.println("arg1=base-source-dir arg2=target-file-prefix arg3=class-level arg4=field-level arg5=method-level\nStorage level: 0=all, 1=not private 2=public and protected, 3=public only\nExample of args: e:\\java\\jdk12\\src e:\\NB\\system\\ParserDB\\jdk12 2 2 2");
            return;
        }
        int n = Integer.parseInt(stringArray[2]);
        int n2 = Integer.parseInt(stringArray[3]);
        int n3 = Integer.parseInt(stringArray[4]);
        System.out.println("Inspecting classes ...");
        List list = JCUtilities.getClassNameList(stringArray[0]);
        List list2 = JCUtilities.getClassList(list, true, n, n2, n3);
        final int[] nArray = new int[1];
        DAFileProvider dAFileProvider = new DAFileProvider(new FileAccessor(new File(stringArray[1] + PROVIDER_FILE_EXT)), new FileAccessor(new File(stringArray[1] + "jcb")));
        dAFileProvider.reset();
        JavaCompletion.ListProvider listProvider = new JavaCompletion.ListProvider(list2){

            public boolean notifyAppend(JCClass jCClass, boolean bl) {
                if (bl) {
                    System.out.print("Building " + jCClass.getFullName() + " ...             \r");
                    nArray[0] = nArray[0] + 1;
                }
                return true;
            }
        };
        long l = System.currentTimeMillis();
        dAFileProvider.append(listProvider);
        System.out.println(nArray[0] + " classes rebuilt in " + (System.currentTimeMillis() - l) + "ms.");
        File file = new File(stringArray[1] + PROVIDER_FILE_EXT);
        File file2 = new File(stringArray[1] + "jcb");
        System.out.println("Files created:\nSkeleton file: " + file.getAbsolutePath() + ", length=" + file.length() + "\nBody file: " + file2.getAbsolutePath() + ", length=" + file2.length());
        System.exit(0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = this.ELEMENT_LIST_LOCK;
        synchronized (object) {
            Iterator iterator = ((AbstractList)this.elementList).iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((JCStorageElement)iterator.next()).toString());
                stringBuffer.append('\n');
            }
        }
        return stringBuffer.toString();
    }

    private boolean getCaseSensitive() {
        return (Boolean)SettingsUtil.getValue(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JCStorage.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit, "completion-case-sensitive", ExtSettingsDefaults.defaultCompletionCaseSensitive);
    }

    private boolean getNaturalSort() {
        return (Boolean)SettingsUtil.getValue(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JCStorage.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit, "completion-natural-sort", ExtSettingsDefaults.defaultCompletionNaturalSort);
    }

    private boolean getShowDeprecated() {
        return (Boolean)SettingsUtil.getValue(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JCStorage.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit, "show-deprecated-members", ExtSettingsDefaults.defaultShowDeprecatedMembers);
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        if (this.finder == null || !(this.finder instanceof JCBaseFinder)) {
            return;
        }
        ((JCBaseFinder)this.finder).setCaseSensitive(this.getCaseSensitive());
        ((JCBaseFinder)this.finder).setNaturalSort(this.getNaturalSort());
        ((JCBaseFinder)this.finder).setShowDeprecated(this.getShowDeprecated());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

