/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.diff;

import java.io.File;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.diff.SimpleDiffBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;

public class DiffCommand
extends BasicCommand {
    protected EventManager eventManager;
    private String beforeDate1;
    private String revision1;
    private String revision2;
    private String beforeDate2;
    private String keywordSubst;
    private boolean ignoreAllWhitespace;
    private boolean ignoreBlankLines;
    private boolean ignoreCase;
    private boolean ignoreSpaceChange;
    private boolean contextDiff;
    private boolean unifiedDiff;

    public Builder createBuilder(EventManager eventManager) {
        if (this.isContextDiff() || this.isUnifiedDiff()) {
            return null;
        }
        return new SimpleDiffBuilder(eventManager, this);
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        clientServices.ensureConnection();
        this.eventManager = eventManager;
        super.execute(clientServices, eventManager);
        try {
            try {
                this.addRDSwitches();
                if (this.getKeywordSubst() != null && !this.getKeywordSubst().equals("")) {
                    this.requests.add(new ArgumentRequest("-k" + this.getKeywordSubst()));
                }
                this.addArgumentRequest(this.isIgnoreAllWhitespace(), "-w");
                this.addArgumentRequest(this.isIgnoreBlankLines(), "-B");
                this.addArgumentRequest(this.isIgnoreSpaceChange(), "-b");
                this.addArgumentRequest(this.isIgnoreCase(), "-i");
                this.addArgumentRequest(this.isContextDiff(), "-c");
                this.addArgumentRequest(this.isUnifiedDiff(), "-u");
                this.addRequestForWorkingDirectory(clientServices);
                this.addArgumentRequests();
                this.addRequest(CommandRequest.DIFF);
                clientServices.processRequests(this.requests);
            }
            catch (CommandException commandException) {
                throw commandException;
            }
            catch (Exception exception) {
                throw new CommandException(exception, exception.getLocalizedMessage());
            }
            Object var6_3 = null;
            this.requests.clear();
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.requests.clear();
            throw throwable;
        }
    }

    private void addRDSwitches() {
        if (this.getRevision2() != null) {
            this.requests.add(1, new ArgumentRequest("-r"));
            this.requests.add(2, new ArgumentRequest(this.getRevision2()));
        } else if (this.getBeforeDate2() != null) {
            this.requests.add(1, new ArgumentRequest("-D " + this.getBeforeDate2()));
        }
        if (this.getRevision1() != null) {
            this.requests.add(1, new ArgumentRequest("-r"));
            this.requests.add(2, new ArgumentRequest(this.getRevision1()));
        } else if (this.getBeforeDate1() != null) {
            this.requests.add(1, new ArgumentRequest("-D " + this.getBeforeDate1()));
        } else {
            return;
        }
    }

    public void commandTerminated(TerminationEvent terminationEvent) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public String getBeforeDate1() {
        return this.beforeDate1;
    }

    public void setBeforeDate1(String string) {
        this.beforeDate1 = string;
    }

    public String getRevision1() {
        return this.revision1;
    }

    public void setRevision1(String string) {
        this.revision1 = string;
    }

    public String getRevision2() {
        return this.revision2;
    }

    public void setRevision2(String string) {
        this.revision2 = string;
    }

    public String getBeforeDate2() {
        return this.beforeDate2;
    }

    public void setBeforeDate2(String string) {
        this.beforeDate2 = string;
    }

    public String getKeywordSubst() {
        return this.keywordSubst;
    }

    public void setKeywordSubst(String string) {
        this.keywordSubst = string;
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("diff ");
        stringBuffer.append(this.getCVSArguments());
        File[] fileArray = this.getFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                stringBuffer.append(fileArray[n].getName() + " ");
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'R') {
            this.setRecursive(true);
        } else if (c == 'l') {
            this.setRecursive(false);
        } else if (c == 'r') {
            if (this.getRevision1() == null) {
                this.setRevision1(string);
            } else {
                this.setRevision2(string);
            }
        } else if (c == 'D') {
            if (this.getBeforeDate1() == null) {
                this.setBeforeDate1(string);
            } else {
                this.setBeforeDate2(string);
            }
        } else if (c == 'k') {
            this.setKeywordSubst(string);
        } else if (c == 'w') {
            this.setIgnoreAllWhitespace(true);
        } else if (c == 'b') {
            this.setIgnoreSpaceChange(true);
        } else if (c == 'B') {
            this.setIgnoreBlankLines(true);
        } else if (c == 'i') {
            this.setIgnoreCase(true);
        } else if (c == 'c') {
            this.setContextDiff(true);
        } else if (c == 'u') {
            this.setUnifiedDiff(true);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "Rlr:D:k:wBbicu";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setRevision1(null);
        this.setRevision2(null);
        this.setBeforeDate1(null);
        this.setBeforeDate2(null);
        this.setKeywordSubst(null);
        this.setIgnoreAllWhitespace(false);
        this.setIgnoreBlankLines(false);
        this.setIgnoreCase(false);
        this.setIgnoreSpaceChange(false);
        this.setContextDiff(false);
        this.setUnifiedDiff(false);
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.getKeywordSubst() != null && this.getKeywordSubst().length() > 0) {
            stringBuffer.append("-k" + this.getKeywordSubst() + " ");
        }
        if (!this.isRecursive()) {
            stringBuffer.append("-l ");
        }
        if (this.getRevision1() != null) {
            stringBuffer.append("-r " + this.getRevision1() + " ");
        }
        if (this.getBeforeDate1() != null) {
            stringBuffer.append("-D " + this.getBeforeDate1() + " ");
        }
        if (this.getRevision2() != null) {
            stringBuffer.append("-r " + this.getRevision2() + " ");
        }
        if (this.getBeforeDate2() != null) {
            stringBuffer.append("-D " + this.getBeforeDate2() + " ");
        }
        if (this.isIgnoreAllWhitespace()) {
            stringBuffer.append("-w ");
        }
        if (this.isIgnoreBlankLines()) {
            stringBuffer.append("-B ");
        }
        if (this.isIgnoreCase()) {
            stringBuffer.append("-i ");
        }
        if (this.isIgnoreSpaceChange()) {
            stringBuffer.append("-b ");
        }
        if (this.isContextDiff()) {
            stringBuffer.append("-c ");
        }
        if (this.isUnifiedDiff()) {
            stringBuffer.append("-u ");
        }
        return stringBuffer.toString();
    }

    public boolean isIgnoreAllWhitespace() {
        return this.ignoreAllWhitespace;
    }

    public void setIgnoreAllWhitespace(boolean bl) {
        this.ignoreAllWhitespace = bl;
    }

    public boolean isIgnoreBlankLines() {
        return this.ignoreBlankLines;
    }

    public void setIgnoreBlankLines(boolean bl) {
        this.ignoreBlankLines = bl;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public boolean isIgnoreSpaceChange() {
        return this.ignoreSpaceChange;
    }

    public void setIgnoreSpaceChange(boolean bl) {
        this.ignoreSpaceChange = bl;
    }

    public boolean isContextDiff() {
        return this.contextDiff;
    }

    public void setContextDiff(boolean bl) {
        this.contextDiff = bl;
    }

    public boolean isUnifiedDiff() {
        return this.unifiedDiff;
    }

    public void setUnifiedDiff(boolean bl) {
        this.unifiedDiff = bl;
    }
}

