/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.log;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandUtils;
import org.netbeans.lib.cvsclient.command.log.LogCommand;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.util.BugLog;

public class LogBuilder
implements Builder {
    private static final String LOGGING_DIR = "server: Logging ";
    private static final String RCS_FILE = "RCS file: ";
    private static final String WORK_FILE = "Working file: ";
    private static final String REV_HEAD = "head: ";
    private static final String BRANCH = "branch: ";
    private static final String LOCKS = "locks: ";
    private static final String ACCESS_LIST = "access list: ";
    private static final String SYM_NAME = "symbolic names:";
    private static final String KEYWORD_SUBST = "keyword substitution: ";
    private static final String TOTAL_REV = "total revisions: ";
    private static final String SEL_REV = ";\tselected revisions: ";
    private static final String DESCRIPTION = "description:";
    private static final String REVISION = "revision ";
    private static final String DATE = "date: ";
    private static final String BRANCHES = "branches: ";
    private static final String AUTHOR = "  author: ";
    private static final String STATE = "  state: ";
    private static final String LINES = "  lines: ";
    private static final String SPLITTER = "----------------------------";
    private static final String FINAL_SPLIT = "=============";
    private static final String ERROR = "server: nothing known about ";
    private static final String NO_FILE = "no file";
    protected EventManager eventManager;
    protected LogCommand logCommand;
    protected LogInformation logInfo;
    protected LogInformation.Revision revision;
    protected String fileDirectory;
    private boolean addingSymNames;
    private boolean addingDescription;
    private boolean addingLogMessage;
    private StringBuffer tempBuffer = null;
    private List messageList;

    public LogBuilder(EventManager eventManager, LogCommand logCommand) {
        this.logCommand = logCommand;
        this.eventManager = eventManager;
        this.addingSymNames = false;
        this.addingDescription = false;
        this.addingLogMessage = false;
        this.logInfo = null;
        this.revision = null;
        this.messageList = new ArrayList(500);
    }

    public void outputDone() {
        if (this.logInfo != null) {
            this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.logInfo));
            this.logInfo = null;
            this.messageList = null;
        }
    }

    public void parseLine(String string, boolean bl) {
        if (string.startsWith(FINAL_SPLIT)) {
            if (this.addingDescription) {
                this.addingDescription = false;
                this.logInfo.setDescription(this.tempBuffer.toString());
            }
            if (this.addingLogMessage) {
                this.addingLogMessage = false;
                this.revision.setMessage(CommandUtils.findUniqueString(this.tempBuffer.toString(), this.messageList));
            }
            if (this.revision != null) {
                this.logInfo.addRevision(this.revision);
                this.revision = null;
            }
            if (this.logInfo != null) {
                this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.logInfo));
                this.logInfo = null;
                this.tempBuffer = null;
            }
            return;
        }
        if (this.addingLogMessage) {
            if (string.startsWith(BRANCHES)) {
                this.processBranches(string.substring(BRANCHES.length()));
            } else {
                this.processLogMessage(string);
                return;
            }
        }
        if (this.addingSymNames) {
            this.processSymbolicNames(string);
        }
        if (this.addingDescription) {
            this.processDescription(string);
        }
        if (string.startsWith(REVISION)) {
            this.processRevisionStart(string);
        }
        if (string.startsWith(DATE)) {
            this.processRevisionDate(string);
        }
        if (string.startsWith(KEYWORD_SUBST)) {
            this.logInfo.setKeywordSubstitution(string.substring(KEYWORD_SUBST.length()).trim().intern());
            this.addingSymNames = false;
            return;
        }
        if (string.startsWith(DESCRIPTION)) {
            this.tempBuffer = new StringBuffer(string.substring(DESCRIPTION.length()));
            this.addingDescription = true;
        }
        if (string.indexOf(LOGGING_DIR) >= 0) {
            this.fileDirectory = string.substring(string.indexOf(LOGGING_DIR) + LOGGING_DIR.length()).trim();
            return;
        }
        if (string.startsWith(RCS_FILE)) {
            this.processRcsFile(string.substring(RCS_FILE.length()));
            return;
        }
        if (string.startsWith(WORK_FILE)) {
            this.processWorkingFile(string.substring(WORK_FILE.length()));
            return;
        }
        if (string.startsWith(REV_HEAD)) {
            this.logInfo.setHeadRevision(string.substring(REV_HEAD.length()).trim().intern());
            return;
        }
        if (string.startsWith(BRANCH)) {
            this.logInfo.setBranch(string.substring(BRANCH.length()).trim().intern());
        }
        if (string.startsWith(LOCKS)) {
            this.logInfo.setLocks(string.substring(LOCKS.length()).trim().intern());
        }
        if (string.startsWith(ACCESS_LIST)) {
            this.logInfo.setAccessList(string.substring(ACCESS_LIST.length()).trim().intern());
        }
        if (string.startsWith(SYM_NAME)) {
            this.addingSymNames = true;
        }
        if (string.startsWith(TOTAL_REV)) {
            int n = string.indexOf(59);
            if (n < 0) {
                this.logInfo.setTotalRevisions(string.substring(TOTAL_REV.length()).trim().intern());
                this.logInfo.setSelectedRevisions("0");
            } else {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n, string.length());
                this.logInfo.setTotalRevisions(string2.substring(TOTAL_REV.length()).trim().intern());
                this.logInfo.setSelectedRevisions(string3.substring(SEL_REV.length()).trim().intern());
            }
        }
    }

    private String findUniqueString(String string, List list) {
        if (string == null) {
            return null;
        }
        int n = list.indexOf(string);
        if (n >= 0) {
            return (String)list.get(n);
        }
        String string2 = string;
        list.add(string2);
        return string2;
    }

    private void processRcsFile(String string) {
        if (this.logInfo != null) {
            // empty if block
        }
        this.logInfo = new LogInformation();
        this.logInfo.setRepositoryFilename(string.trim());
    }

    private void processWorkingFile(String string) {
        String string2 = string.trim();
        if (string2.startsWith(NO_FILE)) {
            string2 = string2.substring(8);
        }
        this.logInfo.setFile(this.createFile(string));
    }

    private void processBranches(String string) {
        int n = string.lastIndexOf(59);
        if (n > 0) {
            string = string.substring(0, n);
        }
        this.revision.setBranches(string.trim());
    }

    private void processLogMessage(String string) {
        if (string.startsWith(SPLITTER)) {
            this.addingLogMessage = false;
            this.revision.setMessage(this.findUniqueString(this.tempBuffer.toString(), this.messageList));
            return;
        }
        this.tempBuffer.append(string + "\n");
    }

    private void processSymbolicNames(String string) {
        int n;
        if (!string.startsWith(KEYWORD_SUBST) && (n = (string = string.trim()).indexOf(58)) > 0) {
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1, string.length()).trim();
            this.logInfo.addSymbolicName(string2.intern(), string3.intern());
        }
    }

    private void processDescription(String string) {
        if (string.startsWith(SPLITTER)) {
            this.addingDescription = false;
            this.logInfo.setDescription(this.tempBuffer.toString());
            return;
        }
        this.tempBuffer.append(string);
    }

    private void processRevisionStart(String string) {
        if (this.revision != null) {
            this.logInfo.addRevision(this.revision);
        }
        this.revision = this.logInfo.createNewRevision(string.substring(REVISION.length()).intern());
    }

    private void processRevisionDate(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        if (stringTokenizer.hasMoreTokens()) {
            this.revision.setDateString(new String(stringTokenizer.nextToken().substring(DATE.length())));
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.revision.setAuthor(stringTokenizer.nextToken().substring(AUTHOR.length()).intern());
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.revision.setState(stringTokenizer.nextToken().substring(STATE.length()).intern());
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.revision.setLines(stringTokenizer.nextToken().substring(LINES.length()).intern());
        }
        this.addingLogMessage = true;
        this.tempBuffer = new StringBuffer();
    }

    protected File createFile(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.logCommand.getLocalDirectory());
        stringBuffer.append(File.separator);
        if (this.fileDirectory == null) {
            File file = this.logCommand.getFileEndingWith(string);
            if (file == null) {
                BugLog.getInstance().bug("JAVACVS ERROR!! wrong algorithm for assigning path to single files(1)!!");
                stringBuffer.append(string);
            } else {
                stringBuffer = new StringBuffer(file.getAbsolutePath());
            }
        } else {
            stringBuffer.append(string);
        }
        return new File(stringBuffer.toString());
    }

    public void parseEnhancedMessage(String string, Object object) {
    }
}

