/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.watch;

import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.Watch;
import org.netbeans.lib.cvsclient.command.watch.WatchMode;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;

public class WatchCommand
extends BasicCommand {
    private WatchMode watchMode;
    private Watch watch;

    public WatchCommand() {
        this.resetCVSCommand();
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        this.checkState();
        clientServices.ensureConnection();
        try {
            try {
                super.execute(clientServices, eventManager);
                if (this.getWatchMode().isWatchOptionAllowed()) {
                    String[] stringArray = this.getWatchNotNull().getArguments();
                    int n = 0;
                    while (n < stringArray.length) {
                        this.addRequest(new ArgumentRequest("-a"));
                        this.addRequest(new ArgumentRequest(stringArray[n]));
                        ++n;
                    }
                }
                this.addRequestForWorkingDirectory(clientServices);
                this.addArgumentRequests();
                this.addRequest(this.getWatchMode().getCommand());
                clientServices.processRequests(this.requests);
            }
            catch (CommandException commandException) {
                throw commandException;
            }
            catch (Exception exception) {
                throw new CommandException(exception, exception.getLocalizedMessage());
            }
            Object var6_7 = null;
            this.requests.clear();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.requests.clear();
            throw throwable;
        }
    }

    public void commandTerminated(TerminationEvent terminationEvent) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'R') {
            this.setRecursive(true);
        } else if (c == 'l') {
            this.setRecursive(false);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "Rl";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setWatch(null);
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("watch ");
        stringBuffer.append(this.getCVSArguments());
        this.appendFileArguments(stringBuffer);
        return stringBuffer.toString();
    }

    public String getCVSArguments() {
        this.checkState();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getWatchMode().toString());
        stringBuffer.append(' ');
        if (!this.isRecursive()) {
            stringBuffer.append("-l ");
        }
        if (this.getWatchMode().isWatchOptionAllowed()) {
            stringBuffer.append("-a ");
            stringBuffer.append(this.getWatchNotNull().toString());
        }
        return stringBuffer.toString();
    }

    public WatchMode getWatchMode() {
        return this.watchMode;
    }

    public void setWatchMode(WatchMode watchMode) {
        this.watchMode = watchMode;
    }

    public Watch getWatch() {
        return this.watch;
    }

    private Watch getWatchNotNull() {
        if (this.watch == null) {
            return Watch.ALL;
        }
        return this.watch;
    }

    public void setWatch(Watch watch) {
        this.watch = watch;
    }

    private void checkState() {
        if (this.getWatchMode() == null) {
            throw new IllegalStateException("Watch mode expected!");
        }
    }
}

