/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.commandLine;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.commandLine.BasicListener;
import org.netbeans.lib.cvsclient.commandLine.CommandFactory;
import org.netbeans.lib.cvsclient.commandLine.GetOpt;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.PServerConnection;
import org.netbeans.lib.cvsclient.connection.ServerConnection;
import org.netbeans.lib.cvsclient.connection.StandardScrambler;

public class CVSCommand {
    private String repository;
    private String localPath;
    private Connection connection;
    private Client client;
    private GlobalOptions globalOptions;

    public void executeCommand(Command command) throws CommandException, AuthenticationException {
        this.client.executeCommand(command, this.globalOptions);
    }

    public void setRepository(String string) {
        this.repository = string;
    }

    public void setLocalPath(String string) {
        this.localPath = string;
    }

    public void setGlobalOptions(GlobalOptions globalOptions) {
        this.globalOptions = globalOptions;
    }

    private void connectToServer() throws AuthenticationException {
        ServerConnection serverConnection = new ServerConnection();
        this.connection = serverConnection;
        serverConnection.setRepository(this.repository);
        serverConnection.open();
        this.client = new Client(serverConnection, new StandardAdminHandler());
        this.client.setLocalPath(this.localPath);
        this.client.getEventManager().addCVSListener(new BasicListener());
    }

    private void connectToServer(String string, String string2, String string3, int n) throws AuthenticationException {
        PServerConnection pServerConnection = new PServerConnection();
        this.connection = pServerConnection;
        pServerConnection.setUserName(string);
        pServerConnection.setEncodedPassword(string2);
        pServerConnection.setHostName(string3);
        pServerConnection.setRepository(this.repository);
        pServerConnection.setPort(n);
        pServerConnection.open();
        this.client = new Client(pServerConnection, new StandardAdminHandler());
        this.client.setLocalPath(this.localPath);
        this.client.getEventManager().addCVSListener(new BasicListener());
    }

    private void close() {
        try {
            this.connection.close();
        }
        catch (IOException iOException) {
            System.err.println("Unable to close connection: " + iOException);
            iOException.printStackTrace();
        }
    }

    /*
     * Loose catch block
     */
    private static String getCVSRoot() {
        String string;
        block13: {
            BufferedReader bufferedReader;
            block12: {
                string = null;
                bufferedReader = null;
                File file = new File(System.getProperty("user.dir"));
                File file2 = new File(file, "CVS/Root");
                if (!file2.exists()) break block12;
                bufferedReader = new BufferedReader(new FileReader(file2));
                string = bufferedReader.readLine();
            }
            Object var5_5 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                break block13;
            }
            catch (IOException iOException) {
                System.err.println("Warning: could not close CVS/Root file!");
            }
            break block13;
            {
                catch (IOException iOException) {
                    Object var5_6 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block13;
                    }
                    catch (IOException iOException2) {
                        System.err.println("Warning: could not close CVS/Root file!");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    System.err.println("Warning: could not close CVS/Root file!");
                }
                throw throwable;
            }
        }
        if (string == null) {
            string = System.getProperty("cvs.root");
        }
        return string;
    }

    private static int processGlobalOptions(String[] stringArray, GlobalOptions globalOptions) {
        GetOpt getOpt = new GetOpt(stringArray, "Hrwd:z:");
        int n = -1;
        boolean bl = false;
        while ((n = getOpt.getopt()) != -1) {
            if ((char)n == 'H') {
                bl = true;
                continue;
            }
            if ((char)n == 'r') {
                globalOptions.setCheckedOutFilesReadOnly(true);
                continue;
            }
            if ((char)n == 'w') {
                globalOptions.setCheckedOutFilesReadOnly(false);
                continue;
            }
            if ((char)n == 'd') {
                globalOptions.setCVSRoot(getOpt.optArgGet());
                continue;
            }
            if ((char)n == 'z') {
                globalOptions.setUseGzip(true);
                getOpt.optArgGet();
                continue;
            }
            bl = true;
        }
        if (bl) {
            CVSCommand.showUsage();
            System.exit(0);
        }
        return getOpt.optIndexGet();
    }

    private static void showUsage() {
        System.err.println("Usage: cvs [global options] command [options]");
    }

    /*
     * Loose catch block
     */
    private static void performLogin(String string, String string2, String string3, int n, GlobalOptions globalOptions) {
        block22: {
            BufferedReader bufferedReader;
            BufferedWriter bufferedWriter;
            File file;
            block21: {
                String string4;
                Object object;
                PServerConnection pServerConnection = new PServerConnection();
                pServerConnection.setUserName(string);
                String string5 = null;
                try {
                    object = new BufferedReader(new InputStreamReader(System.in));
                    System.out.print("Enter password: ");
                    string5 = ((BufferedReader)object).readLine();
                }
                catch (IOException iOException) {
                    System.err.println("Could not read password: " + iOException);
                    System.exit(1);
                }
                object = StandardScrambler.getInstance().scramble(string5);
                pServerConnection.setEncodedPassword((String)object);
                pServerConnection.setHostName(string2);
                pServerConnection.setRepository(string3);
                pServerConnection.setPort(n);
                try {
                    pServerConnection.verify();
                }
                catch (AuthenticationException authenticationException) {
                    System.err.println("Could not login to host " + string2);
                    System.exit(1);
                }
                file = new File(System.getProperty("cvs.passfile", System.getProperty("user.home") + "/.cvspass"));
                bufferedWriter = null;
                bufferedReader = null;
                if (file.createNewFile()) {
                    bufferedWriter = new BufferedWriter(new FileWriter(file));
                    bufferedWriter.write(globalOptions.getCVSRoot() + " " + (String)object);
                    bufferedWriter.close();
                    break block21;
                }
                File file2 = File.createTempFile("cvs", "tmp");
                bufferedReader = new BufferedReader(new FileReader(file));
                bufferedWriter = new BufferedWriter(new FileWriter(file2));
                while ((string4 = bufferedReader.readLine()) != null) {
                    if (string4.startsWith(globalOptions.getCVSRoot())) {
                        bufferedWriter.write(globalOptions.getCVSRoot() + " " + (String)object);
                        continue;
                    }
                    bufferedWriter.write(string4);
                }
                bufferedReader.close();
                bufferedWriter.close();
                File file3 = File.createTempFile("cvs", "tmp");
                file.renameTo(file3);
                file2.renameTo(file);
                file3.delete();
                file2.delete();
            }
            Object var15_17 = null;
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                break block22;
            }
            catch (Exception exception) {}
            break block22;
            {
                catch (IOException iOException) {
                    System.err.println("Error: could not write password file to " + file);
                    System.exit(1);
                    Object var15_18 = null;
                    try {
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block22;
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        System.err.println("Logged in successfully to repository " + string3 + " on host " + string2);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String lookupPassword(String string) {
        String string2;
        File file = new File(System.getProperty("cvs.passfile", System.getProperty("user.home") + "/.cvspass"));
        BufferedReader bufferedReader = null;
        String string3 = null;
        bufferedReader = new BufferedReader(new FileReader(file));
        while ((string2 = bufferedReader.readLine()) != null) {
            if (!string2.startsWith(string)) continue;
            string3 = string2.substring(string.length() + 1);
            break;
        }
        Object var6_6 = null;
        if (bufferedReader == null) return string3;
        try {
            bufferedReader.close();
            return string3;
        }
        catch (IOException iOException) {
            System.err.println("Warning: could not close password file.");
        }
        return string3;
        {
            catch (IOException iOException) {
                System.err.println("Could not read password for host: " + iOException);
                System.exit(1);
                Object var6_7 = null;
                if (bufferedReader == null) return string3;
                try {
                    bufferedReader.close();
                    return string3;
                }
                catch (IOException iOException2) {
                    System.err.println("Warning: could not close password file.");
                }
                return string3;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                System.err.println("Warning: could not close password file.");
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        block25: {
            var1_1 = new GlobalOptions();
            var1_1.setCVSRoot(CVSCommand.getCVSRoot());
            var2_2 = -1;
            try {
                var2_2 = CVSCommand.processGlobalOptions(var0, var1_1);
            }
            catch (IllegalArgumentException var3_3) {
                System.err.println("Invalid argument: " + var3_3);
                System.exit(1);
            }
            if (var1_1.getCVSRoot() == null) {
                System.err.println("No CVS root is set. Use the cvs.root property, e.g. java -Dcvs.root=\":pserver:user@host:/usr/cvs\" or start the application in a directory containing a CVS subdirectory or use the -d command switch.");
                System.exit(1);
            }
            var3_4 = null;
            var4_5 = var1_1.getCVSRoot();
            try {
                var3_4 = new CVSRoot(var4_5);
            }
            catch (IllegalArgumentException var5_6) {
                System.err.println("Incorrect format for CVSRoot: " + var4_5 + "\nThe correct format is: :<connection-type>:user@host:<repository path>" + "\nwhere <connection-type> is pserver and <repository path> is the " + "path to the cvs repository on the server.");
                System.exit(1);
            }
            if (var2_2 >= var0.length) {
                CVSCommand.showUsage();
                System.exit(1);
            }
            if ((var5_7 = var0[var2_2]).equals("login")) {
                if (var3_4.connectionType.equals("pserver")) {
                    CVSCommand.performLogin(var3_4.user, var3_4.host, var3_4.repository, var3_4.port, var1_1);
                    System.exit(0);
                } else {
                    System.err.println("login does not apply for connection type '" + var3_4.connectionType + "'");
                    System.exit(1);
                }
            }
            var6_8 = null;
            try {
                var6_8 = CommandFactory.getCommand(var5_7, var0, ++var2_2);
            }
            catch (IllegalArgumentException var7_9) {
                System.err.println("Illegal argument: " + var7_9.getMessage());
                System.exit(1);
            }
            var7_10 = null;
            if (var3_4.connectionType.equals("pserver")) {
                var7_10 = CVSCommand.lookupPassword(var4_5);
            }
            var8_11 = new CVSCommand();
            var8_11.setGlobalOptions(var1_1);
            var8_11.setRepository(var3_4.repository);
            var8_11.setLocalPath(System.getProperty("user.dir"));
            try {
                if (var3_4.connectionType.equals("pserver")) {
                    var8_11.connectToServer(var3_4.user, var7_10, var3_4.host, var3_4.port);
                } else {
                    var8_11.connectToServer();
                }
                var8_11.executeCommand(var6_8);
                var11_12 = null;
                ** if (var8_11 == null) goto lbl-1000
            }
            catch (Throwable var10_19) {
                var11_14 = null;
                if (var8_11 != null) {
                    try {
                        var8_11.close();
                    }
                    catch (Throwable var12_17) {
                        // empty catch block
                    }
                }
                throw var10_19;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var8_11.close();
                }
                catch (Throwable var12_15) {}
            }
lbl-1000:
            // 2 sources

            {
                break block25;
                catch (Throwable var9_18) {
                    System.err.println("Error: " + var9_18);
                    var9_18.printStackTrace();
                    System.exit(1);
                    var11_13 = null;
                    if (var8_11 != null) {
                        try {
                            var8_11.close();
                        }
                        catch (Throwable var12_16) {}
                    }
                }
            }
        }
        System.exit(0);
    }

    private static class CVSRoot {
        public String connectionType;
        public String user;
        public String host;
        public String repository;
        public int port = 2401;

        public CVSRoot(String string) throws IllegalArgumentException {
            if (!string.startsWith(":")) {
                throw new IllegalArgumentException();
            }
            int n = 0;
            int n2 = string.indexOf(58, 1);
            if (n2 == -1) {
                throw new IllegalArgumentException();
            }
            this.connectionType = string.substring(n + 1, n2);
            n = n2;
            if ((n2 = string.indexOf(64, n2 + 1)) == -1) {
                throw new IllegalArgumentException();
            }
            this.user = string.substring(n + 1, n2);
            n = n2;
            if ((n2 = string.indexOf(58, n2 + 1)) == -1) {
                throw new IllegalArgumentException();
            }
            this.host = string.substring(n + 1, n2);
            this.repository = string.substring(n2 + 1);
            boolean bl = true;
            int n3 = 0;
            String string2 = "";
            while (bl) {
                try {
                    int n4 = Integer.parseInt(this.repository.substring(n3, n3 + 1));
                    string2 = string2 + Integer.toString(n4);
                    ++n3;
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
            }
            if (string2.length() > 0) {
                try {
                    this.port = Integer.parseInt(string2);
                    this.repository = string.substring(string2.length());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.connectionType == null || this.user == null || this.host == null || this.repository == null) {
                throw new IllegalArgumentException();
            }
        }
    }
}

