/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.beans.PropertyEditorSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.netbeans.beaninfo.editors.PropertiesCustomEditor;
import org.openide.ErrorManager;

public class PropertiesEditor
extends PropertyEditorSupport {
    public String getAsText() {
        Object object = this.getValue();
        if (object instanceof Properties) {
            Properties properties = (Properties)object;
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = ((Hashtable)properties).keys();
            while (enumeration.hasMoreElements()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("; ");
                }
                Object k = enumeration.nextElement();
                stringBuffer.append(k + "=" + ((Hashtable)properties).get(k));
            }
            return stringBuffer.toString();
        }
        return "" + object;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Inserted value can't be null.");
        }
        try {
            Properties properties = new Properties();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.replace(';', '\n').getBytes("ISO8859_1"));
            properties.load(byteArrayInputStream);
            this.setValue(properties);
        }
        catch (IOException iOException) {
            throw (IllegalArgumentException)ErrorManager.getDefault().annotate((Throwable)new IllegalArgumentException(), (Throwable)iOException);
        }
    }

    public String getJavaInitializationString() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new PropertiesCustomEditor(this);
    }
}

