/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.netbeans.beaninfo.editors.CustomTableModelEditor;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableModelEditor
implements PropertyEditor,
XMLPropertyEditor {
    static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$beaninfo$editors$TableModelEditor == null ? (class$org$netbeans$beaninfo$editors$TableModelEditor = TableModelEditor.class$("org.netbeans.beaninfo.editors.TableModelEditor")) : class$org$netbeans$beaninfo$editors$TableModelEditor));
    private static final String XML_TABLE = "Table";
    private static final String XML_COLUMN = "Column";
    private static final String XML_DATA = "Data";
    private static final String ATTR_COLUMN_COUNT = "columnCount";
    private static final String ATTR_ROW_COUNT = "rowCount";
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_EDITABLE = "editable";
    private static final String ATTR_VALUE = "value";
    private NbTableModel table;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    static /* synthetic */ Class class$org$netbeans$beaninfo$editors$TableModelEditor;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;

    public Object getValue() {
        return this.table;
    }

    public void setValue(Object object) {
        this.table = new NbTableModel((TableModel)object);
        this.support.firePropertyChange("", null, null);
    }

    public String getAsText() {
        return null;
    }

    public void setAsText(String string) {
    }

    public String getJavaInitializationString() {
        TableModel tableModel = (TableModel)this.getValue();
        StringBuffer stringBuffer = new StringBuffer();
        int n = tableModel.getColumnCount();
        int n2 = tableModel.getRowCount();
        stringBuffer.append("{\n\t\t");
        if (n > 0) {
            String string = tableModel.getColumnName(0);
            stringBuffer.append("\"").append(string != null ? string : "").append('\"');
            int n3 = 1;
            while (n3 < n) {
                String string2 = tableModel.getColumnName(n3);
                stringBuffer.append(", \"").append(string2 != null ? string2 : "").append('\"');
                ++n3;
            }
        }
        stringBuffer.append("\n\t}");
        boolean bl = false;
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("{\n\t\t");
        if (n > 0) {
            stringBuffer2.append(tableModel.getColumnClass(0).getName()).append(".class");
            if (tableModel.getColumnClass(0) != (class$java$lang$Object == null ? (class$java$lang$Object = TableModelEditor.class$("java.lang.Object")) : class$java$lang$Object)) {
                bl = true;
            }
            int n4 = 1;
            while (n4 < n) {
                if (tableModel.getColumnClass(n4) != (class$java$lang$Object == null ? TableModelEditor.class$("java.lang.Object") : class$java$lang$Object)) {
                    bl = true;
                }
                stringBuffer2.append(", ").append(tableModel.getColumnClass(n4).getName()).append(".class");
                ++n4;
            }
        }
        stringBuffer2.append("\n\t}");
        boolean bl2 = false;
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer3.append("{\n\t\t");
        if (n > 0) {
            stringBuffer3.append(tableModel.isCellEditable(0, 0));
            if (!tableModel.isCellEditable(0, 0)) {
                bl2 = true;
            }
            int n5 = 1;
            while (n5 < n) {
                if (!tableModel.isCellEditable(0, n5)) {
                    bl2 = true;
                }
                stringBuffer3.append(", ").append(tableModel.isCellEditable(0, n5));
                ++n5;
            }
        }
        stringBuffer3.append("\n\t}");
        StringBuffer stringBuffer4 = new StringBuffer();
        stringBuffer4.append("{\n\t\t");
        if (n2 > 0) {
            int n6 = 0;
            while (n6 < n2) {
                if (n6 != 0) {
                    stringBuffer4.append(",\n\t\t");
                }
                if (n == 0) {
                    stringBuffer4.append("{}");
                } else {
                    Object object = tableModel.getValueAt(n6, 0);
                    stringBuffer4.append('{').append(TableModelEditor.getAsString(object));
                    int n7 = 1;
                    while (n7 < n) {
                        object = tableModel.getValueAt(n6, n7);
                        stringBuffer4.append(", ").append(TableModelEditor.getAsString(object));
                        ++n7;
                    }
                    stringBuffer4.append('}');
                }
                ++n6;
            }
        }
        stringBuffer4.append("\n\t}");
        if (bl2 || bl) {
            return "new javax.swing.table.DefaultTableModel(\n\tnew Object [][] " + new String(stringBuffer4) + ",\n" + "\tnew String [] " + new String(stringBuffer) + "\n" + ") {\n" + (bl ? "\tClass[] types = new Class [] " + new String(stringBuffer2) + ";\n" : "") + (bl2 ? "\tboolean[] canEdit = new boolean [] " + new String(stringBuffer3) + ";\n" : "") + (bl ? "\n\tpublic Class getColumnClass(int columnIndex) {\n\t\treturn types [columnIndex];\n\t}\n" : "") + (bl2 ? "\n\tpublic boolean isCellEditable(int rowIndex, int columnIndex) {\n\t\treturn canEdit [columnIndex];\n\t}\n" : "") + "}";
        }
        return "new javax.swing.table.DefaultTableModel(\n\tnew Object [][] " + new String(stringBuffer4) + ",\n" + "\tnew String [] " + new String(stringBuffer) + "\n" + ")";
    }

    public String[] getTags() {
        return null;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new CustomTableModelEditor(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public Node storeToXML(Document document) {
        Element element = document.createElement(XML_TABLE);
        int n = this.table.getColumnCount();
        int n2 = this.table.getRowCount();
        element.setAttribute(ATTR_COLUMN_COUNT, Integer.toString(n));
        element.setAttribute(ATTR_ROW_COUNT, Integer.toString(n2));
        int n3 = 0;
        while (n3 < n) {
            NbTableModel.ColumnItem columnItem = this.table.getColumnItem(n3);
            Element element2 = document.createElement(XML_COLUMN);
            element2.setAttribute(ATTR_TITLE, columnItem.title);
            element2.setAttribute(ATTR_TYPE, columnItem.type.getName());
            element2.setAttribute(ATTR_EDITABLE, columnItem.editable ? "true" : "false");
            boolean bl = false;
            int n4 = 0;
            while (n4 < n2) {
                if (columnItem.rows.get(n4) != null) {
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (bl) {
                int n5 = 0;
                while (n5 < n2) {
                    Element element3 = document.createElement(XML_DATA);
                    element3.setAttribute(ATTR_VALUE, TableModelEditor.valueToString(columnItem.rows.get(n5)));
                    element2.appendChild(element3);
                    ++n5;
                }
            }
            element.appendChild(element2);
            ++n3;
        }
        return element;
    }

    public void readFromXML(Node node) throws IOException {
        if (!XML_TABLE.equals(node.getNodeName())) {
            throw new IOException(TableModelEditor.getReadinErrorMessage());
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return;
        }
        IOException iOException = null;
        int n = -1;
        int n2 = -1;
        Node node2 = namedNodeMap.getNamedItem(ATTR_COLUMN_COUNT);
        if (node2 != null) {
            try {
                n = Integer.parseInt(node2.getNodeValue());
            }
            catch (NumberFormatException numberFormatException) {
                iOException = new IOException(TableModelEditor.getReadinErrorMessage());
                ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)numberFormatException);
            }
        }
        if ((node2 = namedNodeMap.getNamedItem(ATTR_ROW_COUNT)) != null) {
            try {
                n2 = Integer.parseInt(node2.getNodeValue());
            }
            catch (NumberFormatException numberFormatException) {
                if (iOException == null) {
                    iOException = new IOException(TableModelEditor.getReadinErrorMessage());
                }
                ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)numberFormatException);
            }
        }
        if (n < 0 || n2 < 0) {
            if (iOException == null) {
                iOException = new IOException(TableModelEditor.getReadinErrorMessage());
            }
            throw iOException;
        }
        ArrayList<NbTableModel.ColumnItem> arrayList = new ArrayList<NbTableModel.ColumnItem>(n);
        NodeList nodeList = node.getChildNodes();
        int n3 = 0;
        int n4 = nodeList.getLength();
        while (n3 < n4) {
            NamedNodeMap namedNodeMap2;
            Node node3 = nodeList.item(n3);
            if (XML_COLUMN.equals(node3.getNodeName()) && (namedNodeMap2 = node3.getAttributes()) != null) {
                String string = null;
                Class<?> clazz = null;
                Boolean bl = null;
                node2 = namedNodeMap2.getNamedItem(ATTR_TITLE);
                if (node2 != null) {
                    string = node2.getNodeValue();
                }
                if ((node2 = namedNodeMap2.getNamedItem(ATTR_TYPE)) != null) {
                    try {
                        clazz = Class.forName(node2.getNodeValue());
                    }
                    catch (Exception exception) {
                        iOException = new IOException(TableModelEditor.getReadinErrorMessage());
                        ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)exception);
                    }
                }
                if ((node2 = namedNodeMap2.getNamedItem(ATTR_EDITABLE)) != null) {
                    bl = new Boolean(node2.getNodeValue());
                }
                if (string == null || clazz == null || bl == null) {
                    if (iOException == null) {
                        iOException = new IOException(TableModelEditor.getReadinErrorMessage());
                    }
                    throw iOException;
                }
                ArrayList<Object> arrayList2 = new ArrayList<Object>(n2);
                NodeList nodeList2 = node3.getChildNodes();
                int n5 = 0;
                int n6 = nodeList2.getLength();
                while (n5 < n6) {
                    NamedNodeMap namedNodeMap3;
                    Node node4 = nodeList2.item(n5);
                    if (XML_DATA.equals(node4.getNodeName()) && (namedNodeMap3 = node4.getAttributes()) != null) {
                        Object object = null;
                        node2 = namedNodeMap3.getNamedItem(ATTR_VALUE);
                        if (node2 != null) {
                            try {
                                object = TableModelEditor.stringToValue(node2.getNodeValue(), clazz);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                iOException = new IOException(TableModelEditor.getReadinErrorMessage());
                                ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)illegalArgumentException);
                                throw iOException;
                            }
                        }
                        arrayList2.add(object);
                    }
                    ++n5;
                }
                if (arrayList2.size() != n2) {
                    if (arrayList2.size() == 0) {
                        int n7 = 0;
                        while (n7 < n2) {
                            arrayList2.add(null);
                            ++n7;
                        }
                    } else {
                        throw new IOException(TableModelEditor.getReadinErrorMessage());
                    }
                }
                arrayList.add(new NbTableModel.ColumnItem(string, clazz, (boolean)bl, arrayList2));
            }
            ++n3;
        }
        if (arrayList.size() != n) {
            throw new IOException(TableModelEditor.getReadinErrorMessage());
        }
        this.table = new NbTableModel(arrayList, n2);
    }

    private static String getReadinErrorMessage() {
        return bundle.getString("ERR_InvalidXMLFormat");
    }

    private static String valueToString(Object object) {
        if (object instanceof Integer || object instanceof Short || object instanceof Byte || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Boolean || object instanceof Character) {
            return object.toString();
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object == null) {
            return "null";
        }
        return null;
    }

    private static Object stringToValue(String string, Class clazz) {
        if ("null".equals(string)) {
            return null;
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = TableModelEditor.class$("java.lang.Object")) : class$java$lang$Object)) {
            return string;
        }
        if ((class$java$lang$Integer == null ? (class$java$lang$Integer = TableModelEditor.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(clazz) || Integer.TYPE.equals(clazz)) {
            return Integer.valueOf(string);
        }
        if ((class$java$lang$Short == null ? (class$java$lang$Short = TableModelEditor.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(clazz) || Short.TYPE.equals(clazz)) {
            return Short.valueOf(string);
        }
        if ((class$java$lang$Byte == null ? (class$java$lang$Byte = TableModelEditor.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(clazz) || Byte.TYPE.equals(clazz)) {
            return Byte.valueOf(string);
        }
        if ((class$java$lang$Long == null ? (class$java$lang$Long = TableModelEditor.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(clazz) || Long.TYPE.equals(clazz)) {
            return Long.valueOf(string);
        }
        if ((class$java$lang$Float == null ? (class$java$lang$Float = TableModelEditor.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(clazz) || Float.TYPE.equals(clazz)) {
            return Float.valueOf(string);
        }
        if ((class$java$lang$Double == null ? (class$java$lang$Double = TableModelEditor.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(clazz) || Double.TYPE.equals(clazz)) {
            return Double.valueOf(string);
        }
        if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = TableModelEditor.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz) || Boolean.TYPE.equals(clazz)) {
            return Boolean.valueOf(string);
        }
        if ((class$java$lang$Character == null ? (class$java$lang$Character = TableModelEditor.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(clazz) || Character.TYPE.equals(clazz)) {
            return new Character(string.charAt(0));
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = TableModelEditor.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz)) {
            return string;
        }
        throw new IllegalArgumentException();
    }

    static String getAsString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            if (object == null) {
                return "\"\"";
            }
            return "\"" + object + "\"";
        }
        String string = object.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1, string.length());
        }
        String string2 = "";
        if (object instanceof Byte) {
            string2 = "(byte) ";
        } else if (object instanceof Short) {
            string2 = "(short) ";
        }
        return "new " + string + "(" + string2 + object + ")";
    }

    static Object getDefaultValue(Class clazz) {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class NbTableModel
    extends AbstractTableModel
    implements Externalizable {
        static final long serialVersionUID = -6843008677521167210L;
        List columns;
        int rowCount;
        transient boolean alwaysEditable = false;
        static /* synthetic */ Class class$java$lang$Object;

        public NbTableModel() {
        }

        public NbTableModel(String[] stringArray, Class[] classArray, boolean[] blArray) {
            this(stringArray, classArray, blArray, 4);
        }

        public NbTableModel(String[] stringArray, Class[] classArray, boolean[] blArray, int n) {
            this.rowCount = n;
            this.columns = new ArrayList(stringArray.length);
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.columns.add(new ColumnItem(stringArray[n2], classArray[n2], blArray[n2], n));
                ++n2;
            }
        }

        public NbTableModel(TableModel tableModel) {
            if (tableModel == null) {
                this.rowCount = 4;
                this.columns = new ArrayList(20);
                int n = 0;
                while (n < 4) {
                    this.columns.add(new ColumnItem(bundle.getString("CTL_Title") + " " + Integer.toString(n + 1), class$java$lang$Object == null ? NbTableModel.class$("java.lang.Object") : class$java$lang$Object, true, this.rowCount));
                    ++n;
                }
            } else {
                this.rowCount = tableModel.getRowCount();
                int n = tableModel.getColumnCount();
                this.columns = new ArrayList(n);
                if (tableModel instanceof NbTableModel) {
                    NbTableModel nbTableModel = (NbTableModel)tableModel;
                    int n2 = 0;
                    while (n2 < n) {
                        ColumnItem columnItem = (ColumnItem)nbTableModel.columns.get(n2);
                        this.columns.add(new ColumnItem(columnItem));
                        ++n2;
                    }
                } else {
                    int n3 = 0;
                    while (n3 < n) {
                        ColumnItem columnItem = new ColumnItem(tableModel.getColumnName(n3), tableModel.getColumnClass(n3), true, this.rowCount);
                        int n4 = 0;
                        while (n4 < this.rowCount) {
                            columnItem.rows.set(n4, tableModel.getValueAt(n4, n3));
                            ++n4;
                        }
                        this.columns.add(columnItem);
                        ++n3;
                    }
                }
            }
        }

        NbTableModel(List list, int n) {
            this.columns = list;
            this.rowCount = n;
        }

        public Class getColumnClass(int n) {
            ColumnItem columnItem = (ColumnItem)this.columns.get(n);
            return columnItem.type;
        }

        public void setColumnClass(int n, Class clazz) {
            ColumnItem columnItem = (ColumnItem)this.columns.get(n);
            columnItem.type = clazz;
        }

        public String getColumnName(int n) {
            ColumnItem columnItem = (ColumnItem)this.columns.get(n);
            return columnItem.title;
        }

        public void setColumnName(int n, String string) {
            ColumnItem columnItem = (ColumnItem)this.columns.get(n);
            columnItem.title = string;
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public int getColumnCount() {
            return this.columns.size();
        }

        public boolean isColumnEditable(int n) {
            ColumnItem columnItem = (ColumnItem)this.columns.get(n);
            return columnItem.editable;
        }

        public boolean isCellEditable(int n, int n2) {
            if (this.alwaysEditable) {
                return true;
            }
            ColumnItem columnItem = (ColumnItem)this.columns.get(n2);
            return columnItem.editable;
        }

        public void setColumnEditable(int n, boolean bl) {
            ColumnItem columnItem = (ColumnItem)this.columns.get(n);
            columnItem.editable = bl;
        }

        public Object getValueAt(int n, int n2) {
            ColumnItem columnItem = (ColumnItem)this.columns.get(n2);
            return columnItem.rows.get(n);
        }

        public void setValueAt(Object object, int n, int n2) {
            ColumnItem columnItem = (ColumnItem)this.columns.get(n2);
            columnItem.rows.set(n, object);
            this.fireTableCellUpdated(n, n2);
        }

        private ColumnItem getColumnItem(int n) {
            return (ColumnItem)this.columns.get(n);
        }

        void setRowCount(int n) {
            if (n == this.rowCount) {
                return;
            }
            int n2 = 0;
            int n3 = this.columns.size();
            while (n2 < n3) {
                int n4;
                List list = ((ColumnItem)this.columns.get((int)n2)).rows;
                if (n > this.rowCount) {
                    n4 = n - this.rowCount;
                    while (n4 > 0) {
                        list.add(null);
                        --n4;
                    }
                } else {
                    n4 = this.rowCount - n;
                    while (n4 > 0) {
                        list.remove(n + n4 - 1);
                        --n4;
                    }
                }
                ++n2;
            }
            int n5 = this.rowCount;
            this.rowCount = n;
            if (n > n5) {
                this.fireTableRowsInserted(n5, n - 1);
            } else {
                this.fireTableRowsDeleted(n, n5 - 1);
            }
        }

        void addRow(int n) {
            if (n >= 0 && n <= this.rowCount) {
                int n2 = 0;
                int n3 = this.columns.size();
                while (n2 < n3) {
                    ((ColumnItem)this.columns.get((int)n2)).rows.add(n, null);
                    ++n2;
                }
                ++this.rowCount;
                this.fireTableRowsInserted(n, n);
            }
        }

        void removeRow(int n) {
            if (n >= 0 && n < this.rowCount) {
                int n2 = 0;
                int n3 = this.columns.size();
                while (n2 < n3) {
                    ((ColumnItem)this.columns.get((int)n2)).rows.remove(n);
                    ++n2;
                }
                --this.rowCount;
                this.fireTableRowsDeleted(n, n);
            }
        }

        void moveRow(int n, int n2) {
            if (this.columns.size() > 0 && n >= 0 && n < this.rowCount && n2 >= 0 && n2 < this.rowCount && n != n2) {
                int n3 = 0;
                int n4 = this.columns.size();
                while (n3 < n4) {
                    List list = ((ColumnItem)this.columns.get((int)n3)).rows;
                    Object e = list.get(n2);
                    list.set(n2, list.get(n));
                    list.set(n, e);
                    ++n3;
                }
                this.fireTableStructureChanged();
            }
        }

        void setColumnCount(int n) {
            int n2 = this.columns.size();
            if (n == n2) {
                return;
            }
            if (n > n2) {
                int n3 = n - n2;
                while (n3 > 0) {
                    this.columns.add(new ColumnItem(bundle.getString("CTL_Title") + " " + Integer.toString(n - n3 + 1), class$java$lang$Object == null ? NbTableModel.class$("java.lang.Object") : class$java$lang$Object, true, this.rowCount));
                    --n3;
                }
            } else {
                int n4 = n2 - n;
                while (n4 > 0) {
                    this.columns.remove(n + n4 - 1);
                    --n4;
                }
            }
            this.fireTableStructureChanged();
        }

        void addColumn(int n) {
            if (n >= 0 && n <= this.columns.size()) {
                this.columns.add(n, new ColumnItem(bundle.getString("CTL_Title") + " " + Integer.toString(n + 1), class$java$lang$Object == null ? (class$java$lang$Object = NbTableModel.class$("java.lang.Object")) : class$java$lang$Object, true, this.rowCount));
                int n2 = n + 1;
                int n3 = this.columns.size();
                while (n2 < n3) {
                    ColumnItem columnItem = (ColumnItem)this.columns.get(n2);
                    NbTableModel.renameDefaultColumnTitle(columnItem, n2, n2 + 1);
                    ++n2;
                }
                this.fireTableStructureChanged();
            }
        }

        void removeColumn(int n) {
            if (n >= 0 && n < this.columns.size()) {
                this.columns.remove(n);
                int n2 = n;
                int n3 = this.columns.size();
                while (n2 < n3) {
                    ColumnItem columnItem = (ColumnItem)this.columns.get(n2);
                    NbTableModel.renameDefaultColumnTitle(columnItem, n2 + 2, n2 + 1);
                    ++n2;
                }
                this.fireTableStructureChanged();
            }
        }

        void moveColumn(int n, int n2) {
            if (n >= 0 && n < this.columns.size() && n2 >= 0 && n2 < this.columns.size() && n != n2) {
                ColumnItem columnItem = (ColumnItem)this.columns.get(n);
                ColumnItem columnItem2 = (ColumnItem)this.columns.get(n2);
                NbTableModel.renameDefaultColumnTitle(columnItem, n + 1, n2 + 1);
                NbTableModel.renameDefaultColumnTitle(columnItem2, n2 + 1, n + 1);
                this.columns.set(n2, columnItem);
                this.columns.set(n, columnItem2);
                this.fireTableStructureChanged();
            }
        }

        private static void renameDefaultColumnTitle(ColumnItem columnItem, int n, int n2) {
            String string = bundle.getString("CTL_Title") + " " + Integer.toString(n);
            if (string.equals(columnItem.title)) {
                columnItem.title = bundle.getString("CTL_Title") + " " + Integer.toString(n2);
            }
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.rowCount);
            int n = this.columns.size();
            objectOutput.writeInt(n);
            String[] stringArray = new String[n];
            boolean[] blArray = new boolean[n];
            int n2 = 0;
            while (n2 < n) {
                ColumnItem columnItem = (ColumnItem)this.columns.get(n2);
                stringArray[n2] = columnItem.title;
                blArray[n2] = columnItem.editable;
                ++n2;
            }
            objectOutput.writeObject(stringArray);
            objectOutput.writeObject(blArray);
            int n3 = 0;
            while (n3 < n) {
                ColumnItem columnItem = (ColumnItem)this.columns.get(n3);
                objectOutput.writeObject(columnItem.type.getName());
                ++n3;
            }
            int n4 = 0;
            while (n4 < this.rowCount) {
                int n5 = 0;
                while (n5 < n) {
                    ColumnItem columnItem = (ColumnItem)this.columns.get(n5);
                    if (columnItem.rows.get(n4) instanceof Serializable) {
                        objectOutput.writeObject(columnItem.rows.get(n4));
                    } else {
                        objectOutput.writeObject(null);
                    }
                    ++n5;
                }
                ++n4;
            }
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.rowCount = objectInput.readInt();
            int n = objectInput.readInt();
            this.columns = new ArrayList(n);
            String[] stringArray = (String[])objectInput.readObject();
            boolean[] blArray = (boolean[])objectInput.readObject();
            int n2 = 0;
            while (n2 < n) {
                this.columns.add(new ColumnItem(stringArray[n2], Class.forName((String)objectInput.readObject()), blArray[n2], this.rowCount));
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.rowCount) {
                int n4 = 0;
                while (n4 < n) {
                    ColumnItem columnItem = (ColumnItem)this.columns.get(n4);
                    columnItem.rows.set(n3, objectInput.readObject());
                    ++n4;
                }
                ++n3;
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private static class ColumnItem {
            String title;
            Class type;
            boolean editable;
            List rows;

            ColumnItem(String string, Class clazz, boolean bl, int n) {
                this.title = string;
                this.type = clazz;
                this.editable = bl;
                this.rows = new ArrayList(n);
                int n2 = 0;
                while (n2 < n) {
                    this.rows.add(null);
                    ++n2;
                }
            }

            ColumnItem(String string, Class clazz, boolean bl, List list) {
                this.title = string;
                this.type = clazz;
                this.editable = bl;
                this.rows = list;
            }

            ColumnItem(ColumnItem columnItem) {
                this.title = columnItem.title;
                this.type = columnItem.type;
                this.editable = columnItem.editable;
                int n = columnItem.rows.size();
                this.rows = new ArrayList(n);
                int n2 = 0;
                while (n2 < n) {
                    this.rows.add(columnItem.rows.get(n2));
                    ++n2;
                }
            }
        }
    }
}

