/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.ToolTipManager;
import org.netbeans.core.NetworkOptions;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.InstanceCookie;
import org.openide.explorer.ExplorerPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class IDESettings
extends SystemOption {
    static final long serialVersionUID = 801136840705717911L;
    public static final String PROP_SHOW_TOOLTIPS_IN_IDE = "showToolTipsInIDE";
    public static final String PROP_SHOW_TIPS_ON_STARTUP = "showTipsOnStartup";
    public static final String PROP_LAST_TIP = "lastTip";
    public static final String PROP_CONFIRM_DELETE = "confirmDelete";
    public static final String PROP_HOME_PAGE = "homePage";
    public static final String PROP_USE_PROXY = "useProxy";
    public static final String PROP_PROXY_HOST = "proxyHost";
    public static final String PROP_PROXY_PORT = "proxyPort";
    public static final String PROP_SHOW_FILE_EXTENSIONS = "showFileExtensions";
    public static final String PROP_MODULES_SORT_MODE = "modulesSortMode";
    public static final String PROP_WWWBROWSER = "WWWBrowser";
    public static final String PROP_UIMODE = "UIMode";
    public static final String KEY_PROXY_HOST = "http.proxyHost";
    public static final String KEY_PROXY_PORT = "http.proxyPort";
    public static final String KEY_NON_PROXY_HOSTS = "http.nonProxyHosts";
    public static final String PROP_MINI_STATUS_BAR_STATE = "mini_status_bar_state";
    public static final int MODULES_SORT_UNSORTED = 0;
    public static final int MODULES_SORT_DISPLAYNAME = 1;
    public static final int MODULES_SORT_CODENAME = 2;
    public static final int MODULES_SORT_ENABLED = 3;
    public static final int MODULES_SORT_URL = 4;
    public static final int MODULES_SORT_CATEGORY = 5;
    private static boolean showToolTips = true;
    private static boolean showTips = true;
    private static int lastTip = -1;
    private static boolean confirmDelete = true;
    private static int modulesSortMode = 5;
    private static Hashtable alreadyLoadedBeans = new Hashtable();
    private static boolean useProxy = false;
    private static boolean isMiniStatusBarEnabled = true;
    private static String proxyHost = System.getProperty("http.proxyHost", "");
    private static String proxyPort = System.getProperty("http.proxyPort", "");
    private static int uiMode = 2;
    static /* synthetic */ Class class$org$netbeans$core$IDESettings;
    static /* synthetic */ Class class$org$openide$awt$HtmlBrowser$Factory;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

    private static Properties getPreInitProxyProps() throws IOException {
        String string = System.getProperty("netbeans.home");
        FileInputStream fileInputStream = new FileInputStream(new File(string, "installer/pre-settings.properties"));
        Properties properties = new Properties();
        properties.load(fileInputStream);
        ((InputStream)fileInputStream).close();
        return properties;
    }

    protected void initialize() {
        super.initialize();
        String string = proxyHost;
        String string2 = proxyPort;
        if (proxyHost.length() == 0 || proxyPort.length() == 0) {
            try {
                Properties properties = IDESettings.getPreInitProxyProps();
                string = properties.getProperty("proxy_host");
                string2 = properties.getProperty("proxy_port");
            }
            catch (IOException iOException) {
                return;
            }
            this.setProxyHost(string);
            this.setProxyPort(string2);
            this.setUseProxy(true);
        }
        this.putProperty(PROP_WWWBROWSER, "", false);
    }

    public static URL getRealHomeURL() {
        return NetworkOptions.getStaticHomeURL();
    }

    public int getModulesSortMode() {
        return modulesSortMode;
    }

    public void setModulesSortMode(int n) {
        int n2 = modulesSortMode;
        modulesSortMode = n;
        this.firePropertyChange(PROP_MODULES_SORT_MODE, new Integer(n2), new Integer(n));
    }

    public boolean getShowToolTipsInIDE() {
        return showToolTips;
    }

    public void setShowToolTipsInIDE(boolean bl) {
        if (showToolTips == bl) {
            return;
        }
        showToolTips = bl;
        ToolTipManager.sharedInstance().setEnabled(bl);
        this.firePropertyChange(PROP_SHOW_TOOLTIPS_IN_IDE, new Boolean(!showToolTips), new Boolean(showToolTips));
    }

    public boolean getShowTipsOnStartup() {
        return showTips;
    }

    public void setShowTipsOnStartup(boolean bl) {
        if (showTips == bl) {
            return;
        }
        showTips = bl;
        this.firePropertyChange(PROP_SHOW_TIPS_ON_STARTUP, new Boolean(!showTips), new Boolean(showTips));
    }

    public int getLastTip() {
        return lastTip;
    }

    public void setLastTip(int n) {
        if (n == lastTip) {
            return;
        }
        Integer n2 = new Integer(lastTip);
        lastTip = n;
        this.firePropertyChange(PROP_LAST_TIP, n2, new Integer(lastTip));
    }

    public boolean getConfirmDelete() {
        return confirmDelete;
    }

    public void setConfirmDelete(boolean bl) {
        if (bl == confirmDelete) {
            return;
        }
        Boolean bl2 = new Boolean(confirmDelete);
        confirmDelete = bl;
        ExplorerPanel.setConfirmDelete((boolean)bl);
        this.firePropertyChange(PROP_CONFIRM_DELETE, bl2, new Boolean(confirmDelete));
    }

    public String displayName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = IDESettings.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings)).getString("CTL_IDESettings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = IDESettings.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings);
    }

    public Hashtable getLoadedBeans() {
        return alreadyLoadedBeans;
    }

    public void setLoadedBeans(Hashtable hashtable) {
        alreadyLoadedBeans = hashtable;
    }

    public String getHomePage() {
        return HtmlBrowser.getHomePage();
    }

    public void setHomePage(String string) {
        HtmlBrowser.setHomePage((String)string);
    }

    public boolean getMiniStatusBarState() {
        return isMiniStatusBarEnabled;
    }

    public void setMiniStatusBarState(boolean bl) {
        if (isMiniStatusBarEnabled != bl) {
            boolean bl2 = isMiniStatusBarEnabled;
            isMiniStatusBarEnabled = bl;
            this.firePropertyChange(PROP_MINI_STATUS_BAR_STATE, new Boolean(bl2), new Boolean(isMiniStatusBarEnabled));
        }
    }

    public boolean getUseProxy() {
        return useProxy;
    }

    public void setUseProxy(boolean bl) {
        if (useProxy != bl) {
            boolean bl2 = useProxy;
            useProxy = bl;
            if (bl) {
                System.setProperty(KEY_PROXY_HOST, this.getProxyHost());
                System.setProperty(KEY_PROXY_PORT, this.getProxyPort());
                System.setProperty(KEY_NON_PROXY_HOSTS, this.getDefaultNonProxyHosts());
            } else {
                System.setProperty(KEY_PROXY_HOST, "");
                System.setProperty(KEY_PROXY_PORT, "");
                System.setProperty(KEY_NON_PROXY_HOSTS, "");
            }
            this.firePropertyChange(PROP_USE_PROXY, new Boolean(bl2), new Boolean(bl));
        }
    }

    public String getProxyHost() {
        return proxyHost;
    }

    public void setProxyHost(String string) {
        if (!proxyHost.equals(string)) {
            String string2 = proxyHost;
            proxyHost = string;
            if (this.getUseProxy()) {
                System.setProperty(KEY_PROXY_HOST, proxyHost);
            }
            this.firePropertyChange(PROP_PROXY_HOST, string2, proxyHost);
        }
    }

    public String getProxyPort() {
        return proxyPort;
    }

    public void setProxyPort(String string) {
        if (!proxyPort.equals(string)) {
            String string2 = proxyPort;
            proxyPort = string;
            if (this.getUseProxy()) {
                System.setProperty(KEY_PROXY_PORT, proxyPort);
            }
            this.firePropertyChange(PROP_PROXY_PORT, string2, proxyPort);
        }
    }

    public boolean getShowFileExtensions() {
        return DataNode.getShowFileExtensions();
    }

    public void setShowFileExtensions(boolean bl) {
        boolean bl2 = this.getShowFileExtensions();
        DataNode.setShowFileExtensions((boolean)bl);
        this.firePropertyChange(PROP_SHOW_FILE_EXTENSIONS, new Boolean(bl2), new Boolean(bl));
    }

    public HtmlBrowser.Factory getWWWBrowser() {
        try {
            Object object = this.getProperty(PROP_WWWBROWSER);
            if (object instanceof String) {
                Lookup.Item item = Lookup.getDefault().lookupItem(new Lookup.Template(class$org$openide$awt$HtmlBrowser$Factory == null ? (class$org$openide$awt$HtmlBrowser$Factory = IDESettings.class$("org.openide.awt.HtmlBrowser$Factory")) : class$org$openide$awt$HtmlBrowser$Factory, (String)object, null));
                return item == null ? null : (HtmlBrowser.Factory)item.getInstance();
            }
            Node.Handle handle = (Node.Handle)object;
            if (handle == null) {
                Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$awt$HtmlBrowser$Factory == null ? (class$org$openide$awt$HtmlBrowser$Factory = IDESettings.class$("org.openide.awt.HtmlBrowser$Factory")) : class$org$openide$awt$HtmlBrowser$Factory));
                Iterator iterator = result.allInstances().iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Services/Browsers");
                    DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                    DataObject[] dataObjectArray = dataFolder.getChildren();
                    int n = 0;
                    while (n < dataObjectArray.length) {
                        Object object2 = null;
                        try {
                            InstanceCookie instanceCookie = (InstanceCookie)dataObjectArray[n].getCookie(class$org$openide$cookies$InstanceCookie == null ? IDESettings.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                            if (instanceCookie != null && (object2 = instanceCookie.instanceCreate()) != null && object2.equals(e) && !Boolean.TRUE.equals(dataObjectArray[n].getPrimaryFile().getAttribute("hidden"))) {
                                return (HtmlBrowser.Factory)e;
                            }
                        }
                        catch (IOException iOException) {
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                        ++n;
                    }
                }
                return null;
            }
            Node node = handle.getNode();
            Object object3 = ((InstanceCookie)node.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = IDESettings.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie)).instanceCreate();
            return (HtmlBrowser.Factory)object3;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorManager.getDefault().notify(1, (Throwable)classNotFoundException);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return null;
    }

    public void setWWWBrowser(HtmlBrowser.Factory factory) {
        try {
            if (factory == null) {
                this.putProperty(PROP_WWWBROWSER, null, true);
                return;
            }
            Lookup.Item item = Lookup.getDefault().lookupItem(new Lookup.Template(null, null, (Object)factory));
            if (item != null) {
                this.putProperty(PROP_WWWBROWSER, item.getId(), true);
            } else {
                ErrorManager.getDefault().log("IDESettings: Cannot find browser in lookup");
                this.putProperty(PROP_WWWBROWSER, null, true);
            }
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Services/Browsers");
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
            DataObject[] dataObjectArray = dataFolder.getChildren();
            int n = 0;
            while (n < dataObjectArray.length) {
                Object object = null;
                try {
                    object = ((InstanceCookie)dataObjectArray[n].getCookie(class$org$openide$cookies$InstanceCookie == null ? IDESettings.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie)).instanceCreate();
                }
                catch (IOException iOException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (object != null && object.equals(factory)) {
                    dataObjectArray[n].getPrimaryFile().setAttribute("DEFAULT_BROWSER", (Object)Boolean.TRUE);
                } else {
                    Object object2 = dataObjectArray[n].getPrimaryFile().getAttribute("DEFAULT_BROWSER");
                    if (object2 != null && object2 instanceof Boolean) {
                        dataObjectArray[n].getPrimaryFile().setAttribute("DEFAULT_BROWSER", (Object)Boolean.FALSE);
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    public void setUIMode(int n) {
        if (uiMode == n) {
            return;
        }
        int n2 = uiMode;
        uiMode = n;
        this.firePropertyChange(PROP_UIMODE, new Integer(n2), new Integer(n));
    }

    public int getUIMode() {
        return uiMode;
    }

    private String getDefaultNonProxyHosts() {
        String string = "localhost";
        try {
            string = string + "|" + InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            ErrorManager.getDefault().notify(1, (Throwable)unknownHostException);
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

