/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.Component;
import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.beaninfo.ExJarFileSystemBeanInfo;
import org.netbeans.beaninfo.ExLocalFileSystemBeanInfo;
import org.netbeans.beaninfo.JarFileSystemBeanInfo;
import org.netbeans.beaninfo.LocalFileSystemBeanInfo;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.UnmountFSCookie;
import org.netbeans.core.ui.MountNode;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.InstanceSupport;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;

final class RootFolderNode
extends DataFolder.FolderNode
implements UnmountFSCookie,
PropertyChangeListener {
    private static MessageFormat formatRoot;
    private FileSystem fs;
    private DataFolder df;
    private Image iconCache;
    static /* synthetic */ Class class$org$netbeans$core$RootFolderNode;
    static /* synthetic */ Class class$org$openide$actions$OpenLocalExplorerAction;
    static /* synthetic */ Class class$org$openide$actions$FindAction;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
    static /* synthetic */ Class class$org$openide$actions$CompileAction;
    static /* synthetic */ Class class$org$openide$actions$CompileAllAction;
    static /* synthetic */ Class class$org$openide$actions$BuildAction;
    static /* synthetic */ Class class$org$openide$actions$BuildAllAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$NewTemplateAction;
    static /* synthetic */ Class class$org$netbeans$core$actions$UnmountFSAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$netbeans$core$UnmountFSCookie;

    public RootFolderNode(DataFolder dataFolder, Children children) {
        super(dataFolder, children);
        this.df = dataFolder;
        this.init();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        sheet.remove("properties");
        Sheet.Set set = sheet.remove("sorting");
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.fs.getClass());
            BeanNode.Descriptor descriptor = BeanNode.computeProperties((Object)this.fs, (BeanInfo)beanInfo);
            Sheet.Set set2 = Sheet.createPropertiesSet();
            set2.put(descriptor.property);
            sheet.put(set2);
            if (descriptor.expert != null) {
                set2 = Sheet.createExpertSet();
                set2.put(descriptor.expert);
                sheet.put(set2);
            }
        }
        catch (IntrospectionException introspectionException) {
            ErrorManager.getDefault().notify(1, (Throwable)introspectionException);
        }
        sheet.put(set);
        return sheet;
    }

    public String getName() {
        return this.fs == null ? "" : this.fs.getSystemName();
    }

    private void init() {
        try {
            this.fs = this.df.getPrimaryFile().getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            throw new InternalError();
        }
        this.fs.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this, (Object)this.fs));
        this.setIconBase("org/netbeans/core/resources/defaultFS");
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$core$RootFolderNode == null ? (class$org$netbeans$core$RootFolderNode = RootFolderNode.class$("org.netbeans.core.RootFolderNode")) : class$org$netbeans$core$RootFolderNode));
        formatRoot = new MessageFormat(resourceBundle.getString("dataFolderRootName"));
        this.initDisplayName();
    }

    private void initDisplayName() {
        String string = formatRoot.format(new Object[]{this.fs.getDisplayName(), this.fs.getSystemName()});
        this.setDisplayName(string);
    }

    public Image getIcon(int n) {
        if (this.iconCache != null) {
            return this.iconCache;
        }
        Class<?> clazz = this.fs.getClass();
        BeanInfo beanInfo = RootFolderNode.getBeanInfoForClass(clazz.getName());
        if (beanInfo != null) {
            this.iconCache = beanInfo.getIcon(n);
            return this.iconCache;
        }
        try {
            beanInfo = Utilities.getBeanInfo(this.fs.getClass());
        }
        catch (IntrospectionException introspectionException) {
            this.iconCache = super.getIcon(n);
            return this.iconCache;
        }
        Image image = beanInfo.getIcon(n);
        this.iconCache = image == null ? super.getIcon(n) : image;
        return this.iconCache;
    }

    public String getShortDescription() {
        BeanDescriptor beanDescriptor;
        Class<?> clazz = this.fs.getClass();
        BeanInfo beanInfo = RootFolderNode.getBeanInfoForClass(clazz.getName());
        if (beanInfo == null) {
            try {
                beanInfo = Utilities.getBeanInfo(this.fs.getClass());
            }
            catch (IntrospectionException introspectionException) {
                ErrorManager.getDefault().notify(1, (Throwable)introspectionException);
                return null;
            }
        }
        if ((beanDescriptor = beanInfo.getBeanDescriptor()) == null) {
            return null;
        }
        String string = beanDescriptor.getShortDescription();
        if (string == null || string.equals(beanDescriptor.getName())) {
            return null;
        }
        return string;
    }

    private static BeanInfo getBeanInfoForClass(String string) {
        if (string.equals("org.openide.filesystems.LocalFileSystem")) {
            return new LocalFileSystemBeanInfo();
        }
        if (string.equals("org.netbeans.core.ExLocalFileSystem")) {
            return new ExLocalFileSystemBeanInfo();
        }
        if (string.equals("org.netbeans.core.ExJarFileSystem")) {
            return new ExJarFileSystemBeanInfo();
        }
        if (string.equals("org.openide.filesystems.JarFileSystem")) {
            return new JarFileSystemBeanInfo();
        }
        return null;
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$OpenLocalExplorerAction == null ? (class$org$openide$actions$OpenLocalExplorerAction = RootFolderNode.class$("org.openide.actions.OpenLocalExplorerAction")) : class$org$openide$actions$OpenLocalExplorerAction)), SystemAction.get((Class)(class$org$openide$actions$FindAction == null ? (class$org$openide$actions$FindAction = RootFolderNode.class$("org.openide.actions.FindAction")) : class$org$openide$actions$FindAction)), SystemAction.get((Class)(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = RootFolderNode.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction)), null, SystemAction.get((Class)(class$org$openide$actions$CompileAction == null ? (class$org$openide$actions$CompileAction = RootFolderNode.class$("org.openide.actions.CompileAction")) : class$org$openide$actions$CompileAction)), SystemAction.get((Class)(class$org$openide$actions$CompileAllAction == null ? (class$org$openide$actions$CompileAllAction = RootFolderNode.class$("org.openide.actions.CompileAllAction")) : class$org$openide$actions$CompileAllAction)), null, SystemAction.get((Class)(class$org$openide$actions$BuildAction == null ? (class$org$openide$actions$BuildAction = RootFolderNode.class$("org.openide.actions.BuildAction")) : class$org$openide$actions$BuildAction)), SystemAction.get((Class)(class$org$openide$actions$BuildAllAction == null ? (class$org$openide$actions$BuildAllAction = RootFolderNode.class$("org.openide.actions.BuildAllAction")) : class$org$openide$actions$BuildAllAction)), null, SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = RootFolderNode.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = RootFolderNode.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$NewTemplateAction == null ? (class$org$openide$actions$NewTemplateAction = RootFolderNode.class$("org.openide.actions.NewTemplateAction")) : class$org$openide$actions$NewTemplateAction)), null, SystemAction.get((Class)(class$org$netbeans$core$actions$UnmountFSAction == null ? (class$org$netbeans$core$actions$UnmountFSAction = RootFolderNode.class$("org.netbeans.core.actions.UnmountFSAction")) : class$org$netbeans$core$actions$UnmountFSAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = RootFolderNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = RootFolderNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public boolean hasCustomizer() {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.fs.getClass());
            return beanInfo.getBeanDescriptor().getCustomizerClass() != null;
        }
        catch (IntrospectionException introspectionException) {
            return false;
        }
    }

    public Component getCustomizer() {
        try {
            Customizer customizer;
            BeanInfo beanInfo = Introspector.getBeanInfo(this.fs.getClass());
            Class<?> clazz = beanInfo.getBeanDescriptor().getCustomizerClass();
            Object obj = clazz.newInstance();
            if (obj instanceof Customizer) {
                customizer = (Customizer)obj;
                customizer.setObject(this.fs);
            }
            if (obj instanceof Component) {
                return (Component)obj;
            }
            if (obj instanceof DialogDescriptor) {
                customizer = (DialogDescriptor)obj;
                return TopManager.getDefault().createDialog((DialogDescriptor)customizer);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return null;
    }

    public Node.Cookie getCookie(Class clazz) {
        Node.Cookie cookie = super.getCookie(clazz);
        if (cookie != null) {
            return cookie;
        }
        if ((class$org$netbeans$core$UnmountFSCookie == null ? (class$org$netbeans$core$UnmountFSCookie = RootFolderNode.class$("org.netbeans.core.UnmountFSCookie")) : class$org$netbeans$core$UnmountFSCookie) == clazz && !this.fs.isDefault()) {
            return this;
        }
        return null;
    }

    public void unmount() {
        MountNode.unmount(this.fs);
        NbTopManager.get().getRepository().removeFileSystem(this.fs);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = "displayName".equals(propertyChangeEvent.getPropertyName());
        boolean bl2 = "systemName".equals(propertyChangeEvent.getPropertyName());
        if (bl2 || bl) {
            this.initDisplayName();
            this.fireShortDescriptionChange(null, null);
        }
        this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    public HelpCtx getHelpCtx() {
        HelpCtx helpCtx = InstanceSupport.findHelp((InstanceCookie)new InstanceSupport.Instance((Object)this.fs));
        if (helpCtx != null) {
            return helpCtx;
        }
        return super.getHelpCtx();
    }

    public Node.Handle getHandle() {
        return new RootFolderHandle(this.fs);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class RootFolderHandle
    implements Node.Handle {
        private String fs;
        private transient FileSystem legacyFS;
        private static final long serialVersionUID = -703297683479416470L;

        public RootFolderHandle(FileSystem fileSystem) {
            this.legacyFS = fileSystem;
            this.fs = fileSystem.getSystemName();
        }

        public Node getNode() throws IOException {
            if (this.legacyFS == null) {
                if (this.fs == null) {
                    throw new IOException("RootFolderHandle: Field fs is null.");
                }
                this.legacyFS = Repository.getDefault().findFileSystem(this.fs);
                if (this.legacyFS == null) {
                    throw new IOException("FileSystem " + this.fs + " not found");
                }
            }
            DataFolder dataFolder = DataFolder.findFolder((FileObject)this.legacyFS.getRoot());
            return new RootFolderNode(dataFolder, dataFolder.createNodeChildren(DataFilter.ALL));
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            Object object = getField.get("fs", null);
            if (object instanceof FileSystem) {
                this.fs = ((FileSystem)object).getSystemName();
            }
            if (object instanceof String) {
                this.fs = (String)object;
            }
        }
    }
}

