/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.awt.Actions;
import org.openide.awt.JMenuPlus;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public final class FrameResidenceAction
extends CallableSystemAction
implements Presenter.Menu {
    private static final String FRAME_INSIDE = "inside";
    private static final String FRAME_OUTSIDE = "outside";
    static /* synthetic */ Class class$org$netbeans$core$actions$AttachFrameAction;
    static /* synthetic */ Class class$org$netbeans$core$actions$DetachFrameAction;

    protected String iconResource() {
        return "org/netbeans/core/resources/actions/frameResides.gif";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$core$actions$AttachFrameAction == null ? (class$org$netbeans$core$actions$AttachFrameAction = FrameResidenceAction.class$("org.netbeans.core.actions.AttachFrameAction")) : class$org$netbeans$core$actions$AttachFrameAction);
    }

    public String getName() {
        return FrameResidenceAction.getBundleString("CTL_FrameResidenceAction");
    }

    public JMenuItem getMenuPresenter() {
        return this.createMenuPresenter(false);
    }

    public JMenuItem getPopupPresenter() {
        return this.createMenuPresenter(true);
    }

    public boolean isEnabled() {
        return WindowUtils.isMdi() && WindowUtils.getActiveMode() != null;
    }

    public void performAction() {
        WindowUtils.changeActiveMode(null, "org.netbeans.core.windows.frames.InternalFrameTypeImpl");
    }

    private JMenuItem createMenuPresenter(boolean bl) {
        JMenuPlus jMenuPlus = new JMenuPlus();
        Actions.connect((JMenuItem)jMenuPlus, (SystemAction)this, (boolean)bl);
        jMenuPlus.addMenuListener(new ResidenceTypeListener());
        return jMenuPlus;
    }

    private static final String getBundleString(String string) {
        return NbBundle.getBundle((Class)(class$org$netbeans$core$actions$DetachFrameAction == null ? (class$org$netbeans$core$actions$DetachFrameAction = FrameResidenceAction.class$("org.netbeans.core.actions.DetachFrameAction")) : class$org$netbeans$core$actions$DetachFrameAction)).getString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class ResidenceTypeListener
    implements MenuListener,
    ActionListener,
    Runnable {
        private ActionEvent evt;

        private ResidenceTypeListener() {
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void menuSelected(MenuEvent menuEvent) {
            String string = WindowUtils.getActiveMode().getFrameType();
            boolean bl = "org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(string) || "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(string);
            JMenu jMenu = (JMenu)menuEvent.getSource();
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem();
            Actions.setMenuText((AbstractButton)jRadioButtonMenuItem, (String)FrameResidenceAction.getBundleString("CTL_FrameInside"), (boolean)true);
            jRadioButtonMenuItem.setActionCommand(FrameResidenceAction.FRAME_INSIDE);
            jRadioButtonMenuItem.addActionListener(this);
            jRadioButtonMenuItem.setSelected(bl);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem();
            Actions.setMenuText((AbstractButton)jRadioButtonMenuItem, (String)FrameResidenceAction.getBundleString("CTL_FrameOutside"), (boolean)true);
            jRadioButtonMenuItem.setActionCommand(FrameResidenceAction.FRAME_OUTSIDE);
            jRadioButtonMenuItem.addActionListener(this);
            jRadioButtonMenuItem.setSelected(!bl);
            jMenu.add(jRadioButtonMenuItem);
        }

        public void menuDeselected(MenuEvent menuEvent) {
            ((JMenu)menuEvent.getSource()).removeAll();
        }

        public synchronized void actionPerformed(ActionEvent actionEvent) {
            this.evt = actionEvent;
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                SwingUtilities.invokeLater(this);
            }
        }

        public synchronized void run() {
            if (this.evt == null) {
                return;
            }
            String string = null;
            ModeImpl modeImpl = WindowUtils.getActiveMode();
            if (FrameResidenceAction.FRAME_INSIDE.equals(this.evt.getActionCommand())) {
                Object object = modeImpl.getCurrentConstraints();
                if (WindowUtils.findConstrainedMode(modeImpl.getWorkspace(), object) == null) {
                    modeImpl.setConstraints(object);
                }
                string = (object = modeImpl.getConstraints()) == null || "CENTER".equals(object) ? "org.netbeans.core.windows.frames.InternalFrameTypeImpl" : "org.netbeans.core.windows.frames.DesktopFrameTypeImpl";
            } else {
                modeImpl.setCurrentConstraints(modeImpl.getConstraints());
                modeImpl.setConstraints(null);
                string = "org.netbeans.core.windows.frames.TopFrameTypeImpl";
            }
            modeImpl.setFrameType(string);
            this.evt = null;
        }
    }
}

