/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.execution;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Hashtable;
import org.netbeans.core.execution.AccController;
import org.netbeans.core.execution.ExecutionSettings;
import org.netbeans.core.execution.IOPermissionCollection;
import org.netbeans.core.execution.IOThreadIfc;
import org.netbeans.core.execution.TaskIO;
import org.openide.TopManager;
import org.openide.util.SharedClassObject;
import org.openide.windows.InputOutput;
import org.openide.windows.TopComponent;

final class IOTable
extends Hashtable {
    static final long serialVersionUID = 9096333712401558521L;
    private ThreadGroup base;
    private TaskIO systemIO;
    private HashMap freeTaskIOs;
    private ExecutionSettings options;
    private boolean searchingIO = false;
    static /* synthetic */ Class class$org$netbeans$core$execution$ExecutionSettings;

    public IOTable(ThreadGroup threadGroup, TaskIO taskIO) {
        this.base = threadGroup;
        this.systemIO = taskIO;
        this.freeTaskIOs = new HashMap(11);
    }

    ThreadGroup findGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        ThreadGroup threadGroup2 = null;
        while (threadGroup != null && threadGroup != this.base) {
            threadGroup2 = threadGroup;
            threadGroup = threadGroup.getParent();
        }
        return threadGroup == null ? null : threadGroup2;
    }

    private synchronized TaskIO getIO() {
        TaskIO taskIO;
        String string;
        if (this.searchingIO) {
            return this.systemIO;
        }
        InputOutput inputOutput = null;
        if (Thread.currentThread() instanceof IOThreadIfc) {
            inputOutput = ((IOThreadIfc)((Object)Thread.currentThread())).getInputOutput();
        }
        IOPermissionCollection iOPermissionCollection = null;
        if (inputOutput == null) {
            try {
                this.searchingIO = true;
                iOPermissionCollection = AccController.getIOPermissionCollection();
                string = null;
                this.searchingIO = false;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.searchingIO = false;
                throw throwable;
            }
            if (iOPermissionCollection == null) {
                return this.systemIO;
            }
            inputOutput = iOPermissionCollection.getIO();
        }
        if ((taskIO = (TaskIO)this.get(inputOutput)) == null) {
            if (inputOutput instanceof TopComponent) {
                string = ((TopComponent)inputOutput).getName();
                taskIO = this.getTaskIO(string);
                if (taskIO == null) {
                    inputOutput = TopManager.getDefault().getIO(string);
                    taskIO = new TaskIO(inputOutput, string);
                } else {
                    inputOutput = taskIO.getInout();
                }
                inputOutput.select();
                inputOutput.setFocusTaken(true);
                if (iOPermissionCollection != null) {
                    iOPermissionCollection.setIO(inputOutput);
                }
                this.put(inputOutput, taskIO);
            } else {
                return new TaskIO(inputOutput);
            }
        }
        return taskIO;
    }

    synchronized TaskIO getTaskIO(String string) {
        TaskIO taskIO;
        if (this.reuseTaskIO() && (taskIO = this.getFreeTaskIO(string)) != null) {
            return taskIO;
        }
        return null;
    }

    private boolean reuseTaskIO() {
        int n = this.getOptions().getTabHandler();
        this.getOptions();
        return n > 0;
    }

    private boolean clearTaskIO() {
        int n = this.getOptions().getTabHandler();
        this.getOptions();
        return (n & 2) != 0;
    }

    private TaskIO getFreeTaskIO(String string) {
        TaskIO taskIO = (TaskIO)this.freeTaskIOs.get(string);
        if (taskIO == null) {
            return null;
        }
        if (this.clearTaskIO()) {
            try {
                taskIO.getInout().getOut().reset();
                taskIO.getInout().getErr().reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        taskIO.in = null;
        taskIO.getInout().flushReader();
        this.freeTaskIOs.remove(string);
        return taskIO;
    }

    synchronized void free(ThreadGroup threadGroup, InputOutput inputOutput) {
        TaskIO taskIO = (TaskIO)this.get(inputOutput);
        if (taskIO == null) {
            return;
        }
        if (taskIO.foreign) {
            return;
        }
        if (taskIO.getName() != "noname" && (taskIO = this.freeTaskIOs.put(taskIO.getName(), taskIO)) != null) {
            taskIO.getInout().closeInputOutput();
        }
        this.remove(inputOutput);
    }

    public Reader getIn() {
        TaskIO taskIO = this.getIO();
        if (taskIO.in == null) {
            taskIO.initIn();
        }
        return taskIO.in;
    }

    public Writer getOut() {
        TaskIO taskIO = this.getIO();
        if (taskIO.out == null) {
            taskIO.initOut();
        }
        return taskIO.out;
    }

    public Writer getErr() {
        TaskIO taskIO = this.getIO();
        if (taskIO.err == null) {
            taskIO.initErr();
        }
        return taskIO.err;
    }

    private ExecutionSettings getOptions() {
        if (this.options == null) {
            this.options = (ExecutionSettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$execution$ExecutionSettings == null ? (class$org$netbeans$core$execution$ExecutionSettings = IOTable.class$("org.netbeans.core.execution.ExecutionSettings")) : class$org$netbeans$core$execution$ExecutionSettings), (boolean)true);
        }
        return this.options;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

