/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.util.enum.ArrayEnumeration;
import org.openide.util.enum.EmptyEnumeration;
import org.openide.util.enum.SequenceEnumeration;

public class ProxyClassLoader
extends ClassLoader {
    private final Map domainsByPackage = new HashMap();
    private HashMap packages = new HashMap();
    private ClassLoader[] parents;
    private boolean dead = false;
    static /* synthetic */ Class class$org$netbeans$core$modules$ProxyClassLoader;

    public ProxyClassLoader(ClassLoader[] classLoaderArray) {
        HashSet<ClassLoader> hashSet;
        if (classLoaderArray.length == 0) {
            classLoaderArray = new ClassLoader[]{(class$org$netbeans$core$modules$ProxyClassLoader == null ? (class$org$netbeans$core$modules$ProxyClassLoader = ProxyClassLoader.class$("org.netbeans.core.modules.ProxyClassLoader")) : class$org$netbeans$core$modules$ProxyClassLoader).getClassLoader()};
        }
        if ((hashSet = new HashSet<ClassLoader>(Arrays.asList(classLoaderArray))).size() < classLoaderArray.length) {
            throw new IllegalArgumentException("duplicate parents");
        }
        if (hashSet.contains(null)) {
            throw new IllegalArgumentException("null parent");
        }
        this.parents = this.coalesceParents(classLoaderArray);
    }

    public synchronized void append(ClassLoader[] classLoaderArray) throws IllegalArgumentException {
        if (classLoaderArray == null) {
            throw new IllegalArgumentException("null parents array");
        }
        int n = 0;
        while (n < classLoaderArray.length) {
            if (classLoaderArray[n] == null) {
                throw new IllegalArgumentException("null parent");
            }
            ++n;
        }
        this.parents = this.coalesceAppend(this.parents, classLoaderArray);
    }

    public void destroy() {
        this.dead = true;
    }

    private void zombieCheck(String string) {
        if (this.dead) {
            IllegalStateException illegalStateException = new IllegalStateException("WARNING - attempting to use a zombie classloader " + this + " on " + string + ". This means classes from a disabled module are still active. May or may not be a problem.");
            ErrorManager.getDefault().notify(1, (Throwable)illegalStateException);
            this.dead = false;
        }
    }

    protected final synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        this.zombieCheck(string);
        String string2 = string.replace('.', '/').concat(".class");
        int n = string2.lastIndexOf(47);
        if (n == -1) {
            throw new ClassNotFoundException("Will not load classes from default package");
        }
        String string3 = string2.substring(0, n + 1);
        Class clazz = this.smartLoadClass(string, string2, string3);
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected Class simpleFindClass(String string, String string2) {
        return null;
    }

    public final URL getResource(String string) {
        this.zombieCheck(string);
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n + 1);
        if (this.isSpecialResource(string2)) {
            int n2 = 0;
            while (n2 < this.parents.length) {
                URL uRL;
                if (this.shouldDelegateResource(string2, this.parents[n2]) && (uRL = this.parents[n2] instanceof ProxyClassLoader ? ((ProxyClassLoader)this.parents[n2]).findResource(string) : this.parents[n2].getResource(string)) != null) {
                    return uRL;
                }
                ++n2;
            }
            return this.findResource(string);
        }
        ClassLoader classLoader = (ClassLoader)this.domainsByPackage.get(string2);
        if (classLoader != null) {
            if (classLoader instanceof ProxyClassLoader) {
                return ((ProxyClassLoader)classLoader).findResource(string);
            }
            return classLoader.getResource(string);
        }
        URL uRL = null;
        int n3 = 0;
        while (n3 < this.parents.length) {
            classLoader = this.parents[n3];
            if (this.shouldDelegateResource(string2, classLoader) && (uRL = classLoader instanceof ProxyClassLoader ? ((ProxyClassLoader)classLoader).findResource(string) : classLoader.getResource(string)) != null) {
                this.domainsByPackage.put(string2, classLoader);
                return uRL;
            }
            ++n3;
        }
        uRL = this.findResource(string);
        if (uRL != null) {
            this.domainsByPackage.put(string2, this);
        }
        return uRL;
    }

    protected URL findResource(String string) {
        return null;
    }

    protected final synchronized Enumeration findResources(String string) throws IOException {
        this.zombieCheck(string);
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return EmptyEnumeration.EMPTY;
        }
        String string2 = string.substring(0, n + 1);
        Object[] objectArray = new Enumeration[this.parents.length + 1];
        int n2 = 0;
        while (n2 < this.parents.length) {
            objectArray[n2] = !this.shouldDelegateResource(string2, this.parents[n2]) ? EmptyEnumeration.EMPTY : (this.parents[n2] instanceof ProxyClassLoader ? ((ProxyClassLoader)this.parents[n2]).simpleFindResources(string) : this.parents[n2].getResources(string));
            ++n2;
        }
        objectArray[this.parents.length] = this.simpleFindResources(string);
        return new SequenceEnumeration((Enumeration)new ArrayEnumeration(objectArray));
    }

    protected Enumeration simpleFindResources(String string) throws IOException {
        return super.findResources(string);
    }

    protected Package getPackage(String string) {
        this.zombieCheck(string);
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n + 1).replace('.', '/');
        HashMap hashMap = this.packages;
        synchronized (hashMap) {
            Object object;
            Package package_ = (Package)this.packages.get(string);
            if (package_ != null) {
                Package package_2 = package_;
                return package_2;
            }
            int n2 = 0;
            while (n2 < this.parents.length) {
                object = this.parents[n2];
                if (object instanceof ProxyClassLoader && this.shouldDelegateResource(string2, (ClassLoader)object) && (package_ = ((ProxyClassLoader)object).getPackage(string)) != null) break;
                ++n2;
            }
            if (package_ == null) {
                package_ = super.getPackage(string);
            }
            if (package_ != null) {
                this.packages.put(string, package_);
            }
            object = package_;
            return object;
        }
    }

    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) throws IllegalArgumentException {
        HashMap hashMap = this.packages;
        synchronized (hashMap) {
            Package package_ = super.definePackage(string, string2, string3, string4, string5, string6, string7, uRL);
            return package_;
        }
    }

    protected synchronized Package[] getPackages() {
        Object object;
        this.zombieCheck(null);
        HashMap hashMap = new HashMap();
        this.addPackages(hashMap, super.getPackages());
        int n = 0;
        while (n < this.parents.length) {
            object = this.parents[n];
            if (object instanceof ProxyClassLoader) {
                this.addPackages(hashMap, ((ProxyClassLoader)object).getPackages());
            }
            ++n;
        }
        object = this.packages;
        synchronized (object) {
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                if (this.packages.containsKey(k)) continue;
                this.packages.put(k, entry.getValue());
            }
        }
        return hashMap.values().toArray(new Package[hashMap.size()]);
    }

    public Package getPackageAccessibly(String string) {
        return this.getPackage(string);
    }

    public Package[] getPackagesAccessibly() {
        return this.getPackages();
    }

    private ClassLoader[] coalesceParents(ClassLoader[] classLoaderArray) throws IllegalArgumentException {
        int n = classLoaderArray.length * 3 + 1;
        HashSet hashSet = new HashSet(n);
        ArrayList arrayList = new ArrayList(n);
        int n2 = 0;
        while (n2 < classLoaderArray.length) {
            this.addRec(hashSet, arrayList, classLoaderArray[n2]);
            ++n2;
        }
        ClassLoader[] classLoaderArray2 = arrayList.toArray(new ClassLoader[arrayList.size()]);
        return classLoaderArray2;
    }

    private ClassLoader[] coalesceAppend(ClassLoader[] classLoaderArray, ClassLoader[] classLoaderArray2) throws IllegalArgumentException {
        int n = classLoaderArray.length + 3;
        HashSet<ClassLoader> hashSet = new HashSet<ClassLoader>(n);
        List<ClassLoader> list = Arrays.asList(classLoaderArray);
        hashSet.addAll(list);
        if (hashSet.containsAll(Arrays.asList(classLoaderArray2))) {
            return classLoaderArray;
        }
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>(n);
        arrayList.addAll(list);
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < classLoaderArray2.length) {
            this.addRec(hashSet, arrayList, classLoaderArray2[n3]);
            ++n3;
        }
        ClassLoader[] classLoaderArray3 = arrayList.toArray(new ClassLoader[arrayList.size()]);
        return classLoaderArray3;
    }

    private void addRec(Set set, List list, ClassLoader classLoader) throws IllegalArgumentException {
        if (classLoader == this) {
            throw new IllegalArgumentException("cycle in parents");
        }
        if (set.contains(classLoader)) {
            return;
        }
        if (classLoader instanceof ProxyClassLoader) {
            ClassLoader[] classLoaderArray = ((ProxyClassLoader)classLoader).parents;
            int n = 0;
            while (n < classLoaderArray.length) {
                this.addRec(set, list, classLoaderArray[n]);
                ++n;
            }
        }
        set.add(classLoader);
        list.add(classLoader);
    }

    private final Class smartLoadClass(String string, String string2, String string3) throws ClassNotFoundException {
        ClassLoader classLoader;
        Class clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader classLoader2 = classLoader = this.isSpecialResource(string3) ? null : (ClassLoader)this.domainsByPackage.get(string3);
        if (classLoader == this) {
            return this.simpleFindClass(string, string2);
        }
        if (classLoader != null) {
            if (classLoader instanceof ProxyClassLoader) {
                return ((ProxyClassLoader)classLoader).fullFindClass(string, string2);
            }
            return classLoader.loadClass(string);
        }
        clazz = this.loadInOrder(string, string2, string3);
        if (clazz != null) {
            ClassLoader classLoader3 = clazz.getClassLoader();
            this.domainsByPackage.put(string3, classLoader3);
        }
        return clazz;
    }

    private final Class loadInOrder(String string, String string2, String string3) throws ClassNotFoundException {
        Object object;
        ClassNotFoundException classNotFoundException = null;
        int n = 0;
        while (n < this.parents.length) {
            object = this.parents[n];
            if (this.shouldDelegateResource(string3, (ClassLoader)object)) {
                if (object instanceof ProxyClassLoader) {
                    Class clazz = ((ProxyClassLoader)object).fullFindClass(string, string2);
                    if (clazz != null) {
                        return clazz;
                    }
                } else {
                    try {
                        return ((ClassLoader)object).loadClass(string);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        classNotFoundException = classNotFoundException2;
                    }
                }
            }
            ++n;
        }
        object = this.simpleFindClass(string, string2);
        if (object != null) {
            return object;
        }
        if (classNotFoundException != null) {
            throw classNotFoundException;
        }
        return null;
    }

    private synchronized Class fullFindClass(String string, String string2) {
        Class clazz = this.findLoadedClass(string);
        return clazz == null ? this.simpleFindClass(string, string2) : clazz;
    }

    private void addPackages(Map map, Package[] packageArray) {
        int n = 0;
        while (n < packageArray.length) {
            map.put(packageArray[n].getName(), packageArray[n]);
            ++n;
        }
    }

    protected boolean isSpecialResource(String string) {
        return string.startsWith("META-INF/");
    }

    protected boolean shouldDelegateResource(String string, ClassLoader classLoader) {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

