/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import org.netbeans.core.projects.cache.LayerCacheManager;
import org.netbeans.core.projects.cache.ParsingLayerCacheManager;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.XMLFileSystem;
import org.openide.xml.XMLUtil;
import org.xml.sax.SAXException;

public class XMLLayerCacheManagerImpl
extends ParsingLayerCacheManager {
    private static final String ALL_LAYERS = "all-layers.xml";
    private final File cacheFile;
    private static final String SPACES = "                                                                                        ";
    private static final int SPACES_LENGTH = "                                                                                        ".length();
    private static final int INDENT = 4;

    public XMLLayerCacheManagerImpl(File file) throws IOException {
        super(file);
        this.cacheFile = new File(file, ALL_LAYERS);
    }

    public boolean cacheExists() {
        return this.cacheFile.exists();
    }

    public void cleanupCache() throws IOException {
        if (this.cacheFile.exists() && !this.cacheFile.delete()) {
            throw new IOException("Could not delete: " + this.cacheFile);
        }
    }

    public FileSystem createEmptyFileSystem() throws IOException {
        return new XMLFileSystem();
    }

    public FileSystem createLoadedFileSystem() throws IOException {
        if (this.cacheFile.exists()) {
            try {
                return new XMLFileSystem(this.cacheFile.toURL());
            }
            catch (SAXException sAXException) {
                IOException iOException = new IOException(sAXException.toString());
                LayerCacheManager.err.annotate((Throwable)iOException, (Throwable)sAXException);
                throw iOException;
            }
        }
        return new XMLFileSystem();
    }

    public void load(FileSystem fileSystem) throws IOException {
        try {
            ((XMLFileSystem)fileSystem).setXmlUrl(this.cacheFile.toURL());
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.toString());
            LayerCacheManager.err.annotate((Throwable)iOException, (Throwable)exception);
            throw iOException;
        }
    }

    protected boolean openURLs() {
        return false;
    }

    protected void store(FileSystem fileSystem, ParsingLayerCacheManager.MemFolder memFolder) throws IOException {
        if (this.cacheFile.exists()) {
            this.cacheFile.delete();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.cacheFile);
        try {
            XMLLayerCacheManagerImpl.writeOut(memFolder, fileOutputStream, Boolean.getBoolean("netbeans.cache.layers.prettyprint"), this.getCacheDirectory());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
        this.load(fileSystem);
    }

    private static void writeOut(ParsingLayerCacheManager.MemFolder memFolder, OutputStream outputStream, boolean bl, File file) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        outputStreamWriter.write("<!DOCTYPE filesystem PUBLIC \"-//NetBeans//DTD Filesystem 1.1//EN\" \"http://www.netbeans.org/dtds/filesystem-1_1.dtd\">\n");
        outputStreamWriter.write("<!-- Module layer cache generated by NetBeans. Do not edit. -->\n");
        outputStreamWriter.write("<filesystem");
        if (XMLLayerCacheManagerImpl.writeAttrs(outputStreamWriter, memFolder.attrs, 1, bl)) {
            outputStreamWriter.write(">");
            if (bl) {
                ((Writer)outputStreamWriter).write(10);
            }
        }
        XMLLayerCacheManagerImpl.writeFolder(outputStreamWriter, memFolder, 1, bl, file);
        outputStreamWriter.write("</filesystem>\n");
        ((Writer)outputStreamWriter).close();
    }

    private static String space(int n) {
        int n2 = n * 4;
        if (n2 <= SPACES_LENGTH) {
            return SPACES.substring(0, n2);
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(' ');
            ++n3;
        }
        return stringBuffer.toString();
    }

    private static void writeFolder(Writer writer, ParsingLayerCacheManager.MemFolder memFolder, int n, boolean bl, File file) throws IOException {
        if (memFolder.children == null) {
            return;
        }
        Iterator iterator = memFolder.children.iterator();
        while (iterator.hasNext()) {
            String string;
            ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder = (ParsingLayerCacheManager.MemFileOrFolder)iterator.next();
            if (memFileOrFolder instanceof ParsingLayerCacheManager.MemFolder) {
                if (bl) {
                    writer.write(XMLLayerCacheManagerImpl.space(n));
                }
                writer.write("<folder name=\"");
                writer.write(XMLUtil.toAttributeValue((String)memFileOrFolder.name));
                writer.write(34);
                if (XMLLayerCacheManagerImpl.writeAttrs(writer, memFileOrFolder.attrs, n + 1, bl)) {
                    writer.write(62);
                    if (bl) {
                        writer.write(10);
                    }
                }
                XMLLayerCacheManagerImpl.writeFolder(writer, (ParsingLayerCacheManager.MemFolder)memFileOrFolder, n + 1, bl, file);
                if (bl) {
                    writer.write(XMLLayerCacheManagerImpl.space(n));
                }
                writer.write("</folder>");
                if (!bl) continue;
                writer.write(10);
                continue;
            }
            ParsingLayerCacheManager.MemFile memFile = (ParsingLayerCacheManager.MemFile)memFileOrFolder;
            if (bl) {
                writer.write(XMLLayerCacheManagerImpl.space(n));
            }
            writer.write("<file name=\"");
            writer.write(XMLUtil.toAttributeValue((String)memFileOrFolder.name));
            String string2 = string = memFile.ref != null ? memFile.ref.toExternalForm() : null;
            if (memFile.contents != null) {
                if (string != null) {
                    throw new IOException("url attr and contents too: url=" + string + " content=" + new String(memFile.contents) + " file name=" + memFileOrFolder.name);
                }
                CRC32 cRC32 = new CRC32();
                cRC32.update(memFile.contents);
                String string3 = Long.toHexString(cRC32.getValue());
                while (string3.length() < 8) {
                    string3 = "0" + string3;
                }
                File file2 = new File(file, "data_" + string3);
                string = file2.toURL().toString();
                if (!file2.isFile()) {
                    Object var14_13;
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    try {
                        ((OutputStream)fileOutputStream).write(memFile.contents);
                        var14_13 = null;
                    }
                    catch (Throwable throwable) {
                        var14_13 = null;
                        ((OutputStream)fileOutputStream).close();
                        throw throwable;
                    }
                    ((OutputStream)fileOutputStream).close();
                    {
                    }
                }
            }
            if (string != null) {
                writer.write("\" url=\"");
                writer.write(XMLUtil.toAttributeValue((String)string));
            }
            writer.write(34);
            if (XMLLayerCacheManagerImpl.writeAttrs(writer, memFileOrFolder.attrs, n + 1, bl)) {
                writer.write("/>");
                if (!bl) continue;
                writer.write(10);
                continue;
            }
            if (bl) {
                writer.write(XMLLayerCacheManagerImpl.space(n));
            }
            writer.write("</file>");
            if (!bl) continue;
            writer.write(10);
        }
    }

    private static boolean writeAttrs(Writer writer, List list, int n, boolean bl) throws IOException {
        if (list == null) {
            return true;
        }
        Iterator iterator = list.iterator();
        if (!iterator.hasNext()) {
            return true;
        }
        writer.write(62);
        if (bl) {
            writer.write(10);
        }
        while (iterator.hasNext()) {
            ParsingLayerCacheManager.MemAttr memAttr = (ParsingLayerCacheManager.MemAttr)iterator.next();
            if (bl) {
                writer.write(XMLLayerCacheManagerImpl.space(n));
            }
            writer.write("<attr name=\"");
            writer.write(XMLUtil.toAttributeValue((String)memAttr.name));
            writer.write("\" ");
            writer.write(memAttr.type);
            writer.write("=\"");
            writer.write(XMLUtil.toAttributeValue((String)memAttr.data));
            writer.write("\"/>");
            if (!bl) continue;
            writer.write(10);
        }
        return false;
    }
}

