/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.EventQueue;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.StateManager;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.windows.WindowManager;

public class DeferredPerformer
implements StateManager.StateListener {
    static final int NOT_INITIALIZED = 0;
    static final int READY = 1;
    static final int DEFERRED = 2;
    int state = 0;
    ArrayList requests;
    StateManager stateManager;
    private int processes = 0;
    private Object LOCK = new Object();

    DeferredPerformer() {
    }

    public void putRequest(DeferredCommand deferredCommand, Object object) {
        this.putRequest(deferredCommand, new DeferredContext(object, false));
    }

    public void putRequest(DeferredCommand deferredCommand, DeferredContext deferredContext) {
        if (deferredContext == null) {
            deferredContext = new DeferredContext(null, false);
        }
        DeferredPerformer deferredPerformer = this;
        synchronized (deferredPerformer) {
            if (this.state == 0) {
                this.initialize();
            }
            if (this.state == 2) {
                DeferredEntry deferredEntry = new DeferredEntry();
                deferredEntry.command = deferredCommand;
                deferredEntry.context = deferredContext;
                this.requests.add(deferredEntry);
                return;
            }
        }
        this.processCommand(deferredCommand, deferredContext);
    }

    public boolean removeRequest(DeferredCommand deferredCommand) {
        DeferredEntry deferredEntry = null;
        DeferredPerformer deferredPerformer = this;
        synchronized (deferredPerformer) {
            Iterator iterator = ((AbstractList)this.requests).iterator();
            while (iterator.hasNext()) {
                deferredEntry = (DeferredEntry)iterator.next();
                if (!deferredEntry.command.equals(deferredCommand)) continue;
                ((AbstractCollection)this.requests).remove(deferredEntry);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public boolean canImmediatelly() {
        return this.state == 1;
    }

    public boolean isProcessing() {
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = this.processes != 0;
            return bl;
        }
    }

    private void incProcesses() {
        Object object = this.LOCK;
        synchronized (object) {
            ++this.processes;
        }
    }

    private void decProcesses() {
        Object object = this.LOCK;
        synchronized (object) {
            --this.processes;
        }
    }

    private void initialize() {
        this.requests = new ArrayList(40);
        WindowManagerImpl cfr_ignored_0 = (WindowManagerImpl)WindowManager.getDefault();
        this.stateManager = WindowManagerImpl.stateManager();
        this.updateState();
        this.stateManager.addStateListener(this);
    }

    public void stateChanged(int n) {
        int n2;
        DeferredEntry[] deferredEntryArray = null;
        DeferredPerformer deferredPerformer = this;
        synchronized (deferredPerformer) {
            n2 = this.state;
            this.updateState();
            if (this.state != n2 && this.state == 1) {
                deferredEntryArray = this.requests.toArray(new DeferredEntry[0]);
                this.requests.clear();
            }
        }
        if (deferredEntryArray != null) {
            n2 = 0;
            while (n2 < deferredEntryArray.length) {
                this.processCommand(deferredEntryArray[n2].command, deferredEntryArray[n2].context);
                ++n2;
            }
        }
    }

    private void updateState() {
        int n = this.stateManager.getState();
        this.state = ((n & 1) != 0 || (n & 4) != 0) && (n & 0x120) != 0 ? 1 : 2;
    }

    private void processCommand(final DeferredCommand deferredCommand, final DeferredContext deferredContext) {
        if (deferredContext.isRunInEventThread() && !EventQueue.isDispatchThread()) {
            this.incProcesses();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        deferredCommand.performCommand(deferredContext);
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        DeferredPerformer.this.decProcesses();
                        throw throwable;
                    }
                    DeferredPerformer.this.decProcesses();
                }
            });
        } else {
            deferredCommand.performCommand(deferredContext);
        }
    }

    private static final class DeferredEntry {
        DeferredCommand command;
        DeferredContext context;

        private DeferredEntry() {
        }
    }

    public static class DeferredContext {
        private Object data;
        private boolean runInEventThread;

        public DeferredContext(Object object, boolean bl) {
            this.data = object;
            this.runInEventThread = bl;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object object) {
            this.data = object;
        }

        public boolean isRunInEventThread() {
            return this.runInEventThread;
        }

        public void setRunInEventThread(boolean bl) {
            this.runInEventThread = bl;
        }
    }

    public static interface DeferredCommand {
        public void performCommand(DeferredContext var1);
    }
}

