/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.windows.SelectedNodesChangedEvent;
import org.netbeans.core.windows.StateManager;
import org.netbeans.core.windows.TopComponentChangedEvent;
import org.netbeans.core.windows.TopComponentListener;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerActions;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class RegistryImpl
implements TopComponent.Registry,
TopComponentListener,
StateManager.StateListener,
PropertyChangeListener {
    private TopComponent activatedTopComponent;
    private HashSet openSet;
    private Node[] current;
    private Node[] activated;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private StateManager stateManager;
    private WeakSet allSet;
    private ExplorerManager currentManager;
    private static final Method explorerActionsGetAttachedManager = RegistryImpl.findMethod(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = RegistryImpl.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions, "getAttachedManager");
    private static final Method explorerPanelGetActions = RegistryImpl.findMethod(class$org$openide$explorer$ExplorerPanel == null ? (class$org$openide$explorer$ExplorerPanel = RegistryImpl.class$("org.openide.explorer.ExplorerPanel")) : class$org$openide$explorer$ExplorerPanel, "getActions");
    static /* synthetic */ Class class$org$openide$explorer$ExplorerActions;
    static /* synthetic */ Class class$org$openide$explorer$ExplorerPanel;

    private static Method findMethod(Class clazz, String string) {
        try {
            Method method = clazz.getDeclaredMethod(string, new Class[0]);
            ((AccessibleObject)method).setAccessible(true);
            return method;
        }
        catch (Exception exception) {
            RegistryImpl.notifyQuiet(exception);
            return null;
        }
    }

    private static void notifyQuiet(Throwable throwable) {
        ErrorManager.getDefault().notify(1, throwable);
    }

    public RegistryImpl() {
        this.openSet = new HashSet(30);
        this.activated = new Node[0];
    }

    public synchronized Set getOpened() {
        return Collections.unmodifiableSet(this.openSet);
    }

    public TopComponent getActivated() {
        return this.activatedTopComponent;
    }

    public Node[] getCurrentNodes() {
        ExplorerManager explorerManager = this.currentManager;
        if (explorerManager != null) {
            return explorerManager.getSelectedNodes();
        }
        if (this.activatedTopComponent == null) {
            return NbTopManager.get().getDefaultNodes(false);
        }
        return this.current;
    }

    public Node[] getActivatedNodes() {
        ExplorerManager explorerManager = this.currentManager;
        if (explorerManager != null) {
            return explorerManager.getSelectedNodes();
        }
        if (this.activatedTopComponent == null) {
            return NbTopManager.get().getDefaultNodes(true);
        }
        return this.activated;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void attachExplorer(Runnable runnable, ExplorerManager explorerManager) {
        RegistryImpl registryImpl2;
        ExplorerManager explorerManager2 = this.currentManager;
        if (explorerManager2 != null) {
            explorerManager2.removePropertyChangeListener((PropertyChangeListener)this);
        }
        RegistryImpl registryImpl = this;
        synchronized (registryImpl) {
            this.currentManager = explorerManager;
            explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
            this.support.firePropertyChange("currentNodes", null, explorerManager.getSelectedNodes());
            this.support.firePropertyChange("activatedNodes", null, explorerManager.getSelectedNodes());
        }
        ExplorerActions explorerActions = null;
        ExplorerManager explorerManager3 = null;
        boolean bl = false;
        try {
            explorerActions = (ExplorerActions)explorerPanelGetActions.invoke(null, new Object[0]);
            explorerManager3 = (ExplorerManager)explorerActionsGetAttachedManager.invoke((Object)explorerActions, new Object[0]);
            bl = true;
        }
        catch (IllegalAccessException illegalAccessException) {
            RegistryImpl.notifyQuiet(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RegistryImpl.notifyQuiet(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            RegistryImpl.notifyQuiet(invocationTargetException);
        }
        if (bl) {
            explorerActions.attach(explorerManager);
        }
        try {
            runnable.run();
            Object var12_12 = null;
            registryImpl2 = this;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            RegistryImpl registryImpl3 = this;
            synchronized (registryImpl3) {
                explorerManager.removePropertyChangeListener((PropertyChangeListener)this);
                this.currentManager = explorerManager2;
                if (explorerManager2 != null) {
                    explorerManager2.addPropertyChangeListener((PropertyChangeListener)this);
                    this.support.firePropertyChange("currentNodes", null, explorerManager2.getSelectedNodes());
                    this.support.firePropertyChange("activatedNodes", null, explorerManager2.getSelectedNodes());
                }
            }
            if (!bl) throw throwable;
            if (explorerManager3 != null) {
                explorerActions.attach(explorerManager3);
                throw throwable;
            } else {
                explorerActions.detach();
            }
            throw throwable;
        }
        synchronized (registryImpl2) {
            explorerManager.removePropertyChangeListener((PropertyChangeListener)this);
            this.currentManager = explorerManager2;
            if (explorerManager2 != null) {
                explorerManager2.addPropertyChangeListener((PropertyChangeListener)this);
                this.support.firePropertyChange("currentNodes", null, explorerManager2.getSelectedNodes());
                this.support.firePropertyChange("activatedNodes", null, explorerManager2.getSelectedNodes());
            }
        }
        if (!bl) return;
        if (explorerManager3 != null) {
            explorerActions.attach(explorerManager3);
            return;
        }
        explorerActions.detach();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void topComponentActivated(TopComponentChangedEvent topComponentChangedEvent) {
        TopComponent topComponent = this.activatedTopComponent;
        this.activatedTopComponent = topComponentChangedEvent.topComponent;
        Window window = topComponentChangedEvent.topComponent == null ? null : SwingUtilities.windowForComponent((Component)topComponentChangedEvent.topComponent);
        RegistryImpl.cancelMenu(window);
        if (topComponent == this.activatedTopComponent) {
            return;
        }
        this.support.firePropertyChange("activated", topComponent, this.activatedTopComponent);
        if (topComponent == null && this.activatedTopComponent != null) {
            this.support.firePropertyChange("activatedNodes", new Node[0], this.activated);
        } else if (topComponent != null && this.activatedTopComponent == null) {
            this.support.firePropertyChange("activatedNodes", this.activated, new Node[0]);
        }
    }

    public synchronized void topComponentOpened(TopComponentChangedEvent topComponentChangedEvent) {
        if (this.openSet.contains(topComponentChangedEvent.topComponent)) {
            return;
        }
        Set set = (Set)this.openSet.clone();
        this.openSet.add(topComponentChangedEvent.topComponent);
        this.support.firePropertyChange("opened", set, this.openSet);
    }

    public synchronized void topComponentClosed(TopComponentChangedEvent topComponentChangedEvent) {
        if (!this.openSet.contains(topComponentChangedEvent.topComponent)) {
            return;
        }
        WindowManagerImpl windowManagerImpl = (WindowManagerImpl)WindowManager.getDefault();
        Workspace[] workspaceArray = windowManagerImpl.getWorkspaces();
        int n = 0;
        while (n < workspaceArray.length) {
            if (WindowManagerImpl.findManager(topComponentChangedEvent.topComponent).isOpened(workspaceArray[n])) {
                return;
            }
            ++n;
        }
        Set set = (Set)this.openSet.clone();
        this.openSet.remove(topComponentChangedEvent.topComponent);
        this.support.firePropertyChange("opened", set, this.openSet);
    }

    public void selectedNodesChanged(SelectedNodesChangedEvent selectedNodesChangedEvent) {
        Object[] objectArray = this.current;
        Object[] objectArray2 = selectedNodesChangedEvent.getSelectedNodes();
        if (this.activatedTopComponent != null && !this.activatedTopComponent.equals(selectedNodesChangedEvent.topComponent)) {
            return;
        }
        if (Arrays.equals(objectArray, objectArray2)) {
            return;
        }
        if (this.stateManager == null) {
            WindowManagerImpl cfr_ignored_0 = (WindowManagerImpl)WindowManager.getDefault();
            this.stateManager = WindowManagerImpl.stateManager();
            this.stateManager.addStateListener(this);
        }
        this.current = objectArray2 == null ? null : (Node[])objectArray2.clone();
        this.tryFireChanges(this.stateManager.getState(), (Node[])objectArray, this.current);
    }

    public void stateChanged(int n) {
        this.tryFireChanges(n, null, this.current);
    }

    static void cancelMenu(Window window) {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        int n = 0;
        while (n < menuElementArray.length) {
            Window window2 = SwingUtilities.windowForComponent(menuElementArray[n].getComponent());
            if (window2 != null && (window2 == window || window2.getOwner() == window)) {
                return;
            }
            ++n;
        }
        menuSelectionManager.clearSelectedPath();
    }

    private void tryFireChanges(int n, Node[] nodeArray, Node[] nodeArray2) {
        if (n == 33) {
            this.support.firePropertyChange("currentNodes", nodeArray, nodeArray2);
            if (nodeArray2 != null) {
                nodeArray = this.activated;
                this.activated = nodeArray2;
                this.support.firePropertyChange("activatedNodes", nodeArray, this.activated);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            this.support.firePropertyChange("currentNodes", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            this.support.firePropertyChange("activatedNodes", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

