/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.frames;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.ui.ArrowsTabbedPaneUI;
import org.netbeans.core.ui.PopupTabbedPaneUI;
import org.netbeans.core.windows.JdkBug4620540Hack;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.windows.TopComponent;

final class CloseButtonTabbedPane
extends JTabbedPane
implements ChangeListener {
    public static final int UI_TYPE_NORMAL = 0;
    public static final int UI_TYPE_ARROWS = 1;
    public static final int UI_TYPE_POPUP = 2;
    private int uiType = 0;
    public static final boolean CLOSE_BUTTON_ENABLED;
    public static final String TAB_NAME_TRAILING_SPACE;
    private static Image closeTabImage;
    private static Image closeTabInactiveImage;
    private int pressedCloseButtonIndex = -1;
    private int mouseOverCloseButtonIndex = -1;
    private boolean draggedOut = false;
    static /* synthetic */ Class class$org$netbeans$core$windows$frames$CloseButtonTabbedPane;

    CloseButtonTabbedPane() {
        if (CLOSE_BUTTON_ENABLED) {
            this.addChangeListener(this);
            CloseButtonListener.install();
        }
    }

    void setUIType(int n) {
        this.uiType = n;
    }

    public void updateUI() {
        if (this.uiType == 0) {
            super.updateUI();
        } else if (this.uiType == 1) {
            this.setUI(new ArrowsTabbedPaneUI());
        } else if (this.uiType == 2) {
            this.setUI(new PopupTabbedPaneUI());
        } else {
            throw new IllegalStateException("Unknown uiType " + this.uiType + " in " + this);
        }
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.reset();
    }

    private void reset() {
        this.setMouseOverCloseButtonIndex(-1);
        this.setPressedCloseButtonIndex(-1);
        this.draggedOut = false;
    }

    private Rectangle getCloseButtonBoundsAt(int n) {
        Rectangle rectangle = this.getBoundsAt(n);
        if (rectangle == null) {
            return null;
        }
        rectangle = new Rectangle(rectangle);
        JdkBug4620540Hack.fixGetBoundsAt(rectangle);
        Dimension dimension = this.getSize();
        if (rectangle.x + rectangle.width >= dimension.width || rectangle.y + rectangle.height >= dimension.height) {
            return null;
        }
        return new Rectangle(rectangle.x + rectangle.width - 13, rectangle.y + rectangle.height / 2 - 5, 8, 8);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!CLOSE_BUTTON_ENABLED) {
            return;
        }
        int n = this.getSelectedIndex();
        int n2 = 0;
        int n3 = this.getTabCount();
        while (n2 < n3) {
            Rectangle rectangle = this.getCloseButtonBoundsAt(n2);
            if (rectangle != null) {
                if (n2 == this.pressedCloseButtonIndex && !this.draggedOut) {
                    graphics.setColor(new Color(153, 153, 153));
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                if (n2 != n) {
                    graphics.drawImage(closeTabInactiveImage, rectangle.x + 2, rectangle.y + 2, this);
                } else {
                    graphics.drawImage(closeTabImage, rectangle.x + 2, rectangle.y + 2, this);
                }
                if (n2 == this.mouseOverCloseButtonIndex || n2 == this.pressedCloseButtonIndex && this.draggedOut) {
                    graphics.setColor(new Color(102, 102, 102));
                    graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.setColor(n2 == n ? new Color(255, 255, 255) : new Color(204, 204, 204));
                    graphics.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width, rectangle.height);
                    graphics.setColor(new Color(162, 162, 162));
                    graphics.drawLine(rectangle.x + rectangle.width, rectangle.y + 1, rectangle.x + rectangle.width, rectangle.y + 1);
                    graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height, rectangle.x + 1, rectangle.y + rectangle.height);
                } else if (n2 == this.pressedCloseButtonIndex) {
                    graphics.setColor(new Color(102, 102, 102));
                    graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.setColor(n2 == n ? new Color(255, 255, 255) : new Color(204, 204, 204));
                    graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height + 1, rectangle.x + rectangle.width + 1, rectangle.y + rectangle.height + 1);
                    graphics.drawLine(rectangle.x + rectangle.width + 1, rectangle.y + 1, rectangle.x + rectangle.width + 1, rectangle.y + rectangle.height + 1);
                    graphics.setColor(new Color(153, 153, 153));
                    graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + rectangle.width, rectangle.y + 1);
                    graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, rectangle.y + rectangle.height);
                }
            }
            ++n2;
        }
    }

    private void setPressedCloseButtonIndex(int n) {
        Rectangle rectangle;
        if (this.pressedCloseButtonIndex == n) {
            return;
        }
        if (this.pressedCloseButtonIndex >= 0) {
            rectangle = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            this.repaint(rectangle.x, rectangle.y, rectangle.width + 2, rectangle.height + 2);
            TopComponent topComponent = (TopComponent)this.getComponentAt(this.pressedCloseButtonIndex);
            this.setToolTipTextAt(this.pressedCloseButtonIndex, topComponent.getToolTipText());
        }
        this.pressedCloseButtonIndex = n;
        if (this.pressedCloseButtonIndex >= 0) {
            rectangle = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            this.repaint(rectangle.x, rectangle.y, rectangle.width + 2, rectangle.height + 2);
            this.setMouseOverCloseButtonIndex(-1);
            this.setToolTipTextAt(this.pressedCloseButtonIndex, null);
        }
    }

    private void setMouseOverCloseButtonIndex(int n) {
        Rectangle rectangle;
        if (this.mouseOverCloseButtonIndex == n) {
            return;
        }
        if (this.mouseOverCloseButtonIndex >= 0) {
            rectangle = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            this.repaint(rectangle.x, rectangle.y, rectangle.width + 2, rectangle.height + 2);
            TopComponent topComponent = (TopComponent)this.getComponentAt(this.mouseOverCloseButtonIndex);
            this.setToolTipTextAt(this.mouseOverCloseButtonIndex, topComponent.getToolTipText());
        }
        this.mouseOverCloseButtonIndex = n;
        if (this.mouseOverCloseButtonIndex >= 0) {
            rectangle = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            this.repaint(rectangle.x, rectangle.y, rectangle.width + 2, rectangle.height + 2);
            this.setPressedCloseButtonIndex(-1);
            this.setToolTipTextAt(this.mouseOverCloseButtonIndex, null);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        boolean bl = CLOSE_BUTTON_ENABLED = System.getProperty("netbeans.tab.close.button.enabled") == null ? true : Boolean.getBoolean("netbeans.tab.close.button.enabled");
        TAB_NAME_TRAILING_SPACE = CLOSE_BUTTON_ENABLED ? (Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) < 0 ? "   " : "  ") : "";
        closeTabImage = Toolkit.getDefaultToolkit().createImage((class$org$netbeans$core$windows$frames$CloseButtonTabbedPane == null ? (class$org$netbeans$core$windows$frames$CloseButtonTabbedPane = CloseButtonTabbedPane.class$("org.netbeans.core.windows.frames.CloseButtonTabbedPane")) : class$org$netbeans$core$windows$frames$CloseButtonTabbedPane).getResource("tabclose.gif"));
        closeTabInactiveImage = Toolkit.getDefaultToolkit().createImage((class$org$netbeans$core$windows$frames$CloseButtonTabbedPane == null ? (class$org$netbeans$core$windows$frames$CloseButtonTabbedPane = CloseButtonTabbedPane.class$("org.netbeans.core.windows.frames.CloseButtonTabbedPane")) : class$org$netbeans$core$windows$frames$CloseButtonTabbedPane).getResource("tabcloseinactive.gif"));
    }

    private static class CloseButtonListener
    implements AWTEventListener {
        private static boolean installed = false;

        private CloseButtonListener() {
        }

        static synchronized void install() {
            if (installed) {
                return;
            }
            installed = true;
            Toolkit.getDefaultToolkit().addAWTEventListener(new CloseButtonListener(), 48L);
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            Component component = (Component)mouseEvent.getSource();
            while (component != null && !(component instanceof CloseButtonTabbedPane)) {
                component = component.getParent();
            }
            if (component == null) {
                return;
            }
            CloseButtonTabbedPane closeButtonTabbedPane = (CloseButtonTabbedPane)component;
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), closeButtonTabbedPane);
            int n = JdkBug4620540Hack.findTabForCoordinate(closeButtonTabbedPane, point.x, point.y);
            Rectangle rectangle = null;
            if (n >= 0) {
                rectangle = closeButtonTabbedPane.getCloseButtonBoundsAt(n);
            }
            if (rectangle == null) {
                rectangle = new Rectangle(0, 0, 0, 0);
            }
            switch (mouseEvent.getID()) {
                case 501: {
                    if (!rectangle.contains(point)) break;
                    closeButtonTabbedPane.setPressedCloseButtonIndex(n);
                    closeButtonTabbedPane.draggedOut = false;
                    mouseEvent.consume();
                    return;
                }
                case 502: {
                    if (rectangle.contains(point) && closeButtonTabbedPane.pressedCloseButtonIndex >= 0) {
                        TopComponent topComponent = (TopComponent)closeButtonTabbedPane.getComponentAt(closeButtonTabbedPane.pressedCloseButtonIndex);
                        closeButtonTabbedPane.reset();
                        topComponent.close();
                        mouseEvent.consume();
                        return;
                    }
                    closeButtonTabbedPane.reset();
                    break;
                }
                case 504: {
                    break;
                }
                case 505: {
                    break;
                }
                case 503: {
                    if (rectangle.contains(point)) {
                        closeButtonTabbedPane.setMouseOverCloseButtonIndex(n);
                        closeButtonTabbedPane.draggedOut = false;
                        mouseEvent.consume();
                        return;
                    }
                    if (closeButtonTabbedPane.mouseOverCloseButtonIndex < 0) break;
                    closeButtonTabbedPane.setMouseOverCloseButtonIndex(-1);
                    closeButtonTabbedPane.draggedOut = false;
                    mouseEvent.consume();
                    break;
                }
                case 506: {
                    if (closeButtonTabbedPane.pressedCloseButtonIndex < 0) break;
                    if (closeButtonTabbedPane.draggedOut != !rectangle.contains(point)) {
                        closeButtonTabbedPane.draggedOut = !rectangle.contains(point);
                        closeButtonTabbedPane.repaint(rectangle.x, rectangle.y, rectangle.width + 2, rectangle.height + 2);
                    }
                    mouseEvent.consume();
                    return;
                }
            }
        }
    }
}

