/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.toolbars;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.core.windows.toolbars.ToolbarConfiguration;
import org.netbeans.core.windows.toolbars.ToolbarConstraints;
import org.netbeans.core.windows.toolbars.ToolbarRow;
import org.openide.awt.Toolbar;
import org.openide.awt.ToolbarPool;
import org.openide.windows.WindowManager;

public class ToolbarLayout
implements LayoutManager2,
Serializable {
    public static final int HGAP = 1;
    public static final int VGAP = 1;
    static final long serialVersionUID = 7489472539255790677L;
    private static final int MIN_VISIBLE_TOOLBAR_WIDTH = 15;
    ToolbarConfiguration toolbarConfig;
    HashMap componentMap;

    public ToolbarLayout(ToolbarConfiguration toolbarConfiguration) {
        this.toolbarConfig = toolbarConfiguration;
        this.componentMap = new HashMap();
    }

    public void addLayoutComponent(String string, Component component) {
        throw new IllegalArgumentException();
    }

    public void addLayoutComponent(Component component, Object object) {
        if (!(object instanceof ToolbarConstraints)) {
            throw new IllegalArgumentException(ToolbarConfiguration.getBundleString("EXC_wrongConstraints"));
        }
        this.componentMap.put(component, object);
        ToolbarConstraints toolbarConstraints = (ToolbarConstraints)object;
        toolbarConstraints.setPreferredSize(component.getPreferredSize());
        component.setVisible(toolbarConstraints.isVisible());
    }

    public void removeLayoutComponent(Component component) {
        this.componentMap.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = new Dimension(insets.left + this.toolbarConfig.getPrefWidth() + insets.right, insets.top + this.toolbarConfig.getPrefHeight() + insets.bottom);
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = WindowManager.getDefault().getMainWindow().getInsets();
            int n = Toolkit.getDefaultToolkit().getScreenSize().width - (insets.left + insets.right) - 1;
            Iterator iterator = this.componentMap.keySet().iterator();
            while (iterator.hasNext()) {
                Component component = (Component)iterator.next();
                ToolbarConstraints toolbarConstraints = (ToolbarConstraints)this.componentMap.get(component);
                toolbarConstraints.updatePreferredSize(component.getPreferredSize());
            }
            HashSet hashSet = new HashSet(this.componentMap.size() * 2);
            int n2 = 0;
            while (n2 < this.toolbarConfig.getRowCount()) {
                ToolbarConstraints toolbarConstraints = this.processRow(this.toolbarConfig.getRow(n2), hashSet, n);
                Iterator iterator2 = this.toolbarConfig.getRow(n2).iterator();
                while (iterator.hasNext()) {
                    hashSet.add(iterator2.next());
                }
                ++n2;
            }
        }
    }

    private ToolbarConstraints processRow(ToolbarRow toolbarRow, Collection collection, int n) {
        ArrayList<ToolbarConstraints> arrayList = new ArrayList<ToolbarConstraints>(5);
        Iterator iterator = toolbarRow.iterator();
        while (iterator.hasNext()) {
            ToolbarConstraints toolbarConstraints = (ToolbarConstraints)iterator.next();
            if (collection.contains(toolbarConstraints)) continue;
            Toolbar toolbar = ToolbarPool.getDefault().findToolbar(toolbarConstraints.getName());
            Rectangle rectangle = toolbarConstraints.getBounds();
            if (rectangle.x < n && rectangle.x + rectangle.width > n) {
                rectangle.width = n - rectangle.x;
                toolbar.setBounds(rectangle);
                continue;
            }
            if (toolbarConstraints.getPosition() > n + 1) {
                if (toolbarConstraints.isAlone() || toolbarRow.toolbarCount() - arrayList.size() <= 1) continue;
                arrayList.add(toolbarConstraints);
                continue;
            }
            toolbar.setBounds(rectangle);
        }
        Iterator iterator2 = ((AbstractList)arrayList).iterator();
        while (iterator2.hasNext()) {
            this.moveToolbarDown((ToolbarConstraints)iterator2.next());
        }
        return null;
    }

    private void moveToolbarDown(ToolbarConstraints toolbarConstraints) {
        int n = toolbarConstraints.rowIndex() + 1;
        toolbarConstraints.destroy();
        int n2 = n;
        while (n2 < n + toolbarConstraints.getRowCount()) {
            this.toolbarConfig.getRow(n2).addToolbar(toolbarConstraints, 0);
            ++n2;
        }
        toolbarConstraints.setPosition(0);
        toolbarConstraints.updatePosition();
    }
}

