/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat.tomcat40.compile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.CompileException;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ParseException;
import org.apache.jasper.logging.DefaultLogger;
import org.apache.jasper.logging.Logger;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;
import org.netbeans.modules.j2ee.server.web.FfjJspCompileContext;
import org.netbeans.modules.j2ee.server.web.JspSourceMapper;
import org.netbeans.modules.java.environment.Utilities;
import org.netbeans.modules.tomcat.tomcat40.Tomcat40Instance;
import org.netbeans.modules.tomcat.tomcat40.compile.InternalCompiler;
import org.netbeans.modules.tomcat.tomcat40.compile.InternalCompilerContext;
import org.netbeans.modules.tomcat.tomcat40.compile.NullWriter;
import org.netbeans.modules.tomcat.tomcat40.compile.TomcatOptionsImpl;
import org.netbeans.modules.tomcat.tomcat40.compile.TomcatSourceMapper;
import org.netbeans.modules.tomcat.tomcat40.compile.WDCompilationDescriptor;
import org.netbeans.modules.web.core.jsploader.CompilationClassLoader;
import org.netbeans.modules.web.core.jsploader.ErrorCompiler;
import org.netbeans.modules.web.core.jsploader.ExCompileContext;
import org.netbeans.modules.web.core.jsploader.JspCompileUtil;
import org.openide.TopManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class TomcatCompileContext
implements FfjJspCompileContext,
ExCompileContext {
    private static final boolean debug = false;
    private static final String PATH_TO_XERCES = "tomcat404/common/lib/xerces.jar";
    private static final String PATH_TO_JASPER_RT = "tomcat404/lib/jasper-runtime.jar";
    private Tomcat40Instance virtualHost;
    private static boolean loggerInitialized = false;

    static synchronized void initializeLogger() {
        if (!loggerInitialized) {
            DefaultLogger defaultLogger = new DefaultLogger(null);
            Logger.setDefaultSink((Writer)new NullWriter());
            defaultLogger.setName("JASPER_LOG");
            loggerInitialized = true;
        }
    }

    public TomcatCompileContext(Tomcat40Instance tomcat40Instance) {
        this.virtualHost = tomcat40Instance;
    }

    public JspSourceMapper createSourceMapper(WebStandardData.WebJsp webJsp) throws IOException {
        return this.createTomcatSourceMapper(webJsp);
    }

    public InputStream getServletSource(WebStandardData.WebJsp webJsp) {
        String string = this.getDevelopmentCompilation(webJsp).getServletFileName();
        if (string != null) {
            try {
                return new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getServletClassName(WebStandardData.WebJsp webJsp) {
        return ((TomcatDevelopmentCompilation)this.getDevelopmentCompilation(webJsp)).getFullClassName();
    }

    public String getRealClassName(WebStandardData.WebJsp webJsp) {
        return ((TomcatDevelopmentCompilation)this.getDevelopmentCompilation(webJsp)).getRealClassName();
    }

    public FfjJspCompileContext.DevelopmentCompilation getDevelopmentCompilation(WebStandardData.WebJsp webJsp) {
        return new TomcatDevelopmentCompilation(webJsp, this.virtualHost);
    }

    public static FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor constructJakartaErrorDescriptor(WebStandardData.WebModule webModule, WebStandardData.WebJsp webJsp, Throwable throwable) {
        FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor errorDescriptor = TomcatCompileContext.constructJakartaErrorDescriptor0(webModule, webJsp, throwable);
        if (errorDescriptor == null) {
            errorDescriptor = new FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor((WebStandardData.WebResource)webJsp, -1, -1, ErrorCompiler.getThrowableMessage((Throwable)throwable, (boolean)true), "");
        }
        return errorDescriptor;
    }

    public JspSourceMapper createTomcatSourceMapper(final WebStandardData.WebJsp webJsp) throws IOException {
        InputStream inputStream = this.getServletSource(webJsp);
        if (inputStream == null) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        TomcatSourceMapper tomcatSourceMapper = new TomcatSourceMapper(bufferedReader, new JspSourceMapper.NameConverter(){

            public String convert(String string) throws IOException {
                String string2 = string;
                FileObject fileObject = JspCompileUtil.findFileObjectForFile((FileSystem)JspCompileUtil.getFOForWebResource((WebStandardData.WebResource)webJsp).getFileSystem(), (String)string);
                if (null != fileObject) {
                    string2 = fileObject.toString();
                }
                return string2;
            }
        });
        if (tomcatSourceMapper.isEmpty()) {
            tomcatSourceMapper.setPrimaryJspFileName(JspCompileUtil.getFOForWebResource((WebStandardData.WebResource)webJsp).getPackageNameExt('/', '.'));
        }
        if (tomcatSourceMapper.size() == 0) {
            throw new IllegalArgumentException(" sourceMangler.size() == 0");
        }
        return tomcatSourceMapper;
    }

    private static FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor constructJakartaErrorDescriptor0(WebStandardData.WebModule webModule, WebStandardData.WebJsp webJsp, Throwable throwable) {
        while (!(throwable instanceof ParseException) && !(throwable instanceof CompileException)) {
            if (!(throwable instanceof JasperException)) {
                return null;
            }
            throwable = ((JasperException)throwable).getRootCause();
        }
        String string = throwable.getMessage();
        int n = string.indexOf(40);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(44, n);
        if (n2 == -1) {
            return null;
        }
        int n3 = string.indexOf(41, n2);
        if (n3 == -1) {
            return null;
        }
        String string2 = string.substring(n + 1, n2);
        String string3 = string.substring(n2 + 1, n3);
        String string4 = string.substring(0, n);
        File file = webModule.getDocumentBase();
        String string5 = file.getAbsolutePath();
        WebStandardData.WebJsp webJsp2 = webJsp;
        if (string4.startsWith(string5)) {
            WebStandardData.WebResource webResource;
            String string6 = string4.substring(string5.length());
            if ((string6 = string6.replace(File.separatorChar, '/')).startsWith("/")) {
                string6 = string6.substring(1);
            }
            if ((webResource = webModule.findResource(string6)) != null) {
                webJsp2 = webResource;
            }
        }
        try {
            return new FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor((WebStandardData.WebResource)webJsp2, Integer.parseInt(string2) + 1, Integer.parseInt(string3), string.substring(n3 + 1).trim(), "");
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static class TomcatDevelopmentCompilation
    implements FfjJspCompileContext.DevelopmentCompilation {
        private transient String additionalClassPath;
        protected WebStandardData.WebJsp jspPage;
        protected Tomcat40Instance virtualHost;
        String className;
        String javaFileName;
        String classFileName;
        String realClassName;
        String currentServletFileName;
        String currentServletClassName;
        String currentClassFileName;
        private boolean outDated;

        TomcatDevelopmentCompilation(WebStandardData.WebJsp webJsp, Tomcat40Instance tomcat40Instance) {
            this.jspPage = webJsp;
            this.virtualHost = tomcat40Instance;
            this.initialize();
        }

        private void initialize() {
            String string = "/" + this.jspPage.getResourceURI();
            boolean bl = false;
            this.outDated = true;
            try {
                TomcatOptionsImpl tomcatOptionsImpl = new TomcatOptionsImpl(this.jspPage, this.virtualHost);
                WDCompilationDescriptor wDCompilationDescriptor = new WDCompilationDescriptor(this.jspPage.getWebModule(), string);
                InternalCompilerContext internalCompilerContext = new InternalCompilerContext((ClassLoader)new CompilationClassLoader(this.getClass().getClassLoader()), string, wDCompilationDescriptor, bl, tomcatOptionsImpl);
                InternalCompiler internalCompiler = (InternalCompiler)internalCompilerContext.createCompiler();
                this.className = internalCompiler.getClassName();
                this.javaFileName = internalCompiler.getJavaFileName();
                this.classFileName = internalCompiler.getClassFileName();
                this.realClassName = internalCompilerContext.getRealClassName();
                File file = new File(this.javaFileName);
                this.currentServletFileName = file.exists() ? this.javaFileName : null;
                this.currentServletClassName = file.exists() ? this.className : null;
                File file2 = new File(this.classFileName);
                this.currentClassFileName = file2.exists() ? this.classFileName : null;
                File file3 = new File(this.classFileName);
                if (!file3.exists()) {
                    this.outDated = true;
                } else {
                    FileObject fileObject = JspCompileUtil.getFOForWebResource((WebStandardData.WebResource)this.jspPage);
                    if (fileObject == null) {
                        throw new IOException();
                    }
                    File file4 = NbClassPath.toFile((FileObject)fileObject);
                    this.outDated = file3.lastModified() < file4.lastModified();
                }
            }
            catch (IOException iOException) {
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)iOException);
            }
            catch (JasperException jasperException) {
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)jasperException);
            }
        }

        public boolean isOutDated() {
            return this.outDated;
        }

        public void cleanJSP() throws IOException {
            FileObject fileObject;
            if (this.currentServletFileName != null) {
                fileObject = JspCompileUtil.findFileObjectForFile((String)this.currentServletFileName);
                if (fileObject == null) {
                    new File(this.currentServletFileName).delete();
                } else {
                    fileObject.delete();
                }
            }
            if (this.currentClassFileName != null) {
                fileObject = JspCompileUtil.findFileObjectForFile((String)this.currentClassFileName);
                if (fileObject == null) {
                    new File(this.currentClassFileName).delete();
                } else {
                    fileObject.delete();
                }
            }
        }

        public String getAdditionalClassPath() {
            if (this.additionalClassPath == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.getClassPathItem(TomcatCompileContext.PATH_TO_XERCES));
                stringBuffer.append(File.pathSeparatorChar);
                stringBuffer.append(this.getClassPathItem(TomcatCompileContext.PATH_TO_JASPER_RT));
                this.additionalClassPath = stringBuffer.toString();
            }
            return this.additionalClassPath;
        }

        private String getClassPathItem(String string) {
            String string2 = string.replace('/', File.separatorChar);
            return Utilities.findInstalledFile((String)string2).getAbsolutePath();
        }

        public void compilePreDeploy() throws IOException {
        }

        public String getServletFileName() {
            return this.currentServletFileName;
        }

        String getFullClassName() {
            return this.currentServletClassName;
        }

        String getRealClassName() {
            return this.realClassName;
        }

        public String getServletEncoding() {
            return "UTF8";
        }

        public FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor[] compileJspToServlet(boolean bl, String string, String string2, ClassLoader classLoader) throws IOException {
            TomcatCompileContext.initializeLogger();
            TomcatOptionsImpl tomcatOptionsImpl = new TomcatOptionsImpl(this.jspPage, this.virtualHost);
            try {
                WDCompilationDescriptor wDCompilationDescriptor = new WDCompilationDescriptor(this.jspPage.getWebModule(), string);
                String string3 = "/" + this.jspPage.getResourceURI();
                InternalCompilerContext internalCompilerContext = new InternalCompilerContext((ClassLoader)new CompilationClassLoader(this.getClass().getClassLoader()), string3, wDCompilationDescriptor, bl, tomcatOptionsImpl);
                Compiler compiler = internalCompilerContext.createCompiler();
                boolean bl2 = compiler.compile();
                return null;
            }
            catch (Exception exception) {
                FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor errorDescriptor = TomcatCompileContext.constructJakartaErrorDescriptor(this.jspPage.getWebModule(), this.jspPage, exception);
                return new FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor[]{errorDescriptor};
            }
        }
    }
}

