/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javamake;

import com.sun.tools.javamake.PrivateException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class BinaryFileReader {
    protected byte[] buf;
    protected int curBufPos;
    protected String fileFullPath;

    protected void initBuf(byte[] byArray, String string) {
        this.buf = byArray;
        this.curBufPos = 0;
        this.fileFullPath = string;
    }

    protected char nextChar() {
        return (char)(((this.buf[this.curBufPos++] & 0xFF) << 8) + (this.buf[this.curBufPos++] & 0xFF));
    }

    protected char getChar(int n) {
        return (char)(((this.buf[n++] & 0xFF) << 8) + (this.buf[n++] & 0xFF));
    }

    protected int nextInt() {
        return ((this.buf[this.curBufPos++] & 0xFF) << 24) + ((this.buf[this.curBufPos++] & 0xFF) << 16) + ((this.buf[this.curBufPos++] & 0xFF) << 8) + (this.buf[this.curBufPos++] & 0xFF);
    }

    protected int getInt(int n) {
        return ((this.buf[n++] & 0xFF) << 24) + ((this.buf[n++] & 0xFF) << 16) + ((this.buf[n++] & 0xFF) << 8) + (this.buf[n++] & 0xFF);
    }

    protected long nextLong() {
        long l = this.getLong(this.curBufPos);
        this.curBufPos += 8;
        return l;
    }

    protected long getLong(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.buf, n, 8));
        try {
            return dataInputStream.readLong();
        }
        catch (IOException iOException) {
            throw new PrivateException(iOException);
        }
    }

    protected float nextFloat() {
        float f = this.getFloat(this.curBufPos);
        this.curBufPos += 4;
        return f;
    }

    protected float getFloat(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.buf, n, 4));
        try {
            return dataInputStream.readFloat();
        }
        catch (IOException iOException) {
            throw new PrivateException(iOException);
        }
    }

    protected double nextDouble() {
        double d = this.getDouble(this.curBufPos);
        this.curBufPos += 8;
        return d;
    }

    protected double getDouble(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.buf, n, 8));
        try {
            return dataInputStream.readDouble();
        }
        catch (IOException iOException) {
            throw new PrivateException(iOException);
        }
    }
}

