/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javamake;

public class BinaryFileWriter {
    protected byte[] buf;
    protected int curBufSize;
    protected int bufInc;
    protected int curBufPos;
    protected int threshold;
    private boolean bufferIncreaseAllowed = true;

    protected void initBuf(int n) {
        this.buf = new byte[n];
        this.curBufSize = n;
        this.bufInc = n / 5;
        this.curBufPos = 0;
        this.threshold = this.curBufSize - this.bufInc;
    }

    protected void increaseBuf() {
        if (!this.bufferIncreaseAllowed) {
            return;
        }
        byte[] byArray = new byte[this.curBufSize + this.bufInc];
        System.arraycopy(this.buf, 0, byArray, 0, this.curBufPos);
        this.buf = byArray;
        this.curBufSize = this.buf.length;
        this.threshold = this.curBufSize - this.bufInc;
    }

    protected void setBufferIncreaseMode(boolean bl) {
        this.bufferIncreaseAllowed = bl;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    protected void writeChar(int n) {
        this.buf[this.curBufPos++] = (byte)(n >> 8 & 0xFF);
        this.buf[this.curBufPos++] = (byte)(n & 0xFF);
        if (this.curBufPos > this.threshold) {
            this.increaseBuf();
        }
    }

    protected void writeInt(int n) {
        this.buf[this.curBufPos++] = (byte)(n >> 24 & 0xFF);
        this.buf[this.curBufPos++] = (byte)(n >> 16 & 0xFF);
        this.buf[this.curBufPos++] = (byte)(n >> 8 & 0xFF);
        this.buf[this.curBufPos++] = (byte)(n & 0xFF);
        if (this.curBufPos > this.threshold) {
            this.increaseBuf();
        }
    }

    protected void writeLong(long l) {
        this.buf[this.curBufPos++] = (byte)(l >> 56 & 0xFFL);
        this.buf[this.curBufPos++] = (byte)(l >> 48 & 0xFFL);
        this.buf[this.curBufPos++] = (byte)(l >> 40 & 0xFFL);
        this.buf[this.curBufPos++] = (byte)(l >> 32 & 0xFFL);
        this.buf[this.curBufPos++] = (byte)(l >> 24 & 0xFFL);
        this.buf[this.curBufPos++] = (byte)(l >> 16 & 0xFFL);
        this.buf[this.curBufPos++] = (byte)(l >> 8 & 0xFFL);
        this.buf[this.curBufPos++] = (byte)(l & 0xFFL);
        if (this.curBufPos > this.threshold) {
            this.increaseBuf();
        }
    }

    protected void writeFloat(float f) {
        int n = Float.floatToIntBits(f);
        this.writeInt(n);
    }

    protected void writeDouble(double d) {
        long l = Double.doubleToLongBits(d);
        this.writeLong(l);
    }
}

