/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javamake;

import com.sun.tools.javamake.ClassInfo;
import com.sun.tools.javamake.PCDEntry;
import com.sun.tools.javamake.PCDManager;
import com.sun.tools.javamake.RefClassFinder;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Set;

public class CompatibilityChecker {
    private PCDManager pcdm;
    private RefClassFinder rf;
    private boolean versionsCompatible;
    private boolean publicConstantChanged;

    public CompatibilityChecker(PCDManager pCDManager) {
        this.pcdm = pCDManager;
        this.publicConstantChanged = false;
    }

    public boolean compareClassVersions(PCDEntry pCDEntry) {
        ClassInfo classInfo = this.pcdm.getClassInfoForPCDEntry(0, pCDEntry);
        ClassInfo classInfo2 = this.pcdm.getClassInfoForPCDEntry(1, pCDEntry);
        this.rf = new RefClassFinder(this.pcdm);
        this.versionsCompatible = true;
        this.checkAccessFlags(classInfo, classInfo2);
        this.checkSuperclasses(classInfo, classInfo2);
        this.checkImplementedInterfaces(classInfo, classInfo2);
        this.checkFields(classInfo, classInfo2);
        if (this.publicConstantChanged) {
            return false;
        }
        this.checkMethodsAndConstructors(classInfo, classInfo2);
        return this.versionsCompatible;
    }

    public void checkDeletedClass(ClassInfo classInfo) {
        this.rf = new RefClassFinder(this.pcdm);
        this.rf.findReferencingClasses2(classInfo);
        this.checkForFinalFields(classInfo);
    }

    public String[] getAffectedClasses() {
        return this.rf.getAffectedClassNames();
    }

    private void checkAccessFlags(ClassInfo classInfo, ClassInfo classInfo2) {
        char c = classInfo.accessFlags;
        char c2 = classInfo2.accessFlags;
        if (c == c2) {
            return;
        }
        if (!Modifier.isFinal(c) && Modifier.isFinal(c2)) {
            this.versionsCompatible = false;
            this.rf.findDirectSubclasses(classInfo);
        }
        if (!Modifier.isAbstract(c) && Modifier.isAbstract(c2)) {
            this.versionsCompatible = false;
            this.rf.findReferencingClasses0(classInfo);
        }
        if (Modifier.isPublic(c2)) {
            return;
        }
        if (Modifier.isProtected(c2)) {
            if (Modifier.isPublic(c)) {
                this.versionsCompatible = false;
                this.rf.findDiffPackageAndNotSubReferencingClasses1(classInfo);
            }
        } else if (Modifier.isPrivate(c2)) {
            if (Modifier.isPrivate(c)) {
                return;
            }
            this.versionsCompatible = false;
            if (Modifier.isPublic(c)) {
                this.rf.findReferencingClasses1(classInfo);
            } else if (Modifier.isProtected(c)) {
                this.rf.findThisPackageOrSubReferencingClasses1(classInfo);
            } else {
                this.rf.findThisPackageReferencingClasses1(classInfo);
            }
        } else if (Modifier.isPublic(c)) {
            this.versionsCompatible = false;
            this.rf.findDiffPackageReferencingClasses1(classInfo);
        } else if (Modifier.isProtected(c)) {
            this.versionsCompatible = false;
            this.rf.findDiffPackageAndSubReferencingClasses1(classInfo);
        }
    }

    private void checkSuperclasses(ClassInfo classInfo, ClassInfo classInfo2) {
        Set set = classInfo.getAllSuperclassNames();
        Set set2 = classInfo2.getAllSuperclassNames();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (set2.contains(string)) continue;
            this.versionsCompatible = false;
            this.rf.findReferencingClasses2(this.pcdm.getClassInfoForName(0, string), classInfo);
        }
    }

    private void checkImplementedInterfaces(ClassInfo classInfo, ClassInfo classInfo2) {
        if (classInfo.isInterface() || classInfo2.isInterface()) {
            return;
        }
        Set set = classInfo.getAllImplementedIntfNames();
        Set set2 = classInfo2.getAllImplementedIntfNames();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (set2.contains(string)) continue;
            this.versionsCompatible = false;
            this.rf.findReferencingClasses2(this.pcdm.getClassInfoForName(0, string), classInfo);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkFields(ClassInfo var1_1, ClassInfo var2_2) {
        var3_3 = var1_1.fieldNames;
        var4_4 = var1_1.fieldSignatures;
        var5_5 = var1_1.fieldAccessFlags;
        var6_6 = var2_2.fieldNames;
        var7_7 = var2_2.fieldSignatures;
        var8_8 = var2_2.fieldAccessFlags;
        var9_9 = var3_3 != null ? var3_3.length : 0;
        var20_11 = var10_10 = var6_6 != null ? var6_6.length : 0;
        var16_12 = 0;
        while (var16_12 < var9_9) {
            var11_13 = var5_5[var16_12];
            if (!Modifier.isPrivate(var11_13)) {
                var13_15 = var3_3[var16_12];
                var14_16 = var4_4[var16_12];
                var21_20 = false;
                var19_19 = var10_10 - 1;
                var18_18 = var16_12 < var10_10 ? var16_12 : var19_19;
                var17_17 = 0;
                while (var17_17 < var10_10) {
                    if (var13_15 == var6_6[var18_18] && var14_16 == var7_7[var18_18]) {
                        var21_20 = true;
                        break;
                    }
                    var18_18 = var18_18 < var19_19 ? ++var18_18 : 0;
                    ++var17_17;
                }
                if (var21_20) {
                    --var20_11;
                    var12_14 = var8_8[var18_18];
                    if (var11_13 == var12_14) {
                        if (Modifier.isStatic(var11_13) && Modifier.isFinal(var11_13) && !ClassInfo.constFieldInitValuesEqual(var1_1, var16_12, var2_2, var18_18)) {
                            this.versionsCompatible = false;
                            this.rf.findAllProjectClasses(var1_1, var16_12);
                            if (Modifier.isPublic(var11_13)) {
                                this.publicConstantChanged = true;
                                return;
                            } else {
                                ** GOTO lbl-1000
                            }
                        }
                    } else if (Modifier.isPrivate(var12_14) || Modifier.isFinal(var12_14) || Modifier.isStatic(var11_13) != Modifier.isStatic(var12_14) || Modifier.isVolatile(var11_13) != Modifier.isVolatile(var12_14)) {
                        this.versionsCompatible = false;
                        this.rf.findReferencingClassesForField(var1_1, var16_12);
                    } else if (Modifier.isPublic(var11_13) && Modifier.isProtected(var12_14)) {
                        this.versionsCompatible = false;
                        this.rf.findDiffPackageReferencingClassesForField(var1_1, var16_12);
                    } else if (!(!Modifier.isPublic(var11_13) && !Modifier.isProtected(var11_13) || Modifier.isPublic(var12_14) || Modifier.isProtected(var12_14) || Modifier.isPrivate(var12_14))) {
                        this.versionsCompatible = false;
                        if (Modifier.isPublic(var11_13)) {
                            this.rf.findDiffPackageReferencingClassesForField(var1_1, var16_12);
                        } else {
                            this.rf.findDiffPackageAndSubReferencingClassesForField(var1_1, var16_12);
                        }
                    } else if (Modifier.isStatic(var11_13) && Modifier.isFinal(var11_13) && (!Modifier.isFinal(var12_14) || !ClassInfo.constFieldInitValuesEqual(var1_1, var16_12, var2_2, var18_18))) {
                        this.versionsCompatible = false;
                        this.rf.findAllProjectClasses(var1_1, var16_12);
                        if (Modifier.isPublic(var11_13)) {
                            this.publicConstantChanged = true;
                            return;
                        }
                    }
                } else if (Modifier.isStatic(var11_13) && Modifier.isFinal(var11_13) && var1_1.primitiveConstantInitValues != null && var1_1.primitiveConstantInitValues[var16_12] != null) {
                    this.versionsCompatible = false;
                    this.rf.findAllProjectClasses(var1_1, var16_12);
                    if (Modifier.isPublic(var11_13)) {
                        this.publicConstantChanged = true;
                        return;
                    }
                } else {
                    this.versionsCompatible = false;
                    this.rf.findReferencingClassesForField(var1_1, var16_12);
                }
            }
            ++var16_12;
        }
        if (var20_11 > 0) {
            var16_12 = 0;
            while (var16_12 < var10_10) {
                var15_21 = var6_6[var16_12];
                var21_20 = false;
                var17_17 = 0;
                while (var17_17 < var9_9) {
                    if (var15_21 == var3_3[var17_17]) {
                        var21_20 = true;
                        break;
                    }
                    ++var17_17;
                }
                if (!var21_20) {
                    var22_22 = var1_1.superName;
                    while (var22_22 != null) {
                        var23_23 = this.pcdm.getClassInfoForName(0, var22_22);
                        if (var23_23 == null) break;
                        var24_24 = var23_23.fieldNames;
                        var25_25 = var24_24 != null ? var24_24.length : 0;
                        var17_17 = 0;
                        while (var17_17 < var25_25) {
                            if (var15_21 == var24_24[var17_17]) {
                                this.versionsCompatible = false;
                                this.rf.findReferencingClassesForField(var23_23, var17_17);
                            }
                            ++var17_17;
                        }
                        var22_22 = var23_23.superName;
                    }
                }
                ++var16_12;
            }
        }
    }

    private void checkForFinalFields(ClassInfo classInfo) {
        char[] cArray = classInfo.fieldAccessFlags;
        int n = classInfo.fieldNames != null ? classInfo.fieldNames.length : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Modifier.isPrivate(c) && Modifier.isStatic(c) && Modifier.isFinal(c)) {
                this.rf.findAllProjectClasses(classInfo, n2);
                if (Modifier.isPublic(c)) {
                    this.publicConstantChanged = true;
                    return;
                }
            }
            ++n2;
        }
    }

    private void checkMethodsAndConstructors(ClassInfo classInfo, ClassInfo classInfo2) {
        block49: {
            Object object;
            Object object2;
            char c;
            int n;
            boolean bl;
            int n2;
            String[] stringArray = classInfo.methodNames;
            String[] stringArray2 = classInfo.methodSignatures;
            char[] cArray = classInfo.methodAccessFlags;
            String[] stringArray3 = classInfo2.methodNames;
            String[] stringArray4 = classInfo2.methodSignatures;
            char[] cArray2 = classInfo2.methodAccessFlags;
            int n3 = stringArray != null ? stringArray.length : 0;
            int n4 = n2 = stringArray3 != null ? stringArray3.length : 0;
            int n5 = 0;
            while (n5 < n3) {
                char c2 = cArray[n5];
                if (!Modifier.isPrivate(c2)) {
                    String string = stringArray[n5];
                    String string2 = stringArray2[n5];
                    bl = false;
                    int n6 = n2 - 1;
                    int n7 = n5 < n2 ? n5 : n6;
                    n = 0;
                    while (n < n2) {
                        if (string == stringArray3[n7] && string2 == stringArray4[n7]) {
                            bl = true;
                            break;
                        }
                        n7 = n7 < n6 ? ++n7 : 0;
                        ++n;
                    }
                    if (bl) {
                        --n4;
                        c = cArray2[n7];
                        if (c2 != c) {
                            if (Modifier.isPrivate(c) || !Modifier.isAbstract(c2) && Modifier.isAbstract(c) || Modifier.isStatic(c2) != Modifier.isStatic(c)) {
                                this.versionsCompatible = false;
                                this.rf.findReferencingClassesForMethod(classInfo, n5);
                            } else if (Modifier.isPublic(c2) && Modifier.isProtected(c)) {
                                this.versionsCompatible = false;
                                this.rf.findDiffPackageReferencingClassesForMethod(classInfo, n5);
                            } else if (!(!Modifier.isPublic(c2) && !Modifier.isProtected(c2) || Modifier.isPublic(c) || Modifier.isProtected(c) || Modifier.isPrivate(c))) {
                                this.versionsCompatible = false;
                                if (Modifier.isPublic(c2)) {
                                    this.rf.findDiffPackageReferencingClassesForMethod(classInfo, n5);
                                } else {
                                    this.rf.findDiffPackageAndSubReferencingClassesForMethod(classInfo, n5);
                                }
                            } else if (!Modifier.isFinal(c2) && Modifier.isFinal(c)) {
                                this.versionsCompatible = false;
                                this.rf.findSubclassesReimplementingMethod(classInfo, n5);
                            }
                        }
                        if (classInfo2.checkedExceptions != null && classInfo2.checkedExceptions[n7] != null) {
                            if (classInfo.checkedExceptions == null) {
                                this.versionsCompatible = false;
                                this.rf.findReferencingClassesForMethod(classInfo, n5);
                            } else if (classInfo.checkedExceptions[n5] == null) {
                                this.versionsCompatible = false;
                                this.rf.findReferencingClassesForMethod(classInfo, n5);
                            } else {
                                String[] stringArray5 = classInfo.checkedExceptions[n5];
                                object2 = classInfo2.checkedExceptions[n7];
                                int n8 = 0;
                                while (n8 < ((String[])object2).length) {
                                    object = object2[n8];
                                    bl = false;
                                    int n9 = 0;
                                    while (n9 < stringArray5.length) {
                                        if (object == stringArray5[n9]) {
                                            bl = true;
                                            break;
                                        }
                                        ++n9;
                                    }
                                    if (!bl) {
                                        this.versionsCompatible = false;
                                        this.rf.findReferencingClassesForMethod(classInfo, n5);
                                        break;
                                    }
                                    ++n8;
                                }
                            }
                        }
                    } else {
                        this.versionsCompatible = false;
                        this.rf.findReferencingClassesForMethod(classInfo, n5);
                        if (classInfo.isAbstract() && !Modifier.isAbstract(c2)) {
                            this.rf.findConcreteSubclassesNotOverridingAbstractMethod(classInfo, classInfo, n5);
                        }
                    }
                }
                ++n5;
            }
            if (n4 <= 0) break block49;
            if (!classInfo.isInterface()) {
                n5 = 0;
                while (n5 < n2) {
                    c = cArray2[n5];
                    if (!Modifier.isPrivate(c)) {
                        String string = stringArray3[n5];
                        String string3 = stringArray4[n5];
                        bl = Modifier.isStatic(c);
                        boolean bl2 = false;
                        n = 0;
                        while (n < n3) {
                            if (string == stringArray[n] && string3 == stringArray2[n]) {
                                bl2 = true;
                                break;
                            }
                            ++n;
                        }
                        if (!bl2) {
                            object2 = classInfo.name;
                            while (object2 != null) {
                                ClassInfo classInfo3 = this.pcdm.getClassInfoForName(0, (String)object2);
                                if (classInfo3 == null) break;
                                object = classInfo3.methodNames;
                                String[] stringArray6 = classInfo3.methodSignatures;
                                int n10 = object != null ? ((String[])object).length : 0;
                                n = 0;
                                while (n < n10) {
                                    if (string == object[n]) {
                                        if (string3 == stringArray6[n]) {
                                            if (bl && classInfo3 != classInfo) {
                                                this.versionsCompatible = false;
                                                this.rf.findReferencingClassesForMethod(classInfo3, n);
                                            }
                                        } else if (this.sameParamNumber(string3, stringArray6[n])) {
                                            this.versionsCompatible = false;
                                            this.rf.findReferencingClassesForMethod(classInfo3, n);
                                        }
                                    }
                                    ++n;
                                }
                                object2 = classInfo3.superName;
                            }
                            if (Modifier.isAbstract(c)) {
                                this.versionsCompatible = false;
                                this.rf.findConcreteSubclassesNotOverridingAbstractMethod(classInfo, classInfo2, n5);
                            } else if (this.subclassesDeclareSameNameMethod(classInfo, string)) {
                                this.versionsCompatible = false;
                            }
                        }
                    }
                    ++n5;
                }
            } else {
                n5 = 0;
                while (n5 < n2) {
                    c = cArray2[n5];
                    if (!Modifier.isStatic(c) && !Modifier.isPrivate(c)) {
                        String string = stringArray3[n5];
                        String string4 = stringArray4[n5];
                        bl = false;
                        n = 0;
                        while (n < n3) {
                            if (string == stringArray[n] && string4 == stringArray2[n]) {
                                bl = true;
                                break;
                            }
                            ++n;
                        }
                        if (!bl) {
                            this.versionsCompatible = false;
                            this.rf.findDirectlyImplementingClasses(classInfo);
                            break;
                        }
                    }
                    ++n5;
                }
            }
        }
    }

    private boolean subclassesDeclareSameNameMethod(ClassInfo classInfo, String string) {
        boolean bl = false;
        ClassInfo[] classInfoArray = classInfo.getDirectSubclasses();
        int n = 0;
        while (n < classInfoArray.length) {
            ClassInfo classInfo2 = classInfoArray[n];
            int n2 = classInfo2.declaresSameNameMethod(string);
            if (n2 >= 0) {
                this.rf.addToAffectedClassNames(classInfo2.name);
                this.rf.findReferencingClassesForMethod(classInfo2, n2);
                bl = true;
            }
            if (this.subclassesDeclareSameNameMethod(classInfo2, string)) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private boolean sameParamNumber(String string, String string2) {
        return CompatibilityChecker.getParamNumber(string) == CompatibilityChecker.getParamNumber(string2);
    }

    /*
     * Unable to fully structure code
     */
    private static int getParamNumber(String var0) {
        var2_1 = 0;
        var3_2 = 0;
        do {
            if ((var1_3 = var0.charAt(++var3_2)) != ')') ** GOTO lbl7
            break;
lbl-1000:
            // 1 sources

            {
                var1_3 = var0.charAt(++var3_2);
lbl7:
                // 2 sources

                ** while (var1_3 == '[')
            }
lbl8:
            // 1 sources

            ++var2_1;
            if (var1_3 != '@') continue;
            while (var1_3 != '#') {
                var1_3 = var0.charAt(++var3_2);
            }
        } while (var1_3 != ')');
        return var2_1;
    }
}

