/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.adaptors;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.lib.ddl.adaptors.DatabaseMetaDataAdaptor;
import org.openide.util.NbBundle;

public class DefaultAdaptor
implements DatabaseMetaDataAdaptor,
Serializable {
    private transient Connection con;
    private transient DatabaseMetaData dmd;
    protected Map properties;
    private transient PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private static ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle");
    public static final int NOT_SET = 0;
    public static final String NOT_SET_STRING = "";
    public static final int YES = 1;
    public static final int NO = 2;
    public static final int NULLSORT_HIGH = 1;
    public static final int NULLSORT_LOW = 2;
    public static final int NULLSORT_START = 3;
    public static final int NULLSORT_END = 4;
    public static final int STORE_LOWERCASE = 1;
    public static final int STORE_UPPERCASE = 2;
    public static final int STORE_MIXEDCASE = 3;
    public static final String PROP_PROCEDURES_ARE_CALLABLE = "proceduresAreCallable";
    public static final String PROP_TABLES_ARE_SELECTABLE = "tablesAreSelectable";
    public static final String PROP_READONLY = "readOnly";
    public static final String PROP_LOCAL_FILES = "localFiles";
    public static final String PROP_FILE_PER_TABLE = "localFilePerTable";
    public static final String PROP_MIXEDCASE_IDENTIFIERS = "mixedCaseIdentifiers";
    public static final String PROP_MIXEDCASE_QUOTED_IDENTIFIERS = "mixedCaseQuotedIdentifiers";
    public static final String PROP_ALTER_ADD = "alterTableWithAddColumn";
    public static final String PROP_ALTER_DROP = "alterTableWithDropColumn";
    public static final String PROP_COLUMN_ALIASING = "columnAliasing";
    public static final String PROP_NULL_PLUS_NULL_IS_NULL = "nullPlusNonNullIsNull";
    public static final String PROP_CONVERT = "convert";
    public static final String PROP_TABLE_CORRELATION_NAMES = "tableCorrelationNames";
    public static final String PROP_DIFF_TABLE_CORRELATION_NAMES = "differentTableCorrelationNames";
    public static final String PROP_EXPRESSIONS_IN_ORDERBY = "expressionsInOrderBy";
    public static final String PROP_ORDER_BY_UNRELATED = "orderByUnrelated";
    public static final String PROP_GROUP_BY = "groupBy";
    public static final String PROP_UNRELATED_GROUP_BY = "groupByUnrelated";
    public static final String PROP_BEYOND_GROUP_BY = "groupByBeyondSelect";
    public static final String PROP_ESCAPE_LIKE = "likeEscapeClause";
    public static final String PROP_MULTIPLE_RS = "multipleResultSets";
    public static final String PROP_MULTIPLE_TRANSACTIONS = "multipleTransactions";
    public static final String PROP_NON_NULL_COLUMNSS = "nonNullableColumns";
    public static final String PROP_MINUMUM_SQL_GRAMMAR = "minimumSQLGrammar";
    public static final String PROP_CORE_SQL_GRAMMAR = "coreSQLGrammar";
    public static final String PROP_EXTENDED_SQL_GRAMMAR = "extendedSQLGrammar";
    public static final String PROP_ANSI_SQL_GRAMMAR = "ANSI92EntryLevelSQL";
    public static final String PROP_INTERMEDIATE_SQL_GRAMMAR = "ANSI92IntermediateSQL";
    public static final String PROP_FULL_SQL_GRAMMAR = "ANSI92FullSQL";
    public static final String PROP_INTEGRITY_ENHANCEMENT = "IntegrityEnhancementFacility";
    public static final String PROP_OUTER_JOINS = "outerJoins";
    public static final String PROP_FULL_OUTER_JOINS = "fullOuterJoins";
    public static final String PROP_LIMITED_OUTER_JOINS = "limitedOuterJoins";
    public static final String PROP_CATALOG_AT_START = "catalogAtStart";
    public static final String PROP_SCHEMAS_IN_DML = "schemasInDataManipulation";
    public static final String PROP_SCHEMAS_IN_PROCEDURE_CALL = "schemasInProcedureCalls";
    public static final String PROP_SCHEMAS_IN_TABLE_DEFINITION = "schemasInTableDefinitions";
    public static final String PROP_SCHEMAS_IN_INDEX = "schemasInIndexDefinitions";
    public static final String PROP_SCHEMAS_IN_PRIVILEGE_DEFINITION = "schemasInPrivilegeDefinitions";
    public static final String PROP_CATALOGS_IN_DML = "catalogsInDataManipulation";
    public static final String PROP_CATALOGS_IN_PROCEDURE_CALL = "catalogsInProcedureCalls";
    public static final String PROP_CATALOGS_IN_TABLE_DEFINITION = "catalogsInTableDefinitions";
    public static final String PROP_CATALOGS_IN_INDEX = "catalogsInIndexDefinitions";
    public static final String PROP_CATALOGS_IN_PRIVILEGE_DEFINITION = "catalogsInPrivilegeDefinitions";
    public static final String PROP_POSITIONED_DELETE = "positionedDelete";
    public static final String PROP_POSITIONED_UPDATE = "positionedUpdate";
    public static final String PROP_SELECT_FOR_UPDATE = "selectForUpdate";
    public static final String PROP_STORED_PROCEDURES = "storedProcedures";
    public static final String PROP_SUBQUERY_IN_COMPARSIONS = "subqueriesInComparisons";
    public static final String PROP_SUBQUERY_IN_EXISTS = "subqueriesInExists";
    public static final String PROP_SUBQUERY_IN_INS = "subqueriesInIns";
    public static final String PROP_SUBQUERY_IN_QUANTIFIEDS = "subqueriesInQuantifieds";
    public static final String PROP_CORRELATED_SUBQUERIES = "correlatedSubqueries";
    public static final String PROP_UNION = "union";
    public static final String PROP_UNION_ALL = "unionAll";
    public static final String PROP_OPEN_CURSORS_ACROSS_COMMIT = "openCursorsAcrossCommit";
    public static final String PROP_OPEN_CURSORS_ACROSS_ROLLBACK = "openCursorsAcrossRollback";
    public static final String PROP_OPEN_STATEMENTS_ACROSS_COMMIT = "openStatementsAcrossCommit";
    public static final String PROP_OPEN_STATEMENTS_ACROSS_ROLLBACK = "openStatementsAcrossRollback";
    public static final String PROP_ROWSIZE_INCLUDING_BLOBS = "maxRowSizeIncludeBlobs";
    public static final String PROP_TRANSACTIONS = "transactions";
    public static final String PROP_DDL_AND_DML_TRANSACTIONS = "dataDefinitionAndDataManipulationTransactions";
    public static final String PROP_DML_TRANSACTIONS_ONLY = "dataManipulationTransactionsOnly";
    public static final String PROP_DDL_CAUSES_COMMIT = "dataDefinitionCausesTransactionCommit";
    public static final String PROP_DDL_IGNORED_IN_TRANSACTIONS = "dataDefinitionIgnoredInTransactions";
    public static final String PROP_BATCH_UPDATES = "batchUpdates";
    public static final String PROP_NULL_SORT = "nullSort";
    public static final String PROP_IDENTIFIER_STORE = "identifierStore";
    public static final String PROP_QUOTED_IDENTS = "quotedIdentifierStore";
    public static final String PROP_MAX_BINARY_LITERAL_LENGTH = "maxBinaryLiteralLength";
    public static final String PROP_MAX_CHAR_LITERAL_LENGTH = "maxCharLiteralLength";
    public static final String PROP_MAX_COLUMN_NAME_LENGTH = "maxColumnNameLength";
    public static final String PROP_MAX_COLUMNS_IN_GROUPBY = "maxColumnsInGroupBy";
    public static final String PROP_MAX_COLUMNS_IN_INDEX = "maxColumnsInIndex";
    public static final String PROP_MAX_COLUMNS_IN_ORDERBY = "maxColumnsInOrderBy";
    public static final String PROP_MAX_COLUMNS_IN_SELECT = "maxColumnsInSelect";
    public static final String PROP_MAX_COLUMNS_IN_TABLE = "maxColumnsInTable";
    public static final String PROP_MAX_CONNECTIONS = "maxConnections";
    public static final String PROP_MAX_CURSORNAME_LENGTH = "maxCursorNameLength";
    public static final String PROP_MAX_INDEX_LENGTH = "maxIndexLength";
    public static final String PROP_MAX_SCHEMA_NAME = "maxSchemaNameLength";
    public static final String PROP_MAX_PROCEDURE_NAME = "maxProcedureNameLength";
    public static final String PROP_MAX_CATALOG_NAME = "maxCatalogNameLength";
    public static final String PROP_MAX_ROW_SIZE = "maxRowSize";
    public static final String PROP_MAX_STATEMENT_LENGTH = "maxStatementLength";
    public static final String PROP_MAX_STATEMENTS = "maxStatements";
    public static final String PROP_MAX_TABLENAME_LENGTH = "maxTableNameLength";
    public static final String PROP_MAX_TABLES_IN_SELECT = "maxTablesInSelect";
    public static final String PROP_MAX_USERNAME = "maxUserNameLength";
    public static final String PROP_DEFAULT_ISOLATION = "defaultTransactionIsolation";
    public static final String PROP_URL = "URL";
    public static final String PROP_USERNAME = "userName";
    public static final String PROP_PRODUCTNAME = "databaseProductName";
    public static final String PROP_PRODUCTVERSION = "databaseProductVersion";
    public static final String PROP_DRIVERNAME = "driverName";
    public static final String PROP_DRIVER_VERSION = "driverVersion";
    public static final String PROP_DRIVER_MAJOR_VERSION = "driverMajorVersion";
    public static final String PROP_DRIVER_MINOR_VERSION = "driverMinorVersion";
    public static final String PROP_IDENTIFIER_QUOTE = "identifierQuoteString";
    public static final String PROP_SQL_KEYWORDS = "SQLKeywords";
    public static final String PROP_NUMERIC_FUNCTIONS = "numericFunctions";
    public static final String PROP_STRING_FUNCTIONS = "stringFunctions";
    public static final String PROP_SYSTEM_FUNCTIONS = "systemFunctions";
    public static final String PROP_TIME_FUNCTIONS = "timeDateFunctions";
    public static final String PROP_STRING_ESCAPE = "searchStringEscape";
    public static final String PROP_EXTRA_CHARACTERS = "extraNameCharacters";
    public static final String PROP_SCHEMA_TERM = "schemaTerm";
    public static final String PROP_PROCEDURE_TERM = "procedureTerm";
    public static final String PROP_CATALOG_TERM = "catalogTerm";
    public static final String PROP_CATALOGS_SEPARATOR = "catalogSeparator";
    public static final String PROP_PROCEDURES_QUERY = "proceduresQuery";
    public static final String PROP_PROCEDURE_COLUMNS_QUERY = "procedureColumnsQuery";
    public static final String PROP_SCHEMAS_QUERY = "schemasQuery";
    public static final String PROP_CATALOGS_QUERY = "catalogsQuery";
    public static final String PROP_TABLES_QUERY = "tablesQuery";
    public static final String PROP_TABLE_TYPES_QUERY = "tableTypesQuery";
    public static final String PROP_COLUMNS_QUERY = "columnsQuery";
    public static final String PROP_COLUMNS_PRIVILEGES_QUERY = "columnPrivilegesQuery";
    public static final String PROP_TABLE_PRIVILEGES_QUERY = "tablePrivilegesQuery";
    public static final String PROP_BEST_ROW_IDENTIFIER = "bestRowIdentifierQuery";
    public static final String PROP_VERSION_COLUMNS = "versionColumnsQuery";
    public static final String PROP_PK_QUERY = "primaryKeysQuery";
    public static final String PROP_IK_QUERY = "importedKeysQuery";
    public static final String PROP_EK_QUERY = "exportedKeysQuery";
    public static final String PROP_CROSSREF_QUERY = "crossReferenceQuery";
    public static final String PROP_TYPE_INFO_QUERY = "typeInfoQuery";
    public static final String PROP_INDEX_INFO_QUERY = "indexInfoQuery";
    public static final String PROP_UDT_QUERY = "UDTsQuery";
    public static final String PROP_CAPITALIZE_USERNAME = "capitializeUsername";
    static final long serialVersionUID = 2490518619095829944L;

    public DefaultAdaptor() {
        this.properties = new HashMap();
    }

    public DefaultAdaptor(Connection connection) throws SQLException {
        this.properties = new HashMap();
        this.con = connection;
        this.dmd = this.con != null ? this.con.getMetaData() : null;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public DatabaseMetaData getMetaData() {
        return this;
    }

    public Connection getConnection() throws SQLException {
        return this.con;
    }

    public void setConnection(Connection connection) throws SQLException {
        this.con = connection;
        this.dmd = this.con != null ? this.con.getMetaData() : null;
    }

    private int getBoolean(String string) {
        Boolean bl = (Boolean)this.properties.get(string);
        if (bl != null) {
            return bl != false ? 1 : 2;
        }
        return 0;
    }

    private void setBoolean(String string, int n) {
        Boolean bl;
        Boolean bl2 = (Boolean)this.properties.get(string);
        if (n != 0) {
            bl = new Boolean(n == 1);
            this.properties.put(string, bl);
        } else {
            bl = null;
            this.properties.remove(string);
        }
        this.propertySupport.firePropertyChange(string, bl2, bl);
    }

    private int getInt(String string) {
        Integer n = (Integer)this.properties.get(string);
        if (n == null) {
            return 0;
        }
        return n;
    }

    private void setInt(String string, int n) {
        Integer n2;
        Integer n3 = (Integer)this.properties.get(string);
        if (n != 0) {
            n2 = new Integer(n);
            this.properties.put(string, n2);
        } else {
            n2 = null;
            this.properties.remove(string);
        }
        this.propertySupport.firePropertyChange(string, n3, n2);
    }

    private String getString(String string) {
        String string2 = (String)this.properties.get(string);
        if (string2 == null) {
            return NOT_SET_STRING;
        }
        return string2;
    }

    private void setString(String string, String string2) {
        String string3;
        String string4 = (String)this.properties.get(string);
        if (string2.length() > 0) {
            string3 = string2;
            this.properties.put(string, string3);
        } else {
            string3 = null;
            this.properties.remove(string);
        }
        this.propertySupport.firePropertyChange(string, string4, string3);
    }

    public boolean allProceduresAreCallable() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_PROCEDURES_ARE_CALLABLE);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.allProceduresAreCallable());
            this.properties.put(PROP_PROCEDURES_ARE_CALLABLE, bl);
        }
        return bl;
    }

    public int getProceduresAreCallable() {
        return this.getBoolean(PROP_PROCEDURES_ARE_CALLABLE);
    }

    public void setProceduresAreCallable(int n) throws SQLException {
        this.setBoolean(PROP_PROCEDURES_ARE_CALLABLE, n);
    }

    public boolean allTablesAreSelectable() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_TABLES_ARE_SELECTABLE);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.allTablesAreSelectable());
            this.properties.put(PROP_TABLES_ARE_SELECTABLE, bl);
        }
        return bl;
    }

    public int getTablesAreSelectable() {
        return this.getBoolean(PROP_TABLES_ARE_SELECTABLE);
    }

    public void setTablesAreSelectable(int n) {
        this.setBoolean(PROP_TABLES_ARE_SELECTABLE, n);
    }

    public String getURL() throws SQLException {
        String string = (String)this.properties.get(PROP_URL);
        if (string == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            string = this.dmd.getURL();
            this.properties.put(PROP_URL, string);
        }
        return string;
    }

    public void setURL(String string) {
        this.setString(PROP_URL, string);
    }

    public String getUserName() throws SQLException {
        String string = (String)this.properties.get(PROP_USERNAME);
        if (string == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            string = this.dmd.getUserName();
            this.properties.put(PROP_USERNAME, string);
        }
        return string;
    }

    public void setUserName(String string) {
        this.setString(PROP_USERNAME, string);
    }

    public boolean isReadOnly() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_READONLY);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.isReadOnly());
            this.properties.put(PROP_READONLY, bl);
        }
        return bl;
    }

    public int getreadOnly() {
        return this.getBoolean(PROP_READONLY);
    }

    public void setreadOnly(int n) {
        this.setBoolean(PROP_READONLY, n);
    }

    public int getNullSort() {
        return this.getInt(PROP_NULL_SORT);
    }

    public void setNullSort(int n) {
        this.setInt(PROP_NULL_SORT, n);
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_NULL_SORT);
        if (n != null) {
            return n == 1;
        }
        if (this.dmd != null) {
            return this.dmd.nullsAreSortedAtStart();
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean nullsAreSortedLow() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_NULL_SORT);
        if (n != null) {
            return n == 2;
        }
        if (this.dmd != null) {
            return this.dmd.nullsAreSortedLow();
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_NULL_SORT);
        if (n != null) {
            return n == 3;
        }
        if (this.dmd != null) {
            return this.dmd.nullsAreSortedAtStart();
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_NULL_SORT);
        if (n != null) {
            return n == 4;
        }
        if (this.dmd != null) {
            return this.dmd.nullsAreSortedAtEnd();
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public String getDatabaseProductName() throws SQLException {
        String string = (String)this.properties.get(PROP_PRODUCTNAME);
        if (string == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            string = this.dmd.getDatabaseProductName().trim();
            this.properties.put(PROP_PRODUCTNAME, string);
        }
        return string;
    }

    public void setDatabaseProductName(String string) {
        this.setString(PROP_PRODUCTNAME, string);
    }

    public String getDatabaseProductVersion() throws SQLException {
        String string = (String)this.properties.get(PROP_PRODUCTVERSION);
        if (string == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            string = this.dmd.getDatabaseProductVersion();
            this.properties.put(PROP_PRODUCTVERSION, string);
        }
        return string;
    }

    public void setDatabaseProductVersion(String string) {
        this.setString(PROP_PRODUCTVERSION, string);
    }

    public String getDriverName() throws SQLException {
        String string = (String)this.properties.get(PROP_DRIVERNAME);
        if (string == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            string = this.dmd.getDriverName();
            this.properties.put(PROP_DRIVERNAME, string);
        }
        return string;
    }

    public void setDriverName(String string) {
        this.setString(PROP_DRIVERNAME, string);
    }

    public String getDriverVersion() throws SQLException {
        String string = (String)this.properties.get(PROP_DRIVER_VERSION);
        if (string == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            string = this.dmd.getDriverVersion();
            this.properties.put(PROP_DRIVER_VERSION, string);
        }
        return string;
    }

    public void setDriverVersion(String string) {
        this.setString(PROP_DRIVER_VERSION, string);
    }

    public int getDriverMajorVersion() {
        Integer n = (Integer)this.properties.get(PROP_DRIVER_MAJOR_VERSION);
        if (n == null) {
            n = this.dmd != null ? new Integer(this.dmd.getDriverMajorVersion()) : new Integer(0);
            this.properties.put(PROP_DRIVER_MAJOR_VERSION, n);
        }
        return n;
    }

    public void setDriverMajorVersion(int n) {
        this.setInt(PROP_DRIVER_MAJOR_VERSION, n);
    }

    public int getDriverMinorVersion() {
        Integer n = (Integer)this.properties.get(PROP_DRIVER_MINOR_VERSION);
        if (n == null) {
            n = this.dmd != null ? new Integer(this.dmd.getDriverMinorVersion()) : new Integer(0);
            this.properties.put(PROP_DRIVER_MINOR_VERSION, n);
        }
        return n;
    }

    public void setDriverMinorVersion(int n) {
        this.setInt(PROP_DRIVER_MINOR_VERSION, n);
    }

    public boolean usesLocalFiles() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_LOCAL_FILES);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.usesLocalFiles());
            this.properties.put(PROP_LOCAL_FILES, bl);
        }
        return bl;
    }

    public int getLocalFiles() {
        return this.getBoolean(PROP_LOCAL_FILES);
    }

    public void setLocalFiles(int n) {
        this.setBoolean(PROP_LOCAL_FILES, n);
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_FILE_PER_TABLE);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.usesLocalFilePerTable());
            this.properties.put(PROP_FILE_PER_TABLE, bl);
        }
        return bl;
    }

    public int getLocalFilePerTable() {
        return this.getBoolean(PROP_FILE_PER_TABLE);
    }

    public void setLocalFilePerTable(int n) {
        this.setBoolean(PROP_FILE_PER_TABLE, n);
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_MIXEDCASE_IDENTIFIERS);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsMixedCaseIdentifiers());
            this.properties.put(PROP_MIXEDCASE_IDENTIFIERS, bl);
        }
        return bl;
    }

    public int getMixedCaseIdentifiers() {
        return this.getBoolean(PROP_MIXEDCASE_IDENTIFIERS);
    }

    public void setMixedCaseIdentifiers(int n) {
        this.setBoolean(PROP_MIXEDCASE_IDENTIFIERS, n);
    }

    public int getIdentifierStore() {
        return this.getInt(PROP_IDENTIFIER_STORE);
    }

    public void setIdentifierStore(int n) {
        this.setInt(PROP_IDENTIFIER_STORE, n);
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_IDENTIFIER_STORE);
        if (n != null) {
            return n == 2;
        }
        if (this.dmd != null) {
            return this.dmd.storesUpperCaseIdentifiers();
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_IDENTIFIER_STORE);
        if (n != null) {
            return n == 1;
        }
        if (this.dmd != null) {
            return this.dmd.storesLowerCaseIdentifiers();
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_IDENTIFIER_STORE);
        if (n != null) {
            return n == 3;
        }
        if (this.dmd != null) {
            return this.dmd.storesLowerCaseIdentifiers();
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_MIXEDCASE_QUOTED_IDENTIFIERS);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsMixedCaseQuotedIdentifiers());
            this.properties.put(PROP_MIXEDCASE_QUOTED_IDENTIFIERS, bl);
        }
        return bl;
    }

    public int getMixedCaseQuotedIdentifiers() {
        return this.getBoolean(PROP_MIXEDCASE_QUOTED_IDENTIFIERS);
    }

    public void setMixedCaseQuotedIdentifiers(int n) {
        this.setBoolean(PROP_MIXEDCASE_QUOTED_IDENTIFIERS, n);
    }

    public int getQuotedIdentifierStore() {
        return this.getInt(PROP_QUOTED_IDENTS);
    }

    public void setQuotedIdentifierStore(int n) {
        this.setInt(PROP_QUOTED_IDENTS, n);
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_QUOTED_IDENTS);
        if (n != null) {
            return n == 2;
        }
        if (this.dmd != null) {
            return this.dmd.storesUpperCaseQuotedIdentifiers();
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_QUOTED_IDENTS);
        if (n != null) {
            return n == 1;
        }
        if (this.dmd != null) {
            return this.dmd.storesLowerCaseQuotedIdentifiers();
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_QUOTED_IDENTS);
        if (n != null) {
            return n == 3;
        }
        if (this.dmd != null) {
            return this.dmd.storesMixedCaseQuotedIdentifiers();
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public String getIdentifierQuoteString() throws SQLException {
        String string = (String)this.properties.get(PROP_IDENTIFIER_QUOTE);
        if (string == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            string = this.dmd.getIdentifierQuoteString();
            this.properties.put(PROP_IDENTIFIER_QUOTE, string);
        }
        return string;
    }

    public void setIdentifierQuoteString(String string) {
        this.setString(PROP_IDENTIFIER_QUOTE, string);
    }

    public String getSQLKeywords() throws SQLException {
        String string = (String)this.properties.get(PROP_SQL_KEYWORDS);
        if (string == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            string = this.dmd.getSQLKeywords();
            this.properties.put(PROP_SQL_KEYWORDS, string);
        }
        return string;
    }

    public void setSQLKeywords(String string) {
        this.setString(PROP_SQL_KEYWORDS, string);
    }

    public String getNumericFunctions() throws SQLException {
        String string = (String)this.properties.get(PROP_NUMERIC_FUNCTIONS);
        if (string == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            string = this.dmd.getNumericFunctions();
            this.properties.put(PROP_NUMERIC_FUNCTIONS, string);
        }
        return string;
    }

    public void setNumericFunctions(String string) {
        this.setString(PROP_NUMERIC_FUNCTIONS, string);
    }

    public String getStringFunctions() throws SQLException {
        String string = (String)this.properties.get(PROP_STRING_FUNCTIONS);
        if (string == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            string = this.dmd.getStringFunctions();
            this.properties.put(PROP_STRING_FUNCTIONS, string);
        }
        return string;
    }

    public void setStringFunctions(String string) {
        this.setString(PROP_STRING_FUNCTIONS, string);
    }

    public String getSystemFunctions() throws SQLException {
        String string = (String)this.properties.get(PROP_SYSTEM_FUNCTIONS);
        if (string == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            string = this.dmd.getSystemFunctions();
            this.properties.put(PROP_SYSTEM_FUNCTIONS, string);
        }
        return string;
    }

    public void setSystemFunctions(String string) {
        this.setString(PROP_SYSTEM_FUNCTIONS, string);
    }

    public String getTimeDateFunctions() throws SQLException {
        String string = (String)this.properties.get(PROP_TIME_FUNCTIONS);
        if (string == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            string = this.dmd.getTimeDateFunctions();
            this.properties.put(PROP_TIME_FUNCTIONS, string);
        }
        return string;
    }

    public void setTimeDateFunctions(String string) {
        this.setString(PROP_TIME_FUNCTIONS, string);
    }

    public String getSearchStringEscape() throws SQLException {
        String string = (String)this.properties.get(PROP_STRING_ESCAPE);
        if (string == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            string = this.dmd.getSearchStringEscape();
            this.properties.put(PROP_STRING_ESCAPE, string);
        }
        return string;
    }

    public void setSearchStringEscape(String string) {
        this.setString(PROP_STRING_ESCAPE, string);
    }

    public String getExtraNameCharacters() throws SQLException {
        String string = (String)this.properties.get(PROP_EXTRA_CHARACTERS);
        if (string == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            string = this.dmd.getExtraNameCharacters();
            this.properties.put(PROP_EXTRA_CHARACTERS, string);
        }
        return string;
    }

    public void setExtraNameCharacters(String string) {
        this.setString(PROP_EXTRA_CHARACTERS, string);
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_ALTER_ADD);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsAlterTableWithAddColumn());
            this.properties.put(PROP_ALTER_ADD, bl);
        }
        return bl;
    }

    public int getAlterTableWithAddColumn() {
        return this.getBoolean(PROP_ALTER_ADD);
    }

    public void setAlterTableWithAddColumn(int n) {
        this.setBoolean(PROP_ALTER_ADD, n);
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_ALTER_DROP);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsAlterTableWithDropColumn());
            this.properties.put(PROP_ALTER_DROP, bl);
        }
        return bl;
    }

    public int getAlterTableWithDropColumn() {
        return this.getBoolean(PROP_ALTER_DROP);
    }

    public void setAlterTableWithDropColumn(int n) {
        this.setBoolean(PROP_ALTER_DROP, n);
    }

    public boolean supportsColumnAliasing() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_COLUMN_ALIASING);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsColumnAliasing());
            this.properties.put(PROP_COLUMN_ALIASING, bl);
        }
        return bl;
    }

    public int getColumnAliasing() {
        return this.getBoolean(PROP_COLUMN_ALIASING);
    }

    public void setColumnAliasing(int n) {
        this.setBoolean(PROP_COLUMN_ALIASING, n);
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_NULL_PLUS_NULL_IS_NULL);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.nullPlusNonNullIsNull());
            this.properties.put(PROP_NULL_PLUS_NULL_IS_NULL, bl);
        }
        return bl;
    }

    public int getNullPlusNonNullIsNull() {
        return this.getBoolean(PROP_NULL_PLUS_NULL_IS_NULL);
    }

    public void setNullPlusNonNullIsNull(int n) {
        this.setBoolean(PROP_NULL_PLUS_NULL_IS_NULL, n);
    }

    public boolean supportsConvert() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_CONVERT);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsConvert());
            this.properties.put(PROP_CONVERT, bl);
        }
        return bl;
    }

    public int getConvert() {
        return this.getBoolean(PROP_CONVERT);
    }

    public void setConvert(int n) {
        this.setBoolean(PROP_CONVERT, n);
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.supportsConvert(n, n2);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_TABLE_CORRELATION_NAMES);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsTableCorrelationNames());
            this.properties.put(PROP_TABLE_CORRELATION_NAMES, bl);
        }
        return bl;
    }

    public int getTableCorrelationNames() {
        return this.getBoolean(PROP_TABLE_CORRELATION_NAMES);
    }

    public void setTableCorrelationNames(int n) {
        this.setBoolean(PROP_TABLE_CORRELATION_NAMES, n);
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_DIFF_TABLE_CORRELATION_NAMES);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsDifferentTableCorrelationNames());
            this.properties.put(PROP_DIFF_TABLE_CORRELATION_NAMES, bl);
        }
        return bl;
    }

    public int getDifferentTableCorrelationNames() {
        return this.getBoolean(PROP_DIFF_TABLE_CORRELATION_NAMES);
    }

    public void setDifferentTableCorrelationNames(int n) {
        this.setBoolean(PROP_DIFF_TABLE_CORRELATION_NAMES, n);
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_EXPRESSIONS_IN_ORDERBY);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsExpressionsInOrderBy());
            this.properties.put(PROP_EXPRESSIONS_IN_ORDERBY, bl);
        }
        return bl;
    }

    public int getExpressionsInOrderBy() {
        return this.getBoolean(PROP_EXPRESSIONS_IN_ORDERBY);
    }

    public void setExpressionsInOrderBy(int n) {
        this.setBoolean(PROP_EXPRESSIONS_IN_ORDERBY, n);
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_ORDER_BY_UNRELATED);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsOrderByUnrelated());
            this.properties.put(PROP_ORDER_BY_UNRELATED, bl);
        }
        return bl;
    }

    public int getOrderByUnrelated() {
        return this.getBoolean(PROP_ORDER_BY_UNRELATED);
    }

    public void setOrderByUnrelated(int n) {
        this.setBoolean(PROP_ORDER_BY_UNRELATED, n);
    }

    public boolean supportsGroupBy() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_GROUP_BY);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsGroupBy());
            this.properties.put(PROP_GROUP_BY, bl);
        }
        return bl;
    }

    public int getGroupBy() {
        return this.getBoolean(PROP_GROUP_BY);
    }

    public void setGroupBy(int n) {
        this.setBoolean(PROP_GROUP_BY, n);
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_UNRELATED_GROUP_BY);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsGroupByUnrelated());
            this.properties.put(PROP_UNRELATED_GROUP_BY, bl);
        }
        return bl;
    }

    public int getGroupByUnrelated() {
        return this.getBoolean(PROP_UNRELATED_GROUP_BY);
    }

    public void setGroupByUnrelated(int n) {
        this.setBoolean(PROP_UNRELATED_GROUP_BY, n);
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_BEYOND_GROUP_BY);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsGroupByBeyondSelect());
            this.properties.put(PROP_BEYOND_GROUP_BY, bl);
        }
        return bl;
    }

    public int getGroupByBeyondSelect() {
        return this.getBoolean(PROP_BEYOND_GROUP_BY);
    }

    public void setGroupByBeyondSelect(int n) {
        this.setBoolean(PROP_BEYOND_GROUP_BY, n);
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_ESCAPE_LIKE);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsLikeEscapeClause());
            this.properties.put(PROP_ESCAPE_LIKE, bl);
        }
        return bl;
    }

    public int getLikeEscapeClause() {
        return this.getBoolean(PROP_ESCAPE_LIKE);
    }

    public void setLikeEscapeClause(int n) {
        this.setBoolean(PROP_ESCAPE_LIKE, n);
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_MULTIPLE_RS);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsMultipleResultSets());
            this.properties.put(PROP_MULTIPLE_RS, bl);
        }
        return bl;
    }

    public int getMultipleResultSets() {
        return this.getBoolean(PROP_MULTIPLE_RS);
    }

    public void setMultipleResultSets(int n) {
        this.setBoolean(PROP_MULTIPLE_RS, n);
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_MULTIPLE_TRANSACTIONS);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsMultipleTransactions());
            this.properties.put(PROP_MULTIPLE_TRANSACTIONS, bl);
        }
        return bl;
    }

    public int getMultipleTransactions() {
        return this.getBoolean(PROP_MULTIPLE_TRANSACTIONS);
    }

    public void setMultipleTransactions(int n) {
        this.setBoolean(PROP_MULTIPLE_TRANSACTIONS, n);
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_NON_NULL_COLUMNSS);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsNonNullableColumns());
            this.properties.put(PROP_NON_NULL_COLUMNSS, bl);
        }
        return bl;
    }

    public int getNonNullableColumns() {
        return this.getBoolean(PROP_NON_NULL_COLUMNSS);
    }

    public void setNonNullableColumns(int n) {
        this.setBoolean(PROP_NON_NULL_COLUMNSS, n);
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_MINUMUM_SQL_GRAMMAR);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsMinimumSQLGrammar());
            this.properties.put(PROP_MINUMUM_SQL_GRAMMAR, bl);
        }
        return bl;
    }

    public int getMinimumSQLGrammar() {
        return this.getBoolean(PROP_MINUMUM_SQL_GRAMMAR);
    }

    public void setMinimumSQLGrammar(int n) {
        this.setBoolean(PROP_MINUMUM_SQL_GRAMMAR, n);
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_CORE_SQL_GRAMMAR);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsCoreSQLGrammar());
            this.properties.put(PROP_CORE_SQL_GRAMMAR, bl);
        }
        return bl;
    }

    public int getCoreSQLGrammar() {
        return this.getBoolean(PROP_CORE_SQL_GRAMMAR);
    }

    public void setCoreSQLGrammar(int n) {
        this.setBoolean(PROP_CORE_SQL_GRAMMAR, n);
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_EXTENDED_SQL_GRAMMAR);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsExtendedSQLGrammar());
            this.properties.put(PROP_EXTENDED_SQL_GRAMMAR, bl);
        }
        return bl;
    }

    public int getExtendedSQLGrammar() {
        return this.getBoolean(PROP_EXTENDED_SQL_GRAMMAR);
    }

    public void setExtendedSQLGrammar(int n) {
        this.setBoolean(PROP_EXTENDED_SQL_GRAMMAR, n);
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_ANSI_SQL_GRAMMAR);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsANSI92EntryLevelSQL());
            this.properties.put(PROP_ANSI_SQL_GRAMMAR, bl);
        }
        return bl;
    }

    public int getANSI92EntryLevelSQL() {
        return this.getBoolean(PROP_ANSI_SQL_GRAMMAR);
    }

    public void setANSI92EntryLevelSQL(int n) {
        this.setBoolean(PROP_ANSI_SQL_GRAMMAR, n);
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_INTERMEDIATE_SQL_GRAMMAR);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsANSI92IntermediateSQL());
            this.properties.put(PROP_INTERMEDIATE_SQL_GRAMMAR, bl);
        }
        return bl;
    }

    public int getANSI92IntermediateSQL() {
        return this.getBoolean(PROP_INTERMEDIATE_SQL_GRAMMAR);
    }

    public void setANSI92IntermediateSQL(int n) {
        this.setBoolean(PROP_INTERMEDIATE_SQL_GRAMMAR, n);
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_FULL_SQL_GRAMMAR);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsANSI92FullSQL());
            this.properties.put(PROP_FULL_SQL_GRAMMAR, bl);
        }
        return bl;
    }

    public int getANSI92FullSQL() {
        return this.getBoolean(PROP_FULL_SQL_GRAMMAR);
    }

    public void setANSI92FullSQL(int n) {
        this.setBoolean(PROP_FULL_SQL_GRAMMAR, n);
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_INTEGRITY_ENHANCEMENT);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsIntegrityEnhancementFacility());
            this.properties.put(PROP_INTEGRITY_ENHANCEMENT, bl);
        }
        return bl;
    }

    public int getIntegrityEnhancementFacility() {
        return this.getBoolean(PROP_INTEGRITY_ENHANCEMENT);
    }

    public void setIntegrityEnhancementFacility(int n) {
        this.setBoolean(PROP_INTEGRITY_ENHANCEMENT, n);
    }

    public boolean supportsOuterJoins() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_OUTER_JOINS);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsOuterJoins());
            this.properties.put(PROP_OUTER_JOINS, bl);
        }
        return bl;
    }

    public int getOuterJoins() {
        return this.getBoolean(PROP_OUTER_JOINS);
    }

    public void setOuterJoins(int n) {
        this.setBoolean(PROP_OUTER_JOINS, n);
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_FULL_OUTER_JOINS);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsFullOuterJoins());
            this.properties.put(PROP_FULL_OUTER_JOINS, bl);
        }
        return bl;
    }

    public int getFullOuterJoins() {
        return this.getBoolean(PROP_FULL_OUTER_JOINS);
    }

    public void setFullOuterJoins(int n) {
        this.setBoolean(PROP_FULL_OUTER_JOINS, n);
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_LIMITED_OUTER_JOINS);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsLimitedOuterJoins());
            this.properties.put(PROP_LIMITED_OUTER_JOINS, bl);
        }
        return bl;
    }

    public int getLimitedOuterJoins() {
        return this.getBoolean(PROP_LIMITED_OUTER_JOINS);
    }

    public void setLimitedOuterJoins(int n) {
        this.setBoolean(PROP_LIMITED_OUTER_JOINS, n);
    }

    public String getSchemaTerm() throws SQLException {
        String string = (String)this.properties.get(PROP_SCHEMA_TERM);
        if (string == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            string = this.dmd.getSchemaTerm();
            this.properties.put(PROP_SCHEMA_TERM, string);
        }
        return string;
    }

    public void setSchemaTerm(String string) {
        this.setString(PROP_SCHEMA_TERM, string);
    }

    public String getProcedureTerm() throws SQLException {
        String string = (String)this.properties.get(PROP_PROCEDURE_TERM);
        if (string == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            string = this.dmd.getProcedureTerm();
            this.properties.put(PROP_PROCEDURE_TERM, string);
        }
        return string;
    }

    public void setProcedureTerm(String string) {
        this.setString(PROP_PROCEDURE_TERM, string);
    }

    public String getCatalogTerm() throws SQLException {
        String string = (String)this.properties.get(PROP_CATALOG_TERM);
        if (string == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            string = this.dmd.getCatalogTerm();
            this.properties.put(PROP_CATALOG_TERM, string);
        }
        return string;
    }

    public void setCatalogTerm(String string) {
        this.setString(PROP_CATALOG_TERM, string);
    }

    public boolean isCatalogAtStart() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_CATALOG_AT_START);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.isCatalogAtStart());
            this.properties.put(PROP_CATALOG_AT_START, bl);
        }
        return bl;
    }

    public int getcatalogAtStart() {
        return this.getBoolean(PROP_CATALOG_AT_START);
    }

    public void setcatalogAtStart(int n) {
        this.setBoolean(PROP_CATALOG_AT_START, n);
    }

    public String getCatalogSeparator() throws SQLException {
        String string = (String)this.properties.get(PROP_CATALOGS_SEPARATOR);
        if (string == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            string = this.dmd.getCatalogSeparator();
            this.properties.put(PROP_CATALOGS_SEPARATOR, string);
        }
        return string;
    }

    public void setCatalogSeparator(String string) {
        this.setString(PROP_CATALOGS_SEPARATOR, string);
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_SCHEMAS_IN_DML);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsSchemasInDataManipulation());
            this.properties.put(PROP_SCHEMAS_IN_DML, bl);
        }
        return bl;
    }

    public int getSchemasInDataManipulation() {
        return this.getBoolean(PROP_SCHEMAS_IN_DML);
    }

    public void setSchemasInDataManipulation(int n) {
        this.setBoolean(PROP_SCHEMAS_IN_DML, n);
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_SCHEMAS_IN_PROCEDURE_CALL);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsSchemasInProcedureCalls());
            this.properties.put(PROP_SCHEMAS_IN_PROCEDURE_CALL, bl);
        }
        return bl;
    }

    public int getSchemasInProcedureCalls() {
        return this.getBoolean(PROP_SCHEMAS_IN_PROCEDURE_CALL);
    }

    public void setSchemasInProcedureCalls(int n) {
        this.setBoolean(PROP_SCHEMAS_IN_PROCEDURE_CALL, n);
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_SCHEMAS_IN_TABLE_DEFINITION);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsSchemasInTableDefinitions());
            this.properties.put(PROP_SCHEMAS_IN_TABLE_DEFINITION, bl);
        }
        return bl;
    }

    public int getSchemasInTableDefinitions() {
        return this.getBoolean(PROP_SCHEMAS_IN_TABLE_DEFINITION);
    }

    public void setSchemasInTableDefinitions(int n) {
        this.setBoolean(PROP_SCHEMAS_IN_TABLE_DEFINITION, n);
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_SCHEMAS_IN_INDEX);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsSchemasInIndexDefinitions());
            this.properties.put(PROP_SCHEMAS_IN_INDEX, bl);
        }
        return bl;
    }

    public int getSchemasInIndexDefinitions() {
        return this.getBoolean(PROP_SCHEMAS_IN_INDEX);
    }

    public void setSchemasInIndexDefinitions(int n) {
        this.setBoolean(PROP_SCHEMAS_IN_INDEX, n);
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_SCHEMAS_IN_PRIVILEGE_DEFINITION);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsSchemasInPrivilegeDefinitions());
            this.properties.put(PROP_SCHEMAS_IN_PRIVILEGE_DEFINITION, bl);
        }
        return bl;
    }

    public int getSchemasInPrivilegeDefinitions() {
        return this.getBoolean(PROP_SCHEMAS_IN_PRIVILEGE_DEFINITION);
    }

    public void setSchemasInPrivilegeDefinitions(int n) {
        this.setBoolean(PROP_SCHEMAS_IN_PRIVILEGE_DEFINITION, n);
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_CATALOGS_IN_DML);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsCatalogsInDataManipulation());
            this.properties.put(PROP_CATALOGS_IN_DML, bl);
        }
        return bl;
    }

    public int getCatalogsInDataManipulation() {
        return this.getBoolean(PROP_CATALOGS_IN_DML);
    }

    public void setCatalogsInDataManipulation(int n) {
        this.setBoolean(PROP_CATALOGS_IN_DML, n);
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_CATALOGS_IN_PROCEDURE_CALL);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsCatalogsInProcedureCalls());
            this.properties.put(PROP_CATALOGS_IN_PROCEDURE_CALL, bl);
        }
        return bl;
    }

    public int getCatalogsInProcedureCalls() {
        return this.getBoolean(PROP_CATALOGS_IN_PROCEDURE_CALL);
    }

    public void setCatalogsInProcedureCalls(int n) {
        this.setBoolean(PROP_CATALOGS_IN_PROCEDURE_CALL, n);
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_CATALOGS_IN_TABLE_DEFINITION);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsCatalogsInTableDefinitions());
            this.properties.put(PROP_CATALOGS_IN_TABLE_DEFINITION, bl);
        }
        return bl;
    }

    public int getCatalogsInTableDefinitions() {
        return this.getBoolean(PROP_CATALOGS_IN_TABLE_DEFINITION);
    }

    public void setCatalogsInTableDefinitions(int n) {
        this.setBoolean(PROP_CATALOGS_IN_TABLE_DEFINITION, n);
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_CATALOGS_IN_INDEX);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsCatalogsInIndexDefinitions());
            this.properties.put(PROP_CATALOGS_IN_INDEX, bl);
        }
        return bl;
    }

    public int getCatalogsInIndexDefinitions() {
        return this.getBoolean(PROP_CATALOGS_IN_INDEX);
    }

    public void setCatalogsInIndexDefinitions(int n) {
        this.setBoolean(PROP_CATALOGS_IN_INDEX, n);
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_CATALOGS_IN_PRIVILEGE_DEFINITION);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsCatalogsInPrivilegeDefinitions());
            this.properties.put(PROP_CATALOGS_IN_PRIVILEGE_DEFINITION, bl);
        }
        return bl;
    }

    public int getCatalogsInPrivilegeDefinitions() {
        return this.getBoolean(PROP_CATALOGS_IN_PRIVILEGE_DEFINITION);
    }

    public void setCatalogsInPrivilegeDefinitions(int n) {
        this.setBoolean(PROP_CATALOGS_IN_PRIVILEGE_DEFINITION, n);
    }

    public boolean supportsPositionedDelete() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_POSITIONED_DELETE);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsPositionedDelete());
            this.properties.put(PROP_POSITIONED_DELETE, bl);
        }
        return bl;
    }

    public int getPositionedDelete() {
        return this.getBoolean(PROP_POSITIONED_DELETE);
    }

    public void setPositionedDelete(int n) {
        this.setBoolean(PROP_POSITIONED_DELETE, n);
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_POSITIONED_UPDATE);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsPositionedUpdate());
            this.properties.put(PROP_POSITIONED_UPDATE, bl);
        }
        return bl;
    }

    public int getPositionedUpdate() {
        return this.getBoolean(PROP_POSITIONED_UPDATE);
    }

    public void setPositionedUpdate(int n) {
        this.setBoolean(PROP_POSITIONED_UPDATE, n);
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_SELECT_FOR_UPDATE);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsSelectForUpdate());
            this.properties.put(PROP_SELECT_FOR_UPDATE, bl);
        }
        return bl;
    }

    public int getSelectForUpdate() {
        return this.getBoolean(PROP_SELECT_FOR_UPDATE);
    }

    public void setSelectForUpdate(int n) {
        this.setBoolean(PROP_SELECT_FOR_UPDATE, n);
    }

    public boolean supportsStoredProcedures() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_STORED_PROCEDURES);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsStoredProcedures());
            this.properties.put(PROP_STORED_PROCEDURES, bl);
        }
        return bl;
    }

    public int getStoredProcedures() {
        return this.getBoolean(PROP_STORED_PROCEDURES);
    }

    public void setStoredProcedures(int n) {
        this.setBoolean(PROP_STORED_PROCEDURES, n);
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_SUBQUERY_IN_COMPARSIONS);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsSubqueriesInComparisons());
            this.properties.put(PROP_SUBQUERY_IN_COMPARSIONS, bl);
        }
        return bl;
    }

    public int getSubqueriesInComparisons() {
        return this.getBoolean(PROP_SUBQUERY_IN_COMPARSIONS);
    }

    public void setSubqueriesInComparisons(int n) {
        this.setBoolean(PROP_SUBQUERY_IN_COMPARSIONS, n);
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_SUBQUERY_IN_EXISTS);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsSubqueriesInExists());
            this.properties.put(PROP_SUBQUERY_IN_EXISTS, bl);
        }
        return bl;
    }

    public int getSubqueriesInExists() {
        return this.getBoolean(PROP_SUBQUERY_IN_EXISTS);
    }

    public void setSubqueriesInExists(int n) {
        this.setBoolean(PROP_SUBQUERY_IN_EXISTS, n);
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_SUBQUERY_IN_INS);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsSubqueriesInIns());
            this.properties.put(PROP_SUBQUERY_IN_INS, bl);
        }
        return bl;
    }

    public int getSubqueriesInIns() {
        return this.getBoolean(PROP_SUBQUERY_IN_INS);
    }

    public void setSubqueriesInIns(int n) {
        this.setBoolean(PROP_SUBQUERY_IN_INS, n);
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_SUBQUERY_IN_QUANTIFIEDS);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsSubqueriesInQuantifieds());
            this.properties.put(PROP_SUBQUERY_IN_QUANTIFIEDS, bl);
        }
        return bl;
    }

    public int getSubqueriesInQuantifieds() {
        return this.getBoolean(PROP_SUBQUERY_IN_QUANTIFIEDS);
    }

    public void setSubqueriesInQuantifieds(int n) {
        this.setBoolean(PROP_SUBQUERY_IN_QUANTIFIEDS, n);
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_CORRELATED_SUBQUERIES);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsCorrelatedSubqueries());
            this.properties.put(PROP_CORRELATED_SUBQUERIES, bl);
        }
        return bl;
    }

    public int getCorrelatedSubqueries() {
        return this.getBoolean(PROP_CORRELATED_SUBQUERIES);
    }

    public void setCorrelatedSubqueries(int n) {
        this.setBoolean(PROP_CORRELATED_SUBQUERIES, n);
    }

    public boolean supportsUnion() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_UNION);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsUnion());
            this.properties.put(PROP_UNION, bl);
        }
        return bl;
    }

    public int getUnion() {
        return this.getBoolean(PROP_UNION);
    }

    public void setUnion(int n) {
        this.setBoolean(PROP_UNION, n);
    }

    public boolean supportsUnionAll() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_UNION_ALL);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsUnionAll());
            this.properties.put(PROP_UNION_ALL, bl);
        }
        return bl;
    }

    public int getUnionAll() {
        return this.getBoolean(PROP_UNION_ALL);
    }

    public void setUnionAll(int n) {
        this.setBoolean(PROP_UNION_ALL, n);
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_OPEN_CURSORS_ACROSS_COMMIT);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsOpenCursorsAcrossCommit());
            this.properties.put(PROP_OPEN_CURSORS_ACROSS_COMMIT, bl);
        }
        return bl;
    }

    public int getOpenCursorsAcrossCommit() {
        return this.getBoolean(PROP_OPEN_CURSORS_ACROSS_COMMIT);
    }

    public void setOpenCursorsAcrossCommit(int n) {
        this.setBoolean(PROP_OPEN_CURSORS_ACROSS_COMMIT, n);
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_OPEN_CURSORS_ACROSS_ROLLBACK);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsOpenCursorsAcrossRollback());
            this.properties.put(PROP_OPEN_CURSORS_ACROSS_ROLLBACK, bl);
        }
        return bl;
    }

    public int getOpenCursorsAcrossRollback() {
        return this.getBoolean(PROP_OPEN_CURSORS_ACROSS_ROLLBACK);
    }

    public void setOpenCursorsAcrossRollback(int n) {
        this.setBoolean(PROP_OPEN_CURSORS_ACROSS_ROLLBACK, n);
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_OPEN_STATEMENTS_ACROSS_COMMIT);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsOpenStatementsAcrossCommit());
            this.properties.put(PROP_OPEN_STATEMENTS_ACROSS_COMMIT, bl);
        }
        return bl;
    }

    public int getOpenStatementsAcrossCommit() {
        return this.getBoolean(PROP_OPEN_STATEMENTS_ACROSS_COMMIT);
    }

    public void setOpenStatementsAcrossCommit(int n) {
        this.setBoolean(PROP_OPEN_STATEMENTS_ACROSS_COMMIT, n);
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_OPEN_STATEMENTS_ACROSS_ROLLBACK);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsOpenStatementsAcrossRollback());
            this.properties.put(PROP_OPEN_STATEMENTS_ACROSS_ROLLBACK, bl);
        }
        return bl;
    }

    public int getOpenStatementsAcrossRollback() {
        return this.getBoolean(PROP_OPEN_STATEMENTS_ACROSS_ROLLBACK);
    }

    public void setOpenStatementsAcrossRollback(int n) {
        this.setBoolean(PROP_OPEN_STATEMENTS_ACROSS_ROLLBACK, n);
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_MAX_BINARY_LITERAL_LENGTH);
        if (n == null && this.dmd != null) {
            n = new Integer(this.dmd.getMaxBinaryLiteralLength());
            this.properties.put(PROP_MAX_BINARY_LITERAL_LENGTH, n);
        }
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void setMaxBinaryLiteralLength(int n) {
        this.setInt(PROP_MAX_BINARY_LITERAL_LENGTH, n);
    }

    public int getMaxCharLiteralLength() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_MAX_CHAR_LITERAL_LENGTH);
        if (n == null && this.dmd != null) {
            n = new Integer(this.dmd.getMaxCharLiteralLength());
            this.properties.put(PROP_MAX_CHAR_LITERAL_LENGTH, n);
        }
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void setMaxCharLiteralLength(int n) {
        this.setInt(PROP_MAX_CHAR_LITERAL_LENGTH, n);
    }

    public int getMaxColumnNameLength() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_MAX_COLUMN_NAME_LENGTH);
        if (n == null && this.dmd != null) {
            n = new Integer(this.dmd.getMaxColumnNameLength());
            this.properties.put(PROP_MAX_COLUMN_NAME_LENGTH, n);
        }
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void setMaxColumnNameLength(int n) {
        this.setInt(PROP_MAX_COLUMN_NAME_LENGTH, n);
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_MAX_COLUMNS_IN_GROUPBY);
        if (n == null && this.dmd != null) {
            n = new Integer(this.dmd.getMaxColumnsInGroupBy());
            this.properties.put(PROP_MAX_COLUMNS_IN_GROUPBY, n);
        }
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void setMaxColumnsInGroupBy(int n) {
        this.setInt(PROP_MAX_COLUMNS_IN_GROUPBY, n);
    }

    public int getMaxColumnsInIndex() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_MAX_COLUMNS_IN_INDEX);
        if (n == null && this.dmd != null) {
            n = new Integer(this.dmd.getMaxColumnsInIndex());
            this.properties.put(PROP_MAX_COLUMNS_IN_INDEX, n);
        }
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void setMaxColumnsInIndex(int n) {
        this.setInt(PROP_MAX_COLUMNS_IN_INDEX, n);
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_MAX_COLUMNS_IN_ORDERBY);
        if (n == null && this.dmd != null) {
            n = new Integer(this.dmd.getMaxColumnsInOrderBy());
            this.properties.put(PROP_MAX_COLUMNS_IN_ORDERBY, n);
        }
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void setMaxColumnsInOrderBy(int n) {
        this.setInt(PROP_MAX_COLUMNS_IN_ORDERBY, n);
    }

    public int getMaxColumnsInSelect() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_MAX_COLUMNS_IN_SELECT);
        if (n == null && this.dmd != null) {
            n = new Integer(this.dmd.getMaxColumnsInSelect());
            this.properties.put(PROP_MAX_COLUMNS_IN_SELECT, n);
        }
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void setMaxColumnsInSelect(int n) {
        this.setInt(PROP_MAX_COLUMNS_IN_SELECT, n);
    }

    public int getMaxColumnsInTable() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_MAX_COLUMNS_IN_TABLE);
        if (n == null && this.dmd != null) {
            n = new Integer(this.dmd.getMaxColumnsInTable());
            this.properties.put(PROP_MAX_COLUMNS_IN_TABLE, n);
        }
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void setMaxColumnsInTable(int n) {
        this.setInt(PROP_MAX_COLUMNS_IN_TABLE, n);
    }

    public int getMaxConnections() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_MAX_CONNECTIONS);
        if (n == null && this.dmd != null) {
            n = new Integer(this.dmd.getMaxConnections());
            this.properties.put(PROP_MAX_CONNECTIONS, n);
        }
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void setMaxConnections(int n) {
        this.setInt(PROP_MAX_CONNECTIONS, n);
    }

    public int getMaxCursorNameLength() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_MAX_CURSORNAME_LENGTH);
        if (n == null && this.dmd != null) {
            n = new Integer(this.dmd.getMaxCursorNameLength());
            this.properties.put(PROP_MAX_CURSORNAME_LENGTH, n);
        }
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void setMaxCursorNameLength(int n) {
        this.setInt(PROP_MAX_CURSORNAME_LENGTH, n);
    }

    public int getMaxIndexLength() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_MAX_INDEX_LENGTH);
        if (n == null && this.dmd != null) {
            n = new Integer(this.dmd.getMaxIndexLength());
            this.properties.put(PROP_MAX_INDEX_LENGTH, n);
        }
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void setMaxIndexLength(int n) {
        this.setInt(PROP_MAX_INDEX_LENGTH, n);
    }

    public int getMaxSchemaNameLength() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_MAX_SCHEMA_NAME);
        if (n == null && this.dmd != null) {
            n = new Integer(this.dmd.getMaxSchemaNameLength());
            this.properties.put(PROP_MAX_SCHEMA_NAME, n);
        }
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void setMaxSchemaNameLength(int n) {
        this.setInt(PROP_MAX_SCHEMA_NAME, n);
    }

    public int getMaxProcedureNameLength() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_MAX_PROCEDURE_NAME);
        if (n == null && this.dmd != null) {
            n = new Integer(this.dmd.getMaxProcedureNameLength());
            this.properties.put(PROP_MAX_PROCEDURE_NAME, n);
        }
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void setMaxProcedureNameLength(int n) {
        this.setInt(PROP_MAX_PROCEDURE_NAME, n);
    }

    public int getMaxCatalogNameLength() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_MAX_CATALOG_NAME);
        if (n == null && this.dmd != null) {
            n = new Integer(this.dmd.getMaxProcedureNameLength());
            this.properties.put(PROP_MAX_CATALOG_NAME, n);
        }
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void setMaxCatalogNameLength(int n) {
        this.setInt(PROP_MAX_CATALOG_NAME, n);
    }

    public int getMaxRowSize() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_MAX_ROW_SIZE);
        if (n == null && this.dmd != null) {
            n = new Integer(this.dmd.getMaxProcedureNameLength());
            this.properties.put(PROP_MAX_ROW_SIZE, n);
        }
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void setMaxRowSize(int n) {
        this.setInt(PROP_MAX_ROW_SIZE, n);
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_ROWSIZE_INCLUDING_BLOBS);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.doesMaxRowSizeIncludeBlobs());
            this.properties.put(PROP_ROWSIZE_INCLUDING_BLOBS, bl);
        }
        return bl;
    }

    public int getMaxRowSizeIncludeBlobs() {
        return this.getBoolean(PROP_ROWSIZE_INCLUDING_BLOBS);
    }

    public void setMaxRowSizeIncludeBlobs(int n) {
        this.setBoolean(PROP_ROWSIZE_INCLUDING_BLOBS, n);
    }

    public int getMaxStatementLength() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_MAX_STATEMENT_LENGTH);
        if (n == null && this.dmd != null) {
            n = new Integer(this.dmd.getMaxStatementLength());
            this.properties.put(PROP_MAX_STATEMENT_LENGTH, n);
        }
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void setMaxStatementLength(int n) {
        this.setInt(PROP_MAX_STATEMENT_LENGTH, n);
    }

    public int getMaxStatements() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_MAX_STATEMENTS);
        if (n == null && this.dmd != null) {
            n = new Integer(this.dmd.getMaxStatementLength());
            this.properties.put(PROP_MAX_STATEMENTS, n);
        }
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void setMaxStatements(int n) {
        this.setInt(PROP_MAX_STATEMENTS, n);
    }

    public int getMaxTableNameLength() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_MAX_TABLENAME_LENGTH);
        if (n == null && this.dmd != null) {
            n = new Integer(this.dmd.getMaxStatementLength());
            this.properties.put(PROP_MAX_TABLENAME_LENGTH, n);
        }
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void setMaxTableNameLength(int n) {
        this.setInt(PROP_MAX_TABLENAME_LENGTH, n);
    }

    public int getMaxTablesInSelect() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_MAX_TABLES_IN_SELECT);
        if (n == null && this.dmd != null) {
            n = new Integer(this.dmd.getMaxStatementLength());
            this.properties.put(PROP_MAX_TABLES_IN_SELECT, n);
        }
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void setMaxTablesInSelect(int n) {
        this.setInt(PROP_MAX_TABLES_IN_SELECT, n);
    }

    public int getMaxUserNameLength() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_MAX_USERNAME);
        if (n == null && this.dmd != null) {
            n = new Integer(this.dmd.getMaxUserNameLength());
            this.properties.put(PROP_MAX_USERNAME, n);
        }
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void setMaxUserNameLength(int n) {
        this.setInt(PROP_MAX_USERNAME, n);
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        Integer n = (Integer)this.properties.get(PROP_DEFAULT_ISOLATION);
        if (n == null && this.dmd != null) {
            n = new Integer(this.dmd.getDefaultTransactionIsolation());
            this.properties.put(PROP_DEFAULT_ISOLATION, n);
        }
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void setDefaultTransactionIsolation(int n) {
        this.setInt(PROP_DEFAULT_ISOLATION, n);
    }

    public boolean supportsTransactions() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_TRANSACTIONS);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.doesMaxRowSizeIncludeBlobs());
            this.properties.put(PROP_TRANSACTIONS, bl);
        }
        return bl;
    }

    public int getTransactions() {
        return this.getBoolean(PROP_TRANSACTIONS);
    }

    public void setTransactions(int n) {
        this.setBoolean(PROP_TRANSACTIONS, n);
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.supportsTransactionIsolationLevel(n);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_DDL_AND_DML_TRANSACTIONS);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.doesMaxRowSizeIncludeBlobs());
            this.properties.put(PROP_DDL_AND_DML_TRANSACTIONS, bl);
        }
        return bl;
    }

    public int getDataDefinitionAndDataManipulationTransactions() {
        return this.getBoolean(PROP_DDL_AND_DML_TRANSACTIONS);
    }

    public void setDataDefinitionAndDataManipulationTransactions(int n) {
        this.setBoolean(PROP_DDL_AND_DML_TRANSACTIONS, n);
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_DML_TRANSACTIONS_ONLY);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsDataManipulationTransactionsOnly());
            this.properties.put(PROP_DML_TRANSACTIONS_ONLY, bl);
        }
        return bl;
    }

    public int getDataManipulationTransactionsOnly() {
        return this.getBoolean(PROP_DML_TRANSACTIONS_ONLY);
    }

    public void setDataManipulationTransactionsOnly(int n) {
        this.setBoolean(PROP_DML_TRANSACTIONS_ONLY, n);
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_DDL_CAUSES_COMMIT);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.dataDefinitionCausesTransactionCommit());
            this.properties.put(PROP_DDL_CAUSES_COMMIT, bl);
        }
        return bl;
    }

    public int getDataDefinitionCausesTransactionCommit() {
        return this.getBoolean(PROP_DDL_CAUSES_COMMIT);
    }

    public void setDataDefinitionCausesTransactionCommit(int n) {
        this.setBoolean(PROP_DDL_CAUSES_COMMIT, n);
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_DDL_IGNORED_IN_TRANSACTIONS);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.dataDefinitionIgnoredInTransactions());
            this.properties.put(PROP_DDL_IGNORED_IN_TRANSACTIONS, bl);
        }
        return bl;
    }

    public int getDataDefinitionIgnoredInTransactions() {
        return this.getBoolean(PROP_DDL_IGNORED_IN_TRANSACTIONS);
    }

    public void setDataDefinitionIgnoredInTransactions(int n) {
        this.setBoolean(PROP_DDL_IGNORED_IN_TRANSACTIONS, n);
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        String string4;
        if (this.getCapitializeUsername() && string2 != null) {
            string2 = string2.toUpperCase();
        }
        if ((string4 = (String)this.properties.get(PROP_PROCEDURES_QUERY)) != null) {
            if (this.con != null) {
                PreparedStatement preparedStatement = this.con.prepareStatement(string4);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, string3);
                return preparedStatement.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getProcedures(string, string2, string3);
    }

    public String getProceduresQuery() {
        return this.getString(PROP_PROCEDURES_QUERY);
    }

    public void setProceduresQuery(String string) {
        this.setString(PROP_PROCEDURES_QUERY, string);
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        String string5;
        if (this.getCapitializeUsername() && string2 != null) {
            string2 = string2.toUpperCase();
        }
        if ((string5 = (String)this.properties.get(PROP_PROCEDURE_COLUMNS_QUERY)) != null) {
            if (this.con != null) {
                PreparedStatement preparedStatement = this.con.prepareStatement(string5);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, string3);
                preparedStatement.setString(4, string4);
                return preparedStatement.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getProcedureColumns(string, string2, string3, string4);
    }

    public String getProcedureColumnsQuery() {
        return this.getString(PROP_PROCEDURE_COLUMNS_QUERY);
    }

    public void setProcedureColumnsQuery(String string) {
        this.setString(PROP_PROCEDURE_COLUMNS_QUERY, string);
    }

    public ResultSet getSchemas() throws SQLException {
        String string = (String)this.properties.get(PROP_PROCEDURE_COLUMNS_QUERY);
        if (string != null) {
            if (this.con != null) {
                return this.con.createStatement().executeQuery(string);
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getSchemas();
    }

    public String getSchemasQuery() {
        return this.getString(PROP_SCHEMAS_QUERY);
    }

    public void setSchemasQuery(String string) {
        this.setString(PROP_SCHEMAS_QUERY, string);
    }

    public ResultSet getCatalogs() throws SQLException {
        String string = (String)this.properties.get(PROP_CATALOGS_QUERY);
        if (string != null) {
            if (this.con != null) {
                return this.con.createStatement().executeQuery(string);
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getCatalogs();
    }

    public String getCatalogsQuery() {
        return this.getString(PROP_CATALOGS_QUERY);
    }

    public void setCatalogsQuery(String string) {
        this.setString(PROP_CATALOGS_QUERY, string);
    }

    public ResultSet getTableTypes() throws SQLException {
        String string = (String)this.properties.get(PROP_TABLE_TYPES_QUERY);
        if (string != null) {
            if (this.con != null) {
                return this.con.createStatement().executeQuery(string);
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getCatalogs();
    }

    public String getTableTypesQuery() {
        return this.getString(PROP_TABLE_TYPES_QUERY);
    }

    public void setTableTypesQuery(String string) {
        this.setString(PROP_TABLE_TYPES_QUERY, string);
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        String string5;
        if (this.getCapitializeUsername() && string2 != null) {
            string2 = string2.toUpperCase();
        }
        if ((string5 = (String)this.properties.get(PROP_COLUMNS_QUERY)) != null) {
            if (this.con != null) {
                PreparedStatement preparedStatement = this.con.prepareStatement(string5);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, string3);
                preparedStatement.setString(4, string4);
                return preparedStatement.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getColumns(string, string2, string3, string4);
    }

    public String getColumnsQuery() {
        return this.getString(PROP_COLUMNS_QUERY);
    }

    public void setColumnsQuery(String string) {
        this.setString(PROP_COLUMNS_QUERY, string);
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        String string5;
        if (this.getCapitializeUsername() && string2 != null) {
            string2 = string2.toUpperCase();
        }
        if ((string5 = (String)this.properties.get(PROP_COLUMNS_PRIVILEGES_QUERY)) != null) {
            if (this.con != null) {
                PreparedStatement preparedStatement = this.con.prepareStatement(string5);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, string3);
                preparedStatement.setString(4, string4);
                return preparedStatement.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getColumnPrivileges(string, string2, string3, string4);
    }

    public String getColumnPrivilegesQuery() {
        return this.getString(PROP_COLUMNS_PRIVILEGES_QUERY);
    }

    public void setColumnPrivilegesQuery(String string) {
        this.setString(PROP_COLUMNS_PRIVILEGES_QUERY, string);
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        String string4;
        if (this.getCapitializeUsername() && string2 != null) {
            string2 = string2.toUpperCase();
        }
        if ((string4 = (String)this.properties.get(PROP_TABLES_QUERY)) != null) {
            if (this.con != null) {
                StringBuffer stringBuffer = new StringBuffer();
                PreparedStatement preparedStatement = this.con.prepareStatement(string4);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, string3);
                int n = 0;
                while (n < stringArray.length) {
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append("'");
                    stringBuffer.append(stringArray[n]);
                    stringBuffer.append("'");
                    ++n;
                }
                preparedStatement.setString(4, stringBuffer.toString());
                return preparedStatement.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getTables(string, string2, string3, stringArray);
    }

    public String getTablesQuery() {
        return this.getString(PROP_TABLES_QUERY);
    }

    public void setTablesQuery(String string) {
        this.setString(PROP_TABLES_QUERY, string);
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        String string4;
        if (this.getCapitializeUsername() && string2 != null) {
            string2 = string2.toUpperCase();
        }
        if ((string4 = (String)this.properties.get(PROP_TABLE_PRIVILEGES_QUERY)) != null) {
            if (this.con != null) {
                PreparedStatement preparedStatement = this.con.prepareStatement(string4);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, string3);
                return preparedStatement.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getTablePrivileges(string, string2, string3);
    }

    public String getTablePrivilegesQuery() {
        return this.getString(PROP_TABLE_PRIVILEGES_QUERY);
    }

    public void setTablePrivilegesQuery(String string) {
        this.setString(PROP_TABLE_PRIVILEGES_QUERY, string);
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        String string4;
        if (this.getCapitializeUsername() && string2 != null) {
            string2 = string2.toUpperCase();
        }
        if ((string4 = (String)this.properties.get(PROP_BEST_ROW_IDENTIFIER)) != null) {
            if (this.con != null) {
                PreparedStatement preparedStatement = this.con.prepareStatement(string4);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, string3);
                preparedStatement.setInt(4, n);
                preparedStatement.setBoolean(5, bl);
                return preparedStatement.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getBestRowIdentifier(string, string2, string3, n, bl);
    }

    public String getBestRowIdentifierQuery() {
        return this.getString(PROP_BEST_ROW_IDENTIFIER);
    }

    public void setBestRowIdentifierQuery(String string) {
        this.setString(PROP_BEST_ROW_IDENTIFIER, string);
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        String string4;
        if (this.getCapitializeUsername() && string2 != null) {
            string2 = string2.toUpperCase();
        }
        if ((string4 = (String)this.properties.get(PROP_VERSION_COLUMNS)) != null) {
            if (this.con != null) {
                PreparedStatement preparedStatement = this.con.prepareStatement(string4);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, string3);
                return preparedStatement.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getVersionColumns(string, string2, string3);
    }

    public String getVersionColumnsQuery() {
        return this.getString(PROP_VERSION_COLUMNS);
    }

    public void setVersionColumnsQuery(String string) {
        this.setString(PROP_VERSION_COLUMNS, string);
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        String string4;
        if (this.getCapitializeUsername() && string2 != null) {
            string2 = string2.toUpperCase();
        }
        if ((string4 = (String)this.properties.get(PROP_PK_QUERY)) != null) {
            if (this.con != null) {
                PreparedStatement preparedStatement = this.con.prepareStatement(string4);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, string3);
                return preparedStatement.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getPrimaryKeys(string, string2, string3);
    }

    public String getPrimaryKeysQuery() {
        return this.getString(PROP_PK_QUERY);
    }

    public void setPrimaryKeysQuery(String string) {
        this.setString(PROP_PK_QUERY, string);
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        String string4;
        if (this.getCapitializeUsername() && string2 != null) {
            string2 = string2.toUpperCase();
        }
        if ((string4 = (String)this.properties.get(PROP_IK_QUERY)) != null) {
            if (this.con != null) {
                PreparedStatement preparedStatement = this.con.prepareStatement(string4);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, string3);
                return preparedStatement.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getImportedKeys(string, string2, string3);
    }

    public String getImportedKeysQuery() {
        return this.getString(PROP_IK_QUERY);
    }

    public void setImportedKeysQuery(String string) {
        this.setString(PROP_IK_QUERY, string);
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        String string4;
        if (this.getCapitializeUsername() && string2 != null) {
            string2 = string2.toUpperCase();
        }
        if ((string4 = (String)this.properties.get(PROP_EK_QUERY)) != null) {
            if (this.con != null) {
                PreparedStatement preparedStatement = this.con.prepareStatement(string4);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, string3);
                return preparedStatement.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getExportedKeys(string, string2, string3);
    }

    public String getExportedKeysQuery() {
        return this.getString(PROP_EK_QUERY);
    }

    public void setExportedKeysQuery(String string) {
        this.setString(PROP_EK_QUERY, string);
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        String string7;
        if (this.getCapitializeUsername() && string2 != null) {
            string2 = string2.toUpperCase();
        }
        if ((string7 = (String)this.properties.get(PROP_CROSSREF_QUERY)) != null) {
            if (this.con != null) {
                PreparedStatement preparedStatement = this.con.prepareStatement(string7);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, string3);
                preparedStatement.setString(4, string4);
                preparedStatement.setString(5, string5);
                preparedStatement.setString(6, string6);
                return preparedStatement.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getCrossReference(string, string2, string3, string4, string5, string6);
    }

    public String getCrossReferenceQuery() {
        return this.getString(PROP_CROSSREF_QUERY);
    }

    public void setCrossReferenceQuery(String string) {
        this.setString(PROP_CROSSREF_QUERY, string);
    }

    public ResultSet getTypeInfo() throws SQLException {
        String string = (String)this.properties.get(PROP_TYPE_INFO_QUERY);
        if (string != null) {
            if (this.con != null) {
                return this.con.createStatement().executeQuery(string);
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getTypeInfo();
    }

    public String getTypeInfoQuery() {
        return this.getString(PROP_TYPE_INFO_QUERY);
    }

    public void setTypeInfoQuery(String string) {
        this.setString(PROP_TYPE_INFO_QUERY, string);
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        String string4;
        if (this.getCapitializeUsername() && string2 != null) {
            string2 = string2.toUpperCase();
        }
        if ((string4 = (String)this.properties.get(PROP_INDEX_INFO_QUERY)) != null) {
            if (this.con != null) {
                PreparedStatement preparedStatement = this.con.prepareStatement(string4);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, string3);
                preparedStatement.setBoolean(4, bl);
                preparedStatement.setBoolean(5, bl2);
                return preparedStatement.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getIndexInfo(string, string2, string3, bl, bl2);
    }

    public String getIndexInfoQuery() {
        return this.getString(PROP_INDEX_INFO_QUERY);
    }

    public void setIndexInfoQuery(String string) {
        this.setString(PROP_INDEX_INFO_QUERY, string);
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.supportsResultSetType(n);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.supportsResultSetConcurrency(n, n2);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.ownUpdatesAreVisible(n);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.ownDeletesAreVisible(n);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.ownInsertsAreVisible(n);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.othersUpdatesAreVisible(n);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.othersDeletesAreVisible(n);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.othersInsertsAreVisible(n);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.updatesAreDetected(n);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.deletesAreDetected(n);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.insertsAreDetected(n);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean supportsBatchUpdates() throws SQLException {
        Boolean bl = (Boolean)this.properties.get(PROP_BATCH_UPDATES);
        if (bl == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            bl = new Boolean(this.dmd.supportsBatchUpdates());
            this.properties.put(PROP_BATCH_UPDATES, bl);
        }
        return bl;
    }

    public int getBatchUpdates() {
        return this.getBoolean(PROP_BATCH_UPDATES);
    }

    public void setBatchUpdates(int n) {
        this.setBoolean(PROP_BATCH_UPDATES, n);
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        String string4;
        if (this.getCapitializeUsername() && string2 != null) {
            string2 = string2.toUpperCase();
        }
        if ((string4 = (String)this.properties.get(PROP_UDT_QUERY)) != null) {
            if (this.con != null) {
                StringBuffer stringBuffer = new StringBuffer();
                PreparedStatement preparedStatement = this.con.prepareStatement(string4);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, string3);
                int n = 0;
                while (n < nArray.length) {
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(nArray[n]);
                    ++n;
                }
                preparedStatement.setString(4, stringBuffer.toString());
                return preparedStatement.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getUDTs(string, string2, string3, nArray);
    }

    public String getUDTsQuery() {
        return this.getString(PROP_UDT_QUERY);
    }

    public void setUDTsQuery(String string) {
        this.setString(PROP_UDT_QUERY, string);
    }

    public boolean getCapitializeUsername() {
        Boolean bl = (Boolean)this.properties.get(PROP_CAPITALIZE_USERNAME);
        if (bl == null) {
            bl = new Boolean(true);
            this.properties.put(PROP_CAPITALIZE_USERNAME, bl);
        }
        return bl;
    }

    public void setCapitializeUsername(boolean bl) {
        Boolean bl2 = (Boolean)this.properties.get(PROP_CAPITALIZE_USERNAME);
        Boolean bl3 = new Boolean(bl);
        this.properties.put(PROP_CAPITALIZE_USERNAME, bl3);
        this.propertySupport.firePropertyChange(PROP_CAPITALIZE_USERNAME, bl2, bl3);
    }
}

