/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.lib.ddl.DDLCommand;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.DatabaseSpecification;
import org.netbeans.lib.ddl.util.CommandFormatter;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.util.NbBundle;

public class AbstractCommand
implements Serializable,
DDLCommand {
    private DatabaseSpecification spec;
    boolean executionWithException;
    private String format;
    private String owner;
    private String name;
    private Map addprops;
    private static ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle");
    static final long serialVersionUID = -560515030304320086L;
    private String quoteStr;

    public DatabaseSpecification getSpecification() {
        return this.spec;
    }

    public void setSpecification(DatabaseSpecification databaseSpecification) {
        this.spec = databaseSpecification;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public String getObjectName() {
        return this.name;
    }

    public void setObjectName(String string) {
        this.name = string;
    }

    public String getObjectOwner() {
        if (this.owner != null && this.owner.trim().equals("")) {
            this.setObjectOwner(null);
        }
        return this.owner;
    }

    public void setObjectOwner(String string) {
        this.owner = string;
    }

    public Object getProperty(String string) {
        return this.addprops.get(string);
    }

    public void setProperty(String string, Object object) {
        if (this.addprops == null) {
            this.addprops = new HashMap();
        }
        this.addprops.put(string, object);
    }

    public Map getCommandProperties() throws DDLException {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.addprops != null) {
            hashMap.putAll(this.addprops);
        }
        if ((string = this.getObjectName()) == null) {
            throw new DDLException(bundle.getString("EXC_Unknown"));
        }
        hashMap.put("object.name", this.quote(this.getObjectName()));
        hashMap.put("object.owner", this.quote(this.getObjectOwner()));
        return hashMap;
    }

    public void execute() throws DDLException {
        Object object;
        String string;
        boolean bl;
        Connection connection;
        block13: {
            connection = null;
            bl = false;
            this.executionWithException = false;
            try {
                string = this.getCommand();
            }
            catch (Exception exception) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    exception.printStackTrace();
                }
                this.executionWithException = true;
                TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)(bundle.getString("EXC_UnableToFormat") + "\n" + this.format + "\n" + exception.getMessage()), 0));
                return;
            }
            if (this.spec.getSpecificationFactory().isDebugMode()) {
                try {
                    object = TopManager.getDefault().getStdOut();
                    if (object == null) {
                        throw new Exception();
                    }
                    ((PrintWriter)object).println(string);
                }
                catch (Exception exception) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block13;
                    exception.printStackTrace();
                    System.out.println(string);
                }
            }
        }
        try {
            connection = this.spec.getJDBCConnection();
            if (connection == null) {
                connection = this.spec.openJDBCConnection();
                bl = true;
            }
            object = connection.createStatement();
            object.execute(string);
            object.close();
        }
        catch (Exception exception) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                exception.printStackTrace();
            }
            this.executionWithException = true;
            if (bl && connection != null) {
                this.spec.closeJDBCConnection();
            }
            throw new DDLException(bundle.getString("EXC_UnableToExecute") + "\n" + string + "\n" + exception.getMessage());
        }
        if (bl) {
            this.spec.closeJDBCConnection();
        }
    }

    public String getCommand() throws DDLException {
        if (this.format == null) {
            throw new DDLException(bundle.getString("EXC_NoFormatSpec"));
        }
        try {
            Map map = this.getCommandProperties();
            return CommandFormatter.format(this.format, map);
        }
        catch (Exception exception) {
            throw new DDLException(exception.getMessage());
        }
    }

    public boolean wasException() {
        return this.executionWithException;
    }

    private String getQuoteString() {
        try {
            this.quoteStr = this.getSpecification().getJDBCConnection().getMetaData().getIdentifierQuoteString();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.quoteStr == null) {
            this.quoteStr = "";
        } else {
            this.quoteStr.trim();
        }
        return this.quoteStr;
    }

    protected String quote(String string) {
        if (string == null || string.equals("")) {
            return string;
        }
        if (this.quoteStr == null) {
            this.quoteStr = this.getQuoteString();
        }
        return this.quoteStr + string + this.quoteStr;
    }

    public void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.format = (String)objectInputStream.readObject();
        this.owner = (String)objectInputStream.readObject();
        this.name = (String)objectInputStream.readObject();
        this.addprops = (Map)objectInputStream.readObject();
    }

    public void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.format);
        objectOutputStream.writeObject(this.owner);
        objectOutputStream.writeObject(this.name);
        objectOutputStream.writeObject(this.addprops);
    }
}

