/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.util.CommandFormatter;
import org.openide.util.NbBundle;

public class AbstractTableColumn
implements Serializable {
    private String name;
    private String cname;
    private String format;
    private String otype;
    private Map addprops;
    String reftab;
    String refcol;
    private static ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle");
    static final long serialVersionUID = -5128289937199572117L;

    public String getObjectName() {
        return this.name;
    }

    public void setObjectName(String string) {
        this.name = string;
    }

    public String getObjectType() {
        return this.otype;
    }

    public void setObjectType(String string) {
        this.otype = string;
    }

    public String getColumnName() {
        return this.cname;
    }

    public void setColumnName(String string) {
        this.cname = string;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public String getReferencedTableName() {
        return this.reftab;
    }

    public void setReferencedTableName(String string) {
        this.reftab = string;
    }

    public String getReferencedColumnName() {
        return this.refcol;
    }

    public void setReferencedColumnName(String string) {
        this.refcol = string;
    }

    public Object getProperty(String string) {
        return this.addprops.get(string);
    }

    public void setProperty(String string, Object object) {
        if (this.addprops == null) {
            this.addprops = new HashMap();
        }
        this.addprops.put(string, object);
    }

    public Map getColumnProperties(AbstractCommand abstractCommand) throws DDLException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = this.getObjectName();
        String string2 = this.getColumnName();
        if (this.addprops != null) {
            hashMap.putAll(this.addprops);
        }
        if (string == null) {
            throw new DDLException(bundle.getString("EXC_Unknown"));
        }
        hashMap.put("object.name", abstractCommand.quote(string));
        if (string2 == null) {
            throw new DDLException(bundle.getString("EXC_Unknown"));
        }
        hashMap.put("column.name", abstractCommand.quote(string2));
        if (this.reftab != null) {
            hashMap.put("fkobject.name", abstractCommand.quote(this.reftab));
        }
        if (this.refcol != null) {
            hashMap.put("fkcolumn.name", abstractCommand.quote(this.refcol));
        }
        return hashMap;
    }

    public String getCommand(AbstractCommand abstractCommand) throws DDLException {
        if (this.format == null) {
            throw new DDLException(bundle.getString("EXC_NoFormatSpec"));
        }
        try {
            Map map = this.getColumnProperties(abstractCommand);
            return CommandFormatter.format(this.format, map);
        }
        catch (Exception exception) {
            throw new DDLException(exception.getMessage());
        }
    }

    public void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.name = (String)objectInputStream.readObject();
        this.cname = (String)objectInputStream.readObject();
        this.format = (String)objectInputStream.readObject();
        this.otype = (String)objectInputStream.readObject();
        this.addprops = (Map)objectInputStream.readObject();
        this.reftab = (String)objectInputStream.readObject();
        this.refcol = (String)objectInputStream.readObject();
    }

    public void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.name);
        objectOutputStream.writeObject(this.cname);
        objectOutputStream.writeObject(this.format);
        objectOutputStream.writeObject(this.otype);
        objectOutputStream.writeObject(this.addprops);
        objectOutputStream.writeObject(this.reftab);
        objectOutputStream.writeObject(this.refcol);
    }
}

