/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.impl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import org.netbeans.lib.ddl.DriverSpecificationFactory;
import org.netbeans.lib.ddl.impl.SpecificationFactory;

public class DriverSpecification {
    private HashMap desc;
    private String catalog;
    private String schema;
    private DatabaseMetaData dmd;
    private ResultSet rs;
    private String quoteString;
    SpecificationFactory factory;

    public DriverSpecification(HashMap hashMap) {
        this.desc = hashMap;
        this.quoteString = null;
    }

    public DriverSpecificationFactory getDriverSpecificationFactory() {
        return this.factory;
    }

    public void setDriverSpecificationFactory(DriverSpecificationFactory driverSpecificationFactory) {
        this.factory = (SpecificationFactory)driverSpecificationFactory;
    }

    public void setCatalog(String string) {
        if (string == null || this.dmd == null) {
            this.catalog = string;
            return;
        }
        string.trim();
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            ResultSet resultSet = this.dmd.getCatalogs();
            while (resultSet.next()) {
                linkedList.add(resultSet.getString(1).trim());
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                sQLException.printStackTrace();
            }
            this.catalog = null;
            Object var2_4 = null;
            return;
        }
        this.catalog = linkedList.contains(string) ? string : null;
    }

    public void setSchema(String string) {
        this.schema = string;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setMetaData(DatabaseMetaData databaseMetaData) {
        this.dmd = databaseMetaData;
    }

    public void getTables(String string, String[] stringArray) {
        try {
            string = this.quoteString(string);
            this.rs = this.dmd.getTables(this.catalog, this.schema, string, stringArray);
        }
        catch (SQLException sQLException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                sQLException.printStackTrace();
            }
            this.rs = null;
        }
    }

    public void getProcedures(String string) {
        try {
            string = this.quoteString(string);
            this.rs = this.dmd.getProcedures(this.catalog, this.schema, string);
        }
        catch (SQLException sQLException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                sQLException.printStackTrace();
            }
            this.rs = null;
        }
    }

    public void getPrimaryKeys(String string) {
        try {
            string = this.quoteString(string);
            this.rs = this.dmd.getPrimaryKeys(this.catalog, this.schema, string);
        }
        catch (SQLException sQLException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                sQLException.printStackTrace();
            }
            this.rs = null;
        }
    }

    public void getIndexInfo(String string, boolean bl, boolean bl2) {
        try {
            string = this.quoteString(string);
            this.rs = this.dmd.getIndexInfo(this.catalog, this.schema, string, bl, bl2);
        }
        catch (SQLException sQLException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                sQLException.printStackTrace();
            }
            this.rs = null;
        }
    }

    public void getColumns(String string, String string2) {
        try {
            string = this.quoteString(string);
            string2 = this.quoteString(string2);
            this.rs = this.dmd.getColumns(this.catalog, this.schema, string, string2);
        }
        catch (SQLException sQLException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                sQLException.printStackTrace();
            }
            this.rs = null;
        }
    }

    public void getProcedureColumns(String string, String string2) {
        try {
            string = this.quoteString(string);
            string2 = this.quoteString(string2);
            this.rs = this.dmd.getProcedureColumns(this.catalog, this.schema, string, string2);
        }
        catch (SQLException sQLException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                sQLException.printStackTrace();
            }
            this.rs = null;
        }
    }

    public void getExportedKeys(String string) {
        try {
            string = this.quoteString(string);
            this.rs = this.dmd.getExportedKeys(this.catalog, this.schema, string);
        }
        catch (SQLException sQLException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                sQLException.printStackTrace();
            }
            this.rs = null;
        }
    }

    public void getImportedKeys(String string) {
        try {
            string = this.quoteString(string);
            this.rs = this.dmd.getImportedKeys(this.catalog, this.schema, string);
        }
        catch (SQLException sQLException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                sQLException.printStackTrace();
            }
            this.rs = null;
        }
    }

    public ResultSet getResultSet() {
        return this.rs;
    }

    public HashMap getRow() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        try {
            int n = this.rs.getMetaData().getColumnCount();
            int n2 = 1;
            while (n2 <= n) {
                String string = null;
                try {
                    string = this.rs.getString(n2);
                }
                catch (SQLException sQLException) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        sQLException.printStackTrace();
                    }
                    hashMap = null;
                    break;
                }
                hashMap.put(new Integer(n2), string);
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                sQLException.printStackTrace();
            }
            hashMap = null;
        }
        return hashMap;
    }

    public boolean areViewsSupported() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("PointBase");
        linkedList.add("MySQL");
        linkedList.add("HypersonicSQL");
        try {
            String string = this.dmd.getDatabaseProductName().trim();
            if (linkedList.contains(string)) {
                if (string.equalsIgnoreCase("PointBase")) {
                    return this.dmd.getDriverMajorVersion() == 4 && this.dmd.getDriverMinorVersion() >= 1 || this.dmd.getDriverMajorVersion() > 4;
                }
                return false;
            }
            return true;
        }
        catch (SQLException sQLException) {
            return true;
        }
    }

    private String getQuoteString() {
        if (this.quoteString == null) {
            try {
                this.quoteString = this.dmd.getIdentifierQuoteString();
                if (this.quoteString == null || this.quoteString.equals(" ")) {
                    this.quoteString = "";
                } else {
                    this.quoteString.trim();
                }
            }
            catch (SQLException sQLException) {
                this.quoteString = "";
            }
        }
        return this.quoteString;
    }

    private String quoteString(String string) {
        try {
            if (this.dmd.getDatabaseProductName().trim().equals("PointBase")) {
                String string2 = this.getQuoteString();
                if (string != null && !string.equals("%") && !string2.equals("")) {
                    string = string2 + string + string2;
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return string;
    }

    public String getDBName() {
        try {
            return this.dmd.getDatabaseProductName().trim();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }
}

