/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.lib.ddl.Argument;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.DatabaseSpecification;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.impl.CreateProcedure;
import org.netbeans.lib.ddl.util.CommandFormatter;
import org.openide.util.NbBundle;

public class ProcedureArgument
implements Argument {
    private String name;
    private int type;
    private int dtype;
    private String format;
    private Map addprops;
    private static ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle");

    public static String getArgumentTypeName(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "IN";
                break;
            }
            case 4: {
                string = "OUT";
                break;
            }
            case 2: {
                string = "INOUT";
            }
        }
        return string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public Object getProperty(String string) {
        return this.addprops.get(string);
    }

    public void setProperty(String string, Object object) {
        if (this.addprops == null) {
            this.addprops = new HashMap();
        }
        this.addprops.put(string, object);
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return ProcedureArgument.getArgumentTypeName(this.type);
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getDataType() {
        return this.dtype;
    }

    public void setDataType(int n) {
        this.dtype = n;
    }

    public Map getColumnProperties(AbstractCommand abstractCommand) throws DDLException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        DatabaseSpecification databaseSpecification = abstractCommand.getSpecification();
        Map map = (Map)databaseSpecification.getProperties().get("ProcedureArgumentMap");
        String string = (String)map.get(ProcedureArgument.getArgumentTypeName(this.type));
        hashMap.put("argument.name", abstractCommand.quote(this.name));
        hashMap.put("argument.type", string);
        hashMap.put("argument.datatype", databaseSpecification.getType(this.dtype));
        return hashMap;
    }

    public String getCommand(CreateProcedure createProcedure) throws DDLException {
        if (this.format == null) {
            throw new DDLException(bundle.getString("EXC_NoFormatSpec"));
        }
        try {
            Map map = this.getColumnProperties(createProcedure);
            return CommandFormatter.format(this.format, map);
        }
        catch (Exception exception) {
            throw new DDLException(exception.getMessage());
        }
    }
}

