/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.impl;

import java.beans.Beans;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.lib.ddl.CommandNotSupportedException;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.lib.ddl.DDLCommand;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.DatabaseSpecification;
import org.netbeans.lib.ddl.DatabaseSpecificationFactory;
import org.netbeans.lib.ddl.adaptors.DatabaseMetaDataAdaptor;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.impl.AddColumn;
import org.netbeans.lib.ddl.impl.CommentTable;
import org.netbeans.lib.ddl.impl.CommentView;
import org.netbeans.lib.ddl.impl.CreateFunction;
import org.netbeans.lib.ddl.impl.CreateIndex;
import org.netbeans.lib.ddl.impl.CreateProcedure;
import org.netbeans.lib.ddl.impl.CreateTable;
import org.netbeans.lib.ddl.impl.CreateTrigger;
import org.netbeans.lib.ddl.impl.CreateView;
import org.netbeans.lib.ddl.impl.DropIndex;
import org.netbeans.lib.ddl.impl.ModifyColumn;
import org.netbeans.lib.ddl.impl.RemoveColumn;
import org.netbeans.lib.ddl.impl.RenameColumn;
import org.netbeans.lib.ddl.impl.RenameTable;
import org.netbeans.lib.ddl.impl.RenameView;
import org.netbeans.lib.ddl.impl.SpecificationFactory;
import org.openide.TopManager;
import org.openide.util.NbBundle;

public class Specification
implements DatabaseSpecification {
    private HashMap desc;
    private Connection jdbccon;
    private static ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle");
    SpecificationFactory factory;
    String adaptorClass;
    DatabaseMetaData dmdAdaptor;
    public static final String CREATE_TABLE = "CreateTableCommand";
    public static final String RENAME_TABLE = "RenameTableCommand";
    public static final String DROP_TABLE = "DropTableCommand";
    public static final String COMMENT_TABLE = "CommentTableCommand";
    public static final String ADD_COLUMN = "AddColumnCommand";
    public static final String MODIFY_COLUMN = "ModifyColumnCommand";
    public static final String RENAME_COLUMN = "RenameColumnCommand";
    public static final String REMOVE_COLUMN = "RemoveColumnCommand";
    public static final String CREATE_INDEX = "CreateIndexCommand";
    public static final String DROP_INDEX = "DropIndexCommand";
    public static final String ADD_CONSTRAINT = "AddConstraintCommand";
    public static final String DROP_CONSTRAINT = "DropConstraintCommand";
    public static final String CREATE_VIEW = "CreateViewCommand";
    public static final String RENAME_VIEW = "RenameViewCommand";
    public static final String COMMENT_VIEW = "CommentViewCommand";
    public static final String DROP_VIEW = "DropViewCommand";
    public static final String CREATE_PROCEDURE = "CreateProcedureCommand";
    public static final String DROP_PROCEDURE = "DropProcedureCommand";
    public static final String CREATE_FUNCTION = "CreateFunctionCommand";
    public static final String DROP_FUNCTION = "DropFunctionCommand";
    public static final String CREATE_TRIGGER = "CreateTriggerCommand";
    public static final String DROP_TRIGGER = "DropTriggerCommand";

    public Specification(HashMap hashMap) {
        this.desc = hashMap;
    }

    public Specification(HashMap hashMap, Connection connection) {
        this.desc = hashMap;
        this.jdbccon = connection;
    }

    public Map getProperties() {
        return this.desc;
    }

    public Map getCommandProperties(String string) {
        return (Map)this.desc.get(string);
    }

    public DBConnection getConnection() {
        return (DBConnection)this.desc.get("connection");
    }

    public DatabaseSpecificationFactory getSpecificationFactory() {
        return this.factory;
    }

    public void setSpecificationFactory(DatabaseSpecificationFactory databaseSpecificationFactory) {
        this.factory = (SpecificationFactory)databaseSpecificationFactory;
    }

    public String getMetaDataAdaptorClassName() {
        if (this.adaptorClass == null || this.adaptorClass.length() == 0) {
            this.adaptorClass = "org.netbeans.lib.ddl.adaptors.DefaultAdaptor";
        }
        return this.adaptorClass;
    }

    public void setMetaDataAdaptorClassName(String string) {
        this.adaptorClass = string.startsWith("Database.Adaptors.") ? string : "Database.Adaptors." + string;
        this.dmdAdaptor = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            ClassLoader classLoader;
            if (this.dmdAdaptor != null || this.jdbccon == null) return this.dmdAdaptor;
            String string = this.getMetaDataAdaptorClassName();
            if (string == null) throw new ClassNotFoundException(bundle.getString("EXC_AdaptorUnspecClass"));
            try {
                classLoader = TopManager.getDefault().currentClassLoader();
            }
            catch (Exception exception) {
                classLoader = null;
            }
            this.dmdAdaptor = (DatabaseMetaData)Beans.instantiate(classLoader, string);
            if (!(this.dmdAdaptor instanceof DatabaseMetaDataAdaptor)) throw new ClassNotFoundException(bundle.getString("EXC_AdaptorInterface"));
            ((DatabaseMetaDataAdaptor)this.dmdAdaptor).setConnection(this.jdbccon);
            return this.dmdAdaptor;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException(exception.getMessage());
        }
    }

    public Connection openJDBCConnection() throws DDLException {
        if (this.jdbccon != null) {
            throw new DDLException(bundle.getString("EXC_ConnOpen"));
        }
        DBConnection dBConnection = this.getConnection();
        if (dBConnection == null) {
            throw new DDLException(bundle.getString("EXC_ConnNot"));
        }
        try {
            this.jdbccon = dBConnection.createJDBCConnection();
        }
        catch (Exception exception) {
            throw new DDLException(bundle.getString("EXC_ConnNot"));
        }
        return this.jdbccon;
    }

    public Connection getJDBCConnection() {
        return this.jdbccon;
    }

    public void closeJDBCConnection() throws DDLException {
        if (this.jdbccon == null) {
            throw new DDLException(bundle.getString("EXC_ConnNot"));
        }
        try {
            this.jdbccon.close();
            this.jdbccon = null;
        }
        catch (SQLException sQLException) {
            throw new DDLException(bundle.getString("EXC_ConnUnableClose"));
        }
    }

    public DDLCommand createCommand(String string) throws CommandNotSupportedException {
        return this.createCommand(string, null);
    }

    public DDLCommand createCommand(String string, String string2) throws CommandNotSupportedException {
        AbstractCommand abstractCommand;
        HashMap hashMap = (HashMap)this.desc.get(string);
        if (hashMap == null) {
            throw new CommandNotSupportedException(string, MessageFormat.format(bundle.getString("EXC_CommandNotSupported"), string));
        }
        String string3 = (String)hashMap.get("Class");
        try {
            Class<?> clazz = Class.forName(string3);
            abstractCommand = (AbstractCommand)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new CommandNotSupportedException(string, MessageFormat.format(bundle.getString("EXC_UnableFindOrInitCommand"), string3, string, exception.getMessage()));
        }
        abstractCommand.setObjectName(string2);
        abstractCommand.setSpecification(this);
        abstractCommand.setFormat((String)hashMap.get("Format"));
        return abstractCommand;
    }

    public CreateTable createCommandCreateTable(String string) throws CommandNotSupportedException {
        return (CreateTable)this.createCommand(CREATE_TABLE, string);
    }

    public CommentTable createCommandCommentTable(String string, String string2) throws CommandNotSupportedException {
        CommentTable commentTable = (CommentTable)this.createCommand(COMMENT_TABLE, string);
        commentTable.setComment(string2);
        return commentTable;
    }

    public AbstractCommand createCommandDropTable(String string) throws CommandNotSupportedException {
        return (AbstractCommand)this.createCommand(DROP_TABLE, string);
    }

    public RenameTable createCommandRenameTable(String string, String string2) throws CommandNotSupportedException {
        RenameTable renameTable = (RenameTable)this.createCommand(RENAME_TABLE, string);
        renameTable.setNewName(string2);
        return renameTable;
    }

    public AddColumn createCommandAddColumn(String string) throws CommandNotSupportedException {
        return (AddColumn)this.createCommand(ADD_COLUMN, string);
    }

    public ModifyColumn createCommandModifyColumn(String string) throws CommandNotSupportedException {
        ModifyColumn modifyColumn = (ModifyColumn)this.createCommand(MODIFY_COLUMN, string);
        return modifyColumn;
    }

    public RenameColumn createCommandRenameColumn(String string) throws CommandNotSupportedException {
        RenameColumn renameColumn = (RenameColumn)this.createCommand(RENAME_COLUMN, string);
        return renameColumn;
    }

    public RemoveColumn createCommandRemoveColumn(String string) throws CommandNotSupportedException {
        RemoveColumn removeColumn = (RemoveColumn)this.createCommand(REMOVE_COLUMN, string);
        return removeColumn;
    }

    public CreateIndex createCommandCreateIndex(String string) throws CommandNotSupportedException {
        CreateIndex createIndex = (CreateIndex)this.createCommand(CREATE_INDEX, string);
        return createIndex;
    }

    public DropIndex createCommandDropIndex(String string) throws CommandNotSupportedException {
        DropIndex dropIndex = (DropIndex)this.createCommand(DROP_INDEX, string);
        return dropIndex;
    }

    public CreateView createCommandCreateView(String string) throws CommandNotSupportedException {
        return (CreateView)this.createCommand(CREATE_VIEW, string);
    }

    public RenameView createCommandRenameView(String string, String string2) throws CommandNotSupportedException {
        RenameView renameView = (RenameView)this.createCommand(RENAME_VIEW, string);
        renameView.setNewName(string2);
        return renameView;
    }

    public CommentView createCommandCommentView(String string, String string2) throws CommandNotSupportedException {
        CommentView commentView = (CommentView)this.createCommand(COMMENT_VIEW, string);
        commentView.setComment(string2);
        return commentView;
    }

    public AbstractCommand createCommandDropView(String string) throws CommandNotSupportedException {
        return (AbstractCommand)this.createCommand(DROP_VIEW, string);
    }

    public CreateProcedure createCommandCreateProcedure(String string) throws CommandNotSupportedException {
        return (CreateProcedure)this.createCommand(CREATE_PROCEDURE, string);
    }

    public AbstractCommand createCommandDropProcedure(String string) throws CommandNotSupportedException {
        return (AbstractCommand)this.createCommand(DROP_PROCEDURE, string);
    }

    public CreateFunction createCommandCreateFunction(String string) throws CommandNotSupportedException {
        return (CreateFunction)this.createCommand(CREATE_FUNCTION, string);
    }

    public AbstractCommand createCommandDropFunction(String string) throws CommandNotSupportedException {
        return (AbstractCommand)this.createCommand(DROP_FUNCTION, string);
    }

    public CreateTrigger createCommandCreateTrigger(String string, String string2, int n) throws CommandNotSupportedException {
        CreateTrigger createTrigger = (CreateTrigger)this.createCommand(CREATE_TRIGGER, string);
        createTrigger.setTableName(string2);
        createTrigger.setTiming(n);
        return createTrigger;
    }

    public AbstractCommand createCommandDropTrigger(String string) throws CommandNotSupportedException {
        return (AbstractCommand)this.createCommand(DROP_TRIGGER, string);
    }

    public Map getTypeMap() {
        return (Map)this.desc.get("TypeMap");
    }

    public String getType(int n) {
        String string = "";
        Map map = this.getTypeMap();
        switch (n) {
            case 2003: {
                string = "ARRAY";
                break;
            }
            case -5: {
                string = "BIGINT";
                break;
            }
            case -2: {
                string = "BINARY";
                break;
            }
            case -7: {
                string = "BIT";
                break;
            }
            case 2004: {
                string = "BLOB";
                break;
            }
            case 1: {
                string = "CHAR";
                break;
            }
            case 2005: {
                string = "CLOB";
                break;
            }
            case 91: {
                string = "DATE";
                break;
            }
            case 3: {
                string = "DECIMAL";
                break;
            }
            case 2001: {
                string = "DISTINCT";
                break;
            }
            case 8: {
                string = "DOUBLE";
                break;
            }
            case 6: {
                string = "FLOAT";
                break;
            }
            case 4: {
                string = "INTEGER";
                break;
            }
            case 2000: {
                string = "JAVA_OBJECT";
                break;
            }
            case -4: {
                string = "LONGVARBINARY";
                break;
            }
            case -1: {
                string = "LONGVARCHAR";
                break;
            }
            case 2: {
                string = "NUMERIC";
                break;
            }
            case 7: {
                string = "REAL";
                break;
            }
            case 2006: {
                string = "REF";
                break;
            }
            case 5: {
                string = "SMALLINT";
                break;
            }
            case 92: {
                string = "TIME";
                break;
            }
            case 93: {
                string = "TIMESTAMP";
                break;
            }
            case -6: {
                string = "TINYINT";
                break;
            }
            case -3: {
                string = "VARBINARY";
                break;
            }
            case 12: {
                string = "VARCHAR";
            }
        }
        String string2 = (String)map.get("java.sql.Types." + string);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public static int getType(String string) {
        if (string.equals("java.sql.Types.ARRAY")) {
            return 2003;
        }
        if (string.equals("java.sql.Types.BIGINT")) {
            return -5;
        }
        if (string.equals("java.sql.Types.BINARY")) {
            return -2;
        }
        if (string.equals("java.sql.Types.BIT")) {
            return -7;
        }
        if (string.equals("java.sql.Types.BLOB")) {
            return 2004;
        }
        if (string.equals("java.sql.Types.CHAR")) {
            return 1;
        }
        if (string.equals("java.sql.Types.CLOB")) {
            return 2005;
        }
        if (string.equals("java.sql.Types.DATE")) {
            return 91;
        }
        if (string.equals("java.sql.Types.DECIMAL")) {
            return 3;
        }
        if (string.equals("java.sql.Types.DISTINCT")) {
            return 2001;
        }
        if (string.equals("java.sql.Types.DOUBLE")) {
            return 8;
        }
        if (string.equals("java.sql.Types.FLOAT")) {
            return 6;
        }
        if (string.equals("java.sql.Types.INTEGER")) {
            return 4;
        }
        if (string.equals("java.sql.Types.JAVA_OBJECT")) {
            return 2000;
        }
        if (string.equals("java.sql.Types.LONGVARBINARY")) {
            return -4;
        }
        if (string.equals("java.sql.Types.LONGVARCHAR")) {
            return -1;
        }
        if (string.equals("java.sql.Types.NUMERIC")) {
            return 2;
        }
        if (string.equals("java.sql.Types.REAL")) {
            return 7;
        }
        if (string.equals("java.sql.Types.REF")) {
            return 2006;
        }
        if (string.equals("java.sql.Types.SMALLINT")) {
            return 5;
        }
        if (string.equals("java.sql.Types.TIME")) {
            return 92;
        }
        if (string.equals("java.sql.Types.TIMESTAMP")) {
            return 93;
        }
        if (string.equals("java.sql.Types.TINYINT")) {
            return -6;
        }
        if (string.equals("java.sql.Types.VARBINARY")) {
            return -3;
        }
        if (string.equals("java.sql.Types.VARCHAR")) {
            return 12;
        }
        return -1;
    }
}

