/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.impl;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.DatabaseProductNotFoundException;
import org.netbeans.lib.ddl.DatabaseSpecification;
import org.netbeans.lib.ddl.DatabaseSpecificationFactory;
import org.netbeans.lib.ddl.DriverSpecificationFactory;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.impl.SpecificationParser;
import org.openide.util.NbBundle;

public class SpecificationFactory
implements DatabaseSpecificationFactory,
DriverSpecificationFactory {
    private final String dbFile = "org/netbeans/lib/ddl/resources/dbspec.plist";
    private final String drvFile = "org/netbeans/lib/ddl/resources/driverspec.plist";
    private HashMap dbSpecs;
    private HashMap drvSpecs;
    private boolean debug = false;
    private static ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle");

    public SpecificationFactory() throws DDLException {
        SpecificationParser specificationParser;
        InputStream inputStream;
        ClassLoader classLoader;
        String string = System.getProperty("db.specifications.file");
        String string2 = System.getProperty("driver.specifications.file");
        try {
            if (string == null) {
                classLoader = this.getClass().getClassLoader();
                inputStream = classLoader.getResourceAsStream("org/netbeans/lib/ddl/resources/dbspec.plist");
                if (inputStream == null) {
                    String string3 = MessageFormat.format(bundle.getString("EXC_UnableToOpenStream"), "org/netbeans/lib/ddl/resources/dbspec.plist");
                    throw new Exception(string3);
                }
                specificationParser = new SpecificationParser(inputStream);
                this.dbSpecs = specificationParser.getData();
                inputStream.close();
            } else {
                specificationParser = new SpecificationParser(string);
                this.dbSpecs = specificationParser.getData();
            }
        }
        catch (Exception exception) {
            if (string != null) {
                throw new DDLException("unable to read specifications file " + string + ", " + exception.getMessage());
            }
            throw new DDLException("unable to read default specifications file, " + exception.getMessage());
        }
        try {
            if (string2 == null) {
                classLoader = this.getClass().getClassLoader();
                inputStream = classLoader.getResourceAsStream("org/netbeans/lib/ddl/resources/driverspec.plist");
                if (inputStream == null) {
                    String string4 = MessageFormat.format(bundle.getString("EXC_UnableToOpenStream"), "org/netbeans/lib/ddl/resources/driverspec.plist");
                    throw new Exception(string4);
                }
                specificationParser = new SpecificationParser(inputStream);
                this.drvSpecs = specificationParser.getData();
                inputStream.close();
            } else {
                specificationParser = new SpecificationParser(string2);
                this.drvSpecs = specificationParser.getData();
            }
        }
        catch (Exception exception) {
            if (string2 != null) {
                throw new DDLException("unable to read specifications file " + string2 + ", " + exception.getMessage());
            }
            throw new DDLException("unable to read default specifications file, " + exception.getMessage());
        }
    }

    public Set supportedDatabases() {
        return this.dbSpecs.keySet();
    }

    public boolean isDatabaseSupported(String string) {
        return this.dbSpecs.containsKey(string);
    }

    public DatabaseSpecification createSpecification(DBConnection dBConnection) throws DatabaseProductNotFoundException, DDLException {
        Connection connection = dBConnection.createJDBCConnection();
        DatabaseSpecification databaseSpecification = this.createSpecification(dBConnection, connection);
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            throw new DDLException(sQLException.getMessage());
        }
        return databaseSpecification;
    }

    public DatabaseSpecification createSpecification(DBConnection dBConnection, Connection connection) throws DatabaseProductNotFoundException, DDLException {
        String string = null;
        try {
            boolean bl = connection == null;
            Connection connection2 = connection != null ? connection : dBConnection.createJDBCConnection();
            DatabaseMetaData databaseMetaData = connection2.getMetaData();
            string = databaseMetaData.getDatabaseProductName().trim();
            DatabaseSpecification databaseSpecification = this.createSpecification(dBConnection, string, connection2);
            if (bl) {
                connection2.close();
            }
            return databaseSpecification;
        }
        catch (SQLException sQLException) {
            throw new DDLException("unable to connect to server");
        }
        catch (Exception exception) {
            throw new DatabaseProductNotFoundException(string, "unable to create specification, " + exception.getMessage());
        }
    }

    public DatabaseSpecification createSpecification(DBConnection dBConnection, String string, Connection connection) throws DatabaseProductNotFoundException {
        HashMap hashMap;
        if (string.toUpperCase().startsWith("DB2/")) {
            string = "DB2/";
        }
        if ((hashMap = (HashMap)this.dbSpecs.get(string)) == null) {
            throw new DatabaseProductNotFoundException(string);
        }
        HashMap hashMap2 = this.deepUnion(hashMap, (HashMap)this.dbSpecs.get("GenericDatabaseSystem"), true);
        hashMap2.put("connection", dBConnection);
        Specification specification = new Specification(hashMap2, connection);
        hashMap2.put("dbproduct", string);
        specification.setSpecificationFactory(this);
        return specification;
    }

    public DatabaseSpecification createSpecification(String string, Connection connection) throws DatabaseProductNotFoundException {
        HashMap hashMap;
        if (string.toUpperCase().startsWith("DB2/")) {
            string = "DB2/";
        }
        if ((hashMap = (HashMap)this.dbSpecs.get(string)) == null) {
            throw new DatabaseProductNotFoundException(string);
        }
        HashMap hashMap2 = this.deepUnion(hashMap, (HashMap)this.dbSpecs.get("GenericDatabaseSystem"), true);
        hashMap2.put("dbproduct", string);
        return new Specification(hashMap2, connection);
    }

    public DatabaseSpecification createSpecification(Connection connection) throws DatabaseProductNotFoundException, SQLException {
        return this.createSpecification(connection, connection.getMetaData().getDatabaseProductName().trim());
    }

    public DatabaseSpecification createSpecification(Connection connection, String string) throws DatabaseProductNotFoundException {
        HashMap hashMap;
        if (string.toUpperCase().startsWith("DB2/")) {
            string = "DB2/";
        }
        if ((hashMap = (HashMap)this.dbSpecs.get(string)) == null) {
            throw new DatabaseProductNotFoundException(string);
        }
        HashMap hashMap2 = this.deepUnion(hashMap, (HashMap)this.dbSpecs.get("GenericDatabaseSystem"), true);
        Specification specification = new Specification(hashMap2, connection);
        specification.setSpecificationFactory(this);
        return specification;
    }

    public boolean isDebugMode() {
        return this.debug;
    }

    public void setDebugMode(boolean bl) {
        this.debug = bl;
    }

    public Set supportedDrivers() {
        return this.drvSpecs.keySet();
    }

    public boolean isDriverSupported(String string) {
        return this.drvSpecs.containsKey(string);
    }

    public DriverSpecification createDriverSpecification(String string) {
        HashMap hashMap = (HashMap)this.drvSpecs.get(string);
        if (hashMap == null) {
            hashMap = (HashMap)this.drvSpecs.get("DefaultDriver");
        }
        HashMap hashMap2 = this.deepUnion(hashMap, (HashMap)this.drvSpecs.get("DefaultDriver"), true);
        DriverSpecification driverSpecification = new DriverSpecification(hashMap2);
        driverSpecification.setDriverSpecificationFactory(this);
        return driverSpecification;
    }

    private HashMap deepClone(HashMap hashMap) {
        HashMap hashMap2 = (HashMap)hashMap.clone();
        Iterator iterator = hashMap2.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object object = null;
            Object v = hashMap2.get(k);
            if (v instanceof HashMap) {
                object = this.deepClone((HashMap)v);
            } else if (v instanceof String) {
                object = new String((String)v);
            } else if (v instanceof Vector) {
                object = ((Vector)v).clone();
            }
            hashMap2.put(k, object);
        }
        return hashMap2;
    }

    private HashMap deepUnion(HashMap hashMap, HashMap hashMap2, boolean bl) {
        Iterator iterator = hashMap2.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object object = hashMap2.get(k);
            if (k.equals("TypeMap")) continue;
            if (hashMap.containsKey(k)) {
                Object v = hashMap.get(k);
                if (!bl || !(v instanceof HashMap) || !(object instanceof HashMap)) continue;
                this.deepUnion((HashMap)v, (HashMap)object, bl);
                continue;
            }
            if (object instanceof HashMap) {
                object = this.deepClone((HashMap)object);
            } else if (object instanceof String) {
                object = new String((String)object);
            } else if (object instanceof Vector) {
                object = ((Vector)object).clone();
            }
            hashMap.put(k, object);
        }
        return hashMap;
    }
}

