/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.util.CommandFormatter;
import org.openide.util.NbBundle;

public class TriggerEvent {
    public static final int INSERT = 1;
    public static final int UPDATE = 2;
    public static final int DELETE = 3;
    private static ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle");
    private String name;
    private String col;
    private String format;

    public static String getName(int n) {
        switch (n) {
            case 1: {
                return "INSERT";
            }
            case 2: {
                return "UPDATE";
            }
            case 3: {
                return "DELETE";
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public String getColumn() {
        return this.col;
    }

    public void setColumn(String string) {
        this.col = string;
    }

    public Map getColumnProperties(AbstractCommand abstractCommand) throws DDLException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event.name", abstractCommand.quote(this.name));
        hashMap.put("event.column", this.col);
        return hashMap;
    }

    public String getCommand(AbstractCommand abstractCommand) throws DDLException {
        if (this.format == null) {
            throw new DDLException(bundle.getString("EXC_NoFormatSpec"));
        }
        try {
            Map map = this.getColumnProperties(abstractCommand);
            return CommandFormatter.format(this.format, map);
        }
        catch (Exception exception) {
            throw new DDLException(exception.getMessage());
        }
    }
}

